/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.atsr;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s3tbx.dataio.atsr.AtsrBandReader;
import org.esa.s3tbx.dataio.atsr.AtsrByteBandReader;
import org.esa.s3tbx.dataio.atsr.AtsrFile;
import org.esa.s3tbx.dataio.atsr.AtsrFlagBandReader;
import org.esa.s3tbx.dataio.atsr.AtsrShortBandReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.SampleCoding;

public class AtsrGSSTFile
extends AtsrFile {
    private int _nadirSSTOffset;
    private int _dualSSTOffset;
    private int _confidenceSSTOffset;
    private int _latOffset;
    private int _lonOffset;
    private int _nadirXOffset;
    private int _nadirYOffset;
    private int _forwardXOffset;
    private int _forwardYOffset;
    private int _nadirFlagsOffset;
    private int _forwardFlagsOffset;
    private FlagCoding _flagCodingNadir;
    private FlagCoding _flagCodingForward;
    private FlagCoding _flagCodingConfidence;

    @Override
    public void open(ImageInputStream inStream, File file) throws IOException {
        super.open(inStream, file);
        this.scanBands();
        this.createFlagBands();
        this.calculateFileOffsets();
        this.createBandReader();
        this.readLatLonTiePoints(this._latOffset, this._lonOffset);
    }

    private void scanBands() {
        this.createSSTBands();
        if (this.getHeader().isXYPresent()) {
            this.createNadirOffsetBands();
            if (!this.getHeader().isNadirOnly()) {
                this.createForwardOffsetBands();
            }
        }
    }

    private void createSSTBands() {
        Band band = null;
        band = new Band("nadir_view_sst", 30, 512, 512);
        band.setUnit("K");
        band.setDescription("Nadir-only sea-surface temperature");
        this.addBand(band);
        band = new Band("dual_view_sst", 30, 512, 512);
        band.setUnit("K");
        band.setDescription("Dual-view sea-surface temperature");
        this.addBand(band);
    }

    private void createNadirOffsetBands() {
        Band band = null;
        band = new Band("x_offs_nadir", 30, 512, 512);
        band.setUnit("km");
        band.setDescription("X coordinate offsets (across-track) of nadir view pixels");
        this.addBand(band);
        band = new Band("y_offs_nadir", 30, 512, 512);
        band.setUnit("km");
        band.setDescription("Y coordinate offsets (along-track) of nadir view pixels");
        this.addBand(band);
    }

    private void createForwardOffsetBands() {
        Band band = null;
        band = new Band("x_offs_fward", 30, 512, 512);
        band.setUnit("km");
        band.setDescription("X coordinate offsets (across-track) of forward view pixels");
        this.addBand(band);
        band = new Band("y_offs_fward", 30, 512, 512);
        band.setUnit("km");
        band.setDescription("Y coordinate offsets (along-track) of forward view pixels");
        this.addBand(band);
    }

    private void createFlagBands() {
        Band band = null;
        this.createFlagCodings();
        band = new Band("confid_flags", 11, 512, 512);
        band.setDescription("Sea-surface temperature confidence words");
        band.setSampleCoding((SampleCoding)this._flagCodingConfidence);
        this.addBand(band);
        if (this.getHeader().areFlagsPresent()) {
            band = new Band("cloud_flags_nadir", 11, 512, 512);
            band.setDescription("Nadir-view cloud-clearing/land-flagging results");
            band.setSampleCoding((SampleCoding)this._flagCodingNadir);
            this.addBand(band);
            if (!this.getHeader().isNadirOnly()) {
                band = new Band("cloud_flags_fward", 11, 512, 512);
                band.setDescription("Forward-view cloud-clearing/land-flagging results");
                band.setSampleCoding((SampleCoding)this._flagCodingForward);
                this.addBand(band);
            }
        }
    }

    private void createFlagCodings() {
        this._flagCodingConfidence = new FlagCoding("confid_flags");
        this._flagCodingConfidence = this.addConfidenceFlagsToCoding(this._flagCodingConfidence);
        if (this.getHeader().areFlagsPresent()) {
            this._flagCodingNadir = new FlagCoding("cloud_flags_nadir");
            this._flagCodingNadir = this.addCloudAndLandFlagsToCoding(this._flagCodingNadir);
            if (!this.getHeader().isNadirOnly()) {
                this._flagCodingForward = new FlagCoding("cloud_flags_fward");
                this._flagCodingForward = this.addCloudAndLandFlagsToCoding(this._flagCodingForward);
            }
        }
    }

    private FlagCoding addConfidenceFlagsToCoding(FlagCoding coding) {
        coding.addFlag("NADIR_SST_VALID", 1, "Nadir-only sea-surface temperature is valid (if not set, pixel contains nadir-view 11 um brightness temperature");
        coding.addFlag("NADIR_SST_37_INCLUDED", 2, "Nadir-only sea-surface temperature retrieval includes 3.7 um channel (if not set, retrieval includes 12 um and 11 um only)");
        coding.addFlag("DUAL_SST_VALID", 4, "Dual-view sea-surface temperature is valid (if not set, pixel contains nadir-view 11 um brightness temperature");
        coding.addFlag("DUAL_SST_37_INCLUDED", 8, "Dual-view sea-surface temperature retrieval includes 3.7 um channel (if not set, retrieval includes 12 um and 11 um only)");
        coding.addFlag("LAND", 16, "Pixel is over land");
        coding.addFlag("NADIR_CLOUDY", 32, "Nadir-view pixel is cloudy");
        coding.addFlag("NADIR_BLANKING", 64, "Nadir-view pixel has blanking-pulse");
        coding.addFlag("NADIR_COSMETIC", 128, "Nadir-view pixel is cosmetic (nearest-neighbour fill)");
        coding.addFlag("FWARD_CLOUDY", 256, "Forward-view pixel is cloudy");
        coding.addFlag("FWARD_BLANKING", 512, "Forward-view pixel has blanking-pulse");
        coding.addFlag("FWARD_COSMETIC", 1024, "Forward-view pixel is cosmetic (nearest-neighbour fill)");
        return coding;
    }

    private void calculateFileOffsets() {
        int runningOffset;
        this._nadirSSTOffset = runningOffset = 4096;
        this._dualSSTOffset = runningOffset += 524288;
        this._confidenceSSTOffset = runningOffset += 524288;
        runningOffset += 524288;
        if (this.getHeader().isLatLonPresent()) {
            this._latOffset = runningOffset;
            this._lonOffset = runningOffset += 0x100000;
            runningOffset += 0x100000;
        }
        if (this.getHeader().isXYPresent()) {
            this._nadirXOffset = runningOffset;
            this._nadirYOffset = runningOffset += 262144;
            this._forwardXOffset = runningOffset += 262144;
            this._forwardYOffset = runningOffset += 262144;
            runningOffset += 262144;
        }
        if (this.getHeader().areFlagsPresent()) {
            this._nadirFlagsOffset = runningOffset;
            this._forwardFlagsOffset = runningOffset += 524288;
            runningOffset += 524288;
        }
    }

    private void createBandReader() {
        AtsrBandReader reader = null;
        reader = new AtsrShortBandReader("nadir_view_sst", this._nadirSSTOffset, 0.01f, this.getStream());
        this.addBandReader(reader);
        reader = new AtsrShortBandReader("dual_view_sst", this._dualSSTOffset, 0.01f, this.getStream());
        this.addBandReader(reader);
        reader = new AtsrFlagBandReader("confid_flags", this._confidenceSSTOffset, 1.0f, this.getStream());
        this.addBandReader(reader);
        if (this.getHeader().isXYPresent()) {
            reader = new AtsrByteBandReader("x_offs_nadir", this._nadirXOffset, 0.00390625f, this.getStream());
            this.addBandReader(reader);
            reader = new AtsrByteBandReader("y_offs_nadir", this._nadirYOffset, 0.00390625f, this.getStream());
            this.addBandReader(reader);
            if (!this.getHeader().isNadirOnly()) {
                reader = new AtsrByteBandReader("x_offs_fward", this._forwardXOffset, 0.00390625f, this.getStream());
                this.addBandReader(reader);
                reader = new AtsrByteBandReader("y_offs_fward", this._forwardYOffset, 0.00390625f, this.getStream());
                this.addBandReader(reader);
            }
        }
        if (this.getHeader().areFlagsPresent()) {
            reader = new AtsrFlagBandReader("cloud_flags_nadir", this._nadirFlagsOffset, 1.0f, this.getStream());
            this.addBandReader(reader);
            if (!this.getHeader().isNadirOnly()) {
                reader = new AtsrFlagBandReader("cloud_flags_fward", this._forwardFlagsOffset, 1.0f, this.getStream());
                this.addBandReader(reader);
            }
        }
    }
}

