/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.atsr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.s3tbx.dataio.atsr.AtsrConstants;

public class AtsrConstantsTest
extends TestCase {
    public AtsrConstantsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(AtsrConstantsTest.class);
    }

    public void testBasicConstants() {
        AtsrConstantsTest.assertEquals((String)"ATSR", (String)"ATSR");
        AtsrConstantsTest.assertEquals((String)"ATSR1/ATSR2 products", (String)"ATSR1/ATSR2 products");
    }

    public void testHeaderByteSizeConstants() {
        AtsrConstantsTest.assertEquals((int)4096, (int)4096);
        AtsrConstantsTest.assertEquals((int)2, (int)2);
        AtsrConstantsTest.assertEquals((int)60, (int)60);
        AtsrConstantsTest.assertEquals((int)6, (int)6);
        AtsrConstantsTest.assertEquals((int)5, (int)5);
        AtsrConstantsTest.assertEquals((int)16, (int)16);
        AtsrConstantsTest.assertEquals((int)25, (int)25);
        AtsrConstantsTest.assertEquals((int)13, (int)13);
        AtsrConstantsTest.assertEquals((int)9, (int)9);
        AtsrConstantsTest.assertEquals((int)11, (int)11);
        AtsrConstantsTest.assertEquals((int)16, (int)16);
        AtsrConstantsTest.assertEquals((int)13, (int)13);
        AtsrConstantsTest.assertEquals((int)2, (int)2);
        AtsrConstantsTest.assertEquals((int)6, (int)6);
        AtsrConstantsTest.assertEquals((int)25, (int)25);
        AtsrConstantsTest.assertEquals((int)8, (int)8);
        AtsrConstantsTest.assertEquals((int)9, (int)9);
        AtsrConstantsTest.assertEquals((int)3, (int)3);
        AtsrConstantsTest.assertEquals((int)6, (int)6);
        AtsrConstantsTest.assertEquals((int)2, (int)2);
        AtsrConstantsTest.assertEquals((int)6, (int)6);
        AtsrConstantsTest.assertEquals((int)8, (int)8);
        AtsrConstantsTest.assertEquals((int)9, (int)9);
        AtsrConstantsTest.assertEquals((int)6, (int)6);
        AtsrConstantsTest.assertEquals((int)8, (int)8);
        AtsrConstantsTest.assertEquals((int)10, (int)10);
        AtsrConstantsTest.assertEquals((int)4, (int)4);
    }

    public void testHeaderConstants() {
        int n;
        char[] expByteOrder = new char[]{'A', 'B'};
        String[] expProductTypes = new String[]{"GBT", "GSST"};
        String[] expInstruments = new String[]{"ATSR1", "ATSR2"};
        for (n = 0; n < expByteOrder.length; ++n) {
            AtsrConstantsTest.assertEquals((char)expByteOrder[n], (char)AtsrConstants.BYTE_ORDER_FIELD[n]);
        }
        for (n = 0; n < expProductTypes.length; ++n) {
            AtsrConstantsTest.assertEquals((String)expProductTypes[n], (String)AtsrConstants.PRODUCT_TYPES[n]);
        }
        for (n = 0; n < expInstruments.length; ++n) {
            AtsrConstantsTest.assertEquals((String)expInstruments[n], (String)AtsrConstants.INSTRUMENTS[n]);
        }
    }

    public void testHeaderFieldNameConstants() {
        AtsrConstantsTest.assertEquals((String)"PRODUCT_FILE_NAME", (String)"PRODUCT_FILE_NAME");
        AtsrConstantsTest.assertEquals((String)"INSTRUMENT_NAME", (String)"INSTRUMENT_NAME");
        AtsrConstantsTest.assertEquals((String)"ERS_STATE_VECTOR_TYPE", (String)"ERS_STATE_VECTOR_TYPE");
        AtsrConstantsTest.assertEquals((String)"ASCENDING_NODE_TIME", (String)"ASCENDING_NODE_TIME");
        AtsrConstantsTest.assertEquals((String)"STATE_VECTOR_POSITION_X", (String)"STATE_VECTOR_POSITION_X");
        AtsrConstantsTest.assertEquals((String)"STATE_VECTOR_POSITION_Y", (String)"STATE_VECTOR_POSITION_Y");
        AtsrConstantsTest.assertEquals((String)"STATE_VECTOR_POSITION_Z", (String)"STATE_VECTOR_POSITION_Z");
        AtsrConstantsTest.assertEquals((String)"STATE_VECTOR_VELOCITY_X", (String)"STATE_VECTOR_VELOCITY_X");
        AtsrConstantsTest.assertEquals((String)"STATE_VECTOR_VELOCITY_Y", (String)"STATE_VECTOR_VELOCITY_Y");
        AtsrConstantsTest.assertEquals((String)"STATE_VECTOR_VELOCITY_Z", (String)"STATE_VECTOR_VELOCITY_Z");
        AtsrConstantsTest.assertEquals((String)"ASCENDING_NODE_LONGITUDE", (String)"ASCENDING_NODE_LONGITUDE");
        AtsrConstantsTest.assertEquals((String)"REFERENCE_UT", (String)"REFERENCE_UT");
        AtsrConstantsTest.assertEquals((String)"ERS_CLOCK_TIME", (String)"ERS_CLOCK_TIME");
        AtsrConstantsTest.assertEquals((String)"ERS_CLOCK_PERIOD", (String)"ERS_CLOCK_PERIOD");
        AtsrConstantsTest.assertEquals((String)"NADIR_ONLY_PRESENT", (String)"NADIR_ONLY_PRESENT");
        AtsrConstantsTest.assertEquals((String)"THERMAL_RECORDS_PRESENT", (String)"THERMAL_RECORDS_PRESENT");
        AtsrConstantsTest.assertEquals((String)"VISIBLE_RECORDS_PRESENT", (String)"VISIBLE_RECORDS_PRESENT");
        AtsrConstantsTest.assertEquals((String)"LAT_LON_RECORDS_PRESENT", (String)"LAT_LON_RECORDS_PRESENT");
        AtsrConstantsTest.assertEquals((String)"X_Y_RECORDS_PRESENT", (String)"X_Y_RECORDS_PRESENT");
        AtsrConstantsTest.assertEquals((String)"FLAG_RECORDS_PRESENT", (String)"FLAG_RECORDS_PRESENT");
        AtsrConstantsTest.assertEquals((String)"ALONG_TRACK_START_DISTANCE", (String)"ALONG_TRACK_START_DISTANCE");
        AtsrConstantsTest.assertEquals((String)"ALONG_TRACK_END_DISTANCE", (String)"ALONG_TRACK_END_DISTANCE");
        AtsrConstantsTest.assertEquals((String)"PRODUCT_START_TIME", (String)"PRODUCT_START_TIME");
        AtsrConstantsTest.assertEquals((String)"PRODUCT_END_TIME", (String)"PRODUCT_END_TIME");
        AtsrConstantsTest.assertEquals((String)"CORNER_LAT_LHS_START", (String)"CORNER_LAT_LHS_START");
        AtsrConstantsTest.assertEquals((String)"CORNER_LAT_RHS_START", (String)"CORNER_LAT_RHS_START");
        AtsrConstantsTest.assertEquals((String)"CORNER_LAT_LHS_END", (String)"CORNER_LAT_LHS_END");
        AtsrConstantsTest.assertEquals((String)"CORNER_LAT_RHS_END", (String)"CORNER_LAT_RHS_END");
        AtsrConstantsTest.assertEquals((String)"CORNER_LON_LHS_START", (String)"CORNER_LON_LHS_START");
        AtsrConstantsTest.assertEquals((String)"CORNER_LON_RHS_START", (String)"CORNER_LON_RHS_START");
        AtsrConstantsTest.assertEquals((String)"CORNER_LON_LHS_END", (String)"CORNER_LON_LHS_END");
        AtsrConstantsTest.assertEquals((String)"CORNER_LON_RHS_END", (String)"CORNER_LON_RHS_END");
        AtsrConstantsTest.assertEquals((String)"PIXEL_SELECTION_MAPS_NADIR", (String)"PIXEL_SELECTION_MAPS_NADIR");
        AtsrConstantsTest.assertEquals((String)"PSM_CHANGE_DISTANCE_NADIR", (String)"PSM_CHANGE_DISTANCE_NADIR");
        AtsrConstantsTest.assertEquals((String)"PIXEL_SELECTION_MAPS_FORWARD", (String)"PIXEL_SELECTION_MAPS_FORWARD");
        AtsrConstantsTest.assertEquals((String)"PSM_CHANGE_DISTANCE_FORWARD", (String)"PSM_CHANGE_DISTANCE_FORWARD");
        AtsrConstantsTest.assertEquals((String)"ATSR2_DATA_RATE_NADIR_VIEW", (String)"ATSR2_DATA_RATE_NADIR_VIEW");
        AtsrConstantsTest.assertEquals((String)"ATSR2_DATA_RATE_CHANGE_NADIR_VIEW", (String)"ATSR2_DATA_RATE_CHANGE_NADIR_VIEW");
        AtsrConstantsTest.assertEquals((String)"ATSR2_DATA_RATE_FORWARD_VIEW", (String)"ATSR2_DATA_RATE_FORWARD_VIEW");
        AtsrConstantsTest.assertEquals((String)"ATSR2_DATA_RATE_CHANGE_FORWARD_VIEW", (String)"ATSR2_DATA_RATE_CHANGE_FORWARD_VIEW");
        AtsrConstantsTest.assertEquals((String)"MINIMUM_SCC_TEMPERATURE", (String)"MINIMUM_SCC_TEMPERATURE");
        AtsrConstantsTest.assertEquals((String)"MINIMUM_INSTRUMENT_TEMPERATURE_1200_NM", (String)"MINIMUM_INSTRUMENT_TEMPERATURE_1200_NM");
        AtsrConstantsTest.assertEquals((String)"MINIMUM_INSTRUMENT_TEMPERATURE_1100_NM", (String)"MINIMUM_INSTRUMENT_TEMPERATURE_1100_NM");
        AtsrConstantsTest.assertEquals((String)"MINIMUM_INSTRUMENT_TEMPERATURE_370_NM", (String)"MINIMUM_INSTRUMENT_TEMPERATURE_370_NM");
        AtsrConstantsTest.assertEquals((String)"MINIMUM_INSTRUMENT_TEMPERATURE_160_NM", (String)"MINIMUM_INSTRUMENT_TEMPERATURE_160_NM");
        AtsrConstantsTest.assertEquals((String)"MINIMUM_INSTRUMENT_TEMPERATURE_87_NM", (String)"MINIMUM_INSTRUMENT_TEMPERATURE_87_NM");
        AtsrConstantsTest.assertEquals((String)"MAXIMUM_SCC_TEMPERATURE", (String)"MAXIMUM_SCC_TEMPERATURE");
        AtsrConstantsTest.assertEquals((String)"MAXIMUM_INSTRUMENT_TEMPERATURE_1200_NM", (String)"MAXIMUM_INSTRUMENT_TEMPERATURE_1200_NM");
        AtsrConstantsTest.assertEquals((String)"MAXIMUM_INSTRUMENT_TEMPERATURE_1100_NM", (String)"MAXIMUM_INSTRUMENT_TEMPERATURE_1100_NM");
        AtsrConstantsTest.assertEquals((String)"MAXIMUM_INSTRUMENT_TEMPERATURE_370_NM", (String)"MAXIMUM_INSTRUMENT_TEMPERATURE_370_NM");
        AtsrConstantsTest.assertEquals((String)"MAXIMUM_INSTRUMENT_TEMPERATURE_160_NM", (String)"MAXIMUM_INSTRUMENT_TEMPERATURE_160_NM");
        AtsrConstantsTest.assertEquals((String)"MAXIMUM_INSTRUMENT_TEMPERATURE_87_NM", (String)"MAXIMUM_INSTRUMENT_TEMPERATURE_87_NM");
        AtsrConstantsTest.assertEquals((String)"sun_elev_nadir", (String)"sun_elev_nadir");
        AtsrConstantsTest.assertEquals((String)"view_elev_nadir", (String)"view_elev_nadir");
        AtsrConstantsTest.assertEquals((String)"sun_azimuth_nadir", (String)"sun_azimuth_nadir");
        AtsrConstantsTest.assertEquals((String)"view_azimuth_nadir", (String)"view_azimuth_nadir");
        AtsrConstantsTest.assertEquals((String)"sun_elev_forward", (String)"sun_elev_forward");
        AtsrConstantsTest.assertEquals((String)"view_elev_forward", (String)"view_elev_forward");
        AtsrConstantsTest.assertEquals((String)"sun_azimuth_forward", (String)"sun_azimuth_forward");
        AtsrConstantsTest.assertEquals((String)"view_azimuth_forward", (String)"view_azimuth_forward");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_YSM_NADIR", (String)"ERS_PLATFORM_MODE_YSM_NADIR");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_FCM_NADIR", (String)"ERS_PLATFORM_MODE_FCM_NADIR");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_OCM_NADIR", (String)"ERS_PLATFORM_MODE_OCM_NADIR");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_FPM_NADIR", (String)"ERS_PLATFORM_MODE_FPM_NADIR");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_RTMM_NADIR", (String)"ERS_PLATFORM_MODE_RTMM_NADIR");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_RTMC_NADIR", (String)"ERS_PLATFORM_MODE_RTMC_NADIR");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_YSM_FORWARD", (String)"ERS_PLATFORM_MODE_YSM_FORWARD");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_FCM_FORWARD", (String)"ERS_PLATFORM_MODE_FCM_FORWARD");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_OCM_FORWARD", (String)"ERS_PLATFORM_MODE_OCM_FORWARD");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_FPM_FORWARD", (String)"ERS_PLATFORM_MODE_FPM_FORWARD");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_RTMM_FORWARD", (String)"ERS_PLATFORM_MODE_RTMM_FORWARD");
        AtsrConstantsTest.assertEquals((String)"ERS_PLATFORM_MODE_RTMC_FORWARD", (String)"ERS_PLATFORM_MODE_RTMC_FORWARD");
        AtsrConstantsTest.assertEquals((String)"PCD_INFORMATION_NADIR", (String)"PCD_INFORMATION_NADIR");
        AtsrConstantsTest.assertEquals((String)"PCD_INFORMATION_FORWARD", (String)"PCD_INFORMATION_FORWARD");
        AtsrConstantsTest.assertEquals((String)"PACKET_INFORMATION_NADIR", (String)"PACKET_INFORMATION_NADIR");
        AtsrConstantsTest.assertEquals((String)"PACKET_INFORMATION_FORWARD", (String)"PACKET_INFORMATION_FORWARD");
        AtsrConstantsTest.assertEquals((String)"MAX_SINGLE_PIXEL_ERROR_CODE", (String)"MAX_SINGLE_PIXEL_ERROR_CODE");
        AtsrConstantsTest.assertEquals((String)"latitude", (String)"latitude");
        AtsrConstantsTest.assertEquals((String)"longitude", (String)"longitude");
    }

    public void testHeaderFieldDescriptionsandUnits() {
        AtsrConstantsTest.assertEquals((String)"Days since January 1st, 1950", (String)"Days since January 1st, 1950");
        AtsrConstantsTest.assertEquals((String)"d", (String)"d");
        AtsrConstantsTest.assertEquals((String)"Universal time at ascending node", (String)"Universal time at ascending node");
        AtsrConstantsTest.assertEquals((String)"km", (String)"km");
        AtsrConstantsTest.assertEquals((String)"Ascending node state vector position x", (String)"Ascending node state vector position x");
        AtsrConstantsTest.assertEquals((String)"Ascending node state vector position y", (String)"Ascending node state vector position y");
        AtsrConstantsTest.assertEquals((String)"Ascending node state vector position z", (String)"Ascending node state vector position z");
        AtsrConstantsTest.assertEquals((String)"km/s", (String)"km/s");
        AtsrConstantsTest.assertEquals((String)"Ascending node state vector velocity x", (String)"Ascending node state vector velocity x");
        AtsrConstantsTest.assertEquals((String)"Ascending node state vector velocity y", (String)"Ascending node state vector velocity y");
        AtsrConstantsTest.assertEquals((String)"Ascending node state vector velocity z", (String)"Ascending node state vector velocity z");
        AtsrConstantsTest.assertEquals((String)"Longitude of ascending node", (String)"Longitude of ascending node");
        AtsrConstantsTest.assertEquals((String)"dec. deg.", (String)"dec. deg.");
        AtsrConstantsTest.assertEquals((String)"Reference universal time (days since January 1st, 1950)", (String)"Reference universal time (days since January 1st, 1950)");
        AtsrConstantsTest.assertEquals((String)"d", (String)"d");
        AtsrConstantsTest.assertEquals((String)"ns", (String)"ns");
        AtsrConstantsTest.assertEquals((String)"Reference ERS satellite clock time", (String)"Reference ERS satellite clock time");
        AtsrConstantsTest.assertEquals((String)"Period of ERS satellite clock", (String)"Period of ERS satellite clock");
        AtsrConstantsTest.assertEquals((String)"Nadir-only records present", (String)"Nadir-only records present");
        AtsrConstantsTest.assertEquals((String)"Thermal infra-red detector records present", (String)"Thermal infra-red detector records present");
        AtsrConstantsTest.assertEquals((String)"Visible/near-infra-red detector records present", (String)"Visible/near-infra-red detector records present");
        AtsrConstantsTest.assertEquals((String)"Latitude/longitude records present", (String)"Latitude/longitude records present");
        AtsrConstantsTest.assertEquals((String)"X/Y coordinate records present", (String)"X/Y coordinate records present");
        AtsrConstantsTest.assertEquals((String)"Cloud-clearing/land-flagging records present", (String)"Cloud-clearing/land-flagging records present");
        AtsrConstantsTest.assertEquals((String)"km", (String)"km");
        AtsrConstantsTest.assertEquals((String)"Along-track distance of product start", (String)"Along-track distance of product start");
        AtsrConstantsTest.assertEquals((String)"Along-track distance of product end", (String)"Along-track distance of product end");
        AtsrConstantsTest.assertEquals((String)"Universal time of data acquisition at product start", (String)"Universal time of data acquisition at product start");
        AtsrConstantsTest.assertEquals((String)"Universal time of data acquisition at product end", (String)"Universal time of data acquisition at product end");
        AtsrConstantsTest.assertEquals((String)"dec. deg.", (String)"dec. deg.");
        AtsrConstantsTest.assertEquals((String)"Latitude of product LHS corner point at start", (String)"Latitude of product LHS corner point at start");
        AtsrConstantsTest.assertEquals((String)"Latitude of product RHS corner point at start", (String)"Latitude of product RHS corner point at start");
        AtsrConstantsTest.assertEquals((String)"Latitude of product LHS corner point at end", (String)"Latitude of product LHS corner point at end");
        AtsrConstantsTest.assertEquals((String)"Latitude of product RHS corner point at end", (String)"Latitude of product RHS corner point at end");
        AtsrConstantsTest.assertEquals((String)"Longitude of product LHS corner point at start", (String)"Longitude of product LHS corner point at start");
        AtsrConstantsTest.assertEquals((String)"Longitude of product RHS corner point at start", (String)"Longitude of product RHS corner point at start");
        AtsrConstantsTest.assertEquals((String)"Longitude of product LHS corner point at end", (String)"Longitude of product LHS corner point at end");
        AtsrConstantsTest.assertEquals((String)"Longitude of product RHS corner point at end", (String)"Longitude of product RHS corner point at end");
        AtsrConstantsTest.assertEquals((String)"1st and 2nd ATSR-2 Pixel Selection Maps in nadir-view", (String)"1st and 2nd ATSR-2 Pixel Selection Maps in nadir-view");
        AtsrConstantsTest.assertEquals((String)"Along-track distance of 1st PSM change in nadir-view", (String)"Along-track distance of 1st PSM change in nadir-view");
        AtsrConstantsTest.assertEquals((String)"km", (String)"km");
        AtsrConstantsTest.assertEquals((String)"1st and 2nd ATSR-2 Pixel Selection Maps in forward-view", (String)"1st and 2nd ATSR-2 Pixel Selection Maps in forward-view");
        AtsrConstantsTest.assertEquals((String)"Along-track distance of 1st PSM change in forward-view", (String)"Along-track distance of 1st PSM change in forward-view");
        AtsrConstantsTest.assertEquals((String)"ATSR-2 data-rate at start of nadir-view", (String)"ATSR-2 data-rate at start of nadir-view");
        AtsrConstantsTest.assertEquals((String)"Along-track distance of 1st ATSR-2 data-rate change in nadir-view", (String)"Along-track distance of 1st ATSR-2 data-rate change in nadir-view");
        AtsrConstantsTest.assertEquals((String)"km", (String)"km");
        AtsrConstantsTest.assertEquals((String)"ATSR-2 data-rate at start of forward-view", (String)"ATSR-2 data-rate at start of forward-view");
        AtsrConstantsTest.assertEquals((String)"Along-track distance of 1st ATSR-2 data-rate change in forward-view", (String)"Along-track distance of 1st ATSR-2 data-rate change in forward-view");
        AtsrConstantsTest.assertEquals((String)"Minimum Stirling Cycle Cooler cold-tip temperature", (String)"Minimum Stirling Cycle Cooler cold-tip temperature");
        AtsrConstantsTest.assertEquals((String)"K", (String)"K");
        AtsrConstantsTest.assertEquals((String)"Minimum instrument detector temperature at 1200 nm", (String)"Minimum instrument detector temperature at 1200 nm");
        AtsrConstantsTest.assertEquals((String)"Minimum instrument detector temperature at 1100 nm", (String)"Minimum instrument detector temperature at 1100 nm");
        AtsrConstantsTest.assertEquals((String)"Minimum instrument detector temperature at 370 nm", (String)"Minimum instrument detector temperature at 370 nm");
        AtsrConstantsTest.assertEquals((String)"Minimum instrument detector temperature at 160 nm", (String)"Minimum instrument detector temperature at 160 nm");
        AtsrConstantsTest.assertEquals((String)"Minimum instrument detector temperature at 87 nm", (String)"Minimum instrument detector temperature at 87 nm");
        AtsrConstantsTest.assertEquals((String)"Maximum Stirling Cycle Cooler cold-tip temperature", (String)"Maximum Stirling Cycle Cooler cold-tip temperature");
        AtsrConstantsTest.assertEquals((String)"Maximum instrument detector temperature at 1200 nm", (String)"Maximum instrument detector temperature at 1200 nm");
        AtsrConstantsTest.assertEquals((String)"Maximum instrument detector temperature at 1100 nm", (String)"Maximum instrument detector temperature at 1100 nm");
        AtsrConstantsTest.assertEquals((String)"Maximum instrument detector temperature at 370 nm", (String)"Maximum instrument detector temperature at 370 nm");
        AtsrConstantsTest.assertEquals((String)"Maximum instrument detector temperature at 160 nm", (String)"Maximum instrument detector temperature at 160 nm");
        AtsrConstantsTest.assertEquals((String)"Maximum instrument detector temperature at 87 nm", (String)"Maximum instrument detector temperature at 87 nm");
        AtsrConstantsTest.assertEquals((String)"dec. deg.", (String)"dec. deg.");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during nadir view as # of scans in YSM", (String)"ERS platform modes during nadir view as # of scans in YSM");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during nadir view as # of scans in FCM", (String)"ERS platform modes during nadir view as # of scans in FCM");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during nadir view as # of scans in OCM", (String)"ERS platform modes during nadir view as # of scans in OCM");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during nadir view as # of scans in FPM", (String)"ERS platform modes during nadir view as # of scans in FPM");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during nadir view as # of scans in RTMM", (String)"ERS platform modes during nadir view as # of scans in RTMM");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during nadir view as # of scans in RTMC", (String)"ERS platform modes during nadir view as # of scans in RTMC");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during forward view as # of scans in YSM", (String)"ERS platform modes during forward view as # of scans in YSM");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during forward view as # of scans in FCM", (String)"ERS platform modes during forward view as # of scans in FCM");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during forward view as # of scans in OCM", (String)"ERS platform modes during forward view as # of scans in OCM");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during forward view as # of scans in FPM", (String)"ERS platform modes during forward view as # of scans in FPM");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during forward view as # of scans in RTMM", (String)"ERS platform modes during forward view as # of scans in RTMM");
        AtsrConstantsTest.assertEquals((String)"ERS platform modes during forward view as # of scans in RTMC", (String)"ERS platform modes during forward view as # of scans in RTMC");
        AtsrConstantsTest.assertEquals((String)"Acquisition of PCD information during nadir-view as # of scans for each condition", (String)"Acquisition of PCD information during nadir-view as # of scans for each condition");
        AtsrConstantsTest.assertEquals((String)"Acquisition of PCD information during forward-view as # of scans for each condition", (String)"Acquisition of PCD information during forward-view as # of scans for each condition");
        AtsrConstantsTest.assertEquals((String)"SADIST-2 packet validation during nadir-view as # of scans for each condition", (String)"SADIST-2 packet validation during nadir-view as # of scans for each condition");
        AtsrConstantsTest.assertEquals((String)"SADIST-2 packet validation during forward-view as # of scans for each condition", (String)"SADIST-2 packet validation during forward-view as # of scans for each condition");
        AtsrConstantsTest.assertEquals((String)"Maximum single-pixel error code", (String)"Maximum single-pixel error code");
        AtsrConstantsTest.assertEquals((String)"Nadir-view solar elevation", (String)"Nadir-view solar elevation");
        AtsrConstantsTest.assertEquals((String)"Nadir-view satellite elevation", (String)"Nadir-view satellite elevation");
        AtsrConstantsTest.assertEquals((String)"Nadir-view solar azimuth", (String)"Nadir-view solar azimuth");
        AtsrConstantsTest.assertEquals((String)"Nadir-view satellite azimuth", (String)"Nadir-view satellite azimuth");
        AtsrConstantsTest.assertEquals((String)"Forward-view solar elevation", (String)"Forward-view solar elevation");
        AtsrConstantsTest.assertEquals((String)"Forward-view satellite elevation", (String)"Forward-view satellite elevation");
        AtsrConstantsTest.assertEquals((String)"Forward-view solar azimuth", (String)"Forward-view solar azimuth");
        AtsrConstantsTest.assertEquals((String)"Forward-view satellite azimuth", (String)"Forward-view satellite azimuth");
        AtsrConstantsTest.assertEquals((String)"Longitudes of image pixels", (String)"Longitudes of image pixels");
        AtsrConstantsTest.assertEquals((String)"Latitudes of image pixels", (String)"Latitudes of image pixels");
    }

    public void testMetadataConstants() {
        AtsrConstantsTest.assertEquals((String)"MPH", (String)"MPH");
        AtsrConstantsTest.assertEquals((String)"SPH", (String)"SPH");
    }

    public void testProductSizeConstants() {
        AtsrConstantsTest.assertEquals((int)512, (int)512);
        AtsrConstantsTest.assertEquals((int)512, (int)512);
        AtsrConstantsTest.assertEquals((int)11, (int)11);
        AtsrConstantsTest.assertEquals((int)2, (int)2);
        AtsrConstantsTest.assertEquals((int)50, (int)50);
        AtsrConstantsTest.assertEquals((int)512, (int)512);
        AtsrConstantsTest.assertEquals((double)6.0, (double)6.0, (double)1.0E-6);
        AtsrConstantsTest.assertEquals((int)16, (int)16);
        AtsrConstantsTest.assertEquals((int)16, (int)16);
    }

    public void testPixelSizes() {
        AtsrConstantsTest.assertEquals((int)2, (int)2);
        AtsrConstantsTest.assertEquals((int)2, (int)2);
        AtsrConstantsTest.assertEquals((int)2, (int)2);
        AtsrConstantsTest.assertEquals((int)2, (int)2);
        AtsrConstantsTest.assertEquals((int)4, (int)4);
        AtsrConstantsTest.assertEquals((int)1, (int)1);
        AtsrConstantsTest.assertEquals((int)2, (int)2);
    }

    public void testConversionConstants() {
        AtsrConstantsTest.assertEquals((double)0.001f, (double)0.001f, (double)1.0E-6);
    }

    public void testFlagCodings() {
        AtsrConstantsTest.assertEquals((String)"Nadir-view cloud-clearing/land-flagging results", (String)"Nadir-view cloud-clearing/land-flagging results");
        AtsrConstantsTest.assertEquals((String)"Forward-view cloud-clearing/land-flagging results", (String)"Forward-view cloud-clearing/land-flagging results");
        AtsrConstantsTest.assertEquals((String)"cloud_flags_nadir", (String)"cloud_flags_nadir");
        AtsrConstantsTest.assertEquals((String)"cloud_flags_fward", (String)"cloud_flags_fward");
        AtsrConstantsTest.assertEquals((String)"LAND", (String)"LAND");
        AtsrConstantsTest.assertEquals((int)1, (int)1);
        AtsrConstantsTest.assertEquals((String)"Pixel is over land", (String)"Pixel is over land");
        AtsrConstantsTest.assertEquals((String)"CLOUDY", (String)"CLOUDY");
        AtsrConstantsTest.assertEquals((int)2, (int)2);
        AtsrConstantsTest.assertEquals((String)"Pixel is cloudy (result of all cloud tests)", (String)"Pixel is cloudy (result of all cloud tests)");
        AtsrConstantsTest.assertEquals((String)"SUN_GLINT", (String)"SUN_GLINT");
        AtsrConstantsTest.assertEquals((int)4, (int)4);
        AtsrConstantsTest.assertEquals((String)"Sunglint detected in pixel", (String)"Sunglint detected in pixel");
        AtsrConstantsTest.assertEquals((String)"CLOUDY_REFL_HIST", (String)"CLOUDY_REFL_HIST");
        AtsrConstantsTest.assertEquals((int)8, (int)8);
        AtsrConstantsTest.assertEquals((String)"1.6 um reflectance histogram test (day-time only)", (String)"1.6 um reflectance histogram test (day-time only)");
        AtsrConstantsTest.assertEquals((String)"CLOUDY_SPAT_COHER_16", (String)"CLOUDY_SPAT_COHER_16");
        AtsrConstantsTest.assertEquals((int)16, (int)16);
        AtsrConstantsTest.assertEquals((String)"1.6 um spatial coherence test (day-time only)", (String)"1.6 um spatial coherence test (day-time only)");
        AtsrConstantsTest.assertEquals((String)"CLOUDY_SPAT_COHER_11", (String)"CLOUDY_SPAT_COHER_11");
        AtsrConstantsTest.assertEquals((int)32, (int)32);
        AtsrConstantsTest.assertEquals((String)"11 um spatial coherence test", (String)"11 um spatial coherence test");
        AtsrConstantsTest.assertEquals((String)"CLOUDY_GROSS_12", (String)"CLOUDY_GROSS_12");
        AtsrConstantsTest.assertEquals((int)64, (int)64);
        AtsrConstantsTest.assertEquals((String)"12 um gross cloud test", (String)"12 um gross cloud test");
        AtsrConstantsTest.assertEquals((String)"CLOUDY_CIRRUS_11_12", (String)"CLOUDY_CIRRUS_11_12");
        AtsrConstantsTest.assertEquals((int)128, (int)128);
        AtsrConstantsTest.assertEquals((String)"11/12 um thin cirrus test", (String)"11/12 um thin cirrus test");
        AtsrConstantsTest.assertEquals((String)"CLOUDY_MED_HI_LEVEL_37_12", (String)"CLOUDY_MED_HI_LEVEL_37_12");
        AtsrConstantsTest.assertEquals((int)256, (int)256);
        AtsrConstantsTest.assertEquals((String)"3.7/12 um medium/high level test (night-time only)", (String)"3.7/12 um medium/high level test (night-time only)");
        AtsrConstantsTest.assertEquals((String)"CLOUDY_FOG_LOW_STRATUS_11_37", (String)"CLOUDY_FOG_LOW_STRATUS_11_37");
        AtsrConstantsTest.assertEquals((int)512, (int)512);
        AtsrConstantsTest.assertEquals((String)"11/3.7 um fog/low stratus test (night-time only)", (String)"11/3.7 um fog/low stratus test (night-time only)");
        AtsrConstantsTest.assertEquals((String)"CLOUDY_VW_DIFF_11_12", (String)"CLOUDY_VW_DIFF_11_12");
        AtsrConstantsTest.assertEquals((int)1024, (int)1024);
        AtsrConstantsTest.assertEquals((String)"11/12 um view difference test", (String)"11/12 um view difference test");
        AtsrConstantsTest.assertEquals((String)"CLOUDY_VW_DIFF_37_11", (String)"CLOUDY_VW_DIFF_37_11");
        AtsrConstantsTest.assertEquals((int)2048, (int)2048);
        AtsrConstantsTest.assertEquals((String)"3.7/11 um view difference test (night-time only)", (String)"3.7/11 um view difference test (night-time only)");
        AtsrConstantsTest.assertEquals((String)"CLOUDY_THERM_HIST_11_12", (String)"CLOUDY_THERM_HIST_11_12");
        AtsrConstantsTest.assertEquals((int)4096, (int)4096);
        AtsrConstantsTest.assertEquals((String)"11/12 um thermal histogram test", (String)"11/12 um thermal histogram test");
    }
}

