/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;
import org.esa.s3tbx.dataio.ceos.records.TextRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextRecordTest {
    private MemoryCacheImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    @Before
    public void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "TextRecordTest_prefix";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("TextRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    @Test
    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        TextRecord textRecord = new TextRecord(this._reader);
        this.assertRecord(textRecord);
    }

    @Test
    public void testInit() throws IOException, IllegalCeosFormatException {
        TextRecord textRecord = new TextRecord(this._reader, (long)this._prefix.length());
        this.assertRecord(textRecord);
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("A ");
        ios.skipBytes(2);
        ios.writeBytes("PRODUCT:O1B2R_UB                        ");
        ios.writeBytes("PROCESS:JAPAN-JAXA-EOC-ALOS-DPS  20060410075225             ");
        ios.writeBytes("ORBIT:ALPSMB003062950                   ");
        ios.writeBytes("BSQ ");
        CeosTestHelper.writeBlanks(ios, 200);
    }

    private void assertRecord(TextRecord record) throws IOException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        Assert.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this._prefix.length() + 360), (long)this._ios.getStreamPosition());
        Assert.assertEquals((Object)"A ", (Object)record.getCodeCharacter());
        Assert.assertEquals((Object)"O1B2R_UB", (Object)record.getProductID());
        Assert.assertEquals((Object)"PROCESS:JAPAN-JAXA-EOC-ALOS-DPS  20060410075225             ", (Object)record.getFacility());
        Assert.assertEquals((Object)"ALPSMB003062950", (Object)record.getSceneID());
        Assert.assertEquals((Object)"BSQ ", (Object)record.getImageFormat());
    }
}

