/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;
import org.esa.s3tbx.dataio.ceos.records.ImageRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageRecordTest {
    private MemoryCacheImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    @Before
    public void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "ImageRecordTest_prefix";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("ImageRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    @Test
    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        ImageRecord record = new ImageRecord(this._reader);
        this.assertRecord(record);
    }

    @Test
    public void testInit() throws IOException, IllegalCeosFormatException {
        ImageRecord record = new ImageRecord(this._reader, (long)this._prefix.length());
        this.assertRecord(record);
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeInt(1234);
        ios.writeInt(2345);
        ios.writeInt(3456);
        ios.writeShort(4567);
        ios.writeInt(5678);
        ios.writeInt(6789);
        CeosTestHelper.writeBlanks(ios, 4646);
    }

    private void assertRecord(ImageRecord record) throws IOException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        Assert.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        Assert.assertEquals((long)1234L, (long)record.getPrefixDataLineNumber());
        Assert.assertEquals((long)2345L, (long)record.getImageNumber());
        Assert.assertEquals((long)3456L, (long)record.getScanStartTimeMillisAtDay());
        Assert.assertEquals((long)4567L, (long)record.getScanStartTimeMicros());
        Assert.assertEquals((long)5678L, (long)record.getNumLeftDummyPixels());
        Assert.assertEquals((long)6789L, (long)record.getNumRightDummyPixels());
    }
}

