/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;
import org.esa.s3tbx.dataio.ceos.records.FilePointerRecord;
import org.esa.snap.core.datamodel.MetadataElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilePointerRecordTest {
    private ImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    @Before
    public void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "fdkjglsdkfhierr.m b9b0970w34";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    @Test
    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._ios.seek(this._prefix.length());
        FilePointerRecord record = new FilePointerRecord(this._reader);
        this.assertRecord(record);
        Assert.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this._prefix.length() + 360), (long)this._ios.getStreamPosition());
    }

    @Test
    public void testInit() throws IOException, IllegalCeosFormatException {
        FilePointerRecord record = new FilePointerRecord(this._reader, (long)this._prefix.length());
        this.assertRecord(record);
        Assert.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this._prefix.length() + 360), (long)this._ios.getStreamPosition());
    }

    @Test
    public void testAssignMetadataTo() throws IOException, IllegalCeosFormatException {
        FilePointerRecord record = new FilePointerRecord(this._reader, (long)this._prefix.length());
        MetadataElement elem = new MetadataElement("elem");
        record.assignMetadataTo(elem, "suffix");
        Assert.assertEquals((long)0L, (long)elem.getNumAttributes());
        Assert.assertEquals((long)1L, (long)elem.getNumElements());
        MetadataElement recordRoot = elem.getElement("FilePointerRecord suffix");
        Assert.assertNotNull((Object)recordRoot);
        FilePointerRecordTest.assertMetadata(recordRoot);
        Assert.assertEquals((long)0L, (long)recordRoot.getNumElements());
        Assert.assertEquals((long)21L, (long)recordRoot.getNumAttributes());
    }

    public static void assertMetadata(MetadataElement elem) {
        BaseRecordTest.assertMetadata(elem);
        BaseRecordTest.assertStringAttribute(elem, "Code character", "A ");
        BaseRecordTest.assertIntAttribute(elem, "File pointer number", 2);
        BaseRecordTest.assertStringAttribute(elem, "File ID", "AL PSMB2IMGYBSQ ");
        BaseRecordTest.assertStringAttribute(elem, "File class", "IMAGERY                     ");
        BaseRecordTest.assertStringAttribute(elem, "File class code", "IMGY");
        BaseRecordTest.assertStringAttribute(elem, "File datatype", "BINARY ONLY                 ");
        BaseRecordTest.assertStringAttribute(elem, "File datatype code", "BINO");
        BaseRecordTest.assertIntAttribute(elem, "Number of records", 14001);
        BaseRecordTest.assertIntAttribute(elem, "First record length", 897623);
        BaseRecordTest.assertIntAttribute(elem, "Max record length", 8634264);
        BaseRecordTest.assertStringAttribute(elem, "Record lengthtype", "FIXED LENGTH");
        BaseRecordTest.assertStringAttribute(elem, "Record lengthtype code", "FIXD");
        BaseRecordTest.assertIntAttribute(elem, "First record volume numer", 1);
        BaseRecordTest.assertIntAttribute(elem, "Final record volume number", 2);
        BaseRecordTest.assertIntAttribute(elem, "First record number of referenced file", 3);
    }

    private void assertRecord(FilePointerRecord record) {
        BaseRecordTest.assertRecord((BaseRecord)record);
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((Object)"A ", (Object)record.getCodeCharacter());
        Assert.assertEquals((long)2L, (long)record.getFilePointerNumber());
        Assert.assertEquals((Object)"AL PSMB2IMGYBSQ ", (Object)record.getFileID());
        Assert.assertEquals((Object)"IMAGERY                     ", (Object)record.getFileClass());
        Assert.assertEquals((Object)"IMGY", (Object)record.getFileClassCode());
        Assert.assertEquals((Object)"BINARY ONLY                 ", (Object)record.getFileDataType());
        Assert.assertEquals((Object)"BINO", (Object)record.getFileDataTypeCode());
        Assert.assertEquals((long)14001L, (long)record.getNumberOfRecords());
        Assert.assertEquals((long)897623L, (long)record.getFirstRecordLength());
        Assert.assertEquals((long)8634264L, (long)record.getMaxRecordLength());
        Assert.assertEquals((Object)"FIXED LENGTH", (Object)record.getRecordLengthType());
        Assert.assertEquals((Object)"FIXD", (Object)record.getRecordLengthTypeCode());
        Assert.assertEquals((long)1L, (long)record.getFirstRecordVolumeNumber());
        Assert.assertEquals((long)2L, (long)record.getFinalRecordVolumeNumber());
        Assert.assertEquals((long)3L, (long)record.getFirstRecordNumberOfReferencedFile());
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("A ");
        ios.skipBytes(2);
        ios.writeBytes("   2");
        ios.writeBytes("AL PSMB2IMGYBSQ ");
        ios.writeBytes("IMAGERY                     ");
        ios.writeBytes("IMGY");
        ios.writeBytes("BINARY ONLY                 ");
        ios.writeBytes("BINO");
        ios.writeBytes("   14001");
        ios.writeBytes("  897623");
        ios.writeBytes(" 8634264");
        ios.writeBytes("FIXED LENGTH");
        ios.writeBytes("FIXD");
        ios.writeBytes(" 1");
        ios.writeBytes(" 2");
        ios.writeBytes("       3");
        ios.writeBytes("                                                                                                                                                                                                                ");
    }
}

