/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseImageFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.CommonFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.CommonFileDescriptorRecordTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseImageFileDescriptorRecordTest {
    private MemoryCacheImageOutputStream ios;
    private String prefix;
    private CeosFileReader reader;

    @Before
    public void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this.ios = new MemoryCacheImageOutputStream(os);
        this.prefix = "AbstractImageFileDescriptorRecordTest_prefix";
        this.ios.writeBytes(this.prefix);
        this.writeRecordData(this.ios);
        this.ios.writeBytes("AbstractImageFileDescriptorRecordTest_suffix");
        this.reader = new CeosFileReader((ImageInputStream)this.ios);
    }

    @Test
    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this.reader.seek((long)this.prefix.length());
        BaseImageFileDescriptorRecord record = this.createImageFileDescriptorRecord(this.reader);
        Assert.assertEquals((long)this.prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this.prefix.length() + 4680), (long)this.ios.getStreamPosition());
        this.assertRecord(record);
    }

    @Test
    public void testInit() throws IOException, IllegalCeosFormatException {
        BaseImageFileDescriptorRecord record = this.createImageFileDescriptor(this.reader, this.prefix.length());
        Assert.assertEquals((long)this.prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this.prefix.length() + 4680), (long)this.ios.getStreamPosition());
        this.assertRecord(record);
    }

    protected void writeRecordData(ImageOutputStream ios) throws IOException {
        CommonFileDescriptorRecordTest.writeRecordData(ios);
        ios.writeBytes(" 12546");
        ios.writeBytes(" 12487");
        CeosTestHelper.writeBlanks(ios, 24);
        ios.writeBytes(" 123");
        ios.writeBytes(" 234");
        ios.writeBytes(" 345");
        ios.writeBytes("abcd");
        ios.writeBytes(" 567");
        ios.writeBytes("14587962");
        ios.writeBytes("1245");
        ios.writeBytes("24568954");
        ios.writeBytes("6542");
        ios.writeBytes("5432");
        ios.writeBytes("4321");
        ios.writeBytes("bcde");
        ios.writeBytes(" 852");
        ios.writeBytes(" 963");
        ios.writeBytes(" 741");
        ios.writeBytes("24562583");
        ios.writeBytes(" 987");
        ios.writeBytes("sdef");
        ios.writeBytes("   1 4PB");
        ios.writeBytes("   5 4PB");
        ios.writeBytes("   9 6PB");
        ios.writeBytes("  15 4PB");
        ios.writeBytes("  19 4PB");
        this.writeBytes341To392(ios);
        ios.writeBytes("oiklfd4klsgjopesirmfdlknaoiawef5lkdd");
        ios.writeBytes("BVFR");
        ios.writeBytes(" 753");
        ios.writeBytes(" 357");
        ios.writeBytes(" 242");
        CeosTestHelper.writeBlanks(ios, 4);
        CeosTestHelper.writeBlanks(ios, 8);
        CeosTestHelper.writeBlanks(ios, 8);
        CeosTestHelper.writeBlanks(ios, 4216);
    }

    protected void assertRecord(BaseImageFileDescriptorRecord record) {
        CommonFileDescriptorRecordTest.assertRecord((CommonFileDescriptorRecord)record);
        Assert.assertEquals((long)12546L, (long)record.getNumImageRecords());
        Assert.assertEquals((long)12487L, (long)record.getImageRecordLength());
        Assert.assertEquals((long)123L, (long)record.getNumBitsPerPixel());
        Assert.assertEquals((long)234L, (long)record.getNumPixelsPerData());
        Assert.assertEquals((long)345L, (long)record.getNumBytesPerData());
        Assert.assertEquals((Object)"abcd", (Object)record.getBitlistOfPixel());
        Assert.assertEquals((long)567L, (long)record.getNumBandsPerFile());
        Assert.assertEquals((long)14587962L, (long)record.getNumLinesPerBand());
        Assert.assertEquals((long)1245L, (long)record.getNumLeftBorderPixelsPerLine());
        Assert.assertEquals((long)24568954L, (long)record.getNumImagePixelsPerLine());
        Assert.assertEquals((long)6542L, (long)record.getNumRightBorderPixelsPerLine());
        Assert.assertEquals((long)5432L, (long)record.getNumTopBorderLines());
        Assert.assertEquals((long)4321L, (long)record.getNumBottomBorderLines());
        Assert.assertEquals((Object)"bcde", (Object)record.getImageFormatID());
        Assert.assertEquals((long)852L, (long)record.getNumRecordsPerLineSingleUnit());
        Assert.assertEquals((long)963L, (long)record.getNumRecordsPerLine());
        Assert.assertEquals((long)741L, (long)record.getNumBytesCoverIdentifierAndHeader());
        Assert.assertEquals((long)24562583L, (long)record.getNumImgDataBytesPerRecAndDummyPix());
        Assert.assertEquals((long)987L, (long)record.getNumBytesOfSuffixDataPerRecord());
        Assert.assertEquals((Object)"sdef", (Object)record.getFlagPrefixDataRepeat());
        Assert.assertEquals((Object)"   1 4PB", (Object)record.getLocatorLineNumber());
        Assert.assertEquals((Object)"   5 4PB", (Object)record.getLocatorBandNumber());
        Assert.assertEquals((Object)"   9 6PB", (Object)record.getLocatorScanStartTime());
        Assert.assertEquals((Object)"  15 4PB", (Object)record.getLocatorLeftDummyPixel());
        Assert.assertEquals((Object)"  19 4PB", (Object)record.getLocatorRightDummyPixel());
        this.assertBytes341To392(record);
        Assert.assertEquals((Object)"oiklfd4klsgjopesirmfdlknaoiawef5lkdd", (Object)record.getDataFormatTypeId());
        Assert.assertEquals((Object)"BVFR", (Object)record.getDataFormatTypeIdCode());
        Assert.assertEquals((long)753L, (long)record.getNumLeftUnusedBitsInPixelData());
        Assert.assertEquals((long)357L, (long)record.getNumRightUnusedBitsInPixelData());
        Assert.assertEquals((long)242L, (long)record.getMaxPixelDataValue());
    }

    protected abstract BaseImageFileDescriptorRecord createImageFileDescriptorRecord(CeosFileReader var1) throws IOException, IllegalCeosFormatException;

    protected abstract BaseImageFileDescriptorRecord createImageFileDescriptor(CeosFileReader var1, int var2) throws IOException, IllegalCeosFormatException;

    protected abstract void writeBytes341To392(ImageOutputStream var1) throws IOException;

    protected abstract void assertBytes341To392(BaseImageFileDescriptorRecord var1);
}

