/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.Ancillary1Record;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class Ancillary1RecordTest {
    private static final int RECORD_LENGTH = 4680;
    private MemoryCacheImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    @Before
    public void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "fdkjglsdkfhierr.m b9b0970w34";
        this._ios.writeBytes(this._prefix);
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    @Test
    public void testInitRecord_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this.writeRecordData(this._ios);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        this._reader.seek((long)this._prefix.length());
        Ancillary1Record record = this.createAncillary1Record(this._reader);
        this.assertRecord(record);
    }

    @Test
    public void testInitRecord() throws IOException, IllegalCeosFormatException {
        this.writeRecordData(this._ios);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        Ancillary1Record record = this.createAncillary1Record(this._reader, this._prefix.length());
        this.assertRecord(record);
    }

    @Test
    public void testInitRecord_exceptions() throws IOException, IllegalCeosFormatException, NoSuchMethodException, IllegalAccessException {
        this.writeRecordDataForExceptions(this._ios);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        Ancillary1Record record = this.createAncillary1Record(new CeosFileReader((ImageInputStream)this._ios), this._prefix.length());
        this.assertExceptions(record);
    }

    private void assertRecord(Ancillary1Record record) throws IOException, IllegalCeosFormatException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        Assert.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        Assert.assertEquals((long)16959L, (long)record.getNumNominalPixelsPerLine_1A_1B1());
        Assert.assertEquals((long)14000L, (long)record.getNumNominalLinesPerScene_1A_1B1());
        Assert.assertEquals((double)2.5, (double)record.getNominalInterPixelDistance_1A_1B1(), (double)1.0E-8);
        Assert.assertEquals((double)3.5, (double)record.getNominalInterLineDistance_1A_1B1(), (double)1.0E-8);
        Assert.assertEquals((double)4.5, (double)record.getImageSkew(), (double)1.0E-8);
        Assert.assertEquals((long)1L, (long)record.getHemisphere());
        Assert.assertEquals((long)35L, (long)record.getUTMZoneNumber());
        Assert.assertEquals((double)5.5, (double)record.getSceneCenterNorthing(), (double)1.0E-8);
        Assert.assertEquals((double)6.5, (double)record.getSceneCenterEasting(), (double)1.0E-8);
        Assert.assertEquals((double)7.5, (double)record.getAngleBetweenMapUTMVerticalAndTrueNorth(), (double)1.0E-8);
        Assert.assertEquals((double)8.5, (double)record.getMapProjOriginLat(), (double)1.0E-8);
        Assert.assertEquals((double)9.5, (double)record.getMapProjOriginLon(), (double)1.0E-8);
        Assert.assertEquals((double)10.5, (double)record.getPSReferenceLat(), (double)1.0E-8);
        Assert.assertEquals((double)11.5, (double)record.getPSReferenceLon(), (double)1.0E-8);
        Assert.assertEquals((double)12.5, (double)record.getSceneCenterX(), (double)1.0E-8);
        Assert.assertEquals((double)13.5, (double)record.getSceneCenterY(), (double)1.0E-8);
        Assert.assertEquals((double)14.5, (double)record.getAngleBetweenMapPSVerticalAndTrueNorth(), (double)1.0E-8);
        Assert.assertEquals((double)15.5, (double)record.getNumNominalPixelsPerLine(), (double)1.0E-8);
        Assert.assertEquals((double)16.5, (double)record.getNumNominalLinesPerScene(), (double)1.0E-8);
        Assert.assertEquals((double)17.5, (double)record.getNominalInterPixelDistance(), (double)1.0E-8);
        Assert.assertEquals((double)18.5, (double)record.getNominalInterLineDistance(), (double)1.0E-8);
        Assert.assertEquals((double)19.5, (double)record.getAngleBetweenMapVerticalAndTrueNorth(), (double)1.0E-8);
        Assert.assertEquals((double)20.5, (double)record.getNominalSateliteOrbitInclination(), (double)1.0E-8);
        Assert.assertEquals((double)21.5, (double)record.getNominalAscendingNodeLon(), (double)1.0E-8);
        Assert.assertEquals((double)22.5, (double)record.getNominalSateliteAltitude(), (double)1.0E-8);
        Assert.assertEquals((double)23.5, (double)record.getNominalGroundSpeed(), (double)1.0E-8);
        Assert.assertEquals((double)24.5, (double)record.getSatteliteHeadingAngleIncludingEarthRotationOfSceneCenter(), (double)1.0E-8);
        Assert.assertEquals((double)25.5, (double)record.getSwathAngle(), (double)1.0E-8);
        Assert.assertEquals((double)26.5, (double)record.getNominalScanRate(), (double)1.0E-8);
        Assert.assertEquals((Object)"kjfojmekmvdoklms", (Object)record.getReferenceEllipsoid());
        Assert.assertEquals((double)27.5, (double)record.getSemimajorAxisOfReferenceEllipsoid(), (double)1.0E-8);
        Assert.assertEquals((double)28.5, (double)record.getSemiminorAxisOfReferenceEllipsoid(), (double)1.0E-8);
        Assert.assertEquals((Object)"uih0897n434kljss", (Object)record.getGeodeticCoordinateName());
        double[] latCoeffs = record.getLatCoeffs_1B2();
        Assert.assertNotNull((Object)latCoeffs);
        Assert.assertEquals((long)10L, (long)latCoeffs.length);
        Assert.assertEquals((double)35.17628253789039, (double)latCoeffs[0], (double)1.0E-50);
        Assert.assertEquals((double)-3.725256331187852E-6, (double)latCoeffs[1], (double)1.0E-50);
        Assert.assertEquals((double)-2.2215447999970105E-5, (double)latCoeffs[2], (double)1.0E-50);
        Assert.assertEquals((double)6.755143773032973E-13, (double)latCoeffs[3], (double)1.0E-50);
        Assert.assertEquals((double)-3.084091141051943E-12, (double)latCoeffs[4], (double)1.0E-50);
        Assert.assertEquals((double)-6.471996919792374E-14, (double)latCoeffs[5], (double)1.0E-50);
        Assert.assertEquals((double)2.3314821005173774E-18, (double)latCoeffs[6], (double)1.0E-50);
        Assert.assertEquals((double)-8.250042936031357E-19, (double)latCoeffs[7], (double)1.0E-50);
        Assert.assertEquals((double)3.8969593104739686E-19, (double)latCoeffs[8], (double)1.0E-50);
        Assert.assertEquals((double)7.628813232677477E-20, (double)latCoeffs[9], (double)1.0E-50);
        double[] lonCoeffs = record.getLonCoeffs_1B2();
        Assert.assertNotNull((Object)lonCoeffs);
        Assert.assertEquals((long)10L, (long)lonCoeffs.length);
        Assert.assertEquals((double)138.25715359181038, (double)lonCoeffs[0], (double)1.0E-50);
        Assert.assertEquals((double)2.705690480229972E-5, (double)lonCoeffs[1], (double)1.0E-50);
        Assert.assertEquals((double)-4.53710988950547E-6, (double)lonCoeffs[2], (double)1.0E-50);
        Assert.assertEquals((double)-7.30238602559697E-12, (double)lonCoeffs[3], (double)1.0E-50);
        Assert.assertEquals((double)-1.0370239800095817E-12, (double)lonCoeffs[4], (double)1.0E-50);
        Assert.assertEquals((double)1.0369839492731332E-12, (double)lonCoeffs[5], (double)1.0E-50);
        Assert.assertEquals((double)1.9190809700592655E-18, (double)lonCoeffs[6], (double)1.0E-50);
        Assert.assertEquals((double)3.6938636659681725E-18, (double)lonCoeffs[7], (double)1.0E-50);
        Assert.assertEquals((double)-1.231287788096679E-18, (double)lonCoeffs[8], (double)1.0E-50);
        Assert.assertEquals((double)-6.396690245833416E-19, (double)lonCoeffs[9], (double)1.0E-50);
        double[] xCoeffs = record.getXCoeffs_1B2();
        Assert.assertNotNull((Object)xCoeffs);
        Assert.assertEquals((long)10L, (long)xCoeffs.length);
        Assert.assertEquals((double)-4179201.4367966666, (double)xCoeffs[0], (double)1.0E-50);
        Assert.assertEquals((double)-145568.010437628, (double)xCoeffs[1], (double)1.0E-50);
        Assert.assertEquals((double)38647.93385966122, (double)xCoeffs[2], (double)1.0E-50);
        Assert.assertEquals((double)-1238.6207042765625, (double)xCoeffs[3], (double)1.0E-50);
        Assert.assertEquals((double)7245.029941048489, (double)xCoeffs[4], (double)1.0E-50);
        Assert.assertEquals((double)232.25103569107037, (double)xCoeffs[5], (double)1.0E-50);
        Assert.assertEquals((double)15.709718483440996, (double)xCoeffs[6], (double)1.0E-50);
        Assert.assertEquals((double)-1.0663678360793067, (double)xCoeffs[7], (double)1.0E-50);
        Assert.assertEquals((double)-89.61527210264579, (double)xCoeffs[8], (double)1.0E-50);
        Assert.assertEquals((double)-0.5652864409872013, (double)xCoeffs[9], (double)1.0E-50);
        double[] yCoeffs = record.getYCoeffs_1B2();
        Assert.assertNotNull((Object)yCoeffs);
        Assert.assertEquals((long)10L, (long)yCoeffs.length);
        Assert.assertEquals((double)215921.6757542982, (double)yCoeffs[0], (double)1.0E-50);
        Assert.assertEquals((double)10460.858558691902, (double)yCoeffs[1], (double)1.0E-50);
        Assert.assertEquals((double)5768.8691879606795, (double)yCoeffs[2], (double)1.0E-50);
        Assert.assertEquals((double)56.5591484966379, (double)yCoeffs[3], (double)1.0E-50);
        Assert.assertEquals((double)-1848.6433081219247, (double)yCoeffs[4], (double)1.0E-50);
        Assert.assertEquals((double)73.60762758714878, (double)yCoeffs[5], (double)1.0E-50);
        Assert.assertEquals((double)9.120082436269685, (double)yCoeffs[6], (double)1.0E-50);
        Assert.assertEquals((double)-2.1573385612990768, (double)yCoeffs[7], (double)1.0E-50);
        Assert.assertEquals((double)5.528499219454698, (double)yCoeffs[8], (double)1.0E-50);
        Assert.assertEquals((double)-0.42620715924067065, (double)yCoeffs[9], (double)1.0E-50);
        double[] f4FunctionCoeffs = record.getF4FunctionCoeffs_1B2();
        Assert.assertNotNull((Object)f4FunctionCoeffs);
        Assert.assertEquals((long)6L, (long)f4FunctionCoeffs.length);
        Assert.assertEquals((double)10.23456, (double)f4FunctionCoeffs[0], (double)1.0E-6);
        Assert.assertEquals((double)11.23456, (double)f4FunctionCoeffs[1], (double)1.0E-6);
        Assert.assertEquals((double)12.23456, (double)f4FunctionCoeffs[2], (double)1.0E-6);
        Assert.assertEquals((double)13.23456, (double)f4FunctionCoeffs[3], (double)1.0E-6);
        Assert.assertEquals((double)14.23456, (double)f4FunctionCoeffs[4], (double)1.0E-6);
        Assert.assertEquals((double)15.23456, (double)f4FunctionCoeffs[5], (double)1.0E-6);
        this.assertCoefficients(record);
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("           16959");
        ios.writeBytes("           14000");
        ios.writeBytes("       2.5000000");
        ios.writeBytes("       3.5000000");
        ios.writeBytes("       4.5000000");
        ios.writeBytes("   1");
        ios.writeBytes("35          ");
        CeosTestHelper.writeBlanks(ios, 16);
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("       5.5000000");
        ios.writeBytes("       6.5000000");
        CeosTestHelper.writeBlanks(ios, 16);
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("       7.5000000");
        CeosTestHelper.writeBlanks(ios, 112);
        ios.writeBytes("       8.5000000");
        ios.writeBytes("       9.5000000");
        ios.writeBytes("      10.5000000");
        ios.writeBytes("      11.5000000");
        CeosTestHelper.writeBlanks(ios, 16);
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("      12.5000000");
        ios.writeBytes("      13.5000000");
        CeosTestHelper.writeBlanks(ios, 16);
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("      14.5000000");
        ios.writeBytes("      15.5000000");
        ios.writeBytes("      16.5000000");
        ios.writeBytes("      17.5000000");
        ios.writeBytes("      18.5000000");
        CeosTestHelper.writeBlanks(ios, 16);
        CeosTestHelper.writeBlanks(ios, 16);
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("      19.5000000");
        ios.writeBytes("      20.5000000");
        ios.writeBytes("      21.5000000");
        ios.writeBytes("      22.5000000");
        ios.writeBytes("      23.5000000");
        ios.writeBytes("      24.5000000");
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("      25.5000000");
        ios.writeBytes("      26.5000000");
        ios.writeBytes("kjfojmekmvdoklms");
        ios.writeBytes("      27.5000000");
        ios.writeBytes("      28.5000000");
        ios.writeBytes("uih0897n434kljss");
        CeosTestHelper.writeBlanks(ios, 128);
        ios.writeBytes(" 3.51762825378903869E+01-3.72525633118785182E-06-2.22154479999701052E-05 6.75514377303297257E-13-3.08409114105194292E-12-6.47199691979237372E-14 2.33148210051737742E-18-8.25004293603135684E-19 3.89695931047396857E-19 7.62881323267747713E-20");
        ios.writeBytes(" 1.38257153591810379E+02 2.70569048022997204E-05-4.53710988950547022E-06-7.30238602559696922E-12-1.03702398000958172E-12 1.03698394927313316E-12 1.91908097005926553E-18 3.69386366596817251E-18-1.23128778809667902E-18-6.39669024583341597E-19");
        ios.writeBytes("-4.17920143679666659E+06-1.45568010437627992E+05 3.86479338596612215E+04-1.23862070427656249E+03 7.24502994104848858E+03 2.32251035691070371E+02 1.57097184834409962E+01-1.06636783607930674E+00-8.96152721026457897E+01-5.65286440987201266E-01");
        ios.writeBytes(" 2.15921675754298194E+05 1.04608585586919016E+04 5.76886918796067948E+03 5.65591484966379028E+01-1.84864330812192475E+03 7.36076275871487837E+01 9.12008243626968529E+00-2.15733856129907675E+00 5.52849921945469802E+00-4.26207159240670652E-01");
        this.writeIncrementingDoubles(10.23456, 6, ios);
        this.writeCoefficients(ios);
        CeosTestHelper.writeBlanks(ios, (int)(4680L - ios.getStreamPosition()));
    }

    protected final void writeIncrementingDoubles(double v, int count, ImageOutputStream ios) throws IOException {
        for (int i = 0; i < count; ++i) {
            ios.writeDouble(v + (double)i);
        }
    }

    private void writeRecordDataForExceptions(MemoryCacheImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        CeosTestHelper.writeBlanks(ios, 752);
        ios.writeBytes("kjfojmekmvdoklms");
        ios.writeBytes("      27.5000000");
        ios.writeBytes("      28.5000000");
        ios.writeBytes("uih0897n434kljss");
        CeosTestHelper.writeBlanks(ios, 3852);
    }

    private void assertExceptions(Ancillary1Record record) throws IOException, NoSuchMethodException, IllegalAccessException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        Assert.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        this.assertException(record, "getNumNominalPixelsPerLine_1A_1B1");
        this.assertException(record, "getNumNominalLinesPerScene_1A_1B1");
        this.assertException(record, "getNominalInterPixelDistance_1A_1B1");
        this.assertException(record, "getNominalInterLineDistance_1A_1B1");
        this.assertException(record, "getImageSkew");
        this.assertException(record, "getHemisphere");
        this.assertException(record, "getUTMZoneNumber");
        this.assertException(record, "getSceneCenterNorthing");
        this.assertException(record, "getSceneCenterEasting");
        this.assertException(record, "getAngleBetweenMapUTMVerticalAndTrueNorth");
        this.assertException(record, "getMapProjOriginLat");
        this.assertException(record, "getMapProjOriginLon");
        this.assertException(record, "getPSReferenceLat");
        this.assertException(record, "getPSReferenceLon");
        this.assertException(record, "getSceneCenterX");
        this.assertException(record, "getSceneCenterY");
        this.assertException(record, "getAngleBetweenMapPSVerticalAndTrueNorth");
        this.assertException(record, "getNumNominalPixelsPerLine");
        this.assertException(record, "getNumNominalLinesPerScene");
        this.assertException(record, "getNominalInterPixelDistance");
        this.assertException(record, "getNominalInterLineDistance");
        this.assertException(record, "getAngleBetweenMapVerticalAndTrueNorth");
        this.assertException(record, "getNominalSateliteOrbitInclination");
        this.assertException(record, "getNominalAscendingNodeLon");
        this.assertException(record, "getNominalSateliteAltitude");
        this.assertException(record, "getNominalGroundSpeed");
        this.assertException(record, "getSatteliteHeadingAngleIncludingEarthRotationOfSceneCenter");
        this.assertException(record, "getSwathAngle");
        this.assertException(record, "getNominalScanRate");
        Assert.assertEquals((Object)"kjfojmekmvdoklms", (Object)record.getReferenceEllipsoid());
        Assert.assertEquals((double)27.5, (double)record.getSemimajorAxisOfReferenceEllipsoid(), (double)1.0E-8);
        Assert.assertEquals((double)28.5, (double)record.getSemiminorAxisOfReferenceEllipsoid(), (double)1.0E-8);
        Assert.assertEquals((Object)"uih0897n434kljss", (Object)record.getGeodeticCoordinateName());
        this.assertException(record, "getLatCoeffs_1B2");
        this.assertException(record, "getLonCoeffs_1B2");
        this.assertException(record, "getXCoeffs_1B2");
        this.assertException(record, "getYCoeffs_1B2");
    }

    private void assertException(Ancillary1Record record, String methodName) throws NoSuchMethodException, IllegalAccessException {
        block2: {
            Method method = record.getClass().getMethod(methodName, new Class[0]);
            String exceptionMessage = "IllegalCeosFormatException expected for method '";
            try {
                method.invoke((Object)record, new Object[0]);
                Assert.fail((String)("IllegalCeosFormatException expected for method '" + methodName + "'"));
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof IllegalCeosFormatException) break block2;
                Assert.fail((String)("IllegalCeosFormatException expected for method '" + methodName + "'"));
            }
        }
    }

    protected abstract Ancillary1Record createAncillary1Record(CeosFileReader var1) throws IOException, IllegalCeosFormatException;

    protected abstract Ancillary1Record createAncillary1Record(CeosFileReader var1, int var2) throws IOException, IllegalCeosFormatException;

    protected abstract void writeCoefficients(ImageOutputStream var1) throws IOException;

    protected abstract void assertCoefficients(Ancillary1Record var1) throws IOException, IllegalCeosFormatException;
}

