/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.prism.records;

import java.io.IOException;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.prism.records.PrismAncillary2Record;
import org.esa.s3tbx.dataio.ceos.records.Ancillary2Record;
import org.esa.s3tbx.dataio.ceos.records.Ancillary2RecordTest;
import org.junit.Assert;

public class PrismAncillary2RecordTest
extends Ancillary2RecordTest {
    @Override
    protected Ancillary2Record createAncillary2Record(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        return new PrismAncillary2Record(reader);
    }

    @Override
    protected Ancillary2Record createAncillary2Record(CeosFileReader reader, int startPos) throws IOException, IllegalCeosFormatException {
        return new PrismAncillary2Record(reader, (long)startPos);
    }

    @Override
    protected void writeSpecificRecordData(MemoryCacheImageOutputStream ios) throws IOException {
        ios.writeBytes("C");
        CeosTestHelper.writeBlanks(ios, 15);
        ios.writeBytes("2345.432");
        ios.writeBytes("5432.345");
        CeosTestHelper.writeBlanks(ios, 2608);
        ios.writeBytes("234.5432");
        ios.writeBytes("543.2345");
        CeosTestHelper.writeBlanks(ios, 1962);
    }

    @Override
    protected void assertSpecificRecordData(Ancillary2Record record) {
        PrismAncillary2Record prismRecord = (PrismAncillary2Record)record;
        Assert.assertEquals((Object)"C", (Object)prismRecord.getCompressionMode());
        Assert.assertEquals((double)2345.432, (double)prismRecord.getCcdTemperature(), (double)1.0E-6);
        Assert.assertEquals((double)5432.345, (double)prismRecord.getSignalProcessingSectionTemperature(), (double)1.0E-6);
        Assert.assertEquals((double)234.5432, (double)prismRecord.getAbsoluteCalibrationGain(), (double)1.0E-6);
        Assert.assertEquals((double)543.2345, (double)prismRecord.getAbsoluteCalibrationOffset(), (double)1.0E-6);
    }
}

