/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2.records;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.avnir2.records.Avnir2ImageFDR;
import org.esa.s3tbx.dataio.ceos.records.BaseImageFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseImageFileDescriptorRecordTest;
import org.junit.Assert;

public class Avnir2ImageFDRTest
extends BaseImageFileDescriptorRecordTest {
    @Override
    protected BaseImageFileDescriptorRecord createImageFileDescriptorRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        return new Avnir2ImageFDR(reader);
    }

    @Override
    protected BaseImageFileDescriptorRecord createImageFileDescriptor(CeosFileReader reader, int startPos) throws IOException, IllegalCeosFormatException {
        return new Avnir2ImageFDR(reader, (long)startPos);
    }

    @Override
    protected void writeBytes341To392(ImageOutputStream ios) throws IOException {
        ios.writeBytes("   112SB");
        ios.writeBytes("  13 8SB");
        ios.writeBytes("  2116SB");
        ios.writeBytes("  3716SB");
        ios.writeBytes("  5312SB");
        ios.writeBytes("  65 2SB");
        CeosTestHelper.writeBlanks(ios, 4);
    }

    @Override
    protected void assertBytes341To392(BaseImageFileDescriptorRecord record) {
        Avnir2ImageFDR avnir2ImageFDR = (Avnir2ImageFDR)record;
        Assert.assertEquals((Object)"   112SB", (Object)avnir2ImageFDR.getLocatorDummyPixel());
        Assert.assertEquals((Object)"  13 8SB", (Object)avnir2ImageFDR.getLocatorOpticalBlack());
        Assert.assertEquals((Object)"  2116SB", (Object)avnir2ImageFDR.getLocatorOpticalWhite());
        Assert.assertEquals((Object)"  3716SB", (Object)avnir2ImageFDR.getLocatorElectricalCalibration());
        Assert.assertEquals((Object)"  5312SB", (Object)avnir2ImageFDR.getLocatorImageAuxiliaryData());
        Assert.assertEquals((Object)"  65 2SB", (Object)avnir2ImageFDR.getLocatorQualityInformation());
    }
}

