/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.CeosTestHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;
import org.esa.beam.dataio.ceos.records.BaseRecordTest;
import org.esa.beam.dataio.ceos.records.VolumeDescriptorRecord;
import org.esa.beam.framework.datamodel.MetadataElement;

public class VolumeDescriptorRecordTest
extends TestCase {
    private MemoryCacheImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "VolumeDescriptorRecordTest_prefix";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("VolumeDescriptorRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        VolumeDescriptorRecord record = new VolumeDescriptorRecord(this._reader);
        this.assertRecord(record);
    }

    public void testInit() throws IOException, IllegalCeosFormatException {
        VolumeDescriptorRecord record = new VolumeDescriptorRecord(this._reader, (long)this._prefix.length());
        this.assertRecord(record);
    }

    public void testAssignMetadata() throws IOException, IllegalCeosFormatException {
        VolumeDescriptorRecord record = new VolumeDescriptorRecord(this._reader, (long)this._prefix.length());
        MetadataElement volumeMetadata = new MetadataElement("VOLUME_DESCRIPTOR");
        record.assignMetadataTo(volumeMetadata, "suffix");
        VolumeDescriptorRecordTest.assertEquals((int)23, (int)volumeMetadata.getNumAttributes());
        VolumeDescriptorRecordTest.assertEquals((int)0, (int)volumeMetadata.getNumElements());
        this.assertMetadata(volumeMetadata);
    }

    private void assertMetadata(MetadataElement elem) {
        BaseRecordTest.assertMetadata(elem);
        BaseRecordTest.assertStringAttribute(elem, "Ascii code character", "AB");
        BaseRecordTest.assertStringAttribute(elem, "Specification number", "abcdefghijkl");
        BaseRecordTest.assertStringAttribute(elem, "Specification revision number", "CD");
        BaseRecordTest.assertStringAttribute(elem, "Record format revision number", "EF");
        BaseRecordTest.assertStringAttribute(elem, "Software version number", "bcdefghijklm");
        BaseRecordTest.assertStringAttribute(elem, "Logical volume ID", "cdefghijklmnopqr");
        BaseRecordTest.assertStringAttribute(elem, "Volume set ID", "defghijklmnopqrs");
        BaseRecordTest.assertIntAttribute(elem, "Volume number of this volume descriptor record", 12);
        BaseRecordTest.assertIntAttribute(elem, "Number of first file following the volume directory file", 2345);
        BaseRecordTest.assertIntAttribute(elem, "Logical volume number in volume set", 3456);
        BaseRecordTest.assertStringAttribute(elem, "Logical volume preparation date", "efghijkl");
        BaseRecordTest.assertStringAttribute(elem, "Logical volume preparation time", "fghijklm");
        BaseRecordTest.assertStringAttribute(elem, "Logical volume preparation country", "ghijklmnopqr");
        BaseRecordTest.assertStringAttribute(elem, "Logical volume preparing agent", "hijklmno");
        BaseRecordTest.assertStringAttribute(elem, "Logical volume preparing facility", "ijklmnopqrst");
        BaseRecordTest.assertIntAttribute(elem, "Number of filepointer records", 4567);
        BaseRecordTest.assertIntAttribute(elem, "Number of records", 5678);
    }

    private void writeRecordData(MemoryCacheImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("AB");
        CeosTestHelper.writeBlanks(ios, 2);
        ios.writeBytes("abcdefghijkl");
        ios.writeBytes("CD");
        ios.writeBytes("EF");
        ios.writeBytes("bcdefghijklm");
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("cdefghijklmnopqr");
        ios.writeBytes("defghijklmnopqrs");
        CeosTestHelper.writeBlanks(ios, 6);
        ios.writeBytes("12");
        ios.writeBytes("2345");
        ios.writeBytes("3456");
        CeosTestHelper.writeBlanks(ios, 4);
        ios.writeBytes("efghijkl");
        ios.writeBytes("fghijklm");
        ios.writeBytes("ghijklmnopqr");
        ios.writeBytes("hijklmno");
        ios.writeBytes("ijklmnopqrst");
        ios.writeBytes("4567");
        ios.writeBytes("5678");
        CeosTestHelper.writeBlanks(ios, 192);
    }

    private void assertRecord(VolumeDescriptorRecord record) throws IOException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        VolumeDescriptorRecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        VolumeDescriptorRecordTest.assertEquals((long)(this._prefix.length() + 360), (long)this._ios.getStreamPosition());
        VolumeDescriptorRecordTest.assertEquals((String)"AB", (String)record.getAsciiCodeCharacter());
        VolumeDescriptorRecordTest.assertEquals((String)"abcdefghijkl", (String)record.getSpecificationNumber());
        VolumeDescriptorRecordTest.assertEquals((String)"CD", (String)record.getSpecificationRevisionNumber());
        VolumeDescriptorRecordTest.assertEquals((String)"EF", (String)record.getRecordFormatRevisionNumer());
        VolumeDescriptorRecordTest.assertEquals((String)"bcdefghijklm", (String)record.getSoftwareVersionNumber());
        VolumeDescriptorRecordTest.assertEquals((String)"cdefghijklmnopqr", (String)record.getLogicalVolumeID());
        VolumeDescriptorRecordTest.assertEquals((String)"defghijklmnopqrs", (String)record.getVolumeSetID());
        VolumeDescriptorRecordTest.assertEquals((int)12, (int)record.getVolumeNumberOfThisVolumeDescritorRecord());
        VolumeDescriptorRecordTest.assertEquals((int)2345, (int)record.getNumberOfFirstFileFollowingTheVolumeDirectoryFile());
        VolumeDescriptorRecordTest.assertEquals((int)3456, (int)record.getLogicalVolumeNumberInVolumeSet());
        VolumeDescriptorRecordTest.assertEquals((String)"efghijkl", (String)record.getLogicalVolumePreparationDate());
        VolumeDescriptorRecordTest.assertEquals((String)"fghijklm", (String)record.getLogicalVolumePreparationTime());
        VolumeDescriptorRecordTest.assertEquals((String)"ghijklmnopqr", (String)record.getLogicalVolumePreparationCountry());
        VolumeDescriptorRecordTest.assertEquals((String)"hijklmno", (String)record.getLogicalVolumePreparingAgent());
        VolumeDescriptorRecordTest.assertEquals((String)"ijklmnopqrst", (String)record.getLogicalVolumePreparingFacility());
        VolumeDescriptorRecordTest.assertEquals((int)4567, (int)record.getNumberOfFilepointerRecords());
        VolumeDescriptorRecordTest.assertEquals((int)5678, (int)record.getNumberOfRecords());
    }
}

