/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.CeosTestHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.CommonFileDescriptorRecord;
import org.esa.beam.dataio.ceos.records.CommonFileDescriptorRecordTest;
import org.esa.beam.dataio.ceos.records.TrailerFileDescriptorRecord;

public class TrailerFileDescriptorRecordTest
extends TestCase {
    private String _prefix;
    private CeosFileReader _reader;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "TrailerFileDescriptorRecordTest_prefix";
        ios.writeBytes(this._prefix);
        this.writeRecordData(ios);
        ios.writeBytes("TrailerFileDescriptorRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)ios);
    }

    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        TrailerFileDescriptorRecord record = new TrailerFileDescriptorRecord(this._reader);
        this.assertRecord(record);
    }

    public void testInit() throws IOException, IllegalCeosFormatException {
        TrailerFileDescriptorRecord record = new TrailerFileDescriptorRecord(this._reader, (long)this._prefix.length());
        this.assertRecord(record);
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        CommonFileDescriptorRecordTest.writeRecordData(ios);
        ios.writeBytes("     1");
        ios.writeBytes("  8460");
        CeosTestHelper.writeBlanks(ios, 24);
        CeosTestHelper.writeBlanks(ios, 8244);
    }

    private void assertRecord(TrailerFileDescriptorRecord record) {
        CommonFileDescriptorRecordTest.assertRecord((CommonFileDescriptorRecord)record);
        TrailerFileDescriptorRecordTest.assertEquals((long)1L, (long)record.getNumTrailerRecords());
        TrailerFileDescriptorRecordTest.assertEquals((long)8460L, (long)record.getTrailerRecordLength());
    }
}

