/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.CeosTestHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;
import org.esa.beam.dataio.ceos.records.BaseRecordTest;
import org.esa.beam.dataio.ceos.records.ImageRecord;

public class ImageRecordTest
extends TestCase {
    private MemoryCacheImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "ImageRecordTest_prefix";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("ImageRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        ImageRecord record = new ImageRecord(this._reader);
        this.assertRecord(record);
    }

    public void testInit() throws IOException, IllegalCeosFormatException {
        ImageRecord record = new ImageRecord(this._reader, (long)this._prefix.length());
        this.assertRecord(record);
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeInt(1234);
        ios.writeInt(2345);
        ios.writeInt(3456);
        ios.writeShort(4567);
        ios.writeInt(5678);
        ios.writeInt(6789);
        CeosTestHelper.writeBlanks(ios, 4646);
    }

    private void assertRecord(ImageRecord record) throws IOException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        ImageRecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        ImageRecordTest.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        ImageRecordTest.assertEquals((int)1234, (int)record.getPrefixDataLineNumber());
        ImageRecordTest.assertEquals((int)2345, (int)record.getImageNumber());
        ImageRecordTest.assertEquals((int)3456, (int)record.getScanStartTimeMillisAtDay());
        ImageRecordTest.assertEquals((int)4567, (int)record.getScanStartTimeMicros());
        ImageRecordTest.assertEquals((int)5678, (int)record.getNumLeftDummyPixels());
        ImageRecordTest.assertEquals((int)6789, (int)record.getNumRightDummyPixels());
    }
}

