/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;
import org.esa.beam.dataio.ceos.records.BaseRecordTest;
import org.esa.beam.dataio.ceos.records.FilePointerRecord;
import org.esa.beam.framework.datamodel.MetadataElement;

public class FilePointerRecordTest
extends TestCase {
    private ImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "fdkjglsdkfhierr.m b9b0970w34";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._ios.seek(this._prefix.length());
        FilePointerRecord record = new FilePointerRecord(this._reader);
        this.assertRecord(record);
        FilePointerRecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        FilePointerRecordTest.assertEquals((long)(this._prefix.length() + 360), (long)this._ios.getStreamPosition());
    }

    public void testInit() throws IOException, IllegalCeosFormatException {
        FilePointerRecord record = new FilePointerRecord(this._reader, (long)this._prefix.length());
        this.assertRecord(record);
        FilePointerRecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        FilePointerRecordTest.assertEquals((long)(this._prefix.length() + 360), (long)this._ios.getStreamPosition());
    }

    public void testAssignMetadataTo() throws IOException, IllegalCeosFormatException {
        FilePointerRecord record = new FilePointerRecord(this._reader, (long)this._prefix.length());
        MetadataElement elem = new MetadataElement("elem");
        record.assignMetadataTo(elem, "suffix");
        FilePointerRecordTest.assertEquals((int)0, (int)elem.getNumAttributes());
        FilePointerRecordTest.assertEquals((int)1, (int)elem.getNumElements());
        MetadataElement recordRoot = elem.getElement("FilePointerRecord suffix");
        FilePointerRecordTest.assertNotNull((Object)recordRoot);
        FilePointerRecordTest.assertMetadata(recordRoot);
        FilePointerRecordTest.assertEquals((int)0, (int)recordRoot.getNumElements());
        FilePointerRecordTest.assertEquals((int)21, (int)recordRoot.getNumAttributes());
    }

    public static void assertMetadata(MetadataElement elem) {
        BaseRecordTest.assertMetadata(elem);
        BaseRecordTest.assertStringAttribute(elem, "Code character", "A ");
        BaseRecordTest.assertIntAttribute(elem, "File pointer number", 2);
        BaseRecordTest.assertStringAttribute(elem, "File ID", "AL PSMB2IMGYBSQ ");
        BaseRecordTest.assertStringAttribute(elem, "File class", "IMAGERY                     ");
        BaseRecordTest.assertStringAttribute(elem, "File class code", "IMGY");
        BaseRecordTest.assertStringAttribute(elem, "File datatype", "BINARY ONLY                 ");
        BaseRecordTest.assertStringAttribute(elem, "File datatype code", "BINO");
        BaseRecordTest.assertIntAttribute(elem, "Number of records", 14001);
        BaseRecordTest.assertIntAttribute(elem, "First record length", 897623);
        BaseRecordTest.assertIntAttribute(elem, "Max record length", 8634264);
        BaseRecordTest.assertStringAttribute(elem, "Record lengthtype", "FIXED LENGTH");
        BaseRecordTest.assertStringAttribute(elem, "Record lengthtype code", "FIXD");
        BaseRecordTest.assertIntAttribute(elem, "First record volume numer", 1);
        BaseRecordTest.assertIntAttribute(elem, "Final record volume number", 2);
        BaseRecordTest.assertIntAttribute(elem, "First record number of referenced file", 3);
    }

    private void assertRecord(FilePointerRecord record) {
        BaseRecordTest.assertRecord((BaseRecord)record);
        FilePointerRecordTest.assertNotNull((Object)record);
        FilePointerRecordTest.assertEquals((String)"A ", (String)record.getCodeCharacter());
        FilePointerRecordTest.assertEquals((int)2, (int)record.getFilePointerNumber());
        FilePointerRecordTest.assertEquals((String)"AL PSMB2IMGYBSQ ", (String)record.getFileID());
        FilePointerRecordTest.assertEquals((String)"IMAGERY                     ", (String)record.getFileClass());
        FilePointerRecordTest.assertEquals((String)"IMGY", (String)record.getFileClassCode());
        FilePointerRecordTest.assertEquals((String)"BINARY ONLY                 ", (String)record.getFileDataType());
        FilePointerRecordTest.assertEquals((String)"BINO", (String)record.getFileDataTypeCode());
        FilePointerRecordTest.assertEquals((int)14001, (int)record.getNumberOfRecords());
        FilePointerRecordTest.assertEquals((int)897623, (int)record.getFirstRecordLength());
        FilePointerRecordTest.assertEquals((int)8634264, (int)record.getMaxRecordLength());
        FilePointerRecordTest.assertEquals((String)"FIXED LENGTH", (String)record.getRecordLengthType());
        FilePointerRecordTest.assertEquals((String)"FIXD", (String)record.getRecordLengthTypeCode());
        FilePointerRecordTest.assertEquals((int)1, (int)record.getFirstRecordVolumeNumber());
        FilePointerRecordTest.assertEquals((int)2, (int)record.getFinalRecordVolumeNumber());
        FilePointerRecordTest.assertEquals((int)3, (int)record.getFirstRecordNumberOfReferencedFile());
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("A ");
        ios.skipBytes(2);
        ios.writeBytes("   2");
        ios.writeBytes("AL PSMB2IMGYBSQ ");
        ios.writeBytes("IMAGERY                     ");
        ios.writeBytes("IMGY");
        ios.writeBytes("BINARY ONLY                 ");
        ios.writeBytes("BINO");
        ios.writeBytes("   14001");
        ios.writeBytes("  897623");
        ios.writeBytes(" 8634264");
        ios.writeBytes("FIXED LENGTH");
        ios.writeBytes("FIXD");
        ios.writeBytes(" 1");
        ios.writeBytes(" 2");
        ios.writeBytes("       3");
        ios.writeBytes("                                                                                                                                                                                                                ");
    }
}

