/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;

public class BaseRecordTest
extends TestCase {
    public static final int RECORD_LENGTH = 4680;
    private ImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "BaseRecordTest_prefix";
        this._ios.writeBytes(this._prefix);
        BaseRecordTest.writeRecordData(this._ios);
        this._ios.writeBytes("BaseRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    public void testInitBaseRecord() throws IOException, IllegalCeosFormatException {
        BaseRecord record = new BaseRecord(this._reader, (long)this._prefix.length());
        BaseRecordTest.assertRecord(record);
        BaseRecordTest.assertSame((Object)this._reader, (Object)record.getReader());
        BaseRecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        BaseRecordTest.assertEquals((long)(this._prefix.length() + 12), (long)this._ios.getStreamPosition());
    }

    public void testAssignMetadataTo() throws IOException, IllegalCeosFormatException {
        BaseRecord record = new BaseRecord(this._reader, (long)this._prefix.length());
        MetadataElement elem = new MetadataElement("elem");
        record.assignMetadataTo(elem, null);
        BaseRecordTest.assertMetadata(elem);
        BaseRecordTest.assertEquals((int)0, (int)elem.getNumElements());
        BaseRecordTest.assertEquals((int)6, (int)elem.getNumAttributes());
    }

    public static void assertMetadata(MetadataElement elem) {
        BaseRecordTest.assertIntAttribute(elem, "Record number", 1);
        BaseRecordTest.assertIntAttribute(elem, "First record subtype", 63);
        BaseRecordTest.assertIntAttribute(elem, "Record type code", 192);
        BaseRecordTest.assertIntAttribute(elem, "Second record subtype", 18);
        BaseRecordTest.assertIntAttribute(elem, "Third record subtype", 17);
        BaseRecordTest.assertIntAttribute(elem, "Record length", 4680);
    }

    public static void assertIntAttribute(MetadataElement elem, String attributeName, int expectedValue) {
        MetadataAttribute attribute = elem.getAttribute(attributeName);
        BaseRecordTest.assertNotNull((Object)attribute);
        BaseRecordTest.assertEquals((int)12, (int)attribute.getDataType());
        BaseRecordTest.assertEquals((long)1L, (long)attribute.getNumDataElems());
        BaseRecordTest.assertEquals((int)expectedValue, (int)attribute.getData().getElemInt());
    }

    public static void assertStringAttribute(MetadataElement elem, String attibuteName, String expectedValue) {
        MetadataAttribute attribute = elem.getAttribute(attibuteName);
        BaseRecordTest.assertNotNull((Object)attribute);
        BaseRecordTest.assertEquals((String)"ascii", (String)attribute.getData().getTypeString());
        BaseRecordTest.assertEquals((String)expectedValue, (String)attribute.getData().getElemString());
    }

    public static void assertRecord(BaseRecord record) {
        BaseRecordTest.assertNotNull((Object)record);
        BaseRecordTest.assertEquals((int)1, (int)record.getRecordNumber());
        BaseRecordTest.assertEquals((int)63, (int)record.getFirstRecordSubtype());
        BaseRecordTest.assertEquals((int)192, (int)record.getRecordTypeCode());
        BaseRecordTest.assertEquals((int)18, (int)record.getSecondRecordSubtype());
        BaseRecordTest.assertEquals((int)17, (int)record.getThirdRecordSubtype());
        BaseRecordTest.assertEquals((int)4680, (int)record.getRecordLength());
    }

    public static void writeRecordData(ImageOutputStream ios) throws IOException {
        ios.writeInt(1);
        ios.write(63);
        ios.write(192);
        ios.write(18);
        ios.write(17);
        ios.writeInt(4680);
    }

    public void testCreateMetadataElement() {
        String suffix = "suffix";
        MetadataElement elem = BaseRecord.createMetadataElement((String)"name", (String)suffix);
        BaseRecordTest.assertNotNull((Object)elem);
        BaseRecordTest.assertEquals((String)"name suffix", (String)elem.getName());
        suffix = "   ";
        elem = BaseRecord.createMetadataElement((String)"name", (String)suffix);
        BaseRecordTest.assertNotNull((Object)elem);
        BaseRecordTest.assertEquals((String)"name", (String)elem.getName());
        suffix = "";
        elem = BaseRecord.createMetadataElement((String)"name", (String)suffix);
        BaseRecordTest.assertNotNull((Object)elem);
        BaseRecordTest.assertEquals((String)"name", (String)elem.getName());
        suffix = null;
        elem = BaseRecord.createMetadataElement((String)"name", (String)suffix);
        BaseRecordTest.assertNotNull((Object)elem);
        BaseRecordTest.assertEquals((String)"name", (String)elem.getName());
    }
}

