/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.CeosTestHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.Ancillary3Record;
import org.esa.beam.dataio.ceos.records.BaseRecord;
import org.esa.beam.dataio.ceos.records.BaseRecordTest;

public class Ancillary3RecordTest
extends TestCase {
    private MemoryCacheImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "Ancillery3RecordTest_prefix";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("Ancillery3RecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        Ancillary3Record record = new Ancillary3Record(this._reader);
        this.assertRecord(record);
    }

    public void testInit() throws IOException, IllegalCeosFormatException {
        Ancillary3Record record = new Ancillary3Record(this._reader, (long)this._prefix.length());
        this.assertRecord(record);
    }

    private void writeRecordData(MemoryCacheImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("ljoiauiaerakb voieiruhnjdsnoirsd");
        ios.writeBytes("    8001.1234567");
        ios.writeBytes("    8002.1234567");
        ios.writeBytes("    8003.1234567");
        ios.writeBytes("    8004.1234567");
        ios.writeBytes("    8005.1234567");
        ios.writeBytes("    8006.1234567");
        ios.writeBytes("4568");
        ios.writeBytes("6578");
        ios.writeBytes("1234");
        ios.writeBytes("4321");
        ios.writeBytes("5643");
        ios.writeBytes(" 4.920000000000000E+03");
        ios.writeBytes(" 6.000000000000000E+01");
        ios.writeBytes("alksdfjpawendbslkdslpovamreoifmclskdasdkfjaoeifmdlkdsfedlsfjiooe");
        CeosTestHelper.writeBlanks(ios, 22);
        ios.writeBytes("       2.0000000");
        ios.writeBytes("       2.1111111");
        ios.writeBytes("       2.2222222");
        ios.writeBytes("       2.3333333");
        ios.writeBytes("       2.4444444");
        ios.writeBytes("       2.5555555");
        for (int i = 0; i < 28; ++i) {
            for (int j = 1; j < 7; ++j) {
                ios.writeBytes(" " + j + "." + (i + 10) + "0000000000000E-03");
            }
        }
        CeosTestHelper.writeBlanks(ios, 18);
        ios.writeBytes("1");
        CeosTestHelper.writeBlanks(ios, 579);
    }

    private void assertRecord(Ancillary3Record record) throws IOException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        Ancillary3RecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Ancillary3RecordTest.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        Ancillary3RecordTest.assertEquals((String)"ljoiauiaerakb voieiruhnjdsnoirsd", (String)record.getOrbitalElementsType());
        Ancillary3RecordTest.assertEquals((int)4568, (int)record.getNumDataPoints());
        Ancillary3RecordTest.assertEquals((int)6578, (int)record.getFirstPointYear());
        Ancillary3RecordTest.assertEquals((int)1234, (int)record.getFirstPointMonth());
        Ancillary3RecordTest.assertEquals((int)4321, (int)record.getFirstPointDay());
        Ancillary3RecordTest.assertEquals((int)5643, (int)record.getFirstPointTotalDays());
        Ancillary3RecordTest.assertEquals((double)4920.0, (double)record.getFirstPointTotalSeconds(), (double)1.0E-10);
        Ancillary3RecordTest.assertEquals((double)60.0, (double)record.getIntervalTimeBetweenPoints(), (double)1.0E-10);
        Ancillary3RecordTest.assertEquals((String)"alksdfjpawendbslkdslpovamreoifmclskdasdkfjaoeifmdlkdsfedlsfjiooe", (String)record.getReferenceCoordinateSystem());
        Ancillary3RecordTest.assertEquals((double)2.0, (double)record.getPositionalErrorFlightDirection(), (double)1.0E-10);
        Ancillary3RecordTest.assertEquals((double)2.1111111, (double)record.getPositionalErrorFlightVerticalDirection(), (double)1.0E-10);
        Ancillary3RecordTest.assertEquals((double)2.2222222, (double)record.getPositionalErrorRadiusDirection(), (double)1.0E-10);
        Ancillary3RecordTest.assertEquals((double)2.3333333, (double)record.getVelocityErrorFlightDirection(), (double)1.0E-10);
        Ancillary3RecordTest.assertEquals((double)2.4444444, (double)record.getVelocityErrorFlightVerticalDirection(), (double)1.0E-10);
        Ancillary3RecordTest.assertEquals((double)2.5555555, (double)record.getVelocityErrorRadiusDirection(), (double)1.0E-10);
        Ancillary3Record.DataPoint[] dataPoints = record.getDataPoints();
        for (int i = 0; i < dataPoints.length; ++i) {
            Ancillary3Record.DataPoint dataPoint = dataPoints[i];
            Ancillary3RecordTest.assertEquals((double)((1.1 + 0.01 * (double)i) * 0.001), (double)dataPoint.getPositionalVectorDataPointX(), (double)1.0E-10);
            Ancillary3RecordTest.assertEquals((double)((2.1 + 0.01 * (double)i) * 0.001), (double)dataPoint.getPositionalVectorDataPointY(), (double)1.0E-10);
            Ancillary3RecordTest.assertEquals((double)((3.1 + 0.01 * (double)i) * 0.001), (double)dataPoint.getPositionalVectorDataPointZ(), (double)1.0E-10);
            Ancillary3RecordTest.assertEquals((double)((4.1 + 0.01 * (double)i) * 0.001), (double)dataPoint.getVelocityVectorDataPointX(), (double)1.0E-10);
            Ancillary3RecordTest.assertEquals((double)((5.1 + 0.01 * (double)i) * 0.001), (double)dataPoint.getVelocityVectorDataPointY(), (double)1.0E-10);
            Ancillary3RecordTest.assertEquals((double)((6.1 + 0.01 * (double)i) * 0.001), (double)dataPoint.getVelocityVectorDataPointZ(), (double)1.0E-10);
        }
        Ancillary3RecordTest.assertEquals((int)1, (int)record.getFlagLeapSecond());
    }
}

