/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.avnir2.records;

import java.io.IOException;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.CeosTestHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.avnir2.records.Avnir2Ancillary2Record;
import org.esa.beam.dataio.ceos.records.Ancillary2Record;
import org.esa.beam.dataio.ceos.records.Ancillary2RecordTest;

public class Avnir2Ancillary2RecordTest
extends Ancillary2RecordTest {
    @Override
    protected Ancillary2Record createAncillary2Record(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        return new Avnir2Ancillary2Record(reader);
    }

    @Override
    protected Ancillary2Record createAncillary2Record(CeosFileReader reader, int startPos) throws IOException, IllegalCeosFormatException {
        return new Avnir2Ancillary2Record(reader, (long)startPos);
    }

    @Override
    protected void writeSpecificRecordData(MemoryCacheImageOutputStream ios) throws IOException {
        ios.seek(this._prefix.length() + 24);
        ios.writeBytes("12345");
        ios.writeBytes("56789");
        ios.writeBytes("12345");
        ios.writeBytes("56789");
        ios.seek(this._prefix.length() + 78);
        ios.writeBytes("2345.432");
        ios.writeBytes("5678.123");
        ios.writeBytes("9876.321");
        ios.writeBytes("1234.567");
        ios.writeBytes("2345.432");
        ios.writeBytes("5678.123");
        ios.writeBytes("9876.321");
        ios.writeBytes("1234.567");
        ios.writeBytes("1111.999");
        CeosTestHelper.writeBlanks(ios, 2552);
        ios.writeBytes("234.5432");
        ios.writeBytes("543.2345");
        ios.writeBytes("987.6321");
        ios.writeBytes("123.4567");
        ios.writeBytes("234.5432");
        ios.writeBytes("543.2345");
        ios.writeBytes("987.6321");
        ios.writeBytes("123.4567");
        CeosTestHelper.writeBlanks(ios, 1914);
    }

    @Override
    protected void assertSpecificRecordData(Ancillary2Record record) {
        Avnir2Ancillary2Record avnir2Record = (Avnir2Ancillary2Record)record;
        Avnir2Ancillary2RecordTest.assertEquals((long)12345L, (long)avnir2Record.getExposureCoefficient(1));
        Avnir2Ancillary2RecordTest.assertEquals((long)56789L, (long)avnir2Record.getExposureCoefficient(2));
        Avnir2Ancillary2RecordTest.assertEquals((long)12345L, (long)avnir2Record.getExposureCoefficient(3));
        Avnir2Ancillary2RecordTest.assertEquals((long)56789L, (long)avnir2Record.getExposureCoefficient(4));
        Avnir2Ancillary2RecordTest.assertEquals((double)2345.432, (double)avnir2Record.getDetectorTemperature(1), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)5678.123, (double)avnir2Record.getDetectorTemperature(2), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)9876.321, (double)avnir2Record.getDetectorTemperature(3), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)1234.567, (double)avnir2Record.getDetectorTemperature(4), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)2345.432, (double)avnir2Record.getDetectorAssemblyTemperature(1), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)5678.123, (double)avnir2Record.getDetectorAssemblyTemperature(2), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)9876.321, (double)avnir2Record.getDetectorAssemblyTemperature(3), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)1234.567, (double)avnir2Record.getDetectorAssemblyTemperature(4), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)1111.999, (double)avnir2Record.getSignalProcessingUnitTemperature(), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)234.5432, (double)avnir2Record.getAbsoluteCalibrationGain(1), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)543.2345, (double)avnir2Record.getAbsoluteCalibrationOffset(1), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)987.6321, (double)avnir2Record.getAbsoluteCalibrationGain(2), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)123.4567, (double)avnir2Record.getAbsoluteCalibrationOffset(2), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)234.5432, (double)avnir2Record.getAbsoluteCalibrationGain(3), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)543.2345, (double)avnir2Record.getAbsoluteCalibrationOffset(3), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)987.6321, (double)avnir2Record.getAbsoluteCalibrationGain(4), (double)1.0E-6);
        Avnir2Ancillary2RecordTest.assertEquals((double)123.4567, (double)avnir2Record.getAbsoluteCalibrationOffset(4), (double)1.0E-6);
    }
}

