/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.gdal;

import org.apache.commons.lang.SystemUtils;

public enum OSCategory {
    WIN_32("gdal-2.1.3-win32", "release-1500-gdal-2-1-3-mapserver-7-0-4.zip", "environment-variables-win32", "Windows"),
    WIN_64("gdal-2.1.3-win64", "release-1500-x64-gdal-2-1-3-mapserver-7-0-4.zip", "environment-variables-win64", "Windows"),
    LINUX_64("gdal-2.2.0-linux", "gdal-2.2.0-linux-bin.zip", "environment-variables", "Linux"),
    MAC_OS_X(null, null, null, "Macintosh"),
    UNSUPPORTED(null, null, null, "");

    String directory;
    String zipFileName;
    String operatingSystemName;
    String environmentVariablesFileName;

    private OSCategory(String directory, String zipFileName, String environmentVariablesFileName, String operatingSystemName) {
        this.directory = directory;
        this.zipFileName = zipFileName;
        this.environmentVariablesFileName = environmentVariablesFileName;
        this.operatingSystemName = operatingSystemName;
    }

    public String getEnvironmentVariablesFileName() {
        return this.environmentVariablesFileName;
    }

    public String getOperatingSystemName() {
        return this.operatingSystemName;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getZipFileName() {
        return this.zipFileName;
    }

    public static OSCategory getOSCategory() {
        String sysArch;
        OSCategory category = SystemUtils.IS_OS_LINUX ? LINUX_64 : (SystemUtils.IS_OS_MAC_OSX ? MAC_OS_X : (SystemUtils.IS_OS_WINDOWS ? ((sysArch = System.getProperty("os.arch").toLowerCase()).contains("amd64") || sysArch.contains("x86_x64") ? WIN_64 : WIN_32) : UNSUPPORTED));
        return category;
    }
}

