/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.gdal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import org.apache.commons.lang.SystemUtils;
import org.esa.s2tbx.dataio.gdal.OSCategory;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.runtime.Config;
import org.esa.snap.utils.FileHelper;
import org.esa.snap.utils.NativeLibraryUtils;

public class GDALInstaller {
    private static final Logger logger = Logger.getLogger(GDALInstaller.class.getName());
    private static final String SRC_PATH = "auxdata/gdal";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Path copyDistribution(Path gdalApplicationFolderPath, OSCategory osCategory) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Copy the GDAL distribution to folder '" + gdalApplicationFolderPath.toString() + "'.");
        }
        Config config = Config.instance((String)"s2tbx");
        config.load();
        Preferences preferences = config.preferences();
        String preferencesKey = "gdal.installer";
        String moduleVersion = this.getModuleSpecificationVersion();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Check the GDAL distribution folder from the local disk.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "The module version is '" + moduleVersion + "'.");
        }
        boolean canCopyGDALDistribution = true;
        if (Files.exists(gdalApplicationFolderPath, new LinkOption[0])) {
            boolean deleted;
            String savedVersion = preferences.get(preferencesKey, null);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The saved GDAL distribution folder version is '" + savedVersion + "'.");
            }
            if (!StringUtils.isNullOrEmpty((String)savedVersion) && GDALInstaller.compareVersions(savedVersion, moduleVersion) >= 0) {
                canCopyGDALDistribution = false;
            }
            if (canCopyGDALDistribution && !(deleted = FileUtils.deleteTree((File)gdalApplicationFolderPath.toFile()))) {
                throw new IllegalArgumentException("Failed to delete the GDAL distribution folder '" + gdalApplicationFolderPath.toString() + "'.");
            }
        }
        if (canCopyGDALDistribution) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Create the folder '" + gdalApplicationFolderPath.toString() + "' to copy the GDAL distribution.");
            }
            Files.createDirectories(gdalApplicationFolderPath, new FileAttribute[0]);
        }
        String zipArchivePath = osCategory.getDirectory() + "/" + osCategory.getZipFileName();
        Path zipFilePathOnLocalDisk = gdalApplicationFolderPath.resolve(zipArchivePath);
        Path gdalDistributionRootFolderPath = zipFilePathOnLocalDisk.getParent();
        GDALInstaller.fixUpPermissions(gdalApplicationFolderPath);
        if (Files.exists(gdalDistributionRootFolderPath, new LinkOption[0])) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The distribution root folder '" + gdalDistributionRootFolderPath.toString() + "' exists on the local disk.");
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Create the distribution root folder '" + gdalDistributionRootFolderPath.toString() + "'.");
            }
            Files.createDirectories(gdalDistributionRootFolderPath, new FileAttribute[0]);
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Copy the zip archive to folder '" + zipFilePathOnLocalDisk.toString() + "'.");
                }
                String zipFilePathFromSources = "auxdata/gdal/" + zipArchivePath;
                URL zipFileURLFromSources = this.getClass().getClassLoader().getResource(zipFilePathFromSources);
                FileHelper.copyFile((URL)zipFileURLFromSources, (Path)zipFilePathOnLocalDisk);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Decompress the zip archive to folder '" + gdalDistributionRootFolderPath.toString() + "'.");
                }
                FileHelper.unzip((Path)zipFilePathOnLocalDisk, (Path)gdalDistributionRootFolderPath, (boolean)true);
            }
            finally {
                try {
                    Files.deleteIfExists(zipFilePathOnLocalDisk);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "GDAL configuration error: failed to delete the zip archive after decompression.", e);
                }
            }
        }
        String libraryFileNameFromSources = System.mapLibraryName(osCategory.getEnvironmentVariablesFileName());
        String libraryFileName = System.mapLibraryName("environment-variables");
        Path libraryFilePath = gdalApplicationFolderPath.resolve(libraryFileName);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "The library file path on the local disk is '" + libraryFilePath.toString() + "' and the library file name from sources is '" + libraryFileNameFromSources + "'.");
        }
        if (canCopyGDALDistribution) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Copy the library file.");
            }
            String libraryFilePathFromSources = "auxdata/gdal/" + libraryFileNameFromSources;
            URL libraryFileURLFromSources = this.getClass().getClassLoader().getResource(libraryFilePathFromSources);
            FileHelper.copyFile((URL)libraryFileURLFromSources, (Path)libraryFilePath);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Register the native paths for folder '" + libraryFilePath.getParent() + "'.");
        }
        NativeLibraryUtils.registerNativePaths((Path[])new Path[]{libraryFilePath.getParent()});
        if (canCopyGDALDistribution) {
            preferences.put(preferencesKey, moduleVersion);
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        return gdalDistributionRootFolderPath;
    }

    private String getModuleSpecificationVersion() throws IOException {
        String manifestFilePath = "/META-INF/MANIFEST.MF";
        Class<?> clazz = this.getClass();
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        String manifestPath = null;
        if (classPath.startsWith("jar")) {
            manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + manifestFilePath;
        } else {
            String relativePath = clazz.getName().replace('.', File.separatorChar) + ".class";
            String classFolder = classPath.substring(0, classPath.length() - relativePath.length() - 1);
            manifestPath = classFolder + manifestFilePath;
        }
        Manifest manifest = new Manifest(new URL(manifestPath).openStream());
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue("OpenIDE-Module-Specification-Version");
    }

    private static void fixUpPermissions(Path destPath) throws IOException {
        Stream<Path> files = Files.list(destPath);
        files.forEach(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                try {
                    GDALInstaller.fixUpPermissions(path);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "GDAL configuration error: failed to fix permissions on " + path, e);
                }
            } else {
                GDALInstaller.setExecutablePermissions(path);
            }
        });
    }

    private static void setExecutablePermissions(Path executablePathName) {
        if (SystemUtils.IS_OS_UNIX) {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE));
            try {
                Files.setPosixFilePermissions(executablePathName, permissions);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Can't set execution permissions for executable " + executablePathName.toString() + ". If required, please ask an authorised user to make the file executable.", e);
            }
        }
    }

    private static int compareVersions(String currentModuleVersion, String savedModuleVersion) {
        int[] moduleVersionFragments = GDALInstaller.parseVersion(currentModuleVersion);
        int[] savedVersionFragments = GDALInstaller.parseVersion(savedModuleVersion);
        int max = Math.max(moduleVersionFragments.length, savedVersionFragments.length);
        for (int i = 0; i < max; ++i) {
            int d2;
            int d1 = i < moduleVersionFragments.length ? moduleVersionFragments[i] : 0;
            int n = d2 = i < savedVersionFragments.length ? savedVersionFragments[i] : 0;
            if (d1 == d2) continue;
            return d1 - d2;
        }
        return 0;
    }

    private static int[] parseVersion(String version) throws NumberFormatException {
        StringTokenizer tok = new StringTokenizer(version, ".", true);
        int len = tok.countTokens();
        if (len % 2 == 0) {
            throw new NumberFormatException("Even number of pieces in a spec version: `" + version + "'");
        }
        int[] digits = new int[len / 2 + 1];
        int index = 0;
        boolean expectingNumber = true;
        while (tok.hasMoreTokens()) {
            String fragment = tok.nextToken();
            if (expectingNumber) {
                expectingNumber = false;
                int piece = Integer.parseInt(fragment);
                if (piece < 0) {
                    throw new NumberFormatException("Spec version component '" + piece + "' is negative.");
                }
                digits[index++] = piece;
                continue;
            }
            if (!".".equals(fragment)) {
                throw new NumberFormatException("Expected dot in version '" + version + "'.");
            }
            expectingNumber = true;
        }
        return digits;
    }
}

