/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.utilities.gpf.ui;

import com.bc.ceres.swing.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.AppContext;

public class TileWriterUI
extends BaseOperatorUI {
    private final JLabel divisionByLabel = new JLabel("Division By:     ");
    private final JComboBox divisionBy = new JComboBox<String>(new String[]{"Tiles", "Pixels"});
    private final JLabel numberOfTilesLabel = new JLabel("Number of Tiles:     ");
    private final JComboBox numberOfTiles = new JComboBox<String>(new String[]{"2", "4", "9", "16", "36", "64", "100", "256"});
    private final JLabel pixelSizeLabel = new JLabel("Pixel Size:     ");
    private final JTextField pixelSizeX = new JTextField("");
    private final JTextField pixelSizeY = new JTextField("");
    private final TargetProductSelector targetProductSelector = new TargetProductSelector();
    private static final String FILE_PARAMETER = "file";

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JPanel panel = this.createPanel();
        this.initParameters();
        this.divisionBy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                TileWriterUI.this.updateDivisionBy();
            }
        });
        File saveDir = null;
        Object value = this.paramMap.get(FILE_PARAMETER);
        if (value != null) {
            File file = (File)value;
            saveDir = file.getParentFile();
        }
        if (saveDir == null) {
            String homeDirPath = SystemUtils.getUserHomeDir().getPath();
            String savePath = SnapApp.getDefault().getPreferences().get("last_product_save_dir", homeDirPath);
            saveDir = new File(savePath);
        }
        this.targetProductSelector.getModel().setProductDir(saveDir);
        this.targetProductSelector.getOpenInAppCheckBox().setText("Open in " + appContext.getApplicationName());
        return panel;
    }

    public JPanel createPanel() {
        JPanel contentPane = new JPanel(new BorderLayout(2, 2));
        JPanel optionsPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        DialogUtils.addComponent((JPanel)optionsPane, (GridBagConstraints)gbc, (JLabel)this.divisionByLabel, (JComponent)this.divisionBy);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)optionsPane, (GridBagConstraints)gbc, (JLabel)this.numberOfTilesLabel, (JComponent)this.numberOfTiles);
        DialogUtils.addComponent((JPanel)optionsPane, (GridBagConstraints)gbc, (JLabel)this.pixelSizeLabel, (JComponent)this.pixelSizeX);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)optionsPane, (GridBagConstraints)gbc, (JLabel)this.pixelSizeLabel, (JComponent)this.pixelSizeY);
        contentPane.add((Component)optionsPane, "Center");
        JPanel subPanel1 = new JPanel(new BorderLayout(3, 3));
        subPanel1.add((Component)this.targetProductSelector.getProductNameLabel(), "North");
        subPanel1.add((Component)this.targetProductSelector.getProductNameTextField(), "Center");
        JPanel subPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        subPanel2.add(this.targetProductSelector.getSaveToFileCheckBox());
        subPanel2.add(this.targetProductSelector.getFormatNameComboBox());
        JPanel subPanel3 = new JPanel(new BorderLayout(3, 3));
        subPanel3.add((Component)this.targetProductSelector.getProductDirLabel(), "North");
        subPanel3.add((Component)this.targetProductSelector.getProductDirTextField(), "Center");
        subPanel3.add((Component)this.targetProductSelector.getProductDirChooserButton(), "East");
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setCellPadding(0, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(1, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(2, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(3, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(4, 0, new Insets(0, 24, 3, 3));
        tableLayout.setCellPadding(5, 0, new Insets(3, 3, 3, 3));
        JPanel targetPanel = new JPanel((LayoutManager)tableLayout);
        targetPanel.setBorder(BorderFactory.createTitledBorder("Target Tile Products"));
        targetPanel.add(subPanel1);
        targetPanel.add(subPanel2);
        targetPanel.add(subPanel3);
        targetPanel.add(this.targetProductSelector.getOpenInAppCheckBox());
        contentPane.add((Component)targetPanel, "South");
        this.updateDivisionBy();
        return contentPane;
    }

    public void initParameters() {
        assert (this.paramMap != null);
        this.divisionBy.setSelectedItem(this.paramMap.get("divisionBy"));
        String numTiles = (String)this.paramMap.get("numberOfTiles");
        if (numTiles == null || numTiles.isEmpty()) {
            numTiles = "4";
        }
        this.numberOfTiles.setSelectedItem(numTiles);
        this.pixelSizeX.setText(String.valueOf(this.paramMap.get("pixelSizeX")));
        this.pixelSizeY.setText(String.valueOf(this.paramMap.get("pixelSizeY")));
        String fileName = "target";
        Object value = this.paramMap.get(FILE_PARAMETER);
        if (value != null) {
            File file = (File)value;
            fileName = file.getName();
        } else if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            fileName = this.sourceProducts[0].getName();
        }
        this.targetProductSelector.getProductNameTextField().setText(fileName);
        this.targetProductSelector.getModel().setProductName(fileName);
    }

    public UIValidation validateParameters() {
        String productDir = this.targetProductSelector.getModel().getProductDir().getAbsolutePath();
        SnapApp.getDefault().getPreferences().put("last_product_save_dir", productDir);
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        if (this.targetProductSelector.getModel().getProductName() != null) {
            this.paramMap.put("divisionBy", this.divisionBy.getSelectedItem());
            this.paramMap.put("numberOfTiles", this.numberOfTiles.getSelectedItem());
            this.paramMap.put("pixelSizeX", Integer.parseInt(this.pixelSizeX.getText()));
            this.paramMap.put("pixelSizeY", Integer.parseInt(this.pixelSizeY.getText()));
            this.paramMap.put(FILE_PARAMETER, this.targetProductSelector.getModel().getProductFile());
            this.paramMap.put("formatName", this.targetProductSelector.getModel().getFormatName());
        }
    }

    private void updateDivisionBy() {
        String item = (String)this.divisionBy.getSelectedItem();
        if (item.equals("Pixels")) {
            this.numberOfTiles.setVisible(false);
            this.numberOfTilesLabel.setVisible(false);
            this.pixelSizeX.setVisible(true);
            this.pixelSizeY.setVisible(true);
            this.pixelSizeLabel.setVisible(true);
        } else {
            this.numberOfTiles.setVisible(true);
            this.numberOfTilesLabel.setVisible(true);
            this.pixelSizeX.setVisible(false);
            this.pixelSizeY.setVisible(false);
            this.pixelSizeLabel.setVisible(false);
        }
    }
}

