/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.utilities.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class OversamplingOpUI
extends BaseOperatorUI {
    private final JList<String> bandList = new JList();
    private final JComboBox<String> outputImageBy = new JComboBox<String>(new String[]{"Image Size", "Ratio", "Pixel Spacing"});
    private final JTextField targetImageHeight = new JTextField("");
    private final JTextField targetImageWidth = new JTextField("");
    private final JTextField widthRatio = new JTextField("");
    private final JTextField heightRatio = new JTextField("");
    private final JTextField rangeSpacing = new JTextField("");
    private final JTextField azimuthSpacing = new JTextField("");
    private final JLabel targetImageHeightLabel = new JLabel("Rows:");
    private final JLabel targetImageWidthLabel = new JLabel("Columns:");
    private final JLabel widthRatioLabel = new JLabel("Width Ratio:");
    private final JLabel heightRatioLabel = new JLabel("Height Ratio:");
    private final JLabel rangeSpacingLabel = new JLabel("Range Spacing (m):");
    private final JLabel azimuthSpacingLabel = new JLabel("Azimuth Spacing (m):");
    private final JLabel outputImageByLabel = new JLabel("Output Image By:     ");
    private final JCheckBox usePRFTileSizeCheckBox = new JCheckBox("Use PRF Tile Size");
    private Boolean usePRFTileSize = false;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.outputImageBy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                OversamplingOpUI.this.updateOutputImageBy(true);
            }
        });
        this.usePRFTileSizeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OversamplingOpUI.this.usePRFTileSize = e.getStateChange() == 1;
            }
        });
        return panel;
    }

    public void initParameters() {
        OperatorUIUtils.initParamList(this.bandList, (String[])this.getBandNames());
        this.outputImageBy.setSelectedItem(this.paramMap.get("outputImageBy"));
        this.targetImageHeight.setText(String.valueOf(this.paramMap.get("targetImageHeight")));
        this.targetImageWidth.setText(String.valueOf(this.paramMap.get("targetImageWidth")));
        this.widthRatio.setText(String.valueOf(this.paramMap.get("widthRatio")));
        this.heightRatio.setText(String.valueOf(this.paramMap.get("heightRatio")));
        this.rangeSpacing.setText(String.valueOf(this.paramMap.get("rangeSpacing")));
        this.azimuthSpacing.setText(String.valueOf(this.paramMap.get("azimuthSpacing")));
        this.usePRFTileSize = (Boolean)this.paramMap.get("usePRFTileSize");
        if (this.usePRFTileSize != null) {
            this.usePRFTileSizeCheckBox.setSelected(this.usePRFTileSize);
        }
        this.updateOutputImageBy(true);
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList(this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("outputImageBy", this.outputImageBy.getSelectedItem());
        this.paramMap.put("targetImageHeight", Integer.parseInt(this.targetImageHeight.getText()));
        this.paramMap.put("targetImageWidth", Integer.parseInt(this.targetImageWidth.getText()));
        this.paramMap.put("widthRatio", Float.valueOf(Float.parseFloat(this.widthRatio.getText())));
        this.paramMap.put("heightRatio", Float.valueOf(Float.parseFloat(this.heightRatio.getText())));
        this.paramMap.put("rangeSpacing", Float.valueOf(Float.parseFloat(this.rangeSpacing.getText())));
        this.paramMap.put("azimuthSpacing", Float.valueOf(Float.parseFloat(this.azimuthSpacing.getText())));
        this.paramMap.put("usePRFTileSize", this.usePRFTileSize);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Source Bands:", (JComponent)new JScrollPane(this.bandList));
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.outputImageByLabel, this.outputImageBy);
        ++gbc.gridy;
        int savedY = gbc.gridy++;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.targetImageHeightLabel, (JComponent)this.targetImageHeight);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.targetImageWidthLabel, (JComponent)this.targetImageWidth);
        gbc.gridy = savedY;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.widthRatioLabel, (JComponent)this.widthRatio);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.heightRatioLabel, (JComponent)this.heightRatio);
        gbc.gridy = savedY;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.rangeSpacingLabel, (JComponent)this.rangeSpacing);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.azimuthSpacingLabel, (JComponent)this.azimuthSpacing);
        ++gbc.gridy;
        contentPane.add((Component)this.usePRFTileSizeCheckBox, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void enableRowColumn(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.targetImageWidthLabel, (JComponent)this.targetImageWidth, (boolean)flag);
        DialogUtils.enableComponents((JComponent)this.targetImageHeightLabel, (JComponent)this.targetImageHeight, (boolean)flag);
    }

    private void enableRatio(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.widthRatioLabel, (JComponent)this.widthRatio, (boolean)flag);
        DialogUtils.enableComponents((JComponent)this.heightRatioLabel, (JComponent)this.heightRatio, (boolean)flag);
    }

    private void enablePixelSpacing(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.rangeSpacingLabel, (JComponent)this.rangeSpacing, (boolean)flag);
        DialogUtils.enableComponents((JComponent)this.azimuthSpacingLabel, (JComponent)this.azimuthSpacing, (boolean)flag);
    }

    private void updateOutputImageBy(boolean show) {
        if (show) {
            this.outputImageBy.setVisible(true);
            this.outputImageByLabel.setVisible(true);
            String item = (String)this.outputImageBy.getSelectedItem();
            if (item.equals("Image Size")) {
                this.enableRowColumn(true);
                this.enableRatio(false);
                this.enablePixelSpacing(false);
            } else if (item.equals("Ratio")) {
                this.enableRowColumn(false);
                this.enableRatio(true);
                this.enablePixelSpacing(false);
            } else {
                this.enableRowColumn(false);
                this.enableRatio(false);
                this.enablePixelSpacing(true);
            }
        } else {
            this.outputImageBy.setVisible(false);
            this.outputImageByLabel.setVisible(false);
            this.enableRowColumn(false);
            this.enableRatio(false);
            this.enablePixelSpacing(false);
        }
    }
}

