/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.utilities.gpf.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class BandSelectOpUI
extends BaseOperatorUI {
    private final JList<String> polList = new JList();
    private final JList bandList = new JList();
    private final JTextField bandNamePattern = new JTextField();

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        return new JScrollPane(panel);
    }

    public void initParameters() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            HashSet<String> pols = new HashSet<String>(4);
            for (Band srcBand : this.sourceProducts[0].getBands()) {
                String pol = OperatorUtils.getPolarizationFromBandName((String)srcBand.getName());
                if (pol == null) continue;
                pols.add(pol.toUpperCase());
            }
            OperatorUIUtils.initParamList(this.polList, (String[])pols.toArray(new String[pols.size()]), (Object[])((String[])this.paramMap.get("selectedPolarisations")));
        }
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        String bandNamePatternStr = (String)this.paramMap.get("bandNamePattern");
        if (this.bandNamePattern != null) {
            this.bandNamePattern.setText(bandNamePatternStr);
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList(this.polList, (Map)this.paramMap, (String)"selectedPolarisations");
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("bandNamePattern", this.bandNamePattern.getText());
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Polarisations:", this.polList);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Source Bands:", (JComponent)new JScrollPane(this.bandList));
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Band Name Pattern:", (JComponent)this.bandNamePattern);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

