/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.Rectangle;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.dataio.ProductSubsetBuilder;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="TOPSAR-Split", category="Radar/Sentinel-1 TOPS", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Creates a new product with only the selected subswath")
public final class TOPSARSplitOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", label="Subswath")
    private String subswath = null;
    @Parameter(description="The list of polarisations", label="Polarisations")
    private String[] selectedPolarisations;
    @Parameter(description="The first burst index", interval="[1, *)", defaultValue="1", label="First Burst Index")
    private Integer firstBurstIndex = 1;
    @Parameter(description="The last burst index", interval="[1, *)", defaultValue="9999", label="Last Burst Index")
    private Integer lastBurstIndex = 9999;
    @Parameter(description="WKT polygon to be used for selecting bursts", label="WKT Area of Interest")
    private String wktAoi = null;
    private Sentinel1Utils su = null;
    private Sentinel1Utils.SubSwathInfo[] subSwathInfo = null;
    private int subSwathIndex = 0;
    private ProductSubsetBuilder subsetBuilder = null;

    public void initialize() throws OperatorException {
        try {
            String pol;
            int n;
            int n2;
            String[] stringArray;
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSentinel1Product();
            validator.checkIfMultiSwathTOPSARProduct();
            validator.checkProductType(new String[]{"SLC"});
            validator.checkAcquisitionMode(new String[]{"IW", "EW"});
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            if (this.subswath == null) {
                String acquisitionMode = absRoot.getAttributeString("ACQUISITION_MODE");
                this.subswath = acquisitionMode + '1';
            }
            this.su = new Sentinel1Utils(this.sourceProduct);
            this.subSwathInfo = this.su.getSubSwath();
            for (int i = 0; i < this.subSwathInfo.length; ++i) {
                if (!this.subSwathInfo[i].subSwathName.contains(this.subswath)) continue;
                this.subSwathIndex = i + 1;
                break;
            }
            if (this.selectedPolarisations == null || this.selectedPolarisations.length == 0) {
                this.selectedPolarisations = Sentinel1Utils.getProductPolarizations((MetadataElement)absRoot);
            }
            ArrayList<TiePointGrid[]> selectedBands = new ArrayList<TiePointGrid[]>();
            for (Band srcBand : this.sourceProduct.getBands()) {
                if (!srcBand.getName().contains(this.subswath)) continue;
                stringArray = this.selectedPolarisations;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    pol = stringArray[n];
                    if (!srcBand.getName().contains(pol)) continue;
                    selectedBands.add((TiePointGrid[])srcBand);
                }
            }
            if (selectedBands.size() < 1) {
                this.selectedPolarisations = Sentinel1Utils.getProductPolarizations((MetadataElement)absRoot);
                for (Band srcBand : this.sourceProduct.getBands()) {
                    if (!srcBand.getName().contains(this.subswath)) continue;
                    stringArray = this.selectedPolarisations;
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        pol = stringArray[n];
                        if (!srcBand.getName().contains(pol)) continue;
                        selectedBands.add((TiePointGrid[])srcBand);
                    }
                }
            }
            int maxBursts = this.su.getNumOfBursts(this.subswath);
            if (this.lastBurstIndex > maxBursts) {
                this.lastBurstIndex = maxBursts;
            }
            if (this.wktAoi != null) {
                this.findValidBurstsBasedOnWkt();
            }
            this.subsetBuilder = new ProductSubsetBuilder();
            ProductSubsetDef subsetDef = new ProductSubsetDef();
            ArrayList<String> selectedTPGList = new ArrayList<String>();
            for (TiePointGrid srcTPG : this.sourceProduct.getTiePointGrids()) {
                if (!srcTPG.getName().contains(this.subswath)) continue;
                selectedTPGList.add(srcTPG.getName());
            }
            subsetDef.addNodeNames(selectedTPGList.toArray(new String[selectedTPGList.size()]));
            boolean x = false;
            int y = (this.firstBurstIndex - 1) * this.subSwathInfo[this.subSwathIndex - 1].linesPerBurst;
            int w = ((Band)selectedBands.get(0)).getRasterWidth();
            int h = (this.lastBurstIndex - this.firstBurstIndex + 1) * this.subSwathInfo[this.subSwathIndex - 1].linesPerBurst;
            subsetDef.setRegion(0, y, w, h);
            subsetDef.setSubSampling(1, 1);
            subsetDef.setIgnoreMetadata(false);
            String[] selectedBandNames = new String[selectedBands.size()];
            for (int i = 0; i < selectedBandNames.length; ++i) {
                selectedBandNames[i] = ((Band)selectedBands.get(i)).getName();
            }
            subsetDef.addNodeNames(selectedBandNames);
            this.targetProduct = this.subsetBuilder.readProductNodes((Object)this.sourceProduct, subsetDef);
            this.targetProduct.removeTiePointGrid(this.targetProduct.getTiePointGrid("latitude"));
            this.targetProduct.removeTiePointGrid(this.targetProduct.getTiePointGrid("longitude"));
            for (TiePointGrid tpg : this.targetProduct.getTiePointGrids()) {
                tpg.setName(tpg.getName().replace(this.subswath + "_", ""));
            }
            TiePointGeoCoding geoCoding = new TiePointGeoCoding(this.targetProduct.getTiePointGrid("latitude"), this.targetProduct.getTiePointGrid("longitude"));
            this.targetProduct.setSceneGeoCoding((GeoCoding)geoCoding);
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData destBuffer = targetTile.getRawSamples();
        Rectangle rectangle = targetTile.getRectangle();
        try {
            this.subsetBuilder.readBandRasterData(targetBand, rectangle.x, rectangle.y, rectangle.width, rectangle.height, destBuffer, pm);
            targetTile.setRawSamples(destBuffer);
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void findValidBurstsBasedOnWkt() {
        Geometry aoi = null;
        try {
            aoi = new WKTReader().read(this.wktAoi);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int numBursts = this.lastBurstIndex - this.firstBurstIndex + 1;
        GeoPos[][] geoBound = new GeoPos[numBursts][4];
        Sentinel1Utils.SubSwathInfo swath = this.subSwathInfo[this.subSwathIndex - 1];
        GeometryFactory gf = new GeometryFactory();
        int numPoints = swath.latitude[0].length - 1;
        ArrayList<Integer> validSelBursts = new ArrayList<Integer>();
        for (int i = 0; i < numBursts; ++i) {
            int burst_i = this.firstBurstIndex - 1 + i;
            geoBound[i][0] = new GeoPos(swath.latitude[burst_i][0], swath.longitude[burst_i][0]);
            geoBound[i][1] = new GeoPos(swath.latitude[burst_i][numPoints], swath.longitude[burst_i][numPoints]);
            geoBound[i][2] = new GeoPos(swath.latitude[burst_i + 1][numPoints], swath.longitude[burst_i + 1][numPoints]);
            geoBound[i][3] = new GeoPos(swath.latitude[burst_i + 1][0], swath.longitude[burst_i + 1][0]);
            Coordinate[] coordinates = new Coordinate[5];
            for (int c_i = 0; c_i < 4; ++c_i) {
                coordinates[c_i] = new Coordinate(geoBound[i][c_i].getLon(), geoBound[i][c_i].getLat());
            }
            coordinates[4] = new Coordinate(geoBound[i][0].getLon(), geoBound[i][0].getLat());
            LinearRing linearRing = gf.createLinearRing(coordinates);
            Polygon burst = gf.createPolygon(linearRing, null);
            if (!aoi.intersects((Geometry)burst)) continue;
            validSelBursts.add(burst_i + 1);
        }
        this.firstBurstIndex = (Integer)Collections.min(validSelBursts);
        this.lastBurstIndex = (Integer)Collections.max(validSelBursts);
    }

    private void updateTargetProductMetadata() {
        this.updateAbstractedMetadata();
        this.updateOriginalMetadata();
    }

    private void updateAbstractedMetadata() {
        MetadataElement[] bandMetadataList;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absRoot.setAttributeUTC("first_line_time", new ProductData.UTC(this.subSwathInfo[this.subSwathIndex - 1].burstFirstLineTime[this.firstBurstIndex - 1] / 86400.0));
        absRoot.setAttributeUTC("last_line_time", new ProductData.UTC(this.subSwathInfo[this.subSwathIndex - 1].burstLastLineTime[this.lastBurstIndex - 1] / 86400.0));
        absRoot.setAttributeDouble("line_time_interval", this.subSwathInfo[this.subSwathIndex - 1].azimuthTimeInterval);
        absRoot.setAttributeDouble("slant_range_to_first_pixel", this.subSwathInfo[this.subSwathIndex - 1].slrTimeToFirstPixel * 2.99792458E8);
        absRoot.setAttributeDouble("range_spacing", this.subSwathInfo[this.subSwathIndex - 1].rangePixelSpacing);
        absRoot.setAttributeDouble("azimuth_spacing", this.subSwathInfo[this.subSwathIndex - 1].azimuthPixelSpacing);
        absRoot.setAttributeInt("num_output_lines", this.subSwathInfo[this.subSwathIndex - 1].linesPerBurst * (this.lastBurstIndex - this.firstBurstIndex + 1));
        absRoot.setAttributeInt("num_samples_per_line", this.subSwathInfo[this.subSwathIndex - 1].numOfSamples);
        int cols = this.subSwathInfo[this.subSwathIndex - 1].latitude[0].length;
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (double)this.subSwathInfo[this.subSwathIndex - 1].latitude[this.firstBurstIndex - 1][0]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (double)this.subSwathInfo[this.subSwathIndex - 1].longitude[this.firstBurstIndex - 1][0]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (double)this.subSwathInfo[this.subSwathIndex - 1].latitude[this.firstBurstIndex - 1][cols - 1]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (double)this.subSwathInfo[this.subSwathIndex - 1].longitude[this.firstBurstIndex - 1][cols - 1]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (double)this.subSwathInfo[this.subSwathIndex - 1].latitude[this.lastBurstIndex][0]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (double)this.subSwathInfo[this.subSwathIndex - 1].longitude[this.lastBurstIndex][0]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (double)this.subSwathInfo[this.subSwathIndex - 1].latitude[this.lastBurstIndex][cols - 1]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (double)this.subSwathInfo[this.subSwathIndex - 1].longitude[this.lastBurstIndex][cols - 1]);
        double incidenceNear = OperatorUtils.getIncidenceAngle((Product)this.targetProduct).getPixelDouble(0, this.targetProduct.getSceneRasterHeight() / 2);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"incidence_near", (double)incidenceNear);
        double incidenceFar = OperatorUtils.getIncidenceAngle((Product)this.targetProduct).getPixelDouble(this.targetProduct.getSceneRasterWidth() - 1, this.targetProduct.getSceneRasterHeight() / 2);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"incidence_far", (double)incidenceFar);
        absRoot.setAttributeString("swath", this.subswath);
        for (int i = 0; i < this.selectedPolarisations.length; ++i) {
            if (i == 0) {
                absRoot.setAttributeString("mds1_tx_rx_polar", this.selectedPolarisations[i]);
                continue;
            }
            if (i == 1) {
                absRoot.setAttributeString("mds2_tx_rx_polar", this.selectedPolarisations[i]);
                continue;
            }
            if (i == 2) {
                absRoot.setAttributeString("mds3_tx_rx_polar", this.selectedPolarisations[i]);
                continue;
            }
            absRoot.setAttributeString("mds4_tx_rx_polar", this.selectedPolarisations[i]);
        }
        for (MetadataElement bandMeta : bandMetadataList = AbstractMetadata.getBandAbsMetadataList((MetadataElement)absRoot)) {
            boolean include = false;
            if (bandMeta.getName().contains(this.subswath)) {
                for (String pol : this.selectedPolarisations) {
                    if (!bandMeta.getName().contains(pol)) continue;
                    include = true;
                    break;
                }
            }
            if (include) continue;
            absRoot.removeElement(bandMeta);
        }
    }

    private void updateOriginalMetadata() {
        MetadataElement origMeta = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        this.removeElements(origMeta, "annotation");
        this.removeElements(origMeta, "calibration");
        this.removeElements(origMeta, "noise");
        this.removeBursts(origMeta);
        this.updateImageInformation(origMeta);
    }

    private void removeElements(MetadataElement origMeta, String parent) {
        MetadataElement parentElem = origMeta.getElement(parent);
        if (parentElem != null) {
            MetadataElement[] elemList;
            for (MetadataElement elem : elemList = parentElem.getElements()) {
                if (!elem.getName().toUpperCase().contains(this.subswath)) {
                    parentElem.removeElement(elem);
                    continue;
                }
                boolean isSelected = false;
                for (String pol : this.selectedPolarisations) {
                    if (!elem.getName().toUpperCase().contains(pol)) continue;
                    isSelected = true;
                    break;
                }
                if (isSelected) continue;
                parentElem.removeElement(elem);
            }
        }
    }

    private void removeBursts(MetadataElement origMeta) {
        MetadataElement[] elems;
        MetadataElement annotation = origMeta.getElement("annotation");
        if (annotation == null) {
            throw new OperatorException("Annotation Metadata not found");
        }
        for (MetadataElement elem : elems = annotation.getElements()) {
            MetadataElement product = elem.getElement("product");
            MetadataElement swathTiming = product.getElement("swathTiming");
            MetadataElement burstList = swathTiming.getElement("burstList");
            burstList.setAttributeString("count", Integer.toString(this.lastBurstIndex - this.firstBurstIndex + 1));
            MetadataElement[] burstListElem = burstList.getElements();
            for (int i = 0; i < burstListElem.length; ++i) {
                if (i >= this.firstBurstIndex - 1 && i <= this.lastBurstIndex - 1) continue;
                burstList.removeElement(burstListElem[i]);
            }
        }
    }

    private void updateImageInformation(MetadataElement origMeta) {
        MetadataElement[] elems;
        MetadataElement annotation = origMeta.getElement("annotation");
        if (annotation == null) {
            throw new OperatorException("Annotation Metadata not found");
        }
        for (MetadataElement elem : elems = annotation.getElements()) {
            MetadataElement product = elem.getElement("product");
            MetadataElement imageAnnotation = product.getElement("imageAnnotation");
            MetadataElement imageInformation = imageAnnotation.getElement("imageInformation");
            imageInformation.setAttributeString("numberOfLines", Integer.toString(this.subSwathInfo[this.subSwathIndex - 1].linesPerBurst * (this.lastBurstIndex - this.firstBurstIndex + 1)));
            ProductData.UTC firstLineTimeUTC = new ProductData.UTC(this.subSwathInfo[this.subSwathIndex - 1].burstFirstLineTime[this.firstBurstIndex - 1] / 86400.0);
            imageInformation.setAttributeString("productFirstLineUtcTime", this.format(firstLineTimeUTC));
            ProductData.UTC lastLineTimeUTC = new ProductData.UTC(this.subSwathInfo[this.subSwathIndex - 1].burstLastLineTime[this.lastBurstIndex - 1] / 86400.0);
            imageInformation.setAttributeString("productLastLineUtcTime", this.format(lastLineTimeUTC));
        }
    }

    public String format(ProductData.UTC utc) {
        Calendar calendar = utc.createCalendar();
        calendar.add(5, utc.getDaysFraction());
        calendar.add(13, (int)utc.getSecondsFraction());
        DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd_HH:mm:ss");
        Date time = calendar.getTime();
        String dateString = dateFormat.format(time);
        String microsString = String.valueOf(utc.getMicroSecondsFraction());
        StringBuilder sb = new StringBuilder(dateString.toUpperCase());
        sb.append('.');
        for (int i = microsString.length(); i < 6; ++i) {
            sb.append('0');
        }
        sb.append(microsString);
        return sb.toString().replace("_", "T");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(TOPSARSplitOp.class);
        }
    }
}

