/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import com.bc.ceres.core.ProgressMonitor;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.jblas.ComplexDoubleMatrix;
import org.jlinda.core.coregistration.utils.CoregistrationUtils;
import org.jlinda.nest.utils.TileUtilsDoris;

@OperatorMetadata(alias="Range-Shift", category="Radar/Coregistration/S-1 TOPS Coregistration", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Estimate constant range offset for the whole image")
public class RangeShiftOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct(description="The target product which will use the master's grid.")
    private Product targetProduct = null;
    @Parameter(valueSet={"32", "64", "128", "256", "512", "1024", "2048"}, defaultValue="512", label="Registration Window Width")
    private String fineWinWidthStr = "512";
    @Parameter(valueSet={"32", "64", "128", "256", "512", "1024", "2048"}, defaultValue="512", label="Registration Window Height")
    private String fineWinHeightStr = "512";
    @Parameter(valueSet={"2", "4", "8", "16", "32", "64"}, defaultValue="16", label="Search Window Accuracy in Azimuth Direction")
    private String fineWinAccAzimuth = "16";
    @Parameter(valueSet={"2", "4", "8", "16", "32", "64"}, defaultValue="16", label="Search Window Accuracy in Range Direction")
    private String fineWinAccRange = "16";
    @Parameter(valueSet={"32", "64", "128", "256"}, defaultValue="128", label="Window oversampling factor")
    private String fineWinOversampling = "128";
    @Parameter(description="The peak cross-correlation threshold", interval="(0, *)", defaultValue="0.1", label="Cross-Correlation Threshold")
    private double xCorrThreshold = 0.1;
    private int fineWinWidth = 0;
    private int fineWinHeight = 0;
    private int fineWinAccY = 0;
    private int fineWinAccX = 0;
    private int fineWinOvsFactor = 0;
    private boolean isRangeOffsetAvailable = false;
    private double azOffset = 0.0;
    private double rgOffset = 0.0;
    private Double noDataValue = -9999.0;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private int subSwathIndex = 0;
    private String[] subSwathNames = null;
    private Band mstBandI = null;
    private Band mstBandQ = null;
    private Band slvBandI = null;
    private Band slvBandQ = null;
    private static final int maxRangeShift = 1;

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSentinel1Product();
            this.fineWinWidth = Integer.parseInt(this.fineWinWidthStr);
            this.fineWinHeight = Integer.parseInt(this.fineWinHeightStr);
            this.fineWinAccY = Integer.parseInt(this.fineWinAccAzimuth);
            this.fineWinAccX = Integer.parseInt(this.fineWinAccRange);
            this.fineWinOvsFactor = Integer.parseInt(this.fineWinOversampling);
            Sentinel1Utils su = new Sentinel1Utils(this.sourceProduct);
            this.subSwath = su.getSubSwath();
            this.subSwathNames = su.getSubSwathNames();
            if (this.subSwathNames.length != 1) {
                throw new OperatorException("Split product is expected.");
            }
            this.subSwathIndex = 1;
            if (this.subSwath[this.subSwathIndex - 1].samplesPerBurst < this.fineWinWidth) {
                throw new OperatorException("Registration window width should not be grater than burst width " + this.subSwath[this.subSwathIndex - 1].samplesPerBurst);
            }
            if (this.subSwath[this.subSwathIndex - 1].linesPerBurst < this.fineWinHeight) {
                throw new OperatorException("Registration window height should not be grater than burst height " + this.subSwath[this.subSwathIndex - 1].linesPerBurst);
            }
            this.mstBandI = this.getSourceBand("_mst", "real");
            this.mstBandQ = this.getSourceBand("_mst", "imaginary");
            this.slvBandI = this.getSourceBand("_slv", "real");
            this.slvBandQ = this.getSourceBand("_slv", "imaginary");
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        String[] srcBandNames;
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        for (String srcBandName : srcBandNames = this.sourceProduct.getBandNames()) {
            Band targetBand;
            Band band = this.sourceProduct.getBand(srcBandName);
            if (band instanceof VirtualBand) continue;
            if (srcBandName.contains("_mst") || srcBandName.contains("derampDemod")) {
                targetBand = ProductUtils.copyBand((String)srcBandName, (Product)this.sourceProduct, (String)srcBandName, (Product)this.targetProduct, (boolean)true);
            } else {
                if (srcBandName.contains("azOffset") || srcBandName.contains("rgOffset")) continue;
                targetBand = new Band(srcBandName, band.getDataType(), band.getRasterWidth(), band.getRasterHeight());
                targetBand.setUnit(band.getUnit());
                this.targetProduct.addBand(targetBand);
            }
            if (targetBand == null || !srcBandName.startsWith("q_")) continue;
            String suffix = srcBandName.substring(1);
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)this.targetProduct.getBand("i" + suffix), (Band)targetBand, (String)suffix);
        }
        this.targetProduct.setPreferredTileSize(this.sourceProduct.getSceneRasterWidth(), 10);
        this.updateTargetMetadata();
    }

    private void updateTargetMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = new MetadataElement("ESD Measurement");
        MetadataElement OverallRgAzShiftElem = new MetadataElement("Overall_Range_Azimuth_Shift");
        OverallRgAzShiftElem.addElement(new MetadataElement(this.subSwathNames[0]));
        ESDMeasurement.addElement(OverallRgAzShiftElem);
        MetadataElement RgShiftPerBurstElem = new MetadataElement("Range_Shift_Per_Burst");
        RgShiftPerBurstElem.addElement(new MetadataElement(this.subSwathNames[0]));
        ESDMeasurement.addElement(RgShiftPerBurstElem);
        absTgt.addElement(ESDMeasurement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        try {
            String[] bandNames;
            if (!this.isRangeOffsetAvailable) {
                this.estimateRangeOffset();
            }
            Band slaveBandI = null;
            Band slaveBandQ = null;
            Band targetBandI = null;
            Band targetBandQ = null;
            for (String bandName : bandNames = this.sourceProduct.getBandNames()) {
                if (bandName.contains("i_") && bandName.contains("_slv")) {
                    slaveBandI = this.sourceProduct.getBand(bandName);
                    targetBandI = this.targetProduct.getBand(bandName);
                    continue;
                }
                if (!bandName.contains("q_") || !bandName.contains("_slv")) continue;
                slaveBandQ = this.sourceProduct.getBand(bandName);
                targetBandQ = this.targetProduct.getBand(bandName);
            }
            Tile slvTileI = this.getSourceTile((RasterDataNode)slaveBandI, targetRectangle);
            Tile slvTileQ = this.getSourceTile((RasterDataNode)slaveBandQ, targetRectangle);
            Tile tgtTileI = targetTileMap.get(targetBandI);
            Tile tgtTileQ = targetTileMap.get(targetBandQ);
            float[] slvArrayI = (float[])slvTileI.getDataBuffer().getElems();
            float[] slvArrayQ = (float[])slvTileQ.getDataBuffer().getElems();
            float[] tgtArrayI = (float[])tgtTileI.getDataBuffer().getElems();
            float[] tgtArrayQ = (float[])tgtTileQ.getDataBuffer().getElems();
            double[] line = new double[2 * w];
            double[] phase = new double[2 * w];
            DoubleFFT_1D row_fft = new DoubleFFT_1D(w);
            RangeShiftOp.computeShiftPhaseArray(this.rgOffset, w, phase);
            for (int r = 0; r < h; ++r) {
                int c;
                int rw = r * w;
                for (c = 0; c < w; ++c) {
                    line[2 * c] = slvArrayI[rw + c];
                    line[2 * c + 1] = slvArrayQ[rw + c];
                }
                row_fft.complexForward(line);
                RangeShiftOp.multiplySpectrumByShiftFactor(line, phase);
                row_fft.complexInverse(line, true);
                for (c = 0; c < w; ++c) {
                    tgtArrayI[rw + c] = (float)line[2 * c];
                    tgtArrayQ[rw + c] = (float)line[2 * c + 1];
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private synchronized void estimateRangeOffset() {
        if (this.isRangeOffsetAvailable) {
            return;
        }
        int numBursts = this.subSwath[this.subSwathIndex - 1].numOfBursts;
        final ArrayList azOffsetArray = new ArrayList(numBursts);
        final ArrayList<Double> rgOffsetArray = new ArrayList<Double>(numBursts);
        final ArrayList<Integer> burstIndexArray = new ArrayList<Integer>(numBursts);
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Estimating range offsets... ", numBursts);
        ThreadManager threadManager = new ThreadManager();
        try {
            int i = 0;
            while (i < numBursts) {
                this.checkForCancellation();
                final int burstIndex = i++;
                Thread worker = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            double[] offset = new double[2];
                            RangeShiftOp.this.estimateAzRgOffsets(burstIndex, offset);
                            List list = azOffsetArray;
                            synchronized (list) {
                                azOffsetArray.add(offset[0]);
                                rgOffsetArray.add(offset[1]);
                                burstIndexArray.add(burstIndex);
                            }
                        }
                        catch (Throwable e) {
                            OperatorUtils.catchOperatorException((String)"estimateOffset", (Throwable)e);
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            status.done();
            threadManager.finish();
            double sumAzOffset = 0.0;
            double sumRgOffset = 0.0;
            int count = 0;
            for (int i2 = 0; i2 < azOffsetArray.size(); ++i2) {
                double azShift = (Double)azOffsetArray.get(i2);
                double rgShift = (Double)rgOffsetArray.get(i2);
                if (this.noDataValue.equals(azShift) || this.noDataValue.equals(rgShift) || Math.abs(rgShift) > 1.0) continue;
                sumAzOffset += azShift;
                sumRgOffset += rgShift;
                ++count;
            }
            if (count <= 0) {
                throw new OperatorException("estimateOffset failed.");
            }
            this.azOffset = sumAzOffset / (double)count;
            this.rgOffset = sumRgOffset / (double)count;
            this.saveOverallRangeShift(this.rgOffset);
            this.saveRangeShiftPerBurst(rgOffsetArray, burstIndexArray);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"estimateOffset", (Throwable)e);
        }
        this.isRangeOffsetAvailable = true;
        SystemUtils.LOG.info("RangeShiftOp: Overall range shift = " + this.rgOffset);
    }

    private void estimateAzRgOffsets(int burstIndex, double[] offset) {
        int burstHeight = this.subSwath[this.subSwathIndex - 1].linesPerBurst;
        int burstWidth = this.subSwath[this.subSwathIndex - 1].samplesPerBurst;
        int x0 = burstWidth / 2;
        int y0 = burstHeight / 2 + burstIndex * burstHeight;
        PixelPos mGCP = new PixelPos((double)x0, (double)y0);
        PixelPos sGCP = new PixelPos((double)x0, (double)y0);
        this.getFineOffsets(mGCP, sGCP, offset);
    }

    private void getFineOffsets(PixelPos mGCPPixelPos, PixelPos sGCPPixelPos, double[] offset) {
        try {
            ComplexDoubleMatrix mI = this.getComplexDoubleMatrix(this.mstBandI, this.mstBandQ, mGCPPixelPos, this.fineWinWidth, this.fineWinHeight);
            ComplexDoubleMatrix sI = this.getComplexDoubleMatrix(this.slvBandI, this.slvBandQ, sGCPPixelPos, this.fineWinWidth, this.fineWinHeight);
            double[] fineOffset = new double[]{0.0, 0.0};
            double coherence = CoregistrationUtils.crossCorrelateFFT((double[])fineOffset, (ComplexDoubleMatrix)mI, (ComplexDoubleMatrix)sI, (int)this.fineWinOvsFactor, (int)this.fineWinAccY, (int)this.fineWinAccX);
            if (coherence < this.xCorrThreshold) {
                offset[0] = this.noDataValue;
                offset[1] = this.noDataValue;
            } else {
                offset[0] = -fineOffset[0];
                offset[1] = -fineOffset[1];
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " getFineOffsets "), (Throwable)e);
        }
    }

    private void saveOverallRangeShift(double rangeShift) {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        MetadataElement OverallRgAzShiftElem = ESDMeasurement.getElement("Overall_Range_Azimuth_Shift");
        MetadataElement swathElem = OverallRgAzShiftElem.getElement(this.subSwathNames[0]);
        MetadataAttribute rangeShiftAttr = new MetadataAttribute("rangeShift", 30);
        rangeShiftAttr.setUnit("pixel");
        swathElem.addAttribute(rangeShiftAttr);
        swathElem.setAttributeDouble("rangeShift", rangeShift);
    }

    private void saveRangeShiftPerBurst(List<Double> rangeShiftArray, List<Integer> burstIndexArray) {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        MetadataElement RangeShiftPerBurstElem = ESDMeasurement.getElement("Range_Shift_Per_Burst");
        MetadataElement swathElem = RangeShiftPerBurstElem.getElement(this.subSwathNames[0]);
        swathElem.addAttribute(new MetadataAttribute("count", 11));
        swathElem.setAttributeInt("count", rangeShiftArray.size());
        for (int i = 0; i < rangeShiftArray.size(); ++i) {
            MetadataElement burstListElem = new MetadataElement("RangeShiftList." + i);
            MetadataAttribute rangeShiftAttr = new MetadataAttribute("rangeShift", 30);
            rangeShiftAttr.setUnit("pixel");
            burstListElem.addAttribute(rangeShiftAttr);
            burstListElem.setAttributeDouble("rangeShift", rangeShiftArray.get(i).doubleValue());
            burstListElem.addAttribute(new MetadataAttribute("burstIndex", 11));
            burstListElem.setAttributeInt("burstIndex", burstIndexArray.get(i).intValue());
            swathElem.addElement(burstListElem);
        }
    }

    private ComplexDoubleMatrix getComplexDoubleMatrix(Band band1, Band band2, PixelPos pixelPos, int fineWinWidth, int fineWinHeight) {
        Rectangle rectangle = this.defineRectangleMask(pixelPos, fineWinWidth, fineWinHeight);
        Tile tileReal = this.getSourceTile((RasterDataNode)band1, rectangle);
        Tile tileImag = this.getSourceTile((RasterDataNode)band2, rectangle);
        return TileUtilsDoris.pullComplexDoubleMatrix((Tile)tileReal, (Tile)tileImag);
    }

    private Rectangle defineRectangleMask(PixelPos pixelPos, int fineWinWidth, int fineWinHeight) {
        int l0 = (int)(pixelPos.y - (double)(fineWinHeight / 2));
        int lN = (int)(pixelPos.y + (double)(fineWinHeight / 2) - 1.0);
        int p0 = (int)(pixelPos.x - (double)(fineWinWidth / 2));
        int pN = (int)(pixelPos.x + (double)(fineWinWidth / 2) - 1.0);
        return new Rectangle(p0, l0, pN - p0 + 1, lN - l0 + 1);
    }

    private Band getSourceBand(String suffix, String bandUnit) {
        String[] bandNames;
        for (String bandName : bandNames = this.sourceProduct.getBandNames()) {
            Band band;
            if (!bandName.contains(suffix) || !(band = this.sourceProduct.getBand(bandName)).getUnit().contains(bandUnit)) continue;
            return band;
        }
        return null;
    }

    private static void computeShiftPhaseArray(double shift, int signalLength, double[] phaseArray) {
        double phase = Math.PI * -2 * shift / (double)signalLength;
        int halfSignalLength = (int)((double)signalLength * 0.5 + 0.5);
        for (int k = 0; k < signalLength; ++k) {
            double phaseK = k < halfSignalLength ? phase * (double)k : phase * (double)(k - signalLength);
            int k2 = k * 2;
            phaseArray[k2] = FastMath.cos((double)phaseK);
            phaseArray[k2 + 1] = FastMath.sin((double)phaseK);
        }
    }

    private static void multiplySpectrumByShiftFactor(double[] array, double[] phaseArray) {
        int signalLength = array.length / 2;
        for (int k = 0; k < signalLength; ++k) {
            int k2 = k * 2;
            double c = phaseArray[k2];
            double s = phaseArray[k2 + 1];
            double real = array[k2];
            double imag = array[k2 + 1];
            array[k2] = real * c - imag * s;
            array[k2 + 1] = real * s + imag * c;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(RangeShiftOp.class);
        }
    }
}

