/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="GRD-Post", category="Radar/Sentinel-1 TOPS", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Applies GRD post-processing")
public final class GRDPostProcessOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSentinel1Product();
            validator.checkProductType(new String[]{"SLC"});
            if (validator.isComplex()) {
                throw new OperatorException("Data should not be complex. Please first apply SLC to GRD processing.");
            }
            if (validator.isMultiSwath()) {
                throw new OperatorException("Data should not be in separate swaths. Please first apply SLC to GRD processing.");
            }
            String productName = this.sourceProduct.getName();
            productName = productName.replace("SLC_", "GRDH");
            this.targetProduct = new Product(productName, "GRD", this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            for (Band srcBand : this.sourceProduct.getBands()) {
                if (srcBand instanceof VirtualBand) {
                    ProductUtils.copyVirtualBand((Product)this.targetProduct, (VirtualBand)((VirtualBand)srcBand), (String)srcBand.getName());
                    continue;
                }
                ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
            }
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        String productName = absRoot.getAttributeString("PRODUCT");
        absRoot.setAttributeString("PRODUCT", productName.replace("SLC_", "GRDH"));
        String description = absRoot.getAttributeString("SPH_DESCRIPTOR");
        absRoot.setAttributeString("SPH_DESCRIPTOR", description.replace("SLC", "GRD"));
        absRoot.setAttributeString("PRODUCT_TYPE", "GRD");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GRDPostProcessOp.class);
        }
    }
}

