/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.download.downloadablecontent.DownloadableArchive;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.Settings;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@OperatorMetadata(alias="EAP-Phase-Correction", category="Radar/Sentinel-1 TOPS", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="EAP Phase Correction")
public final class EAPPhaseCorrectionOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    private MetadataElement absRoot = null;
    private String acquisitionMode = null;
    private Sentinel1Utils su = null;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private File auxCalFile = null;
    private final HashMap<String, String[]> targetBandNameToSourceBandName = new HashMap(2);
    private final HashMap<String, EAPVector> swathPolToEAPVector = new HashMap();
    private boolean isSplitProduct = false;
    private final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyyMMdd-HHmmss");

    public void initialize() throws OperatorException {
        try {
            this.checkSourceProductValidity();
            this.getSourceMetadata();
            this.retrieveAuxCalFile();
            this.readAuxCalFile();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkSourceProductValidity() throws OperatorException {
        InputProductValidator validator = new InputProductValidator(this.sourceProduct);
        validator.checkIfSARProduct();
        validator.checkIfSentinel1Product();
        validator.checkProductType(new String[]{"SLC"});
        this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        String procSysId = this.absRoot.getAttributeString("Processing_system_identifier");
        float version = Float.valueOf(procSysId.substring(procSysId.lastIndexOf(" "))).floatValue();
        if ((double)version >= 2.43) {
            throw new OperatorException("EAP phase correction has already been performed for the Sentinel1 product");
        }
    }

    private void getSourceMetadata() throws Exception {
        this.su = new Sentinel1Utils(this.sourceProduct);
        this.subSwath = this.su.getSubSwath();
        this.acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE");
        this.isSplitProduct = this.subSwath.length == 1;
    }

    void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
        this.updateTargetProductMetadata();
    }

    private void addSelectedBands() {
        Band[] sourceBands = this.sourceProduct.getBands();
        for (int i = 0; i < sourceBands.length; ++i) {
            Band srcBandI = sourceBands[i];
            if (srcBandI instanceof VirtualBand) continue;
            String unit = srcBandI.getUnit();
            String nextUnit = null;
            if (unit == null) {
                throw new OperatorException("band " + srcBandI.getName() + " requires a unit");
            }
            if (unit.contains("imaginary")) {
                throw new OperatorException("I and Q bands should be in pairs");
            }
            if (unit.contains("real")) {
                if (i + 1 >= sourceBands.length) {
                    throw new OperatorException("I and Q bands should be in pairs");
                }
                nextUnit = sourceBands[i + 1].getUnit();
                if (nextUnit == null || !nextUnit.contains("imaginary")) {
                    throw new OperatorException("I and Q bands should be in pairs");
                }
            } else {
                throw new OperatorException("I and Q bands are not in pairs");
            }
            Band srcBandQ = sourceBands[i + 1];
            String[] srcBandNames = new String[]{srcBandI.getName(), srcBandQ.getName()};
            this.targetBandNameToSourceBandName.put(srcBandNames[0], srcBandNames);
            Band targetBandI = new Band(srcBandNames[0], 30, srcBandI.getRasterWidth(), srcBandI.getRasterHeight());
            targetBandI.setUnit(unit);
            targetBandI.setNoDataValueUsed(true);
            this.targetProduct.addBand(targetBandI);
            this.targetBandNameToSourceBandName.put(srcBandNames[1], srcBandNames);
            Band targetBandQ = new Band(srcBandNames[1], 30, srcBandQ.getRasterWidth(), srcBandQ.getRasterHeight());
            targetBandQ.setUnit(nextUnit);
            targetBandQ.setNoDataValueUsed(true);
            this.targetProduct.addBand(targetBandQ);
            String suffix = "_" + OperatorUtils.getSuffixFromBandName((String)srcBandI.getName());
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)targetBandI, (Band)targetBandQ, (String)suffix);
            ++i;
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.addAbstractedAttribute((MetadataElement)absTgt, (String)"EAP Correction", (int)20, (String)"flag", (String)"EAP Correction Applied");
        absTgt.getAttribute("EAP Correction").getData().setElemBoolean(true);
    }

    private void retrieveAuxCalFile() throws Exception {
        double procTime = this.absRoot.getAttributeUTC("PROC_TIME").getMJD();
        Calendar calendar = this.absRoot.getAttributeUTC("PROC_TIME").getAsCalendar();
        int year = calendar.get(1);
        this.auxCalFile = this.findAuxCalFile(procTime, year);
        if (this.auxCalFile == null) {
            this.getRemoteFiles(year);
            this.auxCalFile = this.findAuxCalFile(procTime, year);
            if (this.auxCalFile == null) {
                this.getRemoteFiles(--year);
                this.auxCalFile = this.findAuxCalFile(procTime, year);
                if (this.auxCalFile == null) {
                    String timeStr = this.absRoot.getAttributeUTC("PROC_TIME").format();
                    throw new OperatorException("No valid AUX_CAL file found for " + timeStr);
                }
            }
        }
        if (!this.auxCalFile.exists()) {
            throw new IOException("EAPPhaseCorrection: Unable to find AUX_CAL file");
        }
    }

    private File findAuxCalFile(double time, int year) {
        final String prefix = "S1A_AUX_CAL_";
        File localFolder = SystemUtils.getAuxDataPath().resolve("AuxCal").resolve("S1").toFile();
        File auxCalFileFolder = new File(localFolder, String.valueOf(year));
        File[] files = auxCalFileFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return ((name = name.toUpperCase()).endsWith(".ZIP") || name.endsWith(".SAFE")) && name.startsWith(prefix);
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        File auxFile = null;
        double minTimeDuration = Double.MAX_VALUE;
        for (File file : files) {
            try {
                double duration;
                String filename = file.getName();
                ProductData.UTC valStart = this.getValidityStartFromFilenameUTC(filename);
                if (valStart == null || !((duration = time - valStart.getMJD()) > 0.0) || !(duration < minTimeDuration)) continue;
                auxFile = file;
                minTimeDuration = duration;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return auxFile;
    }

    private ProductData.UTC getValidityStartFromFilenameUTC(String filename) throws ParseException {
        if (filename.substring(12, 13).equals("V")) {
            String val = EAPPhaseCorrectionOp.extractTimeFromFilename(filename, 13);
            return ProductData.UTC.parse((String)val, (DateFormat)this.dateFormat);
        }
        return null;
    }

    private static String extractTimeFromFilename(String filename, int offset) {
        return filename.substring(offset, offset + 15).replace("T", "-");
    }

    private void getRemoteFiles(int year) throws Exception {
        File localFolder = SystemUtils.getAuxDataPath().resolve("AuxCal").resolve("S1").resolve(String.valueOf(year)).toFile();
        URL remotePath = new URL(Settings.getPath((String)"AuxCal.Sentinel1.remotePath"));
        File localFile = new File(localFolder, year + ".zip");
        DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
        archive.getContentFiles();
    }

    private void readAuxCalFile() throws Exception {
        try {
            Document doc;
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            if (this.auxCalFile.getName().toLowerCase().endsWith(".zip")) {
                ZipFile productZip = new ZipFile(this.auxCalFile, 1);
                Enumeration<? extends ZipEntry> entries = productZip.entries();
                ZipEntry folderEntry = entries.nextElement();
                ZipEntry zipEntry = productZip.getEntry(folderEntry.getName() + "data/s1a-aux-cal.xml");
                InputStream is = productZip.getInputStream(zipEntry);
                doc = documentBuilder.parse(is);
            } else {
                doc = documentBuilder.parse(this.auxCalFile);
            }
            if (doc == null) {
                System.out.println("EAPPhaseCorrection: failed to create Document for AUX_CAL file");
                return;
            }
            doc.getDocumentElement().normalize();
            Node calibrationParamsListNode = doc.getElementsByTagName("auxiliaryCalibration").item(0).getChildNodes().item(1);
            for (Node childNode = calibrationParamsListNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                String swath;
                if (!childNode.getNodeName().equals("calibrationParams") || (swath = this.getNodeTextContent(childNode, "swath")) == null || !swath.contains(this.acquisitionMode)) continue;
                String pol = this.getNodeTextContent(childNode, "polarisation");
                this.readOneEAPVector(childNode, swath, pol.toUpperCase());
            }
        }
        catch (IOException e) {
            System.out.println("EAPPhaseCorrection: IOException " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            System.out.println("EAPPhaseCorrection: ParserConfigurationException " + e.getMessage());
        }
        catch (SAXException e) {
            System.out.println("EAPPhaseCorrection: SAXException " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("EAPPhaseCorrection: Exception " + e.getMessage());
        }
    }

    private String getNodeTextContent(Node node, String nodeName) {
        Node childNode = this.getChildNode(node, nodeName);
        if (childNode != null) {
            return childNode.getTextContent();
        }
        return null;
    }

    private Node getChildNode(Node node, String childNodeName) {
        for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!childNode.getNodeName().equals(childNodeName)) continue;
            return childNode;
        }
        return null;
    }

    private void readOneEAPVector(Node node, String swath, String pol) throws Exception {
        Node elevationAntennaPatternNode = this.getChildNode(node, "elevationAntennaPattern");
        Node elevationAngleIncrementNode = this.getChildNode(elevationAntennaPatternNode, "elevationAngleIncrement");
        double elevationAngleIncrement = Double.parseDouble(elevationAngleIncrementNode.getTextContent());
        Node eapNode = this.getChildNode(elevationAntennaPatternNode, "values");
        Node attrCount = this.getAttributeFromNode(eapNode, "count");
        int count = Integer.parseInt(attrCount.getTextContent());
        double[] eap = new double[2 * count];
        String eapArrayStr = eapNode.getTextContent();
        if (!eapArrayStr.isEmpty()) {
            StringTokenizer st = new StringTokenizer(eapArrayStr);
            int k = 0;
            while (st.hasMoreTokens()) {
                eap[k++] = Double.parseDouble(st.nextToken());
            }
            if (k != 2 * count) {
                throw new IOException("EAPPhaseCorrection: Complex elevation antenna pattern is required in AUX_CAL file");
            }
        }
        String key = swath + "_" + pol;
        EAPVector eapVector = new EAPVector(swath, pol, elevationAngleIncrement, eap);
        this.swathPolToEAPVector.put(key, eapVector);
    }

    private Node getAttributeFromNode(Node node, String attrName) {
        NamedNodeMap attr = node.getAttributes();
        Node attrNode = null;
        for (int j = 0; j < attr.getLength(); ++j) {
            if (!attr.item(j).getNodeName().equals(attrName)) continue;
            if (attrNode == null) {
                attrNode = attr.item(j);
                continue;
            }
            System.out.println("EAPPhaseCorrection: more than one " + attrName + " in " + node.getNodeName());
        }
        return attrNode;
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetRectangle = targetTile.getRectangle();
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            int tyMax = ty0 + th;
            int subSwathIndex = 1;
            if (!this.isSplitProduct) {
                subSwathIndex = this.getSubSwathIndex(targetBand.getName());
            }
            String polarization = this.getPolarization(targetBand.getName());
            for (int burstIndex = 0; burstIndex < this.subSwath[subSwathIndex - 1].numOfBursts; ++burstIndex) {
                int firstLineIdx = burstIndex * this.subSwath[subSwathIndex - 1].linesPerBurst;
                int lastLineIdx = firstLineIdx + this.subSwath[subSwathIndex - 1].linesPerBurst - 1;
                if (tyMax <= firstLineIdx || ty0 > lastLineIdx) continue;
                int nty0 = Math.max(ty0, firstLineIdx);
                int ntyMax = Math.min(tyMax, lastLineIdx + 1);
                int nth = ntyMax - nty0;
                this.computeTileForOneBurst(subSwathIndex, burstIndex, polarization, tx0, nty0, tw, nth, targetBand, targetTile);
            }
        }
        catch (Exception e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private int getSubSwathIndex(String targetBandName) {
        for (int i = 0; i < 5; ++i) {
            if (!targetBandName.contains(String.valueOf(i + 1))) continue;
            return i + 1;
        }
        return -1;
    }

    private String getPolarization(String targetBandName) {
        String targetBandNameInLowerCase = targetBandName.toLowerCase();
        if (targetBandNameInLowerCase.contains("hh")) {
            return "HH";
        }
        if (targetBandNameInLowerCase.contains("hv")) {
            return "HV";
        }
        if (targetBandNameInLowerCase.contains("vh")) {
            return "VH";
        }
        if (targetBandNameInLowerCase.contains("vv")) {
            return "VV";
        }
        return null;
    }

    private void computeTileForOneBurst(int subSwathIndex, int burstIndex, String polarization, int x0, int y0, int w, int h, Band targetBand, Tile targetTile) {
        double rollSteeringAngle = this.computeRollSteeringAngle(subSwathIndex, burstIndex);
        Unit.UnitType tgtBandUnit = Unit.getUnitType((Band)targetBand);
        Rectangle sourceRectangle = new Rectangle(x0, y0, w, h);
        String[] srcBandNames = this.targetBandNameToSourceBandName.get(targetBand.getName());
        Band sourceBandI = this.sourceProduct.getBand(srcBandNames[0]);
        Band sourceBandQ = this.sourceProduct.getBand(srcBandNames[1]);
        Tile sourceRasterI = this.getSourceTile((RasterDataNode)sourceBandI, sourceRectangle);
        Tile sourceRasterQ = this.getSourceTile((RasterDataNode)sourceBandQ, sourceRectangle);
        ProductData srcDataI = sourceRasterI.getDataBuffer();
        ProductData srcDataQ = sourceRasterQ.getDataBuffer();
        ProductData tgtData = targetTile.getDataBuffer();
        TileIndex srcIndex = new TileIndex(sourceRasterI);
        TileIndex trgIndex = new TileIndex(targetTile);
        String key = this.subSwath[subSwathIndex - 1].subSwathName + "_" + polarization;
        EAPVector eapVector = this.swathPolToEAPVector.get(key);
        int yMax = y0 + h;
        int xMax = x0 + w;
        double[] eap = new double[2];
        double val = targetBand.getNoDataValue();
        for (int y = y0; y < yMax; ++y) {
            srcIndex.calculateStride(y);
            trgIndex.calculateStride(y);
            for (int x = x0; x < xMax; ++x) {
                double slantRangeTime = this.su.getSlantRangeTime(x, subSwathIndex) * 2.0;
                double elevationAngle = this.computeElevationAngle(subSwathIndex, burstIndex, slantRangeTime);
                if (elevationAngle == -1.0) continue;
                this.computeEAP(elevationAngle, rollSteeringAngle, eapVector, eap);
                int srcIdx = srcIndex.getIndex(x);
                if (tgtBandUnit == Unit.UnitType.REAL) {
                    val = (srcDataI.getElemDoubleAt(srcIdx) * eap[0] + srcDataQ.getElemDoubleAt(srcIdx) * eap[1]) / Math.sqrt(eap[0] * eap[0] + eap[1] * eap[1]);
                } else if (tgtBandUnit == Unit.UnitType.IMAGINARY) {
                    val = (srcDataQ.getElemDoubleAt(srcIdx) * eap[0] - srcDataI.getElemDoubleAt(srcIdx) * eap[1]) / Math.sqrt(eap[0] * eap[0] + eap[1] * eap[1]);
                }
                tgtData.setElemDoubleAt(trgIndex.getIndex(x), val);
            }
        }
    }

    private double computeRollSteeringAngle(int subSwathIndex, int burstIndex) {
        double ascendingNodeTime = this.subSwath[subSwathIndex - 1].ascendingNodeTime;
        double burstFirstLineTime = this.subSwath[subSwathIndex - 1].burstFirstLineTime[burstIndex];
        double satelliteAltitude = EAPPhaseCorrectionOp.computeSatelliteAltitude(ascendingNodeTime, burstFirstLineTime);
        return EAPPhaseCorrectionOp.computeRollSteeringAngle(satelliteAltitude);
    }

    private static double computeSatelliteAltitude(double ascendingNodeTime, double burstFirstLineTime) {
        double h0 = 707714.8;
        double h1 = 8351.5;
        double h2 = 8947.9;
        double h3 = 23.32;
        double h4 = 11.74;
        double phi1 = 3.1495;
        double phi2 = -1.5655;
        double phi3 = -3.1297;
        double phi4 = 4.7222;
        double omega = 0.0010605301831490871;
        double delta = burstFirstLineTime - ascendingNodeTime;
        double omegaByDelta = 0.0010605301831490871 * delta;
        return 707714.8 + 8351.5 * FastMath.sin((double)(omegaByDelta + 3.1495)) + 8947.9 * FastMath.sin((double)(2.0 * omegaByDelta + -1.5655)) + 23.32 * FastMath.sin((double)(3.0 * omegaByDelta + -3.1297)) + 11.74 * FastMath.sin((double)(4.0 * omegaByDelta + 4.7222));
    }

    private static double computeRollSteeringAngle(double satelliteAltitude) {
        double thetaRef = 29.45;
        double hRef = 711.7;
        double alphaRoll = 0.0566;
        return 29.45 + 0.0566 * (satelliteAltitude / 1000.0 - 711.7);
    }

    private double computeElevationAngle(int subSwathIndex, int burstIndex, double slantRangeTime) {
        double[] slantRangeTimeArray = this.subSwath[subSwathIndex - 1].apSlantRangeTime[burstIndex];
        double[] elevationAngleArray = this.subSwath[subSwathIndex - 1].apElevationAngle[burstIndex];
        if (slantRangeTime < slantRangeTimeArray[0] || slantRangeTime > slantRangeTimeArray[slantRangeTimeArray.length - 1]) {
            return -1.0;
        }
        double slrt0 = 0.0;
        double slrt1 = 0.0;
        double theta0 = 0.0;
        double theta1 = 0.0;
        for (int i = 0; i < slantRangeTimeArray.length; ++i) {
            slrt1 = slantRangeTimeArray[i];
            theta1 = elevationAngleArray[i];
            if (slantRangeTime <= slrt1) break;
            slrt0 = slrt1;
            theta0 = theta1;
        }
        if (slrt0 == 0.0 || slrt1 == 0.0) {
            return -1.0;
        }
        double lambda = (slantRangeTime - slrt0) / (slrt1 - slrt0);
        return (1.0 - lambda) * theta0 + lambda * theta1;
    }

    private void computeEAP(double elevationAngle, double rollSteeringAngle, EAPVector eapVector, double[] eap) {
        int i0 = (int)((elevationAngle - rollSteeringAngle) / eapVector.elevationAngleIncrement + (double)(eapVector.count - 1) / 2.0);
        double elevationAngle0 = ((double)i0 - (double)(eapVector.count - 1) / 2.0) * eapVector.elevationAngleIncrement + rollSteeringAngle;
        int i1 = i0 + 1;
        double eapI0 = eapVector.eapI[i0];
        double eapI1 = eapVector.eapI[i1];
        double eapQ0 = eapVector.eapQ[i0];
        double eapQ1 = eapVector.eapQ[i1];
        double lambda = (elevationAngle - elevationAngle0) / eapVector.elevationAngleIncrement;
        eap[0] = (1.0 - lambda) * eapI0 + lambda * eapI1;
        eap[1] = (1.0 - lambda) * eapQ0 + lambda * eapQ1;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(EAPPhaseCorrectionOp.class);
        }
    }

    public static final class EAPVector {
        public String swath;
        public String polarization;
        public double elevationAngleIncrement;
        public int count;
        public double[] eapI;
        public double[] eapQ;

        public EAPVector(String swath, String polarization, double elevationAngleIncrement, double[] eap) {
            this.swath = swath;
            this.polarization = polarization;
            this.elevationAngleIncrement = elevationAngleIncrement;
            this.count = eap.length / 2;
            this.eapI = new double[this.count];
            this.eapQ = new double[this.count];
            for (int i = 0; i < this.count; ++i) {
                this.eapI[i] = eap[2 * i];
                this.eapQ[i] = eap[2 * i + 1];
            }
        }
    }
}

