/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Double-Difference-Interferogram", category="Radar/Coregistration/S-1 TOPS Coregistration", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Compute double difference interferogram")
public class DoubleDifferenceInterferogramOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct(description="The target product which will use the master's grid.")
    private Product targetProduct = null;
    @Parameter(description="Output coherence for overlapped area", defaultValue="false", label="Output coherence")
    private boolean outputCoherence = false;
    @Parameter(valueSet={"3", "5", "9", "11"}, defaultValue="5", label="Coherence Window Size")
    private String cohWinSize = "5";
    private Sentinel1Utils su;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private int subSwathIndex = 0;
    private int cohWin = 0;
    private int numOverlaps = 0;
    private Band mstBandI = null;
    private Band mstBandQ = null;
    private Band slvBandI = null;
    private Band slvBandQ = null;
    private Band ddiBand = null;
    private Band cohBand = null;
    private String[] subSwathNames = null;

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSentinel1Product();
            this.su = new Sentinel1Utils(this.sourceProduct);
            this.su.computeDopplerRate();
            this.subSwath = this.su.getSubSwath();
            this.subSwathNames = this.su.getSubSwathNames();
            if (this.subSwathNames.length != 1) {
                throw new OperatorException("Split product is expected.");
            }
            this.subSwathIndex = 1;
            this.cohWin = Integer.parseInt(this.cohWinSize);
            this.numOverlaps = this.subSwath[this.subSwathIndex - 1].numOfBursts - 1;
            this.getSourceBands();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        int sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        int sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), sourceImageWidth, sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.ddiBand = new Band("DDIPhase", 30, sourceImageWidth, sourceImageHeight);
        this.ddiBand.setUnit("radian");
        this.ddiBand.setNoDataValue(0.0);
        this.ddiBand.setNoDataValueUsed(true);
        this.targetProduct.addBand(this.ddiBand);
        if (this.outputCoherence) {
            this.cohBand = new Band("coherence", 30, sourceImageWidth, sourceImageHeight);
            this.cohBand.setUnit("coherence");
            this.cohBand.setNoDataValue(0.0);
            this.cohBand.setNoDataValueUsed(true);
            this.targetProduct.addBand(this.cohBand);
        }
        this.targetProduct.setPreferredTileSize(512, this.subSwath[this.subSwathIndex - 1].linesPerBurst);
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            int overlapIndex = y0 / this.subSwath[this.subSwathIndex - 1].linesPerBurst;
            if (overlapIndex > this.numOverlaps - 1) {
                return;
            }
            Rectangle overlapInBurstOneRectangle = new Rectangle();
            Rectangle overlapInBurstTwoRectangle = new Rectangle();
            boolean successful = this.getOverlappedRectangles(overlapIndex, targetRectangle, overlapInBurstOneRectangle, overlapInBurstTwoRectangle);
            if (!successful) {
                return;
            }
            double[][] ddiPhase = this.computeDDIPhase(overlapInBurstOneRectangle, overlapInBurstTwoRectangle);
            double[][] data = new double[h][w];
            int x0DDI = overlapInBurstOneRectangle.x;
            int y0DDI = overlapInBurstOneRectangle.y;
            int xMaxDDI = x0DDI + overlapInBurstOneRectangle.width;
            int yMaxDDI = y0DDI + overlapInBurstOneRectangle.height;
            for (int y = y0DDI; y < yMaxDDI; ++y) {
                int r = y - y0;
                int rr = y - y0DDI;
                for (int x = x0DDI; x < xMaxDDI; ++x) {
                    int c = x - x0;
                    int cc = x - x0DDI;
                    data[r][c] = ddiPhase[rr][cc];
                }
            }
            this.saveData(data, this.ddiBand, targetTileMap, targetRectangle);
            if (this.outputCoherence) {
                double[][] coh = this.computeCoherence(overlapInBurstOneRectangle, this.mstBandI, this.mstBandQ, this.slvBandI, this.slvBandQ, this.cohWin);
                for (int y = y0DDI; y < yMaxDDI; ++y) {
                    int r = y - y0;
                    int rr = y - y0DDI;
                    for (int x = x0DDI; x < xMaxDDI; ++x) {
                        int c = x - x0;
                        int cc = x - x0DDI;
                        data[r][c] = coh[rr][cc];
                    }
                }
                this.saveData(data, this.cohBand, targetTileMap, targetRectangle);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void saveData(double[][] data, Band tgtBand, Map<Band, Tile> targetTileMap, Rectangle targetRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        if (data.length != h || data[0].length != w) {
            throw new OperatorException("The target data to save has different dimension than the processing tile");
        }
        Tile tgtTile = targetTileMap.get(tgtBand);
        ProductData tgtData = tgtTile.getDataBuffer();
        TileIndex tgtIndex = new TileIndex(tgtTile);
        int xMax = x0 + w;
        int yMax = y0 + h;
        for (int y = y0; y < yMax; ++y) {
            tgtIndex.calculateStride(y);
            int yy = y - y0;
            for (int x = x0; x < xMax; ++x) {
                tgtData.setElemDoubleAt(tgtIndex.getIndex(x), data[yy][x - x0]);
            }
        }
    }

    private void getSourceBands() {
        Band[] sourceBands;
        for (Band band : sourceBands = this.sourceProduct.getBands()) {
            String bandName = band.getName();
            String unit = band.getUnit();
            if (StackUtils.isMasterBand((String)bandName, (Product)this.sourceProduct)) {
                if (unit.contains("real") && this.mstBandI == null) {
                    this.mstBandI = band;
                    continue;
                }
                if (!unit.contains("imaginary") || this.mstBandQ != null) continue;
                this.mstBandQ = band;
                continue;
            }
            if (!StackUtils.isSlaveBand((String)bandName, (Product)this.sourceProduct)) continue;
            if (unit.contains("real") && this.slvBandI == null) {
                this.slvBandI = band;
                continue;
            }
            if (!unit.contains("imaginary") || this.slvBandQ != null) continue;
            this.slvBandQ = band;
        }
        if (this.mstBandI == null || this.mstBandQ == null || this.slvBandI == null || this.slvBandQ == null) {
            throw new OperatorException("Invalid source bands");
        }
    }

    private double[][] computeDDIPhase(Rectangle overlapInBurstOneRectangle, Rectangle overlapInBurstTwoRectangle) {
        try {
            int w = overlapInBurstOneRectangle.width;
            int h = overlapInBurstOneRectangle.height;
            if (overlapInBurstTwoRectangle.width != w || overlapInBurstTwoRectangle.height != h) {
                throw new OperatorException("Forward and backward rectangles have difference dimension");
            }
            double[][] mIBack = this.getSourceData(this.mstBandI, overlapInBurstTwoRectangle);
            double[][] mQBack = this.getSourceData(this.mstBandQ, overlapInBurstTwoRectangle);
            double[][] sIBack = this.getSourceData(this.slvBandI, overlapInBurstTwoRectangle);
            double[][] sQBack = this.getSourceData(this.slvBandQ, overlapInBurstTwoRectangle);
            double[][] mIFor = this.getSourceData(this.mstBandI, overlapInBurstOneRectangle);
            double[][] mQFor = this.getSourceData(this.mstBandQ, overlapInBurstOneRectangle);
            double[][] sIFor = this.getSourceData(this.slvBandI, overlapInBurstOneRectangle);
            double[][] sQFor = this.getSourceData(this.slvBandQ, overlapInBurstOneRectangle);
            double[][] backIntReal = new double[h][w];
            double[][] backIntImag = new double[h][w];
            DoubleDifferenceInterferogramOp.complexArrayMultiplication(mIBack, mQBack, sIBack, sQBack, backIntReal, backIntImag);
            double[][] forIntReal = new double[h][w];
            double[][] forIntImag = new double[h][w];
            DoubleDifferenceInterferogramOp.complexArrayMultiplication(mIFor, mQFor, sIFor, sQFor, forIntReal, forIntImag);
            double[][] diffIntReal = new double[h][w];
            double[][] diffIntImag = new double[h][w];
            DoubleDifferenceInterferogramOp.complexArrayMultiplication(forIntReal, forIntImag, backIntReal, backIntImag, diffIntReal, diffIntImag);
            double[][] ddiPhase = new double[h][w];
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    ddiPhase[i][j] = Math.atan2(diffIntImag[i][j], diffIntReal[i][j]);
                }
            }
            return ddiPhase;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeDDIPhase", (Throwable)e);
            return null;
        }
    }

    private boolean getOverlappedRectangles(int overlapIndex, Rectangle targetRectangle, Rectangle overlapInBurstOneRectangle, Rectangle overlapInBurstTwoRectangle) {
        int firstValidPixelOfBurstOne = this.getBurstFirstValidPixel(overlapIndex);
        int lastValidPixelOfBurstOne = this.getBurstLastValidPixel(overlapIndex);
        int firstValidPixelOfBurstTwo = this.getBurstFirstValidPixel(overlapIndex + 1);
        int lastValidPixelOfBurstTwo = this.getBurstLastValidPixel(overlapIndex + 1);
        int firstValidPixel = Math.max(firstValidPixelOfBurstOne, firstValidPixelOfBurstTwo);
        int lastValidPixel = Math.min(lastValidPixelOfBurstOne, lastValidPixelOfBurstTwo);
        int x0 = Math.max(firstValidPixel, targetRectangle.x);
        int xN = Math.min(lastValidPixel, targetRectangle.x + targetRectangle.width - 1);
        int w = xN - x0 + 1;
        if (w <= 0) {
            return false;
        }
        int numOfInvalidLinesInBurstOne = this.subSwath[this.subSwathIndex - 1].linesPerBurst - this.subSwath[this.subSwathIndex - 1].lastValidLine[overlapIndex] - 1;
        int numOfInvalidLinesInBurstTwo = this.subSwath[this.subSwathIndex - 1].firstValidLine[overlapIndex + 1];
        int numOverlappedLines = this.computeBurstOverlapSize(overlapIndex);
        int h = numOverlappedLines - numOfInvalidLinesInBurstOne - numOfInvalidLinesInBurstTwo;
        int y0BurstOne = this.subSwath[this.subSwathIndex - 1].linesPerBurst * (overlapIndex + 1) - numOfInvalidLinesInBurstOne - h;
        int y0BurstTwo = this.subSwath[this.subSwathIndex - 1].linesPerBurst * (overlapIndex + 1) + numOfInvalidLinesInBurstTwo;
        overlapInBurstOneRectangle.setBounds(x0, y0BurstOne, w, h);
        overlapInBurstTwoRectangle.setBounds(x0, y0BurstTwo, w, h);
        return true;
    }

    private int getBurstFirstValidPixel(int burstIndex) {
        for (int lineIdx = 0; lineIdx < this.subSwath[this.subSwathIndex - 1].firstValidSample[burstIndex].length; ++lineIdx) {
            if (this.subSwath[this.subSwathIndex - 1].firstValidSample[burstIndex][lineIdx] == -1) continue;
            return this.subSwath[this.subSwathIndex - 1].firstValidSample[burstIndex][lineIdx];
        }
        return -1;
    }

    private int getBurstLastValidPixel(int burstIndex) {
        for (int lineIdx = 0; lineIdx < this.subSwath[this.subSwathIndex - 1].lastValidSample[burstIndex].length; ++lineIdx) {
            if (this.subSwath[this.subSwathIndex - 1].lastValidSample[burstIndex][lineIdx] == -1) continue;
            return this.subSwath[this.subSwathIndex - 1].lastValidSample[burstIndex][lineIdx];
        }
        return -1;
    }

    private int computeBurstOverlapSize(int overlapIndex) {
        double endTime = this.subSwath[this.subSwathIndex - 1].burstLastLineTime[overlapIndex];
        double startTime = this.subSwath[this.subSwathIndex - 1].burstFirstLineTime[overlapIndex + 1];
        return (int)((endTime - startTime) / this.subSwath[this.subSwathIndex - 1].azimuthTimeInterval);
    }

    private double[][] getSourceData(Band srcBand, Rectangle rectangle) {
        int x0 = rectangle.x;
        int y0 = rectangle.y;
        int w = rectangle.width;
        int h = rectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        Tile srcTile = this.getSourceTile((RasterDataNode)srcBand, rectangle);
        ProductData srcData = srcTile.getDataBuffer();
        TileIndex srcIndex = new TileIndex(srcTile);
        double[][] dataArray = new double[h][w];
        for (int y = y0; y < yMax; ++y) {
            srcIndex.calculateStride(y);
            int yy = y - y0;
            for (int x = x0; x < xMax; ++x) {
                dataArray[yy][x - x0] = srcData.getElemDoubleAt(srcIndex.getIndex(x));
            }
        }
        return dataArray;
    }

    private static void complexArrayMultiplication(double[][] realArray1, double[][] imagArray1, double[][] realArray2, double[][] imagArray2, double[][] realOutput, double[][] imagOutput) {
        int h = realArray1.length;
        int w = realArray1[0].length;
        if (imagArray1.length != h || realArray2.length != h || imagArray2.length != h || realOutput.length != h || imagOutput.length != h || imagArray1[0].length != w || realArray2[0].length != w || imagArray2[0].length != w || realOutput[0].length != w || imagOutput[0].length != w) {
            throw new OperatorException("Arrays of the same dimension are expected.");
        }
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                realOutput[i][j] = realArray1[i][j] * realArray2[i][j] + imagArray1[i][j] * imagArray2[i][j];
                imagOutput[i][j] = imagArray1[i][j] * realArray2[i][j] - realArray1[i][j] * imagArray2[i][j];
            }
        }
    }

    private double[][] computeCoherence(Rectangle rectangle, Band mBandI, Band mBandQ, Band sBandI, Band sBandQ, int cohWin) {
        int x;
        int yy;
        int y;
        int x0 = rectangle.x;
        int y0 = rectangle.y;
        int w = rectangle.width;
        int h = rectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        int halfWindowSize = cohWin / 2;
        double[][] coherence = new double[h][w];
        Tile mstTileI = this.getSourceTile((RasterDataNode)mBandI, rectangle);
        Tile mstTileQ = this.getSourceTile((RasterDataNode)mBandQ, rectangle);
        ProductData mstDataBufferI = mstTileI.getDataBuffer();
        ProductData mstDataBufferQ = mstTileQ.getDataBuffer();
        Tile slvTileI = this.getSourceTile((RasterDataNode)sBandI, rectangle);
        Tile slvTileQ = this.getSourceTile((RasterDataNode)sBandQ, rectangle);
        ProductData slvDataBufferI = slvTileI.getDataBuffer();
        ProductData slvDataBufferQ = slvTileQ.getDataBuffer();
        TileIndex srcIndex = new TileIndex(mstTileI);
        double[][] cohReal = new double[h][w];
        double[][] cohImag = new double[h][w];
        double[][] mstPower = new double[h][w];
        double[][] slvPower = new double[h][w];
        for (y = y0; y < yMax; ++y) {
            srcIndex.calculateStride(y);
            yy = y - y0;
            for (x = x0; x < xMax; ++x) {
                int srcIdx = srcIndex.getIndex(x);
                int xx = x - x0;
                float mI = mstDataBufferI.getElemFloatAt(srcIdx);
                float mQ = mstDataBufferQ.getElemFloatAt(srcIdx);
                float sI = slvDataBufferI.getElemFloatAt(srcIdx);
                float sQ = slvDataBufferQ.getElemFloatAt(srcIdx);
                cohReal[yy][xx] = mI * sI + mQ * sQ;
                cohImag[yy][xx] = mQ * sI - mI * sQ;
                mstPower[yy][xx] = mI * mI + mQ * mQ;
                slvPower[yy][xx] = sI * sI + sQ * sQ;
            }
        }
        for (y = y0; y < yMax; ++y) {
            yy = y - y0;
            for (x = x0; x < xMax; ++x) {
                int xx = x - x0;
                int rowSt = Math.max(yy - halfWindowSize, 0);
                int rowEd = Math.min(yy + halfWindowSize, h - 1);
                int colSt = Math.max(xx - halfWindowSize, 0);
                int colEd = Math.min(xx + halfWindowSize, w - 1);
                double cohRealSum = 0.0;
                double cohImagSum = 0.0;
                double mstPowerSum = 0.0;
                double slvPowerSum = 0.0;
                int count = 0;
                for (int r = rowSt; r <= rowEd; ++r) {
                    for (int c = colSt; c <= colEd; ++c) {
                        cohRealSum += cohReal[r][c];
                        cohImagSum += cohImag[r][c];
                        mstPowerSum += mstPower[r][c];
                        slvPowerSum += slvPower[r][c];
                        ++count;
                    }
                }
                if (count <= 0 || mstPowerSum == 0.0 || slvPowerSum == 0.0) continue;
                double cohRealMean = cohRealSum / (double)count;
                double cohImagMean = cohImagSum / (double)count;
                double mstPowerMean = mstPowerSum / (double)count;
                double slvPowerMean = slvPowerSum / (double)count;
                coherence[yy][xx] = Math.sqrt((cohRealMean * cohRealMean + cohImagMean * cohImagMean) / (mstPowerMean * slvPowerMean));
            }
        }
        return coherence;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(DoubleDifferenceInterferogramOp.class);
        }
    }

    private static class AzimuthShiftData {
        int overlapIndex;
        int blockIndex;
        double shift;

        public AzimuthShiftData(int overlapIndex, int blockIndex, double shift) {
            this.overlapIndex = overlapIndex;
            this.blockIndex = blockIndex;
            this.shift = shift;
        }
    }
}

