/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.insar.gpf.coregistration.CreateStackOp;
import org.esa.s1tbx.insar.gpf.coregistration.DEMAssistedCoregistrationOp;
import org.esa.s1tbx.insar.gpf.support.SARGeocoding;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.dem.dataio.EarthGravitationalModel96;
import org.esa.snap.dem.dataio.FileElevationModel;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.PosVector;
import org.esa.snap.engine_utilities.datamodel.ProductInformation;
import org.esa.snap.engine_utilities.eo.GeoUtils;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.jlinda.core.Window;
import org.jlinda.core.delaunay.TriangleInterpolator;

@OperatorMetadata(alias="Back-Geocoding", category="Radar/Coregistration/S-1 TOPS Coregistration", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Bursts co-registration using orbit and DEM")
public final class BackGeocodingOp
extends Operator {
    @SourceProducts
    private Product[] sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(defaultValue="BICUBIC_INTERPOLATION", label="DEM Resampling Method")
    private String demResamplingMethod = "BICUBIC_INTERPOLATION";
    @Parameter(label="External DEM")
    private File externalDEMFile = null;
    @Parameter(label="DEM No Data Value", defaultValue="0")
    private double externalDEMNoDataValue = 0.0;
    @Parameter(defaultValue="BISINC_5_POINT_INTERPOLATION", description="The method to be used when resampling the slave grid onto the master grid.", label="Resampling Type")
    private String resamplingType = "BISINC_5_POINT_INTERPOLATION";
    @Parameter(defaultValue="true", label="Mask out areas with no elevation")
    private boolean maskOutAreaWithoutElevation = true;
    @Parameter(defaultValue="false", label="Output Range and Azimuth Offset")
    private boolean outputRangeAzimuthOffset = false;
    @Parameter(defaultValue="false", label="Output Deramp and Demod Phase")
    private boolean outputDerampDemodPhase = false;
    @Parameter(defaultValue="false", label="Disable Reramp")
    private boolean disableReramp = false;
    private Resampling selectedResampling = null;
    private Product masterProduct = null;
    private List<SlaveData> slaveDataList = new ArrayList<SlaveData>();
    private Sentinel1Utils mSU = null;
    private Sentinel1Utils.SubSwathInfo[] mSubSwath = null;
    private ElevationModel dem = null;
    private boolean isElevationModelAvailable = false;
    private double demNoDataValue = 0.0;
    private double demSamplingLat = 0.0;
    private double demSamplingLon = 0.0;
    private double noDataValue = 0.0;
    private int subSwathIndex = 0;
    private boolean burstOffsetComputed = false;
    private String swathIndexStr = null;
    private final HashMap<Band, Band> targetBandToSlaveBandMap = new HashMap(2);
    private final HashMap<Band, SlaveData> targetBandToSlaveDataMap = new HashMap(2);
    private static final double invalidIndex = -9999.0;
    private static final String PRODUCT_SUFFIX = "_Stack";
    private boolean outputDEM = false;

    public void initialize() throws OperatorException {
        try {
            if (this.sourceProduct == null) {
                return;
            }
            this.checkSourceProductValidity();
            this.masterProduct = this.sourceProduct[0];
            this.mSU = new Sentinel1Utils(this.masterProduct);
            this.mSubSwath = this.mSU.getSubSwath();
            for (Product product : this.sourceProduct) {
                if (product.equals(this.masterProduct)) continue;
                this.slaveDataList.add(new SlaveData(product));
            }
            String[] mSubSwathNames = this.mSU.getSubSwathNames();
            String[] mPolarizations = this.mSU.getPolarizations();
            for (SlaveData slaveData : this.slaveDataList) {
                String[] sSubSwathNames = slaveData.sSU.getSubSwathNames();
                if (mSubSwathNames.length != 1 || sSubSwathNames.length != 1) {
                    throw new OperatorException("Split product is expected.");
                }
                if (!mSubSwathNames[0].equals(sSubSwathNames[0])) {
                    throw new OperatorException("Same sub-swath is expected.");
                }
                String[] sPolarizations = slaveData.sSU.getPolarizations();
                if (StringUtils.containsIgnoreCase((String[])sPolarizations, (String)mPolarizations[0])) continue;
                throw new OperatorException("Same polarization is expected.");
            }
            this.subSwathIndex = 1;
            this.swathIndexStr = mSubSwathNames[0].substring(2);
            if (this.externalDEMFile == null) {
                DEMFactory.checkIfDEMInstalled((String)this.demName);
            }
            DEMFactory.validateDEM((String)this.demName, (Product)this.masterProduct);
            this.selectedResampling = ResamplingFactory.createResampling((String)this.resamplingType);
            if (this.selectedResampling == null) {
                throw new OperatorException("Resampling method " + this.resamplingType + " is invalid");
            }
            this.createTargetProduct();
            ArrayList<String> masterProductBands = new ArrayList<String>();
            String mstSuffix = "_mst" + StackUtils.createBandTimeStamp((Product)this.masterProduct);
            for (String bandName : this.masterProduct.getBandNames()) {
                if (this.masterProduct.getBand(bandName) instanceof VirtualBand) continue;
                masterProductBands.add(bandName + mstSuffix);
            }
            StackUtils.saveMasterProductBandNames((Product)this.targetProduct, (String[])masterProductBands.toArray(new String[masterProductBands.size()]));
            StackUtils.saveSlaveProductNames((Product[])this.sourceProduct, (Product)this.targetProduct, (Product)this.masterProduct, this.targetBandToSlaveBandMap);
            this.updateTargetProductMetadata();
            Band masterBandI = BackGeocodingOp.getBand(this.masterProduct, "i_", this.swathIndexStr, this.mSU.getPolarizations()[0]);
            if (masterBandI != null && masterBandI.isNoDataValueUsed()) {
                this.noDataValue = masterBandI.getNoDataValue();
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private static void outputToFile(String filePath, double[][] fbuf) throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            DataOutputStream dos = new DataOutputStream(fos);
            for (double[] aFbuf : fbuf) {
                for (int j = 0; j < fbuf[0].length; ++j) {
                    dos.writeDouble(aFbuf[j]);
                }
            }
            dos.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkSourceProductValidity() throws OperatorException {
        MetadataElement mAbsRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct[0]);
        if (mAbsRoot == null) {
            throw new OperatorException("Abstracted Metadata not found");
        }
        String mAcquisitionMode = mAbsRoot.getAttributeString("ACQUISITION_MODE");
        for (Product product : this.sourceProduct) {
            InputProductValidator validator1 = new InputProductValidator(product);
            validator1.checkIfSARProduct();
            validator1.checkIfSentinel1Product();
            validator1.checkIfSLC();
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
            if (absRoot == null) {
                throw new OperatorException("Abstracted Metadata not found");
            }
            String acquisitionMode = absRoot.getAttributeString("ACQUISITION_MODE");
            if (mAcquisitionMode.equals(acquisitionMode)) continue;
            throw new OperatorException("Source products should have the same acquisition modes");
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.masterProduct.getName() + PRODUCT_SUFFIX, this.masterProduct.getProductType(), this.masterProduct.getSceneRasterWidth(), this.masterProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.masterProduct, (Product)this.targetProduct);
        String[] masterBandNames = this.masterProduct.getBandNames();
        String mstSuffix = "_mst" + StackUtils.createBandTimeStamp((Product)this.masterProduct);
        for (String bandName : masterBandNames) {
            Band targetBand;
            if (this.masterProduct.getBand(bandName) instanceof VirtualBand || (targetBand = ProductUtils.copyBand((String)bandName, (Product)this.masterProduct, (String)(bandName + mstSuffix), (Product)this.targetProduct, (boolean)true)) == null || targetBand.getUnit() == null || !targetBand.getUnit().equals("imaginary")) continue;
            int idx = this.targetProduct.getBandIndex(targetBand.getName());
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)this.targetProduct.getBandAt(idx - 1), (Band)targetBand, (String)mstSuffix);
        }
        Band masterBand = this.masterProduct.getBand(masterBandNames[0]);
        int masterBandWidth = masterBand.getRasterWidth();
        int masterBandHeight = masterBand.getRasterHeight();
        int i = 1;
        for (SlaveData slaveData : this.slaveDataList) {
            String slvSuffix;
            String[] slaveBandNames = slaveData.slaveProduct.getBandNames();
            slaveData.slvSuffix = slvSuffix = "_slv" + i + StackUtils.createBandTimeStamp((Product)slaveData.slaveProduct);
            for (String bandName : slaveBandNames) {
                Band srcBand = slaveData.slaveProduct.getBand(bandName);
                if (srcBand instanceof VirtualBand) continue;
                Band targetBand = new Band(bandName + slvSuffix, 30, masterBandWidth, masterBandHeight);
                targetBand.setUnit(srcBand.getUnit());
                targetBand.setDescription(srcBand.getDescription());
                if (this.maskOutAreaWithoutElevation) {
                    targetBand.setNoDataValueUsed(true);
                    targetBand.setNoDataValue(this.noDataValue);
                }
                this.targetProduct.addBand(targetBand);
                this.targetBandToSlaveBandMap.put(targetBand, srcBand);
                if (targetBand.getUnit().equals("imaginary")) {
                    int idx = this.targetProduct.getBandIndex(targetBand.getName());
                    ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)this.targetProduct.getBandAt(idx - 1), (Band)targetBand, (String)slvSuffix);
                }
                this.targetBandToSlaveDataMap.put(targetBand, slaveData);
            }
            this.copySlaveMetadata(slaveData.slaveProduct);
            if (this.outputRangeAzimuthOffset) {
                Band azOffsetBand = new Band("azOffset" + slvSuffix, 30, masterBandWidth, masterBandHeight);
                azOffsetBand.setUnit("Index");
                this.targetProduct.addBand(azOffsetBand);
                Band rgOffsetBand = new Band("rgOffset" + slvSuffix, 30, masterBandWidth, masterBandHeight);
                rgOffsetBand.setUnit("Index");
                this.targetProduct.addBand(rgOffsetBand);
            }
            if (this.outputDerampDemodPhase) {
                Band phaseBand = new Band("derampDemodPhase" + slvSuffix, 30, masterBandWidth, masterBandHeight);
                phaseBand.setUnit("radian");
                this.targetProduct.addBand(phaseBand);
            }
            ++i;
        }
        DEMAssistedCoregistrationOp.setMasterValidPixelExpression((Product)this.targetProduct, (boolean)this.maskOutAreaWithoutElevation);
        if (this.outputDEM) {
            Band elevBand = new Band("elevation", 30, masterBandWidth, masterBandHeight);
            elevBand.setUnit("meters");
            this.targetProduct.addBand(elevBand);
        }
    }

    private void copySlaveMetadata(Product slaveProduct) {
        MetadataElement targetSlaveMetadataRoot = AbstractMetadata.getSlaveMetadata((MetadataElement)this.targetProduct.getMetadataRoot());
        MetadataElement slvAbsMetadata = AbstractMetadata.getAbstractedMetadata((Product)slaveProduct);
        if (slvAbsMetadata != null) {
            String timeStamp = StackUtils.createBandTimeStamp((Product)slaveProduct);
            MetadataElement targetSlaveMetadata = new MetadataElement(slaveProduct.getName() + timeStamp);
            targetSlaveMetadataRoot.addElement(targetSlaveMetadata);
            ProductUtils.copyMetadata((MetadataElement)slvAbsMetadata, (MetadataElement)targetSlaveMetadata);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"coregistered_stack", (int)1);
        MetadataElement inputElem = ProductInformation.getInputProducts((Product)this.targetProduct);
        for (SlaveData slaveData : this.slaveDataList) {
            MetadataAttribute[] slvInputProductAttrbList;
            MetadataElement slvInputElem = ProductInformation.getInputProducts((Product)slaveData.slaveProduct);
            for (MetadataAttribute attrib : slvInputProductAttrbList = slvInputElem.getAttributes()) {
                MetadataAttribute inputAttrb = AbstractMetadata.addAbstractedAttribute((MetadataElement)inputElem, (String)"InputProduct", (int)41, (String)"", (String)"");
                inputAttrb.getData().setElems((Object)attrib.getData().getElemString());
            }
        }
        CreateStackOp.getBaselines((Product[])this.sourceProduct, (Product)this.targetProduct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            int tyMax = ty0 + th;
            if (!this.isElevationModelAvailable) {
                this.getElevationModel();
            }
            if (!this.burstOffsetComputed) {
                this.computeBurstOffset();
            }
            for (int burstIndex = 0; burstIndex < this.mSubSwath[this.subSwathIndex - 1].numOfBursts; ++burstIndex) {
                int firstLineIdx = burstIndex * this.mSubSwath[this.subSwathIndex - 1].linesPerBurst;
                int lastLineIdx = firstLineIdx + this.mSubSwath[this.subSwathIndex - 1].linesPerBurst - 1;
                if (tyMax <= firstLineIdx || ty0 > lastLineIdx) continue;
                int ntx0 = tx0;
                int ntw = tw;
                int nty0 = Math.max(ty0, firstLineIdx);
                int ntyMax = Math.min(tyMax, lastLineIdx + 1);
                int nth = ntyMax - nty0;
                double[] extendedAmount = new double[]{0.0, 0.0, 0.0, 0.0};
                this.computeExtendedAmount(ntx0, nty0, ntw, nth, extendedAmount);
                for (SlaveData slaveData : this.slaveDataList) {
                    this.computePartialTile(this.subSwathIndex, burstIndex, ntx0, nty0, ntw, nth, targetTileMap, slaveData, extendedAmount);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private synchronized void getElevationModel() throws Exception {
        block6: {
            if (this.isElevationModelAvailable) {
                return;
            }
            try {
                if (this.externalDEMFile != null) {
                    this.dem = new FileElevationModel(this.externalDEMFile, this.demResamplingMethod, Double.valueOf(this.externalDEMNoDataValue));
                    this.demNoDataValue = this.externalDEMNoDataValue;
                    this.demName = this.externalDEMFile.getPath();
                    try {
                        this.demSamplingLat = Math.abs(this.dem.getGeoPos(new PixelPos(0.0, 1.0)).getLat() - this.dem.getGeoPos(new PixelPos(0.0, 0.0)).getLat());
                        this.demSamplingLon = Math.abs(this.dem.getGeoPos(new PixelPos(1.0, 0.0)).getLon() - this.dem.getGeoPos(new PixelPos(0.0, 0.0)).getLon());
                        break block6;
                    }
                    catch (Exception e) {
                        throw new OperatorException("The DEM '" + this.demName + "' cannot be properly interpreted.");
                    }
                }
                this.dem = DEMFactory.createElevationModel((String)this.demName, (String)this.demResamplingMethod);
                this.demNoDataValue = this.dem.getDescriptor().getNoDataValue();
                this.demSamplingLon = this.demSamplingLat = (double)this.dem.getDescriptor().getTileWidthInDegrees() / (double)this.dem.getDescriptor().getTileWidth();
            }
            catch (Throwable t) {
                SystemUtils.LOG.severe("Unable to get elevation model: " + t.getMessage());
            }
        }
        this.isElevationModelAvailable = true;
    }

    private synchronized void computeBurstOffset() throws Exception {
        if (this.burstOffsetComputed) {
            return;
        }
        try {
            int h = this.mSubSwath[this.subSwathIndex - 1].latitude.length;
            int w = this.mSubSwath[this.subSwathIndex - 1].latitude[0].length;
            PosVector earthPoint = new PosVector();
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    double lat = this.mSubSwath[this.subSwathIndex - 1].latitude[i][j];
                    double lon = this.mSubSwath[this.subSwathIndex - 1].longitude[i][j];
                    Double alt = this.dem.getElevation(new GeoPos(lat, lon));
                    if (alt.equals(this.demNoDataValue)) continue;
                    GeoUtils.geo2xyzWGS84((double)lat, (double)lon, (double)alt, (PosVector)earthPoint);
                    BurstIndices mBurstIndices = BackGeocodingOp.getBurstIndices(this.subSwathIndex, this.mSU, earthPoint);
                    for (SlaveData slaveData : this.slaveDataList) {
                        if (slaveData.burstOffset != -9999) continue;
                        Sentinel1Utils sSU = slaveData.sSU;
                        BurstIndices sBurstIndices = BackGeocodingOp.getBurstIndices(this.subSwathIndex, sSU, earthPoint);
                        if (mBurstIndices == null || sBurstIndices == null || mBurstIndices.firstBurstIndex == -1 && mBurstIndices.secondBurstIndex == -1 || sBurstIndices.firstBurstIndex == -1 && sBurstIndices.secondBurstIndex == -1) continue;
                        if (mBurstIndices.inUpperPartOfFirstBurst == sBurstIndices.inUpperPartOfFirstBurst) {
                            slaveData.burstOffset = sBurstIndices.firstBurstIndex - mBurstIndices.firstBurstIndex;
                            continue;
                        }
                        if (sBurstIndices.secondBurstIndex != -1 && mBurstIndices.inUpperPartOfFirstBurst == sBurstIndices.inUpperPartOfSecondBurst) {
                            slaveData.burstOffset = sBurstIndices.secondBurstIndex - mBurstIndices.firstBurstIndex;
                            continue;
                        }
                        if (mBurstIndices.secondBurstIndex != -1 && mBurstIndices.inUpperPartOfSecondBurst == sBurstIndices.inUpperPartOfFirstBurst) {
                            slaveData.burstOffset = sBurstIndices.firstBurstIndex - mBurstIndices.secondBurstIndex;
                            continue;
                        }
                        if (mBurstIndices.secondBurstIndex == -1 || sBurstIndices.secondBurstIndex == -1 || mBurstIndices.inUpperPartOfSecondBurst != sBurstIndices.inUpperPartOfSecondBurst) continue;
                        slaveData.burstOffset = sBurstIndices.secondBurstIndex - mBurstIndices.secondBurstIndex;
                    }
                    boolean allComputed = true;
                    for (SlaveData slaveData : this.slaveDataList) {
                        if (slaveData.burstOffset != -9999) continue;
                        allComputed = false;
                        break;
                    }
                    if (!allComputed) continue;
                    this.burstOffsetComputed = true;
                    return;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static BurstIndices getBurstIndices(int subSwathIndex, Sentinel1Utils su, PosVector earthPoint) {
        try {
            Sentinel1Utils.SubSwathInfo subSwath = su.getSubSwath()[subSwathIndex - 1];
            double zeroDopplerTimeInDays = SARGeocoding.getZeroDopplerTime((double)su.lineTimeInterval, (double)su.wavelength, (PosVector)earthPoint, (SARGeocoding.Orbit)su.getOrbit());
            if (zeroDopplerTimeInDays == -99999.0) {
                return null;
            }
            double zeroDopplerTime = zeroDopplerTimeInDays * 86400.0;
            BurstIndices burstIndices = new BurstIndices();
            int k = 0;
            for (int i = 0; i < subSwath.numOfBursts; ++i) {
                boolean inUpperPartOfBurst;
                if (!(zeroDopplerTime >= subSwath.burstFirstLineTime[i]) || !(zeroDopplerTime < subSwath.burstLastLineTime[i])) continue;
                boolean bl = inUpperPartOfBurst = zeroDopplerTime >= (subSwath.burstFirstLineTime[i] + subSwath.burstLastLineTime[i]) / 2.0;
                if (k != 0) {
                    burstIndices.secondBurstIndex = i;
                    burstIndices.inUpperPartOfSecondBurst = inUpperPartOfBurst;
                    break;
                }
                burstIndices.firstBurstIndex = i;
                burstIndices.inUpperPartOfFirstBurst = inUpperPartOfBurst;
                ++k;
            }
            return burstIndices;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"getBurstIndices", (Throwable)e);
            return null;
        }
    }

    private void computeExtendedAmount(int x0, int y0, int w, int h, double[] extendedAmount) throws Exception {
        EarthGravitationalModel96 egm = EarthGravitationalModel96.instance();
        GeoPos geoPos = new GeoPos();
        PositionData posData = new PositionData();
        double azExtendedAmountMax = -1.7976931348623157E308;
        double azExtendedAmountMin = Double.MAX_VALUE;
        double rgExtendedAmountMax = -1.7976931348623157E308;
        double rgExtendedAmountMin = Double.MAX_VALUE;
        for (int y = y0; y < y0 + h; y += 20) {
            int burstIndex = this.getBurstIndex(y);
            for (int x = x0; x < x0 + w; x += 20) {
                double azTime = this.getAzimuthTime(y, burstIndex);
                double rgTime = this.getSlantRangeTime(x);
                double lat = this.mSU.getLatitude(azTime, rgTime, this.subSwathIndex);
                double lon = this.mSU.getLongitude(azTime, rgTime, this.subSwathIndex);
                geoPos.setLocation(lat, lon);
                Double alt = this.dem.getElevation(geoPos);
                if (alt.equals(this.demNoDataValue)) {
                    alt = egm.getEGM(lat, lon);
                }
                GeoUtils.geo2xyzWGS84((double)geoPos.getLat(), (double)geoPos.getLon(), (double)alt, (PosVector)posData.earthPoint);
                if (!BackGeocodingOp.getPosition(this.subSwathIndex, burstIndex, this.mSU, posData)) continue;
                double azExtendedAmount = posData.azimuthIndex - (double)y;
                double rgExtendedAmount = posData.rangeIndex - (double)x;
                if (azExtendedAmount > azExtendedAmountMax) {
                    azExtendedAmountMax = azExtendedAmount;
                }
                if (azExtendedAmount < azExtendedAmountMin) {
                    azExtendedAmountMin = azExtendedAmount;
                }
                if (rgExtendedAmount > rgExtendedAmountMax) {
                    rgExtendedAmountMax = rgExtendedAmount;
                }
                if (!(rgExtendedAmount < rgExtendedAmountMin)) continue;
                rgExtendedAmountMin = rgExtendedAmount;
            }
        }
        extendedAmount[0] = azExtendedAmountMin != Double.MAX_VALUE && azExtendedAmountMin < 0.0 ? azExtendedAmountMin : 0.0;
        extendedAmount[1] = azExtendedAmountMax != -1.7976931348623157E308 && azExtendedAmountMax > 0.0 ? azExtendedAmountMax : 0.0;
        extendedAmount[2] = rgExtendedAmountMin != Double.MAX_VALUE && rgExtendedAmountMin < 0.0 ? rgExtendedAmountMin : 0.0;
        extendedAmount[3] = rgExtendedAmountMax != -1.7976931348623157E308 && rgExtendedAmountMax > 0.0 ? rgExtendedAmountMax : 0.0;
    }

    private int getBurstIndex(int y) {
        for (int burstIndex = 0; burstIndex < this.mSubSwath[this.subSwathIndex - 1].numOfBursts; ++burstIndex) {
            int firstLineIdx = burstIndex * this.mSubSwath[this.subSwathIndex - 1].linesPerBurst;
            int lastLineIdx = firstLineIdx + this.mSubSwath[this.subSwathIndex - 1].linesPerBurst - 1;
            if (y < firstLineIdx || y > lastLineIdx) continue;
            return burstIndex;
        }
        return -1;
    }

    private double getAzimuthTime(int y, int burstIndex) {
        Sentinel1Utils.SubSwathInfo subSwath = this.mSubSwath[this.subSwathIndex - 1];
        return subSwath.burstFirstLineTime[burstIndex] + (double)(y - burstIndex * subSwath.linesPerBurst) * subSwath.azimuthTimeInterval;
    }

    private double getSlantRangeTime(int x) {
        return this.mSubSwath[this.subSwathIndex - 1].slrTimeToFirstPixel + (double)x * this.mSU.rangeSpacing / 2.99792458E8;
    }

    private void computePartialTile(int subSwathIndex, int mBurstIndex, int x0, int y0, int w, int h, Map<Band, Tile> targetTileMap, SlaveData slaveData, double[] extendedAmount) throws Exception {
        int margin;
        Rectangle sourceRectangle;
        PixelPos[][] slavePixPos;
        boolean isSuccessful;
        int sBurstIndex = mBurstIndex + slaveData.burstOffset;
        if (sBurstIndex < 0 || sBurstIndex >= slaveData.sSU.getSubSwath()[subSwathIndex - 1].numOfBursts) {
            return;
        }
        double[][] elevation = null;
        if (this.outputDEM) {
            elevation = new double[h][w];
        }
        if (!(isSuccessful = this.computeSlavePixPos(subSwathIndex, mBurstIndex, sBurstIndex, x0, y0, w, h, extendedAmount, slavePixPos = new PixelPos[h][w], slaveData, elevation))) {
            return;
        }
        if (this.outputRangeAzimuthOffset) {
            this.outputRangeAzimuthOffsets(x0, y0, w, h, targetTileMap, slavePixPos, subSwathIndex, slaveData, mBurstIndex, sBurstIndex);
        }
        if (this.outputDEM) {
            this.outputDEM(x0, y0, w, h, targetTileMap, elevation);
        }
        if ((sourceRectangle = this.getBoundingBox(slavePixPos, margin = this.selectedResampling.getKernelSize(), subSwathIndex, sBurstIndex, slaveData.sSU.getSubSwath())) == null) {
            return;
        }
        double[][] derampDemodPhase = slaveData.sSU.computeDerampDemodPhase(slaveData.sSU.getSubSwath(), subSwathIndex, sBurstIndex, sourceRectangle);
        if (derampDemodPhase == null) {
            return;
        }
        for (String polarization : this.mSU.getPolarizations()) {
            Band slaveBandI = BackGeocodingOp.getBand(slaveData.slaveProduct, "i_", this.swathIndexStr, polarization);
            Band slaveBandQ = BackGeocodingOp.getBand(slaveData.slaveProduct, "q_", this.swathIndexStr, polarization);
            Tile slaveTileI = this.getSourceTile((RasterDataNode)slaveBandI, sourceRectangle);
            Tile slaveTileQ = this.getSourceTile((RasterDataNode)slaveBandQ, sourceRectangle);
            if (slaveTileI == null || slaveTileQ == null) {
                return;
            }
            double[][] derampDemodI = new double[sourceRectangle.height][sourceRectangle.width];
            double[][] derampDemodQ = new double[sourceRectangle.height][sourceRectangle.width];
            BackGeocodingOp.performDerampDemod(slaveTileI, slaveTileQ, sourceRectangle, derampDemodPhase, derampDemodI, derampDemodQ);
            this.performInterpolation(x0, y0, w, h, sourceRectangle, slaveTileI, slaveTileQ, targetTileMap, derampDemodPhase, derampDemodI, derampDemodQ, slavePixPos, subSwathIndex, sBurstIndex, slaveData, polarization);
        }
    }

    private boolean computeSlavePixPos(int subSwathIndex, int mBurstIndex, int sBurstIndex, int x0, int y0, int w, int h, double[] extendedAmount, PixelPos[][] slavePixelPos, SlaveData slaveData, double[][] elevation) throws Exception {
        try {
            int xmin = x0 - (int)extendedAmount[3];
            int ymin = y0 - (int)extendedAmount[1];
            int ymax = y0 + h + (int)Math.abs(extendedAmount[0]);
            int xmax = x0 + w + (int)Math.abs(extendedAmount[2]);
            double[] latLonMinMax = new double[4];
            this.computeImageGeoBoundary(subSwathIndex, mBurstIndex, xmin, xmax, ymin, ymax, latLonMinMax);
            double delta = Math.max(this.demSamplingLat, this.demSamplingLon);
            double extralat = 20.0 * delta;
            double extralon = 20.0 * delta;
            double latMin = latLonMinMax[0] - extralat;
            double latMax = latLonMinMax[1] + extralat;
            double lonMin = latLonMinMax[2] - extralon;
            double lonMax = latLonMinMax[3] + extralon;
            PixelPos upperLeft = this.dem.getIndex(new GeoPos(latMax, lonMin));
            PixelPos lowerRight = this.dem.getIndex(new GeoPos(latMin, lonMax));
            int latMaxIdx = (int)Math.floor(upperLeft.getY());
            int latMinIdx = (int)Math.ceil(lowerRight.getY());
            int lonMinIdx = (int)Math.floor(upperLeft.getX());
            int lonMaxIdx = (int)Math.ceil(lowerRight.getX());
            int numLines = latMinIdx - latMaxIdx;
            int numPixels = lonMaxIdx - lonMinIdx;
            double[][] masterAz = new double[numLines][numPixels];
            double[][] masterRg = new double[numLines][numPixels];
            double[][] slaveAz = new double[numLines][numPixels];
            double[][] slaveRg = new double[numLines][numPixels];
            double[][] lat = new double[numLines][numPixels];
            double[][] lon = new double[numLines][numPixels];
            PositionData posData = new PositionData();
            PixelPos pix = new PixelPos();
            EarthGravitationalModel96 egm = EarthGravitationalModel96.instance();
            boolean noValidSlavePixPos = true;
            for (int l = 0; l < numLines; ++l) {
                for (int p = 0; p < numPixels; ++p) {
                    pix.setLocation((double)(lonMinIdx + p), (double)(latMaxIdx + l));
                    GeoPos gp = this.dem.getGeoPos(pix);
                    lat[l][p] = gp.lat;
                    lon[l][p] = gp.lon;
                    Double alt = this.dem.getElevation(gp);
                    if (alt.equals(this.demNoDataValue) && !this.maskOutAreaWithoutElevation) {
                        alt = egm.getEGM(gp.lat, gp.lon);
                    }
                    if (!alt.equals(this.demNoDataValue)) {
                        GeoUtils.geo2xyzWGS84((double)gp.lat, (double)gp.lon, (double)alt, (PosVector)posData.earthPoint);
                        if (BackGeocodingOp.getPosition(subSwathIndex, mBurstIndex, this.mSU, posData)) {
                            masterAz[l][p] = posData.azimuthIndex;
                            masterRg[l][p] = posData.rangeIndex;
                            if (BackGeocodingOp.getPosition(subSwathIndex, sBurstIndex, slaveData.sSU, posData)) {
                                slaveAz[l][p] = posData.azimuthIndex;
                                slaveRg[l][p] = posData.rangeIndex;
                                noValidSlavePixPos = false;
                                continue;
                            }
                        }
                    }
                    masterAz[l][p] = -9999.0;
                    masterRg[l][p] = -9999.0;
                }
            }
            if (noValidSlavePixPos) {
                return false;
            }
            Window tileWindow = new Window((long)y0, (long)(y0 + h - 1), (long)x0, (long)(x0 + w - 1));
            double rgAzRatio = this.mSU.rangeSpacing / this.mSU.azimuthSpacing;
            double[][] latArray = new double[(int)tileWindow.lines()][(int)tileWindow.pixels()];
            double[][] lonArray = new double[(int)tileWindow.lines()][(int)tileWindow.pixels()];
            double[][] azArray = new double[(int)tileWindow.lines()][(int)tileWindow.pixels()];
            double[][] rgArray = new double[(int)tileWindow.lines()][(int)tileWindow.pixels()];
            for (double[] data : azArray) {
                Arrays.fill(data, -9999.0);
            }
            for (double[] data : rgArray) {
                Arrays.fill(data, -9999.0);
            }
            TriangleInterpolator.ZData[] dataList = new TriangleInterpolator.ZData[]{new TriangleInterpolator.ZData(slaveAz, azArray), new TriangleInterpolator.ZData(slaveRg, rgArray), new TriangleInterpolator.ZData(lat, latArray), new TriangleInterpolator.ZData(lon, lonArray)};
            TriangleInterpolator.gridDataLinear((double[][])masterAz, (double[][])masterRg, (TriangleInterpolator.ZData[])dataList, (Window)tileWindow, (double)rgAzRatio, (int)1, (int)1, (double)-9999.0, (int)0);
            boolean allElementsAreNull = true;
            for (int yy = 0; yy < h; ++yy) {
                for (int xx = 0; xx < w; ++xx) {
                    if (rgArray[yy][xx] == -9999.0 || azArray[yy][xx] == -9999.0) {
                        slavePixelPos[yy][xx] = null;
                        continue;
                    }
                    if (this.maskOutAreaWithoutElevation || elevation != null) {
                        Double alt = this.dem.getElevation(new GeoPos(latArray[yy][xx], lonArray[yy][xx]));
                        if (elevation != null) {
                            elevation[yy][xx] = alt;
                        }
                        if (!alt.equals(this.demNoDataValue)) {
                            slavePixelPos[yy][xx] = new PixelPos(rgArray[yy][xx], azArray[yy][xx]);
                            allElementsAreNull = false;
                            continue;
                        }
                        slavePixelPos[yy][xx] = null;
                        continue;
                    }
                    slavePixelPos[yy][xx] = new PixelPos(rgArray[yy][xx], azArray[yy][xx]);
                    allElementsAreNull = false;
                }
            }
            return !allElementsAreNull;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeSlavePixPos", (Throwable)e);
            return false;
        }
    }

    private void computeImageGeoBoundary(int subSwathIndex, int burstIndex, int xMin, int xMax, int yMin, int yMax, double[] latLonMinMax) throws Exception {
        Sentinel1Utils.SubSwathInfo subSwath = this.mSubSwath[subSwathIndex - 1];
        double azTimeMin = subSwath.burstFirstLineTime[burstIndex] + (double)(yMin - burstIndex * subSwath.linesPerBurst) * subSwath.azimuthTimeInterval;
        double azTimeMax = subSwath.burstFirstLineTime[burstIndex] + (double)(yMax - burstIndex * subSwath.linesPerBurst) * subSwath.azimuthTimeInterval;
        double rgTimeMin = subSwath.slrTimeToFirstPixel + (double)xMin * this.mSU.rangeSpacing / 2.99792458E8;
        double rgTimeMax = subSwath.slrTimeToFirstPixel + (double)xMax * this.mSU.rangeSpacing / 2.99792458E8;
        double latUL = this.mSU.getLatitude(azTimeMin, rgTimeMin, subSwathIndex);
        double lonUL = this.mSU.getLongitude(azTimeMin, rgTimeMin, subSwathIndex);
        double latUR = this.mSU.getLatitude(azTimeMin, rgTimeMax, subSwathIndex);
        double lonUR = this.mSU.getLongitude(azTimeMin, rgTimeMax, subSwathIndex);
        double latLL = this.mSU.getLatitude(azTimeMax, rgTimeMin, subSwathIndex);
        double lonLL = this.mSU.getLongitude(azTimeMax, rgTimeMin, subSwathIndex);
        double latLR = this.mSU.getLatitude(azTimeMax, rgTimeMax, subSwathIndex);
        double lonLR = this.mSU.getLongitude(azTimeMax, rgTimeMax, subSwathIndex);
        double[] lats = new double[]{latUL, latUR, latLL, latLR};
        double[] lons = new double[]{lonUL, lonUR, lonLL, lonLR};
        double latMin = 90.0;
        double latMax = -90.0;
        for (double lat : lats) {
            if (lat < latMin) {
                latMin = lat;
            }
            if (!(lat > latMax)) continue;
            latMax = lat;
        }
        double lonMin = 180.0;
        double lonMax = -180.0;
        for (double lon : lons) {
            if (lon < lonMin) {
                lonMin = lon;
            }
            if (!(lon > lonMax)) continue;
            lonMax = lon;
        }
        latLonMinMax[0] = latMin;
        latLonMinMax[1] = latMax;
        latLonMinMax[2] = lonMin;
        latLonMinMax[3] = lonMax;
    }

    private static boolean getPosition(int subSwathIndex, int burstIndex, Sentinel1Utils su, PositionData data) {
        try {
            Sentinel1Utils.SubSwathInfo subSwath = su.getSubSwath()[subSwathIndex - 1];
            double zeroDopplerTimeInDays = SARGeocoding.getZeroDopplerTime((double)su.lineTimeInterval, (double)su.wavelength, (PosVector)data.earthPoint, (SARGeocoding.Orbit)su.getOrbit());
            if (zeroDopplerTimeInDays == -99999.0) {
                return false;
            }
            double zeroDopplerTime = zeroDopplerTimeInDays * 86400.0;
            data.azimuthIndex = (double)(burstIndex * subSwath.linesPerBurst) + (zeroDopplerTime - subSwath.burstFirstLineTime[burstIndex]) / subSwath.azimuthTimeInterval;
            double slantRange = SARGeocoding.computeSlantRange((double)zeroDopplerTimeInDays, (SARGeocoding.Orbit)su.getOrbit(), (PosVector)data.earthPoint, (PosVector)data.sensorPos);
            data.rangeIndex = !su.srgrFlag ? (slantRange - subSwath.slrTimeToFirstPixel * 2.99792458E8) / su.rangeSpacing : SARGeocoding.computeRangeIndex((boolean)su.srgrFlag, (int)su.sourceImageWidth, (double)su.firstLineUTC, (double)su.lastLineUTC, (double)su.rangeSpacing, (double)zeroDopplerTimeInDays, (double)slantRange, (double)su.nearEdgeSlantRange, (AbstractMetadata.SRGRCoefficientList[])su.srgrConvParams);
            if (!su.nearRangeOnLeft) {
                data.rangeIndex = (double)(su.sourceImageWidth - 1) - data.rangeIndex;
            }
            return true;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"getPosition", (Throwable)e);
            return false;
        }
    }

    private Rectangle getBoundingBox(PixelPos[][] slavePixPos, int margin, int subSwathIndex, int sBurstIndex, Sentinel1Utils.SubSwathInfo[] sSubswath) {
        int firstLineIndex = sBurstIndex * sSubswath[subSwathIndex - 1].linesPerBurst;
        int lastLineIndex = firstLineIndex + sSubswath[subSwathIndex - 1].linesPerBurst - 1;
        boolean firstPixelIndex = false;
        int lastPixelIndex = sSubswath[subSwathIndex - 1].samplesPerBurst - 1;
        int minX = Integer.MAX_VALUE;
        int maxX = -2147483647;
        int minY = Integer.MAX_VALUE;
        int maxY = -2147483647;
        for (PixelPos[] slavePixPo : slavePixPos) {
            for (int j = 0; j < slavePixPos[0].length; ++j) {
                if (slavePixPo[j] == null) continue;
                int x = (int)Math.floor(slavePixPo[j].getX());
                int y = (int)Math.floor(slavePixPo[j].getY());
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        minX = Math.max(minX - margin, 0);
        maxX = Math.min(maxX + margin, lastPixelIndex);
        minY = Math.max(minY - margin, firstLineIndex);
        maxY = Math.min(maxY + margin, lastLineIndex);
        if (minX > maxX || minY > maxY) {
            return null;
        }
        return new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    static void performDerampDemod(Tile slaveTileI, Tile slaveTileQ, Rectangle slaveRectangle, double[][] derampDemodPhase, double[][] derampDemodI, double[][] derampDemodQ) {
        try {
            int x0 = slaveRectangle.x;
            int y0 = slaveRectangle.y;
            int xMax = x0 + slaveRectangle.width;
            int yMax = y0 + slaveRectangle.height;
            ProductData slaveDataI = slaveTileI.getDataBuffer();
            ProductData slaveDataQ = slaveTileQ.getDataBuffer();
            TileIndex slvIndex = new TileIndex(slaveTileI);
            for (int y = y0; y < yMax; ++y) {
                slvIndex.calculateStride(y);
                int yy = y - y0;
                for (int x = x0; x < xMax; ++x) {
                    int idx = slvIndex.getIndex(x);
                    int xx = x - x0;
                    double valueI = slaveDataI.getElemDoubleAt(idx);
                    double valueQ = slaveDataQ.getElemDoubleAt(idx);
                    double cosPhase = FastMath.cos((double)derampDemodPhase[yy][xx]);
                    double sinPhase = FastMath.sin((double)derampDemodPhase[yy][xx]);
                    derampDemodI[yy][xx] = valueI * cosPhase - valueQ * sinPhase;
                    derampDemodQ[yy][xx] = valueI * sinPhase + valueQ * cosPhase;
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"performDerampDemod", (Throwable)e);
        }
    }

    private void performInterpolation(int x0, int y0, int w, int h, Rectangle sourceRectangle, Tile slaveTileI, Tile slaveTileQ, Map<Band, Tile> targetTileMap, double[][] derampDemodPhase, double[][] derampDemodI, double[][] derampDemodQ, PixelPos[][] slavePixPos, int subswathIndex, int sBurstIndex, SlaveData slaveData, String polarization) throws OperatorException {
        try {
            ResamplingRaster resamplingRasterI = new ResamplingRaster(slaveTileI, derampDemodI);
            ResamplingRaster resamplingRasterQ = new ResamplingRaster(slaveTileQ, derampDemodQ);
            ResamplingRaster resamplingRasterPhase = new ResamplingRaster(slaveTileI, derampDemodPhase);
            Band iBand = this.getTargetBand("i_", slaveData.slvSuffix, polarization);
            Band qBand = this.getTargetBand("q_", slaveData.slvSuffix, polarization);
            if (iBand == null || qBand == null) {
                throw new OperatorException("Unable to find " + iBand.getName() + " or " + qBand.getName());
            }
            Tile tgtTileI = targetTileMap.get(iBand);
            Tile tgtTileQ = targetTileMap.get(qBand);
            ProductData tgtBufferI = tgtTileI.getDataBuffer();
            ProductData tgtBufferQ = tgtTileQ.getDataBuffer();
            TileIndex tgtIndex = new TileIndex(tgtTileI);
            ProductData tgtBufferPhase = null;
            if (this.outputDerampDemodPhase) {
                Band phaseBand = this.getTargetBand("derampDemodPhase", slaveData.slvSuffix, null);
                if (phaseBand == null) {
                    throw new OperatorException("derampDemodPhase not found");
                }
                Tile tgtTilePhase = targetTileMap.get(phaseBand);
                tgtBufferPhase = tgtTilePhase.getDataBuffer();
            }
            Resampling.Index resamplingIndex = this.selectedResampling.createIndex();
            for (int y = y0; y < y0 + h; ++y) {
                tgtIndex.calculateStride(y);
                int yy = y - y0;
                for (int x = x0; x < x0 + w; ++x) {
                    int tgtIdx = tgtIndex.getIndex(x);
                    PixelPos slavePixelPos = slavePixPos[yy][x - x0];
                    if (slavePixelPos == null) {
                        tgtBufferI.setElemDoubleAt(tgtIdx, this.noDataValue);
                        tgtBufferQ.setElemDoubleAt(tgtIdx, this.noDataValue);
                        if (!this.outputDerampDemodPhase) continue;
                        tgtBufferPhase.setElemFloatAt(tgtIdx, (float)this.noDataValue);
                        continue;
                    }
                    if (this.isSlavePixPosValid(slavePixelPos, subswathIndex, sBurstIndex, slaveData.sSU.getSubSwath())) {
                        this.selectedResampling.computeCornerBasedIndex(slavePixelPos.x - (double)sourceRectangle.x, slavePixelPos.y - (double)sourceRectangle.y, sourceRectangle.width, sourceRectangle.height, resamplingIndex);
                        double samplePhase = this.selectedResampling.resample((Resampling.Raster)resamplingRasterPhase, resamplingIndex);
                        double sampleI = this.selectedResampling.resample((Resampling.Raster)resamplingRasterI, resamplingIndex);
                        double sampleQ = this.selectedResampling.resample((Resampling.Raster)resamplingRasterQ, resamplingIndex);
                        double cosPhase = FastMath.cos((double)samplePhase);
                        double sinPhase = FastMath.sin((double)samplePhase);
                        double rerampRemodI = sampleI * cosPhase + sampleQ * sinPhase;
                        double rerampRemodQ = -sampleI * sinPhase + sampleQ * cosPhase;
                        if (Double.isNaN(rerampRemodI)) {
                            rerampRemodI = this.noDataValue;
                        }
                        if (Double.isNaN(rerampRemodQ)) {
                            rerampRemodQ = this.noDataValue;
                        }
                        if (this.disableReramp) {
                            tgtBufferI.setElemDoubleAt(tgtIdx, sampleI);
                            tgtBufferQ.setElemDoubleAt(tgtIdx, sampleQ);
                        } else {
                            tgtBufferI.setElemDoubleAt(tgtIdx, rerampRemodI);
                            tgtBufferQ.setElemDoubleAt(tgtIdx, rerampRemodQ);
                        }
                        if (!this.outputDerampDemodPhase) continue;
                        tgtBufferPhase.setElemFloatAt(tgtIdx, (float)samplePhase);
                        continue;
                    }
                    tgtBufferI.setElemDoubleAt(tgtIdx, this.noDataValue);
                    tgtBufferQ.setElemDoubleAt(tgtIdx, this.noDataValue);
                    if (!this.outputDerampDemodPhase) continue;
                    tgtBufferPhase.setElemFloatAt(tgtIdx, (float)this.noDataValue);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"performInterpolation", (Throwable)e);
        }
    }

    private static Band getBand(Product product, String prefix, String swathIndexStr, String polarization) {
        String[] bandNames;
        for (String bandName : bandNames = product.getBandNames()) {
            if (!bandName.contains(prefix) || !bandName.contains(swathIndexStr) || !bandName.contains(polarization)) continue;
            return product.getBand(bandName);
        }
        return null;
    }

    private boolean isSlavePixPosValid(PixelPos slavePixPos, int subswathIndex, int sBurstIndex, Sentinel1Utils.SubSwathInfo[] sSubswath) {
        return slavePixPos != null && slavePixPos.y >= (double)(sSubswath[subswathIndex - 1].linesPerBurst * sBurstIndex) && slavePixPos.y < (double)(sSubswath[subswathIndex - 1].linesPerBurst * (sBurstIndex + 1));
    }

    private void outputRangeAzimuthOffsets(int x0, int y0, int w, int h, Map<Band, Tile> targetTileMap, PixelPos[][] slavePixPos, int subSwathIndex, SlaveData slaveData, int mBurstIndex, int sBurstIndex) {
        try {
            Band azOffsetBand = this.getTargetBand("azOffset", slaveData.slvSuffix, null);
            Band rgOffsetBand = this.getTargetBand("rgOffset", slaveData.slvSuffix, null);
            if (azOffsetBand == null || rgOffsetBand == null) {
                return;
            }
            Tile tgtTileAzOffset = targetTileMap.get(azOffsetBand);
            Tile tgtTileRgOffset = targetTileMap.get(rgOffsetBand);
            ProductData tgtBufferAzOffset = tgtTileAzOffset.getDataBuffer();
            ProductData tgtBufferRgOffset = tgtTileRgOffset.getDataBuffer();
            TileIndex tgtIndex = new TileIndex(tgtTileAzOffset);
            for (int y = y0; y < y0 + h; ++y) {
                tgtIndex.calculateStride(y);
                int yy = y - y0;
                for (int x = x0; x < x0 + w; ++x) {
                    int tgtIdx = tgtIndex.getIndex(x);
                    int xx = x - x0;
                    if (slavePixPos[yy][xx] == null) {
                        tgtBufferAzOffset.setElemFloatAt(tgtIdx, (float)this.noDataValue);
                        tgtBufferRgOffset.setElemFloatAt(tgtIdx, (float)this.noDataValue);
                        continue;
                    }
                    tgtBufferAzOffset.setElemFloatAt(tgtIdx, (float)slavePixPos[yy][xx].y);
                    tgtBufferRgOffset.setElemFloatAt(tgtIdx, (float)slavePixPos[yy][xx].x);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"outputRangeAzimuthOffsets", (Throwable)e);
        }
    }

    private void outputDEM(int x0, int y0, int w, int h, Map<Band, Tile> targetTileMap, double[][] elevation) {
        try {
            Band elevBand = this.getTargetBand("elevation", null, null);
            if (elevBand == null) {
                return;
            }
            Tile tgtTileElev = targetTileMap.get(elevBand);
            ProductData tgtBufferElev = tgtTileElev.getDataBuffer();
            TileIndex tgtIndex = new TileIndex(tgtTileElev);
            for (int y = y0; y < y0 + h; ++y) {
                tgtIndex.calculateStride(y);
                int yy = y - y0;
                for (int x = x0; x < x0 + w; ++x) {
                    int tgtIdx = tgtIndex.getIndex(x);
                    int xx = x - x0;
                    tgtBufferElev.setElemFloatAt(tgtIdx, (float)elevation[yy][xx]);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"outputDEM", (Throwable)e);
        }
    }

    private Band getTargetBand(String name, String tag, String pol) {
        Band[] targetBands;
        for (Band band : targetBands = this.targetProduct.getBands()) {
            String bandName = band.getName();
            if (!bandName.contains(name)) continue;
            if (tag != null) {
                if (!bandName.contains(tag)) continue;
                if (pol == null) {
                    return band;
                }
                if (!bandName.contains(pol)) continue;
                return band;
            }
            if (pol == null) {
                return band;
            }
            if (!bandName.contains(pol)) continue;
            return band;
        }
        return null;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(BackGeocodingOp.class);
        }
    }

    private static class SlaveData {
        Product slaveProduct;
        Sentinel1Utils sSU;
        int burstOffset = -9999;
        String slvSuffix;

        SlaveData(Product product) throws Exception {
            this.slaveProduct = product;
            this.sSU = new Sentinel1Utils(product);
            this.sSU.computeDopplerRate();
            this.sSU.computeReferenceTime();
        }

        public void print() {
            SystemUtils.LOG.info(this.slvSuffix + " burstOffset=" + this.burstOffset);
        }
    }

    private static class BurstIndices {
        int firstBurstIndex = -1;
        int secondBurstIndex = -1;
        boolean inUpperPartOfFirstBurst = false;
        boolean inUpperPartOfSecondBurst = false;

        private BurstIndices() {
        }
    }

    private static class ResamplingRaster
    implements Resampling.Raster {
        private final Tile tile;
        private final double[][] data;
        private final boolean usesNoData;
        private final double noDataValue;

        ResamplingRaster(Tile tile, double[][] data) {
            this.tile = tile;
            this.data = data;
            RasterDataNode rasterDataNode = tile.getRasterDataNode();
            this.usesNoData = rasterDataNode.isNoDataValueUsed();
            this.noDataValue = rasterDataNode.getNoDataValue();
        }

        public final int getWidth() {
            return this.tile.getWidth();
        }

        public final int getHeight() {
            return this.tile.getHeight();
        }

        public boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
            boolean allValid = true;
            try {
                for (int i = 0; i < y.length; ++i) {
                    for (int j = 0; j < x.length; ++j) {
                        double val = this.data[y[i]][x[j]];
                        if (this.usesNoData && this.noDataValue == val) {
                            val = Double.NaN;
                            allValid = false;
                        }
                        samples[i][j] = val;
                    }
                }
            }
            catch (Exception e) {
                SystemUtils.LOG.severe(e.getMessage());
                allValid = false;
            }
            return allValid;
        }
    }

    private static class PositionData {
        final PosVector earthPoint = new PosVector();
        final PosVector sensorPos = new PosVector();
        double azimuthIndex;
        double rangeIndex;

        private PositionData() {
        }
    }
}

