/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sar.gpf.ui.orbits;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class ApplyOrbitFileOpUI
extends BaseOperatorUI {
    private final JComboBox<String> orbitTypeCombo = new JComboBox();
    private final JTextField polyDegree = new JTextField("");
    private final JCheckBox continueOnFailCheckBox = new JCheckBox("Do not fail if new orbit file is not found");
    private Boolean continueOnFail = true;
    private static final String[] ORBIT_TYPES = new String[]{"Sentinel Precise (Auto Download)", "Sentinel Restituted (Auto Download)", "DORIS Preliminary POR (ENVISAT)", "DORIS Precise VOR (ENVISAT) (Auto Download)", "DELFT Precise (ENVISAT, ERS1&2) (Auto Download)", "PRARE Precise (ERS1&2) (Auto Download)"};

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        for (String item : ORBIT_TYPES) {
            this.orbitTypeCombo.addItem(item);
        }
        this.continueOnFailCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ApplyOrbitFileOpUI.this.continueOnFail = e.getStateChange() == 1;
            }
        });
        this.initParameters();
        return new JScrollPane(panel);
    }

    public void initParameters() {
        this.polyDegree.setText(String.valueOf(this.paramMap.get("polyDegree")));
        this.continueOnFail = (Boolean)this.paramMap.get("continueOnFail");
        if (this.continueOnFail != null) {
            this.continueOnFailCheckBox.setSelected(this.continueOnFail);
        }
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0]);
            String mission = absRoot.getAttributeString("MISSION");
            if (mission.equals("ENVISAT")) {
                this.populateOrbitTypes("ENVISAT");
                this.setSelectedOrbitType("DORIS Precise VOR");
            } else if (mission.equals("ERS1") || mission.equals("ERS2")) {
                this.populateOrbitTypes("ERS");
                this.setSelectedOrbitType("PRARE Precise");
            } else if (mission.startsWith("SENTINEL")) {
                this.populateOrbitTypes("Sentinel");
                this.setSelectedOrbitType("Sentinel Precise");
            }
        }
    }

    private void populateOrbitTypes(String mission) {
        this.orbitTypeCombo.removeAllItems();
        for (String item : ORBIT_TYPES) {
            if (!item.contains(mission)) continue;
            this.orbitTypeCombo.addItem(item);
        }
    }

    private void setSelectedOrbitType(String defaultStr) {
        int i;
        String orbitTypeFromGraph = (String)this.paramMap.get("orbitType");
        for (i = 0; i < this.orbitTypeCombo.getItemCount(); ++i) {
            if (!this.orbitTypeCombo.getItemAt(i).startsWith(orbitTypeFromGraph)) continue;
            this.orbitTypeCombo.setSelectedItem(this.orbitTypeCombo.getItemAt(i));
            return;
        }
        for (i = 0; i < this.orbitTypeCombo.getItemCount(); ++i) {
            if (!this.orbitTypeCombo.getItemAt(i).startsWith(defaultStr)) continue;
            this.orbitTypeCombo.setSelectedItem(this.orbitTypeCombo.getItemAt(i));
            return;
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        String polyDegreeStr = this.polyDegree.getText();
        if (polyDegreeStr != null && !polyDegreeStr.isEmpty()) {
            this.paramMap.put("polyDegree", Integer.parseInt(polyDegreeStr));
        }
        this.paramMap.put("orbitType", this.orbitTypeCombo.getSelectedItem());
        this.paramMap.put("continueOnFail", this.continueOnFail);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Orbit State Vectors:", this.orbitTypeCombo);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Polynomial Degree:", (JComponent)this.polyDegree);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"", (JComponent)this.continueOnFailCheckBox);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

