/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sar.gpf.ui.geometric;

import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.crs.CrsForm;
import org.esa.snap.ui.crs.CrsSelectionPanel;
import org.esa.snap.ui.crs.CustomCrsForm;
import org.esa.snap.ui.crs.PredefinedCrsForm;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapProjectionHandler {
    private final CrsSelectionPanel crsSelectionPanel = MapProjectionHandler.createCRSPanel();
    private CoordinateReferenceSystem crs;

    private static CrsSelectionPanel createCRSPanel() {
        AppContext appContext = SnapApp.getDefault().getAppContext();
        CustomCrsForm customCrsForm = new CustomCrsForm(appContext);
        PredefinedCrsForm predefinedCrsForm = new PredefinedCrsForm(appContext);
        return new CrsSelectionPanel(new CrsForm[]{customCrsForm, predefinedCrsForm});
    }

    public void initParameters(String mapProjection, Product[] sourceProducts) {
        this.crs = this.getCRS(mapProjection, sourceProducts);
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public String getCRSName() {
        if (this.crs != null) {
            return this.crs.getName().getCode();
        }
        return "";
    }

    private CoordinateReferenceSystem getCRS(String mapProjection, Product[] sourceProducts) {
        CoordinateReferenceSystem theCRS = MapProjectionHandler.parseCRS(mapProjection);
        if (theCRS == null) {
            return this.getCRSFromDialog(sourceProducts);
        }
        return theCRS;
    }

    static CoordinateReferenceSystem parseCRS(String mapProjection) {
        try {
            if (mapProjection != null && !mapProjection.isEmpty()) {
                return CRS.parseWKT((String)mapProjection);
            }
        }
        catch (Exception e) {
            try {
                return CRS.decode((String)mapProjection, (boolean)true);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
        return null;
    }

    private CoordinateReferenceSystem getCRSFromDialog(Product[] sourceProducts) {
        try {
            if (sourceProducts == null || sourceProducts[0] == null) {
                return this.crsSelectionPanel.getCrs(new GeoPos(0.0, 0.0));
            }
            return this.crsSelectionPanel.getCrs(ProductUtils.getCenterGeoPos((Product)sourceProducts[0]));
        }
        catch (Exception e) {
            Dialogs.showError((String)"Unable to create coodinate reference system");
            return null;
        }
    }

    public void promptForFeatureCrs(Product[] sourceProducts) {
        ModalDialog dialog = new ModalDialog(null, "Map Projection", 161, "mapProjection");
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setCellPadding(0, 0, new Insets(4, 10, 4, 4));
        JPanel contentPanel = new JPanel((LayoutManager)tableLayout);
        contentPanel.add((Component)this.crsSelectionPanel);
        dialog.setContent((Component)contentPanel);
        if (dialog.show() == 1) {
            this.crs = this.getCRSFromDialog(sourceProducts);
        }
    }
}

