/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sar.gpf.ui.geometric;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.s1tbx.sar.gpf.ui.geometric.MapProjectionHandler;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeolocationGridGeocodingOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JComboBox imgResamplingMethod = new JComboBox<String>(ResamplingFactory.resamplingNames);
    private final JButton crsButton = new JButton();
    private final MapProjectionHandler mapProjHandler = new MapProjectionHandler();

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.crsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeolocationGridGeocodingOpUI.this.mapProjHandler.promptForFeatureCrs(GeolocationGridGeocodingOpUI.this.sourceProducts);
                GeolocationGridGeocodingOpUI.this.crsButton.setText(GeolocationGridGeocodingOpUI.this.mapProjHandler.getCRSName());
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        this.imgResamplingMethod.setSelectedItem(this.paramMap.get("imgResamplingMethod"));
        String mapProjection = (String)this.paramMap.get("mapProjection");
        this.mapProjHandler.initParameters(mapProjection, this.sourceProducts);
        this.crsButton.setText(this.mapProjHandler.getCRSName());
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("imgResamplingMethod", this.imgResamplingMethod.getSelectedItem());
        if (this.mapProjHandler.getCRS() != null) {
            CoordinateReferenceSystem crs = this.mapProjHandler.getCRS();
            try {
                this.paramMap.put("mapProjection", crs.toWKT());
            }
            catch (UnformattableObjectException e) {
                this.paramMap.put("mapProjection", crs.toString());
            }
        }
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 2;
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Image Resampling Method:", (JComponent)this.imgResamplingMethod);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Map Projection:", (JComponent)this.crsButton);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

