/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.ocean.worldwind.layers;

import com.bc.ceres.core.ProgressMonitor;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.BufferFactory;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurface;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceAttributes;
import gov.nasa.worldwindx.examples.util.DirectedPath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.ocean.toolviews.polarview.OceanSwellTopComponent;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.worldwind.ArrowInfo;
import org.esa.snap.worldwind.ColorBarLegend;
import org.esa.snap.worldwind.ProductRenderablesInfo;
import org.esa.snap.worldwind.layers.BaseLayer;
import org.esa.snap.worldwind.layers.WWLayer;

public class Level2ProductLayer
extends BaseLayer
implements WWLayer {
    private static double HUE_BLUE = 0.6666666666666666;
    private static double HUE_RED = 0.0;
    private static double HUE_MAX_RED = 1.0;
    private JPanel theControlLevel2Panel;
    private boolean theOWILimitChanged = false;
    private boolean theRVLLimitChanged = false;
    private boolean theOWIArrowsDisplayed = false;
    private static double GLOBE_RADIUS = 6371000.0;
    private static int theOWIArrowCellSize = 4;
    private static int theOWIArrowNumLevels = 5;
    private JCheckBox theArrowsCB;
    private final HashMap<String, ColorBarLegend> theColorBarLegendHash = new HashMap();
    private String theSelectedComp = null;
    private final HashMap<Object, String> theObjectInfoHash = new HashMap();
    private final HashMap<Object, Product> theSurfaceProductHash = new HashMap();
    private final HashMap<Object, Integer> theSurfaceSequenceHash = new HashMap();
    private final HashMap<Product, ProductRenderablesInfo> theProductRenderablesInfoHash = new HashMap();
    public ScreenAnnotation theInfoAnnotation;
    private DirectedPath theLastSelectedDP = null;
    private WorldWindowGLCanvas theWWD;

    public Level2ProductLayer() {
        this.setName("S-1 Level-2 OCN");
        this.theWWD = null;
        this.theInfoAnnotation = new ScreenAnnotation("", new Point(120, 520));
        this.theInfoAnnotation.getAttributes().setSize(new Dimension(Integer.MAX_VALUE, 0));
        this.theInfoAnnotation.getAttributes().setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFitText");
        this.theInfoAnnotation.getAttributes().setCornerRadius(0);
        this.theInfoAnnotation.getAttributes().setHighlightScale(1.0);
        this.theInfoAnnotation.getAttributes().setTextColor(Color.WHITE);
        this.theInfoAnnotation.getAttributes().setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        this.theInfoAnnotation.getAttributes().setInsets(new Insets(6, 6, 6, 6));
        this.theInfoAnnotation.getAttributes().setBorderWidth(1.0);
        this.theInfoAnnotation.getAttributes().setVisible(false);
    }

    public void updateInfoAnnotation(SelectEvent event) {
        if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && this.theObjectInfoHash.get(event.getTopObject()) != null) {
            String info = this.theObjectInfoHash.get(event.getTopObject());
            if (event.getTopObject() instanceof DirectedPath) {
                DirectedPath dp = (DirectedPath)event.getTopObject();
                dp.setHighlighted(true);
                this.theLastSelectedDP = dp;
            }
            this.theInfoAnnotation.setText(info);
            this.theInfoAnnotation.getAttributes().setVisible(true);
        } else if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick") && this.theSurfaceProductHash.get(event.getTopObject()) != null && this.theSurfaceSequenceHash.get(event.getTopObject()) != null) {
            OceanSwellTopComponent.setOSWRecord(this.theSurfaceProductHash.get(event.getTopObject()), this.theSurfaceSequenceHash.get(event.getTopObject()));
        } else {
            if (this.theLastSelectedDP != null) {
                this.theLastSelectedDP.setHighlighted(false);
            }
            this.theInfoAnnotation.getAttributes().setVisible(false);
        }
    }

    public void addProduct(Product product, WorldWindowGLCanvas wwd) {
        if (!product.getProductType().equalsIgnoreCase("OCN")) {
            return;
        }
        if (this.theProductRenderablesInfoHash.get(product) != null) {
            return;
        }
        this.theWWD = wwd;
        this.addRenderable((Renderable)this.theInfoAnnotation);
        String text = "First line<br />Second line";
        this.theInfoAnnotation.setText("First line<br />Second line");
        this.theInfoAnnotation.getAttributes().setVisible(false);
        ProductRenderablesInfo productRenderablesInfo = new ProductRenderablesInfo();
        String prefix = "vv";
        if (product.getBand(prefix + "_001_owiLon") == null) {
            prefix = "hh";
        }
        MetadataElement metadataRoot = product.getMetadataRoot();
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        String acquisitionMode = absRoot.getAttributeString("ACQUISITION_MODE");
        Band owiLonBand = product.getBand(prefix + "_001_owiLon");
        Band owiLatBand = product.getBand(prefix + "_001_owiLat");
        Band owiIncAngleBand = product.getBand(prefix + "_001_owiIncidenceAngle");
        Band owiWindSpeedBand = product.getBand(prefix + "_001_owiWindSpeed");
        Band owiWindDirBand = product.getBand(prefix + "_001_owiWindDirection");
        int numRVLElements = 0;
        int rvlSwathWidth = 0;
        int rvlSwathHeight = 0;
        int numSwaths = 0;
        if (acquisitionMode.equalsIgnoreCase("IW")) {
            numSwaths = 3;
        } else if (acquisitionMode.equalsIgnoreCase("EW")) {
            numSwaths = 5;
        }
        for (int i = 0; i < numSwaths; ++i) {
            Band rvlLonBand = product.getBand(prefix + "_001_" + acquisitionMode.toUpperCase() + (i + 1) + "_rvlLon");
            numRVLElements += rvlLonBand.getRasterWidth() * rvlLonBand.getRasterHeight();
            rvlSwathWidth = rvlLonBand.getRasterWidth();
            rvlSwathHeight = rvlLonBand.getRasterHeight();
        }
        GeoPos geoPos1 = product.getSceneGeoCoding().getGeoPos(new PixelPos(0.0, 0.0), null);
        GeoPos geoPos2 = product.getSceneGeoCoding().getGeoPos(new PixelPos((double)(product.getSceneRasterWidth() - 1), (double)(product.getSceneRasterHeight() - 1)), null);
        try {
            int numElements;
            if (owiLonBand != null) {
                double[] lonValues = new double[owiLonBand.getRasterWidth() * owiLonBand.getRasterHeight()];
                owiLonBand.readPixels(0, 0, owiLonBand.getRasterWidth(), owiLonBand.getRasterHeight(), lonValues, ProgressMonitor.NULL);
                double[] latValues = new double[owiLatBand.getRasterWidth() * owiLatBand.getRasterHeight()];
                owiLatBand.readPixels(0, 0, owiLatBand.getRasterWidth(), owiLatBand.getRasterHeight(), latValues, ProgressMonitor.NULL);
                double[] incAngleValues = new double[owiIncAngleBand.getRasterWidth() * owiIncAngleBand.getRasterHeight()];
                owiIncAngleBand.readPixels(0, 0, owiIncAngleBand.getRasterWidth(), owiIncAngleBand.getRasterHeight(), incAngleValues, ProgressMonitor.NULL);
                double[] windSpeedValues = new double[owiWindSpeedBand.getRasterWidth() * owiWindSpeedBand.getRasterHeight()];
                owiWindSpeedBand.readPixels(0, 0, owiWindSpeedBand.getRasterWidth(), owiWindSpeedBand.getRasterHeight(), windSpeedValues, ProgressMonitor.NULL);
                double[] windDirValues = new double[owiWindDirBand.getRasterWidth() * owiWindDirBand.getRasterHeight()];
                owiWindDirBand.readPixels(0, 0, owiWindDirBand.getRasterWidth(), owiWindDirBand.getRasterHeight(), windDirValues, ProgressMonitor.NULL);
                this.addWindSpeedArrows(latValues, lonValues, incAngleValues, windSpeedValues, windDirValues, owiLonBand.getRasterWidth(), owiLonBand.getRasterHeight(), (ArrayList)productRenderablesInfo.theRenderableListHash.get("owi"));
                this.createColorSurfaceWithGradient(geoPos1, geoPos2, latValues, lonValues, windSpeedValues, owiWindSpeedBand.getRasterWidth(), owiWindSpeedBand.getRasterHeight(), 0.0, 10.0, false, (ArrayList)productRenderablesInfo.theRenderableListHash.get("owi"), productRenderablesInfo, "owi");
            }
            if (numRVLElements > 0) {
                boolean displayAsOne = false;
                double[] rvlLonValues = null;
                double[] rvlLatValues = null;
                double[] rvlRadVelValues = null;
                if (displayAsOne) {
                    rvlLonValues = new double[numRVLElements];
                    rvlLatValues = new double[numRVLElements];
                    rvlRadVelValues = new double[numRVLElements];
                }
                for (int i = 0; i < numSwaths; ++i) {
                    Band currRVLLonBand = product.getBand(prefix + "_001_" + acquisitionMode.toUpperCase() + (i + 1) + "_rvlLon");
                    Band currRVLLatBand = product.getBand(prefix + "_001_" + acquisitionMode.toUpperCase() + (i + 1) + "_rvlLat");
                    Band currRVLRadVelBand = product.getBand(prefix + "_001_" + acquisitionMode.toUpperCase() + (i + 1) + "_rvlRadVel");
                    double[] currRVLLonValues = new double[currRVLLonBand.getRasterWidth() * currRVLLonBand.getRasterHeight()];
                    currRVLLonBand.readPixels(0, 0, currRVLLonBand.getRasterWidth(), currRVLLonBand.getRasterHeight(), currRVLLonValues, ProgressMonitor.NULL);
                    double[] currRVLLatValues = new double[currRVLLatBand.getRasterWidth() * currRVLLatBand.getRasterHeight()];
                    currRVLLatBand.readPixels(0, 0, currRVLLatBand.getRasterWidth(), currRVLLatBand.getRasterHeight(), currRVLLatValues, ProgressMonitor.NULL);
                    double[] currRVLRadVelValues = new double[currRVLRadVelBand.getRasterWidth() * currRVLRadVelBand.getRasterHeight()];
                    currRVLRadVelBand.readPixels(0, 0, currRVLRadVelBand.getRasterWidth(), currRVLRadVelBand.getRasterHeight(), currRVLRadVelValues, ProgressMonitor.NULL);
                    if (displayAsOne) {
                        System.arraycopy(currRVLLonValues, 0, rvlLonValues, i * currRVLLonBand.getRasterWidth() * currRVLLonBand.getRasterHeight(), currRVLLonBand.getRasterWidth() * currRVLLonBand.getRasterHeight());
                        System.arraycopy(currRVLLatValues, 0, rvlLatValues, i * currRVLLatBand.getRasterWidth() * currRVLLatBand.getRasterHeight(), currRVLLatBand.getRasterWidth() * currRVLLatBand.getRasterHeight());
                        System.arraycopy(currRVLRadVelValues, 0, rvlRadVelValues, i * currRVLRadVelBand.getRasterWidth() * currRVLRadVelBand.getRasterHeight(), currRVLRadVelBand.getRasterWidth() * currRVLRadVelBand.getRasterHeight());
                        continue;
                    }
                    this.createColorSurfaceWithGradient(geoPos1, geoPos2, currRVLLatValues, currRVLLonValues, currRVLRadVelValues, rvlSwathWidth, rvlSwathHeight, -6.0, 6.0, true, (ArrayList)productRenderablesInfo.theRenderableListHash.get("rvl"), productRenderablesInfo, "rvl");
                }
                if (displayAsOne) {
                    this.createColorSurfaceWithGradient(geoPos1, geoPos2, rvlLatValues, rvlLonValues, rvlRadVelValues, numSwaths * rvlSwathWidth, rvlSwathHeight, -6.0, 6.0, true, (ArrayList)productRenderablesInfo.theRenderableListHash.get("rvl"), productRenderablesInfo, "rvl");
                }
            }
            double[][] oswData = null;
            double[][] owiData = null;
            double[][] rvlData = null;
            if (acquisitionMode.equalsIgnoreCase("WV") && metadataRoot.getElement("Original_Product_Metadata") != null && metadataRoot.getElement("Original_Product_Metadata").getElement("annotation") != null && (numElements = metadataRoot.getElement("Original_Product_Metadata").getElement("annotation").getNumElements()) > 0) {
                oswData = new double[5][numElements];
                owiData = new double[3][numElements];
                rvlData = new double[3][numElements];
                int i = 0;
                for (MetadataElement element : metadataRoot.getElement("Original_Product_Metadata").getElement("annotation").getElements()) {
                    oswData[0][i] = this.getData(element.getElement("oswLat"));
                    oswData[1][i] = this.getData(element.getElement("oswLon"));
                    oswData[2][i] = this.getData(element.getElement("oswHs"));
                    oswData[3][i] = this.getData(element.getElement("oswWl"));
                    oswData[4][i] = this.getData(element.getElement("oswDirmet"));
                    owiData[0][i] = this.getData(element.getElement("owiLat"));
                    owiData[1][i] = this.getData(element.getElement("owiLon"));
                    owiData[2][i] = this.getData(element.getElement("owiWindSpeed"));
                    rvlData[0][i] = this.getData(element.getElement("rvlLat"));
                    rvlData[1][i] = this.getData(element.getElement("rvlLon"));
                    rvlData[2][i] = this.getData(element.getElement("rvlRadVel"));
                    ++i;
                }
            }
            if (oswData != null) {
                this.addWaveLengthArrows(oswData[0], oswData[1], oswData[3], oswData[4], (ArrayList)productRenderablesInfo.theRenderableListHash.get("osw"));
                this.createWVColorSurfaceWithGradient(product, oswData[0], oswData[1], oswData[2], (ArrayList)productRenderablesInfo.theRenderableListHash.get("osw"), "osw");
            }
            if (owiData != null && owiLonBand == null) {
                this.createWVColorSurfaceWithGradient(product, owiData[0], owiData[1], owiData[2], (ArrayList)productRenderablesInfo.theRenderableListHash.get("owi"), "owi");
            }
            if (rvlData != null && numRVLElements == 0) {
                this.createWVColorSurfaceWithGradient(product, rvlData[0], rvlData[1], rvlData[2], (ArrayList)productRenderablesInfo.theRenderableListHash.get("rvl"), "rvl");
            }
            this.theProductRenderablesInfoHash.put(product, productRenderablesInfo);
            if (this.theControlLevel2Panel != null) {
                this.theControlLevel2Panel.setVisible(true);
            }
            this.setComponentVisible(this.theSelectedComp, wwd);
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("L2ProductLayer unable to add product " + product.getName(), (Throwable)e);
        }
    }

    public double getData(MetadataElement element) {
        if (element.getElement("Values") != null) {
            return element.getElement("Values").getAttribute("data").getData().getElemDouble();
        }
        return 0.0;
    }

    public void createColorSurfaceWithGradient(GeoPos geoPos1, GeoPos geoPos2, double[] latValues, double[] lonValues, double[] values, int width, int height, double minValue, double maxValue, boolean whiteZero, ArrayList<Renderable> renderableList, ProductRenderablesInfo prodRenderInfo, String comp) {
        this.createColorSurface(geoPos1, geoPos2, latValues, lonValues, values, width, height, renderableList, prodRenderInfo, comp);
        if (this.theColorBarLegendHash.get(comp) != null) {
            minValue = this.theColorBarLegendHash.get(comp).getMinValue();
            maxValue = this.theColorBarLegendHash.get(comp).getMaxValue();
        }
        this.createColorGradient(minValue, maxValue, whiteZero, prodRenderInfo, comp);
    }

    public void createColorBarLegend(double minValue, double maxValue, String title, String comp) {
        String unit = "m/s";
        if (comp.equalsIgnoreCase("osw")) {
            unit = "m";
        }
        DecimalFormat legendLabelFormat = new DecimalFormat("# " + unit);
        ColorBarLegend colorBarLegend = new ColorBarLegend();
        colorBarLegend.setColorGradient(32, 256, minValue, maxValue, HUE_RED, HUE_MAX_RED, Color.WHITE, ColorBarLegend.createDefaultColorGradientLabels((double)minValue, (double)maxValue, (Format)legendLabelFormat), ColorBarLegend.createDefaultTitle((String)title), comp.equalsIgnoreCase("rvl"));
        colorBarLegend.setOpacity(0.8);
        colorBarLegend.setScreenLocation(new Point(900, 320));
        this.theColorBarLegendHash.put(comp, colorBarLegend);
    }

    public void setComponentVisible(String comp, WorldWindowGLCanvas wwd) {
        for (String currComp : this.theColorBarLegendHash.keySet()) {
            if (this.theColorBarLegendHash.get(currComp) == null) continue;
            this.removeRenderable((Renderable)this.theColorBarLegendHash.get(currComp));
            if (currComp.equals(comp)) {
                this.addRenderable((Renderable)this.theColorBarLegendHash.get(currComp));
            }
            for (ProductRenderablesInfo productRenderablesInfo : this.theProductRenderablesInfoHash.values()) {
                if (productRenderablesInfo == null) continue;
                ArrayList renderableList = (ArrayList)productRenderablesInfo.theRenderableListHash.get(currComp);
                for (Renderable renderable : renderableList) {
                    this.removeRenderable(renderable);
                    if (!currComp.equals(comp)) continue;
                    this.addRenderable(renderable);
                }
            }
        }
        wwd.redrawNow();
    }

    private void addWindSpeedArrows(double[] latValues, double[] lonValues, double[] incAngleValues, double[] windSpeedValues, double[] windDirValues, int width, int height, ArrayList<Renderable> renderableList) {
        double pixelWidth = Math.abs(lonValues[0] - lonValues[lonValues.length - 1]) / (double)width;
        double pixelHeight = Math.abs(latValues[0] - latValues[latValues.length - 1]) / (double)height;
        double arrowLength_deg = pixelWidth;
        if (pixelHeight < pixelWidth) {
            arrowLength_deg = pixelHeight;
        }
        double arrowHeadLength = Angle.fromDegrees((double)(arrowLength_deg *= (double)Level2ProductLayer.theOWIArrowCellSize)).radians * GLOBE_RADIUS / 3.0;
        BasicShapeAttributes dpAttrs = new BasicShapeAttributes();
        dpAttrs.setOutlineMaterial(Material.BLACK);
        dpAttrs.setOutlineWidth(2.0);
        int numCellRows = height / theOWIArrowCellSize;
        int numCellCols = width / theOWIArrowCellSize;
        final ArrowInfo[][][] arrowGrid = new ArrowInfo[theOWIArrowNumLevels][numCellRows + 1][numCellCols + 1];
        for (int row = 0; row < height; row += theOWIArrowCellSize) {
            for (int col = 0; col < width; col += theOWIArrowCellSize) {
                int globalInd = row * width + col;
                float avgLat = 0.0f;
                float avgLon = 0.0f;
                double avgIncAngle = 0.0;
                double avgWindSpeed = 0.0;
                double avgWindDir = 0.0;
                int finalCellRow = row + theOWIArrowCellSize;
                int finalCellCol = col + theOWIArrowCellSize;
                if (finalCellRow > height) {
                    finalCellRow = height;
                }
                if (finalCellCol > width) {
                    finalCellCol = width;
                }
                for (int currCellRow = row; currCellRow < finalCellRow; ++currCellRow) {
                    for (int currCellCol = col; currCellCol < finalCellCol; ++currCellCol) {
                        int i = currCellRow * width + currCellCol;
                        avgLat = (float)((double)avgLat + latValues[i]);
                        avgLon = (float)((double)avgLon + lonValues[i]);
                        avgIncAngle += incAngleValues[i];
                        avgWindSpeed += windSpeedValues[i];
                        avgWindDir += windDirValues[i];
                    }
                }
                avgIncAngle /= (double)((finalCellRow - row) * (finalCellCol - col));
                avgWindSpeed /= (double)((finalCellRow - row) * (finalCellCol - col));
                Position startPos = new Position(Angle.fromDegreesLatitude((double)(avgLat /= (float)((finalCellRow - row) * (finalCellCol - col)))), Angle.fromDegreesLongitude((double)(avgLon /= (float)((finalCellRow - row) * (finalCellCol - col)))), 10.0);
                Position endPos = new Position(LatLon.greatCircleEndPosition((LatLon)startPos, (Angle)Angle.fromDegrees((double)(avgWindDir /= (double)((finalCellRow - row) * (finalCellCol - col)))), (Angle)Angle.fromDegrees((double)arrowLength_deg)), 10.0);
                ArrayList<Position> positions = new ArrayList<Position>();
                positions.add(startPos);
                positions.add(endPos);
                DirectedPath directedPath = this.getDirectedPath(positions, (ShapeAttributes)dpAttrs);
                directedPath.setArrowLength(arrowHeadLength);
                int currCellRow = row / theOWIArrowCellSize;
                int currCellCol = col / theOWIArrowCellSize;
                arrowGrid[0][currCellRow][currCellCol] = new ArrowInfo(directedPath, avgIncAngle, avgWindSpeed, avgWindDir, arrowLength_deg);
                for (int cellSizeResolution = 1; cellSizeResolution < theOWIArrowNumLevels; ++cellSizeResolution) {
                    int currBigCellSize = (int)FastMath.pow((double)2.0, (int)cellSizeResolution);
                    if (currCellRow % currBigCellSize != currBigCellSize - 1 || currCellCol % currBigCellSize != currBigCellSize - 1) continue;
                    int bigCellRow = currCellRow / currBigCellSize;
                    int bigCellCol = currCellCol / currBigCellSize;
                    int smallCellStartRow = bigCellRow * 2;
                    int smallCellStartCol = bigCellCol * 2;
                    double cumAvgIncAngle = 0.0;
                    double cumAvgWindSpeed = 0.0;
                    double cumAvgWindDir = 0.0;
                    Position cumStartPos = new Position(Angle.fromDegreesLatitude((double)0.0), Angle.fromDegreesLongitude((double)0.0), 10.0);
                    Position cumEndPos = new Position(Angle.fromDegreesLatitude((double)0.0), Angle.fromDegreesLongitude((double)0.0), 10.0);
                    double cumStartPosLat_deg = 0.0;
                    double cumStartPosLon_deg = 0.0;
                    double bigCellArrowLength_deg = (double)currBigCellSize * arrowLength_deg;
                    for (int currSmallCellRow = smallCellStartRow; currSmallCellRow < smallCellStartRow + 2; ++currSmallCellRow) {
                        for (int currSmallCellCol = smallCellStartCol; currSmallCellCol < smallCellStartCol + 2; ++currSmallCellCol) {
                            ArrowInfo currSmallArrow = arrowGrid[cellSizeResolution - 1][currSmallCellRow][currSmallCellCol];
                            cumAvgIncAngle += currSmallArrow.theAvgIncAngle;
                            cumAvgWindSpeed += currSmallArrow.theAvgWindSpeed;
                            cumAvgWindDir += currSmallArrow.theAvgWindDir;
                            boolean firstPosNext = true;
                            for (Position pos : currSmallArrow.theDirectedPath.getPositions()) {
                                if (firstPosNext) {
                                    cumStartPos = cumStartPos.add(pos);
                                    cumStartPosLat_deg += pos.getLatitude().getDegrees();
                                    cumStartPosLon_deg += pos.getLongitude().getDegrees();
                                    firstPosNext = false;
                                    continue;
                                }
                                cumEndPos = cumEndPos.add(pos);
                            }
                        }
                    }
                    cumAvgIncAngle /= 4.0;
                    cumAvgWindSpeed /= 4.0;
                    arrowGrid[cellSizeResolution][bigCellRow][bigCellCol] = null;
                    Position bigCellStartPos = new Position(Angle.fromDegreesLatitude((double)(cumStartPosLat_deg /= 4.0)), Angle.fromDegreesLongitude((double)(cumStartPosLon_deg /= 4.0)), 10.0);
                    Position bigCellEndPos = new Position(LatLon.greatCircleEndPosition((LatLon)bigCellStartPos, (Angle)Angle.fromDegrees((double)(cumAvgWindDir /= 4.0)), (Angle)Angle.fromDegrees((double)bigCellArrowLength_deg)), 10.0);
                    ArrayList<Position> bigCellPositions = new ArrayList<Position>();
                    bigCellPositions.add(bigCellStartPos);
                    bigCellPositions.add(bigCellEndPos);
                    DirectedPath bigDC = this.getDirectedPath(bigCellPositions, (ShapeAttributes)dpAttrs);
                    bigDC.setArrowLength((double)currBigCellSize * arrowHeadLength);
                    arrowGrid[cellSizeResolution][bigCellRow][bigCellCol] = new ArrowInfo(bigDC, cumAvgIncAngle, cumAvgWindSpeed, cumAvgWindDir, bigCellArrowLength_deg);
                }
            }
        }
        for (int cellRow = 0; cellRow < numCellRows; ++cellRow) {
            for (int cellCol = 0; cellCol < numCellCols; ++cellCol) {
                final int finalCellRow = cellRow;
                final int finalCellCol = cellCol;
                Renderable renderable = new Renderable(){

                    public void render(DrawContext dc) {
                        if (!Level2ProductLayer.this.theOWIArrowsDisplayed) {
                            return;
                        }
                        double currAlt = dc.getView().getCurrentEyePosition().getAltitude();
                        int selectedResolutionInd = (int)(Math.log(currAlt * 8.0E-6) / Math.log(2.0));
                        if (selectedResolutionInd < 0) {
                            selectedResolutionInd = 0;
                        } else if (selectedResolutionInd > 4) {
                            selectedResolutionInd = 4;
                        }
                        int selectedInd = (int)FastMath.pow((double)2.0, (int)selectedResolutionInd);
                        if (finalCellRow % selectedInd == 0 && finalCellCol % selectedInd == 0) {
                            int bigCellRow = finalCellRow / selectedInd;
                            int bigCellCol = finalCellCol / selectedInd;
                            if (arrowGrid[selectedResolutionInd][bigCellRow] != null && arrowGrid[selectedResolutionInd][bigCellRow][bigCellCol] != null) {
                                ArrowInfo currArrow = arrowGrid[selectedResolutionInd][bigCellRow][bigCellCol];
                                if (currArrow.theAvgWindSpeed > 0.0) {
                                    DirectedPath currDirectedPath = currArrow.theDirectedPath;
                                    currDirectedPath.render(dc);
                                    if (Level2ProductLayer.this.theObjectInfoHash.get(currDirectedPath) == null) {
                                        String info = "Wind Speed: " + currArrow.theAvgWindSpeed + "<br/>";
                                        info = info + "Wind Direction: " + currArrow.theAvgWindDir + "<br/>";
                                        info = info + "Incidence Angle: " + currArrow.theAvgIncAngle + "<br/>";
                                        Level2ProductLayer.this.theObjectInfoHash.put(currDirectedPath, info);
                                    }
                                }
                            }
                        }
                    }
                };
                this.addRenderable(renderable);
                if (renderableList == null) continue;
                renderableList.add(renderable);
            }
        }
    }

    private DirectedPath getDirectedPath(ArrayList<Position> positions, ShapeAttributes dpAttrs) {
        DirectedPath directedPath = new DirectedPath(positions);
        directedPath.setAttributes(dpAttrs);
        directedPath.setVisible(true);
        directedPath.setFollowTerrain(true);
        directedPath.setAltitudeMode(2);
        directedPath.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        return directedPath;
    }

    private void addWaveLengthArrows(double[] latValues, double[] lonValues, double[] waveLengthValues, double[] waveDirValues, ArrayList<Renderable> renderableList) {
        BasicShapeAttributes dpAttrs = new BasicShapeAttributes();
        dpAttrs.setOutlineMaterial(Material.WHITE);
        dpAttrs.setOutlineWidth(2.0);
        for (int ind = 0; ind < waveLengthValues.length; ++ind) {
            double arrowLength_deg = waveLengthValues[ind] / 4000.0;
            double arrowHeadLength = Angle.fromDegrees((double)arrowLength_deg).radians * GLOBE_RADIUS / 3.0;
            Position startPos = new Position(Angle.fromDegreesLatitude((double)latValues[ind]), Angle.fromDegreesLongitude((double)lonValues[ind]), 10.0);
            Position endPos = new Position(LatLon.greatCircleEndPosition((LatLon)startPos, (Angle)Angle.fromDegrees((double)waveDirValues[ind]), (Angle)Angle.fromDegrees((double)arrowLength_deg)), 10.0);
            ArrayList<Position> positions = new ArrayList<Position>();
            positions.add(startPos);
            positions.add(endPos);
            final DirectedPath directedPath = this.getDirectedPath(positions, (ShapeAttributes)dpAttrs);
            directedPath.setArrowLength(arrowHeadLength);
            Renderable renderable = new Renderable(){

                public void render(DrawContext dc) {
                    directedPath.render(dc);
                }
            };
            this.addRenderable(renderable);
            if (renderableList == null) continue;
            renderableList.add(renderable);
        }
    }

    private void createWVColorSurfaceWithGradient(final Product product, double[] latValues, double[] lonValues, double[] values, ArrayList<Renderable> renderableList, String comp) {
        BasicShapeAttributes dpAttrs = new BasicShapeAttributes();
        dpAttrs.setOutlineMaterial(Material.WHITE);
        dpAttrs.setOutlineWidth(2.0);
        for (int ind = 0; ind < values.length; ++ind) {
            final int finalInd = ind;
            ArrayList<Position> polygonPositions = new ArrayList<Position>();
            double vignette_half_side_deg = 572957.7951308233 / GLOBE_RADIUS;
            polygonPositions.add(new Position(Angle.fromDegreesLatitude((double)(latValues[ind] - vignette_half_side_deg)), Angle.fromDegreesLongitude((double)(lonValues[ind] - vignette_half_side_deg)), 10.0));
            polygonPositions.add(new Position(Angle.fromDegreesLatitude((double)(latValues[ind] - vignette_half_side_deg)), Angle.fromDegreesLongitude((double)(lonValues[ind] + vignette_half_side_deg)), 10.0));
            polygonPositions.add(new Position(Angle.fromDegreesLatitude((double)(latValues[ind] + vignette_half_side_deg)), Angle.fromDegreesLongitude((double)(lonValues[ind] + vignette_half_side_deg)), 10.0));
            polygonPositions.add(new Position(Angle.fromDegreesLatitude((double)(latValues[ind] + vignette_half_side_deg)), Angle.fromDegreesLongitude((double)(lonValues[ind] - vignette_half_side_deg)), 10.0));
            polygonPositions.add(new Position(Angle.fromDegreesLatitude((double)(latValues[ind] - vignette_half_side_deg)), Angle.fromDegreesLongitude((double)(lonValues[ind] - vignette_half_side_deg)), 10.0));
            Polyline p = new Polyline();
            p.setFollowTerrain(true);
            p.setPositions(polygonPositions);
            this.addRenderable((Renderable)p);
            if (renderableList != null) {
                renderableList.add((Renderable)p);
            }
            String info = "";
            if (comp.equalsIgnoreCase("osw")) {
                info = "Wave Length: " + values[ind] + "<br/>";
            } else if (comp.equalsIgnoreCase("owi")) {
                info = "Wind Speed: " + values[ind] + "<br/>";
            } else if (comp.equalsIgnoreCase("rvl")) {
                info = "Radial Velocity: " + values[ind] + "<br/>";
            }
            final String finalInfo = info;
            AnalyticSurface analyticSurface = new AnalyticSurface(){

                public void render(DrawContext dc) {
                    super.render(dc);
                    if (this.clampToGroundSurface != null) {
                        Level2ProductLayer.this.theObjectInfoHash.put(this.clampToGroundSurface, finalInfo);
                        Level2ProductLayer.this.theSurfaceProductHash.put(this.clampToGroundSurface, product);
                        Level2ProductLayer.this.theSurfaceSequenceHash.put(this.clampToGroundSurface, finalInd);
                    }
                }
            };
            analyticSurface.setSector(Sector.fromDegrees((double)(latValues[ind] - vignette_half_side_deg), (double)(latValues[ind] + vignette_half_side_deg), (double)(lonValues[ind] - vignette_half_side_deg), (double)(lonValues[ind] + vignette_half_side_deg)));
            analyticSurface.setAltitudeMode(1);
            analyticSurface.setDimensions(2, 2);
            ArrayList<AnalyticSurface.GridPointAttributes> attributesList = new ArrayList<AnalyticSurface.GridPointAttributes>();
            for (int i = 0; i < 4; ++i) {
                attributesList.add(Level2ProductLayer.createColorGradientAttributes(values[ind], 0.0, 10.0, HUE_RED, HUE_MAX_RED, false));
            }
            analyticSurface.setValues(attributesList);
            AnalyticSurfaceAttributes attr = new AnalyticSurfaceAttributes();
            attr.setDrawShadow(false);
            attr.setInteriorOpacity(1.0);
            attr.setDrawOutline(false);
            analyticSurface.setSurfaceAttributes(attr);
            analyticSurface.setClientLayer((Layer)this);
            this.addRenderable((Renderable)analyticSurface);
            if (renderableList == null) continue;
            renderableList.add((Renderable)analyticSurface);
        }
    }

    private double computeSegmentLength(Path path, DrawContext dc, Position posA, Position posB) {
        LatLon llA = new LatLon(posA.getLatitude(), posA.getLongitude());
        LatLon llB = new LatLon(posB.getLatitude(), posB.getLongitude());
        String pathType = path.getPathType();
        Angle ang = pathType == "gov.nasa.worldwind.avkey.Linear" ? LatLon.linearDistance((LatLon)llA, (LatLon)llB) : (pathType == "gov.nasa.worldwind.avkey.RhumbLine" || pathType == "gov.nasa.worldwind.avkey.Loxodrome" ? LatLon.rhumbDistance((LatLon)llA, (LatLon)llB) : LatLon.greatCircleDistance((LatLon)llA, (LatLon)llB));
        if (path.getAltitudeMode() == 1) {
            return ang.radians * dc.getGlobe().getRadius();
        }
        double height = 0.5 * (posA.getElevation() + posB.getElevation());
        return ang.radians * (dc.getGlobe().getRadius() + height * dc.getVerticalExaggeration());
    }

    protected void createColorSurface(GeoPos geoPos1, GeoPos geoPos2, final double[] latValues, final double[] lonValues, final double[] vals, int width, int height, ArrayList<Renderable> renderableList, ProductRenderablesInfo prodRenderInfo, String comp) {
        AnalyticSurface analyticSurface = new AnalyticSurface(){

            protected void doUpdate(DrawContext dc) {
                this.referencePos = new Position(this.sector.getCentroid(), this.altitude);
                this.referencePoint = dc.getGlobe().computePointFromPosition(this.referencePos);
                if (this.surfaceRenderInfo == null || this.surfaceRenderInfo.getGridWidth() != this.width || this.surfaceRenderInfo.getGridHeight() != this.height) {
                    this.surfaceRenderInfo = new AnalyticSurface.RenderInfo(this.width, this.height){

                        public void drawInterior(DrawContext dc) {
                            if (dc == null) {
                                this.cartesianVertexBuffer.rewind();
                                this.geographicVertexBuffer.rewind();
                                this.colorBuffer.rewind();
                                this.shadowColorBuffer.rewind();
                                return;
                            }
                            super.drawInterior(dc);
                        }
                    };
                }
                this.updateSurfacePoints(dc, this.surfaceRenderInfo);
                this.updateSurfaceNormals(this.surfaceRenderInfo);
            }

            protected void updateSurfacePoints(DrawContext dc, AnalyticSurface.RenderInfo outRenderInfo) {
                Iterator iter = this.values.iterator();
                for (int row = 0; row < this.height; ++row) {
                    for (int col = 0; col < this.width; ++col) {
                        AnalyticSurface.GridPointAttributes attr;
                        int i = row * this.width + col;
                        AnalyticSurface.GridPointAttributes gridPointAttributes = attr = iter.hasNext() ? (AnalyticSurface.GridPointAttributes)iter.next() : null;
                        if (vals[i] == -999.0) continue;
                        this.updateNextSurfacePoint(dc, Angle.fromDegrees((double)latValues[i]), Angle.fromDegrees((double)lonValues[i]), attr, outRenderInfo);
                    }
                }
                outRenderInfo.drawInterior(null);
            }
        };
        analyticSurface.setSector(Sector.fromDegrees((double)geoPos2.getLat(), (double)geoPos1.getLat(), (double)geoPos1.getLon(), (double)geoPos2.getLon()));
        analyticSurface.setAltitudeMode(1);
        analyticSurface.setDimensions(width, height);
        AnalyticSurfaceAttributes attr = new AnalyticSurfaceAttributes();
        attr.setDrawShadow(false);
        attr.setInteriorOpacity(1.0);
        attr.setDrawOutline(false);
        analyticSurface.setSurfaceAttributes(attr);
        analyticSurface.setClientLayer((Layer)this);
        BufferWrapper analyticSurfaceValueBuffer = new BufferFactory.DoubleBufferFactory().newBuffer(vals.length);
        analyticSurfaceValueBuffer.putDouble(0, vals, 0, vals.length);
        prodRenderInfo.setAnalyticSurfaceAndBuffer(analyticSurface, analyticSurfaceValueBuffer, comp);
        if (renderableList != null) {
            renderableList.add((Renderable)analyticSurface);
        }
    }

    public void createColorGradient(double minValue, double maxValue, boolean whiteZero, ProductRenderablesInfo prodRenderInfo, String comp) {
        ArrayList analyticSurfaces = null;
        ArrayList analyticSurfaceValueBuffers = null;
        if (comp.equalsIgnoreCase("owi")) {
            analyticSurfaces = prodRenderInfo.owiAnalyticSurfaces;
            analyticSurfaceValueBuffers = prodRenderInfo.owiAnalyticSurfaceValueBuffers;
        } else if (comp.equalsIgnoreCase("osw")) {
            analyticSurfaces = prodRenderInfo.oswAnalyticSurfaces;
            analyticSurfaceValueBuffers = prodRenderInfo.oswAnalyticSurfaceValueBuffers;
        } else if (comp.equalsIgnoreCase("rvl")) {
            analyticSurfaces = prodRenderInfo.rvlAnalyticSurfaces;
            analyticSurfaceValueBuffers = prodRenderInfo.rvlAnalyticSurfaceValueBuffers;
        }
        if (analyticSurfaces != null) {
            for (int currSurfInd = 0; currSurfInd < analyticSurfaces.size(); ++currSurfInd) {
                AnalyticSurface analyticSurface = (AnalyticSurface)analyticSurfaces.get(currSurfInd);
                BufferWrapper analyticSurfaceValueBuffer = (BufferWrapper)analyticSurfaceValueBuffers.get(currSurfInd);
                ArrayList<AnalyticSurface.GridPointAttributes> attributesList = new ArrayList<AnalyticSurface.GridPointAttributes>();
                for (int i = 0; i < analyticSurfaceValueBuffer.length(); ++i) {
                    double d = analyticSurfaceValueBuffer.getDouble(i);
                    attributesList.add(Level2ProductLayer.createColorGradientAttributes(d, minValue, maxValue, HUE_RED, HUE_MAX_RED, whiteZero));
                }
                analyticSurface.setValues(attributesList);
            }
        }
    }

    public static AnalyticSurface.GridPointAttributes createColorGradientAttributes(double value, double minValue, double maxValue, double minHue, double maxHue, boolean whiteZero) {
        double hueFactor = WWMath.computeInterpolationFactor((double)value, (double)minValue, (double)maxValue);
        double hue = WWMath.mix((double)hueFactor, (double)minHue, (double)maxHue);
        double sat = 1.0;
        if (whiteZero) {
            sat = Math.abs(WWMath.mixSmooth((double)hueFactor, (double)-1.0, (double)1.0));
        }
        Color color = Color.getHSBColor((float)hue, (float)sat, 1.0f);
        double opacity = WWMath.computeInterpolationFactor((double)value, (double)minValue, (double)(minValue + (maxValue - minValue) * 0.1));
        Color rgbaColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
        return AnalyticSurface.createGridPointAttributes((double)value, (Color)rgbaColor);
    }

    public void removeProduct(Product product) {
        ProductRenderablesInfo productRenderablesInfo = this.theProductRenderablesInfoHash.get(product);
        if (productRenderablesInfo != null) {
            for (ArrayList renderableList : productRenderablesInfo.theRenderableListHash.values()) {
                for (Renderable renderable : renderableList) {
                    this.removeRenderable(renderable);
                    if (!(renderable instanceof DirectedPath)) continue;
                    this.theObjectInfoHash.remove(renderable);
                    this.theSurfaceProductHash.remove(renderable);
                    this.theSurfaceSequenceHash.remove(renderable);
                }
                renderableList.clear();
            }
        }
        this.theProductRenderablesInfoHash.remove(product);
        if (this.theProductRenderablesInfoHash.size() == 0) {
            this.theControlLevel2Panel.setVisible(false);
            for (ColorBarLegend colorBarLegend : this.theColorBarLegendHash.values()) {
                this.removeRenderable((Renderable)colorBarLegend);
            }
        }
        this.theWWD.redrawNow();
        this.theWWD.redrawNow();
    }

    public void recreateColorBarAndGradient(double minValue, double maxValue, String comp, WorldWindowGLCanvas wwd, boolean redraw) {
        String title = "";
        if (comp.equalsIgnoreCase("owi")) {
            title = "OWI Wind Speed";
        } else if (comp.equalsIgnoreCase("osw")) {
            title = "OSW Wave Height.";
        } else if (comp.equalsIgnoreCase("rvl")) {
            title = "RVL Rad. Vel.";
        }
        if (redraw) {
            this.removeRenderable((Renderable)this.theColorBarLegendHash.get(comp));
        }
        this.createColorBarLegend(minValue, maxValue, title, comp);
        if (redraw) {
            this.addRenderable((Renderable)this.theColorBarLegendHash.get(comp));
        }
        for (ProductRenderablesInfo productRenderablesInfo : this.theProductRenderablesInfoHash.values()) {
            this.createColorGradient(minValue, maxValue, false, productRenderablesInfo, comp);
        }
        if (redraw) {
            wwd.redrawNow();
        }
    }

    public JPanel getControlPanel(final WorldWindowGLCanvas wwd) {
        this.theControlLevel2Panel = new JPanel(new GridLayout(7, 1, 5, 5));
        this.theControlLevel2Panel.setVisible(false);
        JRadioButton owiBtn = new JRadioButton("OWI");
        owiBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Level2ProductLayer.this.theSelectedComp = "owi";
                Level2ProductLayer.this.setComponentVisible("owi", wwd);
                Level2ProductLayer.this.theArrowsCB.setEnabled(true);
            }
        });
        JRadioButton oswBtn = new JRadioButton("OSW");
        oswBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Level2ProductLayer.this.theSelectedComp = "osw";
                Level2ProductLayer.this.setComponentVisible("osw", wwd);
                Level2ProductLayer.this.theArrowsCB.setEnabled(false);
            }
        });
        JRadioButton rvlBtn = new JRadioButton("RVL");
        rvlBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Level2ProductLayer.this.theSelectedComp = "rvl";
                Level2ProductLayer.this.setComponentVisible("rvl", wwd);
                Level2ProductLayer.this.theArrowsCB.setEnabled(false);
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(owiBtn);
        group.add(oswBtn);
        group.add(rvlBtn);
        owiBtn.setSelected(true);
        this.theSelectedComp = "owi";
        JPanel componentTypePanel = new JPanel(new GridLayout(1, 4, 5, 5));
        componentTypePanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        componentTypePanel.add(new JLabel("Component:"));
        componentTypePanel.add(owiBtn);
        componentTypePanel.add(oswBtn);
        componentTypePanel.add(rvlBtn);
        this.theControlLevel2Panel.add(componentTypePanel);
        JPanel arrowDisplayPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.theArrowsCB = new JCheckBox(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    Level2ProductLayer.this.theOWIArrowsDisplayed = true;
                } else {
                    Level2ProductLayer.this.theOWIArrowsDisplayed = false;
                }
                wwd.redrawNow();
            }
        });
        arrowDisplayPanel.add(new JLabel("Display Wind Vectors:"));
        arrowDisplayPanel.add(this.theArrowsCB);
        this.theControlLevel2Panel.add(arrowDisplayPanel);
        JPanel maxPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        maxPanel.add(new JLabel("Max OWI Wind Speed:"));
        final JSpinner maxSP = new JSpinner(new SpinnerNumberModel(10, 0, 10, 1));
        maxSP.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int newValue = (Integer)((JSpinner)e.getSource()).getValue();
                Level2ProductLayer.this.theOWILimitChanged = true;
            }
        });
        maxPanel.add(maxSP);
        this.theControlLevel2Panel.add(maxPanel);
        JPanel minPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        minPanel.add(new JLabel("Min OWI Wind Speed:"));
        final JSpinner minSP = new JSpinner(new SpinnerNumberModel(0, 0, 10, 1));
        minSP.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Level2ProductLayer.this.theOWILimitChanged = true;
            }
        });
        minPanel.add(minSP);
        this.theControlLevel2Panel.add(minPanel);
        JPanel maxRVLPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        maxRVLPanel.add(new JLabel("Max RVL Rad Vel.:"));
        final JSpinner maxRVLSP = new JSpinner(new SpinnerNumberModel(6, 0, 10, 1));
        maxRVLSP.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int newValue = (Integer)((JSpinner)e.getSource()).getValue();
                Level2ProductLayer.this.theRVLLimitChanged = true;
            }
        });
        maxRVLPanel.add(maxRVLSP);
        this.theControlLevel2Panel.add(maxRVLPanel);
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Level2ProductLayer.this.theOWILimitChanged) {
                    double minValue = ((Integer)minSP.getValue()).intValue();
                    double maxValue = ((Integer)maxSP.getValue()).intValue();
                    Level2ProductLayer.this.recreateColorBarAndGradient(minValue, maxValue, "owi", wwd, Level2ProductLayer.this.theSelectedComp.equalsIgnoreCase("owi"));
                }
                if (Level2ProductLayer.this.theRVLLimitChanged) {
                    double maxValue = ((Integer)maxRVLSP.getValue()).intValue();
                    double minValue = -1.0 * maxValue;
                    Level2ProductLayer.this.recreateColorBarAndGradient(minValue, maxValue, "rvl", wwd, Level2ProductLayer.this.theSelectedComp.equalsIgnoreCase("rvl"));
                }
                Level2ProductLayer.this.theOWILimitChanged = false;
                Level2ProductLayer.this.theRVLLimitChanged = false;
            }
        });
        this.theControlLevel2Panel.add(updateButton);
        this.createColorBarLegend(0.0, 10.0, "OWI Wind Speed", "owi");
        this.createColorBarLegend(0.0, 10.0, "OSW Wave Height.", "osw");
        this.createColorBarLegend(-6.0, 6.0, "RVL Rad. Vel.", "rvl");
        return this.theControlLevel2Panel;
    }
}

