/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.ocean.toolviews.polarview.polarplot;

import java.awt.Color;
import java.awt.Graphics;
import org.esa.s1tbx.ocean.toolviews.polarview.polarplot.Axis;
import org.esa.s1tbx.ocean.toolviews.polarview.polarplot.ColourScale;

public class PolarData {
    private final float firstDir;
    private final float dirStep;
    private final float[] radii;
    private final float minValue;
    private final float maxValue;
    private final int Nr;
    private final int Nth;
    private final AxisInfo rData = new AxisInfo();
    private final AxisInfo cData = new AxisInfo();
    private int[] rScreenPoints = null;
    private Object[] cValues = null;
    private float dirOffset = 0.0f;
    private final Color backgroundColor = Color.white;
    private Color[][] colors;
    private ColourScale cScale = null;
    private int plotCount = 0;

    public PolarData(float[][] cValues, float firstDir, float dirStep, float[] radii, float minValue, float maxValue) {
        this.cValues = (Object[])cValues;
        this.colors = null;
        this.firstDir = firstDir;
        this.dirStep = dirStep;
        this.radii = radii;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.Nth = cValues.length;
        this.Nr = cValues[0].length;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setRAxis(Axis rAxis) {
        this.rData.setAxis(rAxis);
    }

    public void setDirOffset(float dirOffset) {
        this.dirOffset = dirOffset;
    }

    void preparePlot() {
        this.plotCount = this.cValues.length;
        this.prepareColors(this.cValues);
        this.prepareRTPoints();
    }

    public void draw(Graphics g) {
        if (this.rData.axis == null) {
            return;
        }
        this.rData.axis.getAxisGraphics(g);
        this.preparePlot();
        int lastRad = Integer.MAX_VALUE;
        int arcAngle = (int)this.dirStep;
        if (this.rScreenPoints[0] < this.rScreenPoints[this.Nr]) {
            int rad2;
            int rad;
            for (int ri = this.Nr - 1; ri >= 0; --ri) {
                float th = this.firstDir + this.dirOffset;
                float r = this.rScreenPoints[ri + 1];
                rad = (int)r;
                if (rad >= lastRad) {
                    this.rScreenPoints[ri + 1] = rad = lastRad - 1;
                }
                lastRad = rad;
                rad2 = rad + rad;
                for (int thi = 0; thi < this.Nth; ++thi) {
                    int angle = (int)th;
                    g.setColor(this.colors[thi][ri]);
                    g.fillArc(-rad, -rad, rad2, rad2, angle, arcAngle);
                    th += this.dirStep;
                }
            }
            rad = this.rScreenPoints[0];
            rad2 = rad + rad;
            g.setColor(this.backgroundColor);
            g.fillOval(-rad, -rad, rad2, rad2);
        } else {
            int rad2;
            int rad;
            for (int ri = 0; ri < this.Nr; ++ri) {
                float th = this.firstDir + this.dirOffset;
                float r = this.rScreenPoints[ri + 1];
                rad = (int)r;
                if (rad >= lastRad) {
                    this.rScreenPoints[ri + 1] = rad = lastRad - 1;
                }
                lastRad = rad;
                rad2 = rad + rad;
                for (int thi = 0; thi < this.Nth; ++thi) {
                    int angle = (int)th;
                    g.setColor(this.colors[thi][ri]);
                    g.fillArc(-rad, -rad, rad2, rad2, angle, arcAngle);
                    th += this.dirStep;
                }
            }
            rad = this.rScreenPoints[this.Nr];
            rad2 = rad + rad;
            g.setColor(this.backgroundColor);
            g.fillOval(-rad, -rad, rad2, rad2);
        }
    }

    private void prepareRTPoints() {
        if (this.rData.axis == null) {
            return;
        }
        if (this.rScreenPoints == null || this.rScreenPoints.length != this.radii.length) {
            this.rScreenPoints = new int[this.radii.length];
            this.rData.touch();
        }
        this.rData.checkTouchedAxis();
        if (this.rData.touched) {
            this.rData.untouch();
            int[][] rP = new int[][]{this.rScreenPoints};
            float[][] r = new float[][]{this.radii};
            PolarData.computeScreenPoints(r, rP, this.rData.axis);
        }
    }

    public double valueFromScreenPoint(int r) {
        if (this.rScreenPoints[0] < this.rScreenPoints[this.Nr]) {
            if (r < this.rScreenPoints[0]) {
                return this.radii[0];
            }
            for (int ri = 1; ri <= this.Nr; ++ri) {
                if (this.rScreenPoints[ri - 1] > r || this.rScreenPoints[ri] < r) continue;
                if (this.rScreenPoints[ri - 1] == r) {
                    return this.radii[ri - 1];
                }
                if (this.rScreenPoints[ri] == r) {
                    return this.radii[ri];
                }
                return (this.radii[ri] - this.radii[ri - 1]) * ((float)r - (float)this.rScreenPoints[ri - 1]) / (float)(this.rScreenPoints[ri] - this.rScreenPoints[ri - 1]) + this.radii[ri - 1];
            }
            return this.radii[this.Nr];
        }
        if (r > this.rScreenPoints[0]) {
            return this.radii[0];
        }
        for (int ri = 1; ri <= this.Nr; ++ri) {
            if (this.rScreenPoints[ri - 1] < r || this.rScreenPoints[ri] > r) continue;
            if (this.rScreenPoints[ri - 1] == r) {
                return this.radii[ri - 1];
            }
            if (this.rScreenPoints[ri] == r) {
                return this.radii[ri];
            }
            return (this.radii[ri] - this.radii[ri - 1]) * ((float)r - (float)this.rScreenPoints[ri]) / (float)(this.rScreenPoints[ri - 1] - this.rScreenPoints[ri]) + this.radii[ri - 1];
        }
        return this.radii[this.Nr];
    }

    private static void computeScreenPoints(float[][] values, int[][] points, Axis axis) {
        if (axis == null) {
            return;
        }
        int np = values.length;
        for (int i = 0; i < np; ++i) {
            if (values[i] == null) {
                points[i] = null;
                continue;
            }
            int n = values[i].length;
            if (points[i] == null || points[i].length != n) {
                points[i] = new int[n];
            }
            for (int j = 0; j < n; ++j) {
                points[i][j] = axis.getScreenPoint(values[i][j]);
            }
        }
    }

    public void setCAxis(Axis cAxis) {
        this.cData.setAxis(cAxis);
    }

    public ColourScale getColorScale() {
        return this.cScale;
    }

    public void setColorScale(ColourScale cScale) {
        this.cScale = cScale;
        this.cData.touch();
    }

    private void prepareColors(Object[] cValues) {
        int TouchId;
        if (this.cScale == null) {
            return;
        }
        if (this.colors == null || this.colors.length != this.plotCount) {
            this.colors = new Color[this.plotCount][];
            this.cData.touched = true;
        }
        if (this.cData.axis != null && (TouchId = this.cData.axis.getTouchId()) != this.cData.touchId) {
            this.cData.touched = true;
            this.cData.touchId = TouchId;
        }
        if (this.cData.touched) {
            this.cData.touched = false;
            this.cScale.setRange(this.cData.axis.getRange());
            PolarData.computeColors((float[][])cValues, this.colors, this.cScale);
        }
    }

    private static void computeColors(float[][] values, Color[][] colors, ColourScale cScale) {
        if (cScale == null) {
            return;
        }
        int np = values.length;
        for (int i = 0; i < np; ++i) {
            if (values[i] == null) {
                colors[i] = null;
                continue;
            }
            int n = values[i].length;
            if (colors[i] == null || colors[i].length != n) {
                colors[i] = new Color[n];
            }
            for (int j = 0; j < n; ++j) {
                colors[i][j] = cScale.getColor(values[i][j]);
            }
        }
    }

    private static final class AxisInfo {
        private Axis axis = null;
        private boolean touched = true;
        private int touchId = -1;

        AxisInfo() {
        }

        void setAxis(Axis axis) {
            this.axis = axis;
            this.touched = true;
        }

        void touch() {
            this.touched = true;
        }

        void untouch() {
            this.touched = false;
        }

        void checkTouchedAxis() {
            int id = this.axis.getTouchId();
            if (this.touchId != id) {
                this.touched = true;
                this.touchId = id;
            }
        }
    }
}

