/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.ocean.toolviews.polarview.polarplot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.ocean.toolviews.polarview.polarplot.AbstractAxisDisplay;

public class Axis {
    private static final double[] stepValues = new double[]{0.1, 1.0, 2.0, 3.0, 5.0, 10.0};
    private static final int TOP_X = 1;
    private static final int BOTTOM_X = 2;
    private static final int LEFT_Y = 3;
    public static final int RIGHT_Y = 4;
    public static final int RADIAL = 5;
    private AbstractAxisDisplay gr = null;
    private boolean isX = true;
    private final boolean ticksInside = false;
    private final boolean withGrid = false;
    private double minValue = 0.0;
    private double maxValue = 1.0;
    private double axisRange = this.maxValue - this.minValue;
    private double tickRange = this.maxValue - this.minValue;
    private double minData = 0.0;
    private double maxData = 1.0;
    private final double minRange = 0.0;
    private final boolean visible = true;
    private boolean autoRange = true;
    private int length = 0;
    private int breadth = 0;
    private int TouchId = 0;
    private String title = null;
    private final int tickLength = -5;
    private int tickCount = 3;
    private int bestTickCount = 3;
    private int spacing = Math.abs(-5);
    private String[] tickNames = new String[]{"0", "0.5", "1"};
    private double[] tickValues = new double[]{0.0, 0.5, 1.0};
    private int[] tickPos = null;
    private final Font font = Axis.getFont("default.font.plot.axis.tick", "SansSerif-plain-12");
    private final Font titleFont = Axis.getFont("default.font.plot.axis.title", "SansSerif-plain-12");
    private final Color axisColor = Color.black;
    private final Color labelColor = Color.black;
    private final Color gridColor = Color.darkGray;
    private String unit = "";

    public Axis(int orientation) {
        this.setLocation(orientation);
    }

    private static Font getFont(String propertyName, String defaultFont) {
        String fontSpec = System.getProperty(propertyName, defaultFont);
        return Font.decode(fontSpec);
    }

    public void setTitle(String str) {
        this.title = str;
    }

    public void setUnit(String unitStr) {
        this.unit = unitStr;
    }

    public String getUnit() {
        return this.unit;
    }

    public AbstractAxisDisplay getAxisGraphics(Graphics g) {
        this.gr.setGraphics(g);
        return this.gr;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public final double[] getRange() {
        return new double[]{this.minValue, this.maxValue};
    }

    public void setAutoRange(boolean autoRange) {
        if (!this.autoRange && autoRange) {
            this.setApproximateRange(this.minData, this.maxData);
        }
        this.autoRange = autoRange;
    }

    public void setDataRange(double[] range) {
        this.setDataRange(range[0], range[1]);
    }

    public void setDataRange(double minValue, double maxValue) {
        this.minData = minValue;
        this.maxData = maxValue;
        if (this.autoRange) {
            this.setApproximateRange(minValue, maxValue);
        }
    }

    void setApproximateRange(double minValue, double maxValue) {
        double range;
        if (minValue == maxValue) {
            minValue -= 1.0;
            maxValue += 1.0;
        }
        if (Math.abs(range = maxValue - minValue) < 0.0) {
            maxValue = minValue + 0.0;
            range = maxValue - minValue;
        }
        double step = Axis.getStepValue(range / 5.0, true);
        double first = Math.floor(minValue / step + 1.0E-5) * step;
        int count = (int)Math.ceil((maxValue - first) / step);
        this.setRange(first, first + (double)count * step, count + 1);
    }

    private static double getStepValue(double thevalue, boolean up) {
        int i;
        boolean negative = thevalue < 0.0;
        double val = thevalue;
        if (negative) {
            val = -val;
        }
        int exponent = (int)Math.floor(Math.log10(val));
        val *= FastMath.pow((double)10.0, (int)(-exponent));
        for (i = stepValues.length - 1; i > 0 && !(val > stepValues[i]); --i) {
        }
        val = up ? stepValues[i + 1] : stepValues[i];
        val *= FastMath.pow((double)10.0, (int)exponent);
        if (negative) {
            val = -val;
        }
        return val;
    }

    void setRange(double rangeMin, double rangeMax) {
        if (rangeMin == this.minValue && rangeMax == this.maxValue) {
            return;
        }
        this.setApproximateRange(rangeMin, rangeMax);
        this.minValue = rangeMin;
        this.maxValue = rangeMax;
        if (this.minValue == this.maxValue) {
            this.minValue -= 1.0;
            this.maxValue += 1.0;
        }
        this.axisRange = this.maxValue - this.minValue;
        if (Math.abs(this.axisRange) < 0.0) {
            this.maxValue = this.minValue + 0.0;
            this.axisRange = this.maxValue - this.minValue;
        }
        this.bestTickCount = this.tickCount;
        this.setTickCount(this.tickCount);
    }

    public void setRange(double minValue, double maxValue, int tickCount) {
        if (minValue == this.minValue && maxValue == this.maxValue && tickCount == this.bestTickCount) {
            return;
        }
        if (minValue == maxValue) {
            minValue -= 1.0;
            maxValue += 1.0;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.tickRange = this.axisRange = maxValue - minValue;
        if (Math.abs(this.axisRange) < 0.0) {
            maxValue = minValue + 0.0;
            this.tickRange = this.axisRange = maxValue - minValue;
        }
        this.bestTickCount = tickCount;
        this.setTickCount(tickCount);
    }

    private void setTickCount(int newTickCount) {
        int lastTickIndex;
        double step;
        double first;
        double absMax;
        this.tickCount = Math.abs(newTickCount);
        double absMin = Math.abs(this.minValue);
        double largestValue = absMin <= (absMax = Math.abs(this.maxValue)) ? absMax : absMin;
        int exponent = (int)Math.floor(Math.log10(largestValue));
        if (Math.abs(exponent) < 5) {
            exponent = 0;
        }
        if (Math.abs((first = this.minValue) + (step = this.tickRange / (double)(lastTickIndex = this.tickCount - 1)) - this.minValue) < Math.abs(step * 0.15)) {
            this.tickCount = lastTickIndex--;
            first += step;
            this.tickRange -= step;
        }
        if (Math.abs(first + this.tickRange - this.maxValue) > Math.abs(step * 0.85)) {
            this.tickCount = lastTickIndex--;
            this.tickRange -= step;
        }
        if (this.tickCount < 3) {
            lastTickIndex = 2;
            this.tickCount = 3;
            first = this.minValue;
            this.tickRange = this.axisRange;
            step = this.tickRange / (double)lastTickIndex;
        }
        if (this.tickValues == null || this.tickValues.length != this.tickCount) {
            this.tickValues = new double[this.tickCount];
            this.tickNames = new String[this.tickCount];
        }
        for (int i = 1; i < lastTickIndex; ++i) {
            double v;
            this.tickValues[i] = v = first + (double)i * step;
            this.tickNames[i] = Axis.valueToString(v, exponent);
        }
        this.tickValues[0] = this.minValue;
        this.tickNames[0] = Axis.valueToString(this.minValue, exponent);
        this.tickValues[lastTickIndex] = this.maxValue;
        this.tickNames[lastTickIndex] = Axis.valueToString(this.maxValue, exponent);
        this.getTickPositions();
    }

    final void setLocation(int orientation) {
        switch (orientation) {
            default: {
                this.isX = true;
                this.gr = new AbstractAxisDisplay.XAxisDisplay(false);
                break;
            }
            case 2: {
                this.isX = true;
                this.gr = new AbstractAxisDisplay.XAxisDisplay(true);
                break;
            }
            case 3: {
                this.isX = false;
                this.gr = new AbstractAxisDisplay.YAxisDisplay(true);
                break;
            }
            case 4: {
                this.isX = false;
                this.gr = new AbstractAxisDisplay.YAxisDisplay(false);
                break;
            }
            case 5: {
                this.isX = true;
                this.gr = new AbstractAxisDisplay.XAxisDisplay(false);
            }
        }
    }

    public int getTouchId() {
        return this.TouchId;
    }

    public void setSize(Dimension graphSize) {
        int breadth;
        int length;
        if (this.isX) {
            length = graphSize.width - 2 * this.spacing;
            breadth = graphSize.height - 2 * this.spacing;
        } else {
            length = graphSize.height - 2 * this.spacing;
            breadth = graphSize.width - 2 * this.spacing;
        }
        this.breadth = breadth;
        if (length != this.length) {
            this.length = length;
            this.getTickPositions();
        }
    }

    public void draw(Graphics g, Dimension graphSize) {
        this.setSize(graphSize);
        this.draw(g);
    }

    public void draw(Graphics g) {
        int i;
        this.gr.setGraphics(g);
        FontMetrics fm = g.getFontMetrics(this.font);
        g.setColor(this.axisColor);
        this.gr.drawLine(0, 0, this.length + 2 * this.spacing, 0);
        int tickLength = this.tickLength;
        int maxTickCount = (int)(((float)this.length + 0.5f) / (float)this.gr.maxTickSize(this.tickNames, this.tickCount, this.font));
        int minTickCount = Math.min(maxTickCount, this.bestTickCount);
        if (this.tickCount > maxTickCount) {
            this.setTickCount(maxTickCount);
        } else if (this.tickCount < minTickCount) {
            this.setTickCount(minTickCount);
        }
        for (i = 0; i < this.tickCount; ++i) {
            this.gr.drawTick(this.tickPos[i], tickLength);
        }
        g.setColor(this.labelColor);
        g.setFont(this.font);
        for (i = 0; i < this.tickCount; ++i) {
            this.gr.drawMultiLineTickName(this.tickNames[i], this.tickPos[i], tickLength, fm);
        }
        g.setFont(this.titleFont);
        this.gr.drawTitle(this.title, this.titleFont, this.length);
    }

    private static String valueToString(double v, int exponent) {
        float vm;
        if (exponent != 0 && (vm = (float)(v * FastMath.pow((double)10.0, (int)(-exponent)))) != 0.0f) {
            return Float.toString(vm) + 'e' + exponent;
        }
        return Float.toString((float)v);
    }

    public final int getScreenPoint(double value) {
        int p = this.spacing + (int)((double)this.length * (value - this.minValue) / this.axisRange);
        if (this.isX) {
            return p;
        }
        return -p;
    }

    private void getTickPositions() {
        if (this.tickPos == null || this.tickPos.length != this.tickCount) {
            this.tickPos = new int[this.tickCount];
        }
        for (int i = 0; i < this.tickCount; ++i) {
            this.tickPos[i] = this.isX ? this.getScreenPoint(this.tickValues[i]) : -this.getScreenPoint(this.tickValues[i]);
        }
        ++this.TouchId;
    }
}

