/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.ocean.toolviews.polarview.polarplot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

abstract class AbstractAxisDisplay {
    Graphics g = null;
    private Color backgroundColor = Color.white;
    public static final int MAX_POINTS = 16380;

    AbstractAxisDisplay() {
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackground(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    abstract void drawLine(int var1, int var2, int var3, int var4);

    abstract void drawTitle(String var1, Font var2, int var3);

    abstract Rectangle getTickName(String var1, int var2, int var3, int var4, int var5, FontMetrics var6);

    abstract void drawTickName(String var1, int var2, int var3, int var4, int var5, int var6, int var7);

    abstract int maxTickSize(String[] var1, int var2, Font var3);

    void setGraphics(Graphics g) {
        this.g = g;
    }

    void drawTick(int tickPixel, int tickLength) {
        this.drawLine(tickPixel, 0, tickPixel, tickLength);
    }

    void drawMultiLineTickName(String name, int tickPixel, int tickLength, FontMetrics fm) {
        int leading = Math.max(fm.getLeading(), 3);
        int lineCount = 0;
        int p = 0;
        do {
            p = name.indexOf(10, p);
            ++lineCount;
        } while (++p > 0);
        int f = 0;
        for (int i = 1; i <= lineCount; ++i) {
            p = name.indexOf(10, f);
            if (p < 0) {
                p = name.length();
            }
            String text = name.substring(f, p);
            Rectangle box = this.getTickName(text, tickPixel, tickLength, i, lineCount, fm);
            Color col = this.g.getColor();
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(box.x - leading, box.y, box.width + 2 * leading, box.height + leading);
            this.g.setColor(col);
            this.g.drawString(text, box.x, box.y + fm.getAscent());
            f = p + 1;
        }
    }

    Dimension getTickLabelBounds(String name, Font font) {
        int p;
        FontMetrics fm = this.g.getFontMetrics(font);
        int maxWidth = 0;
        int height = 0;
        int f = 0;
        do {
            int n = (p = name.indexOf(10, f)) < 0 ? name.length() : p;
            maxWidth = Math.max(fm.stringWidth(name.substring(f, n)), maxWidth);
            height += fm.getAscent();
        } while ((f = p + 1) > 0);
        return new Dimension(maxWidth, height);
    }

    public static class YAxisDisplay
    extends AbstractAxisDisplay {
        final boolean isBottomLeft;

        public YAxisDisplay(boolean bottomLeft) {
            this.isBottomLeft = bottomLeft;
        }

        @Override
        void drawLine(int x1, int y1, int x2, int y2) {
            if (this.isBottomLeft) {
                this.g.drawLine(y1, -x1, y2, -x2);
            } else {
                this.g.drawLine(-y1, -x1, -y2, -x2);
            }
        }

        @Override
        void drawTitle(String title, Font titleFont, int length) {
            if (title != null) {
                FontMetrics fm = this.g.getFontMetrics(titleFont);
                int y = length + fm.getHeight();
                int w = fm.stringWidth(title);
                int x = this.isBottomLeft ? -w / 2 : -(w / 2);
                this.g.drawString(title, x, -y);
            }
        }

        @Override
        Rectangle getTickName(String name, int tickPixel, int tickLength, int lineNumber, int lineCount, FontMetrics fm) {
            int height = fm.getAscent();
            int width = fm.stringWidth(name);
            int y = tickPixel;
            int x = tickLength >= 0 ? 0 : tickLength;
            y -= height * lineNumber - height * lineCount / 2;
            x -= height / 2;
            if (this.isBottomLeft) {
                x -= width;
                x = -x;
            }
            return new Rectangle(-x, -y - height, width, height);
        }

        @Override
        void drawTickName(String name, int tickPixel, int tickLength, int width, int height, int lineNumber, int lineCount) {
            int y = tickPixel;
            int x = tickLength >= 0 ? 0 : tickLength;
            y -= height * lineNumber - height * lineCount / 2;
            x -= height / 2;
            if (this.isBottomLeft) {
                this.g.drawString(name, x -= width, -y);
            } else {
                this.g.drawString(name, -x, -y);
            }
        }

        @Override
        int maxTickSize(String[] tickNames, int tickCount, Font font) {
            int maxHeight = 0;
            for (int i = 0; i < tickCount; ++i) {
                maxHeight = Math.max(this.getTickLabelBounds((String)tickNames[i], (Font)font).height + 6, maxHeight);
            }
            return maxHeight;
        }
    }

    public static class XAxisDisplay
    extends AbstractAxisDisplay {
        final boolean isBottomLeft;

        public XAxisDisplay(boolean bottomLeft) {
            this.isBottomLeft = bottomLeft;
        }

        @Override
        void drawLine(int x1, int y1, int x2, int y2) {
            if (this.isBottomLeft) {
                this.g.drawLine(x1, -y1, x2, -y2);
            } else {
                this.g.drawLine(x1, y1, x2, y2);
            }
        }

        @Override
        void drawTitle(String title, Font titleFont, int length) {
            if (title != null) {
                FontMetrics tfm = this.g.getFontMetrics(titleFont);
                this.g.drawString(title, (length - tfm.stringWidth(title)) / 2, tfm.getHeight() * 3);
            }
        }

        @Override
        Rectangle getTickName(String name, int tickPixel, int tickLength, int lineNumber, int lineCount, FontMetrics fm) {
            int height = fm.getAscent();
            int width = fm.stringWidth(name);
            int x = tickPixel;
            int y = tickLength >= 0 ? 0 : tickLength;
            x -= width / 2;
            if (this.isBottomLeft) {
                y -= Math.round((float)height * ((float)lineNumber + 0.5f));
                y = -y;
            } else {
                y -= Math.round((float)height * ((float)lineNumber - 0.5f));
            }
            return new Rectangle(x, y - height, width, height);
        }

        @Override
        void drawTickName(String name, int tickPixel, int tickLength, int width, int height, int lineNumber, int lineCount) {
            int x = tickPixel;
            int y = tickLength >= 0 ? 0 : tickLength;
            x -= width / 2;
            if (this.isBottomLeft) {
                this.g.drawString(name, x, -(y -= Math.round((float)height * ((float)lineNumber + 0.5f))));
            } else {
                this.g.drawString(name, x, y -= Math.round((float)height * ((float)lineNumber - 0.5f)));
            }
        }

        @Override
        int maxTickSize(String[] tickNames, int tickCount, Font font) {
            int maxWidth = 0;
            for (int i = 0; i < tickCount; ++i) {
                maxWidth = Math.max(this.getTickLabelBounds((String)tickNames[i], (Font)font).width + 6, maxWidth);
            }
            return maxWidth;
        }
    }
}

