/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.ocean.toolviews.polarview;

import java.util.ArrayList;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.ocean.toolviews.polarview.SpectraData;
import org.esa.s1tbx.ocean.toolviews.polarview.SpectraDataBase;
import org.esa.s1tbx.ocean.toolviews.polarview.polarplot.PolarData;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;

public class SpectraDataSentinel1
extends SpectraDataBase
implements SpectraData {
    private final MetadataElement annotation;
    private float minValue;
    private float maxValue;

    public SpectraDataSentinel1(Product product) {
        super(product);
        MetadataElement root = AbstractMetadata.getOriginalProductMetadata((Product)product);
        this.annotation = root.getElement("annotation");
        this.numRecords = this.annotation.getNumElements() - 1;
        Band rasterNode = product.getBandAt(0);
        this.recordLength = rasterNode.getRasterWidth() * rasterNode.getRasterHeight();
    }

    @Override
    public String[] getSpectraMetadata(int rec) throws Exception {
        MetadataElement[] elems = this.annotation.getElements();
        if (elems.length <= rec) {
            throw new Exception("OSW Record not found in product");
        }
        MetadataElement recElem = elems[rec];
        MetadataElement dimensions = recElem.getElement("Dimensions");
        this.numWLBins = dimensions.getAttributeInt("oswWavenumberBinSize", 0);
        this.numDirBins = dimensions.getAttributeInt("oswAngularBinSize", 0);
        this.firstDirBins = 0.0f;
        this.dirBinStep = 10.0f;
        this.firstWLBin = 800.0f;
        this.lastWLBin = 30.0f;
        MetadataElement oswWindSpeed = recElem.getElement("oswWindSpeed");
        this.windSpeed = oswWindSpeed.getElement("Values").getAttributeDouble("data", 0.0);
        MetadataElement oswWindDirection = recElem.getElement("oswWindDirection");
        this.windDirection = oswWindDirection.getElement("Values").getAttributeDouble("data", 0.0);
        ArrayList<String> metadataList = new ArrayList<String>();
        metadataList.add(this.createMetadataDouble("Wind Speed", recElem, "oswWindSpeed", null));
        metadataList.add(this.createMetadataDouble("Wind Direction", recElem, "oswWindDirection", "\u00b0"));
        metadataList.add(this.createMetadataDouble("Wind Sea Heights", recElem, "oswWindSeaHs", null));
        metadataList.add(this.createMetadataDouble("Wave Age", recElem, "oswWaveAge", ""));
        metadataList.add(this.createMetadataDouble("Az Cut-off Wavelength", recElem, "oswAzCutoff", null));
        metadataList.add(this.createMetadataDouble("Ra Cut-off Wavelength", recElem, "oswRaCutoff", null));
        metadataList.add(this.createMetadataDouble("Water Depth", recElem, "oswDepth", null));
        metadataList.add(this.createMetadataDouble("Incidence Angle", recElem, "oswIncidenceAngle", "\u00b0"));
        metadataList.add(this.createMetadataDouble("Backscatter", recElem, "oswNrcs", null));
        return metadataList.toArray(new String[metadataList.size()]);
    }

    private String createMetadataDouble(String name, MetadataElement recElem, String elemName, String unit) {
        MetadataElement elem = recElem.getElement(elemName);
        double value = elem.getElement("Values").getAttributeDouble("data", 0.0);
        String valueStr = String.valueOf(value);
        if (value - (double)((int)value) != 0.0) {
            valueStr = this.frmt.format(value);
        }
        if (unit == null) {
            unit = elem.getAttributeString("units");
        }
        return name + ": " + valueStr + " " + unit;
    }

    @Override
    public PolarData getPolarData(int currentRec, SpectraData.SpectraUnit spectraUnit) throws Exception {
        boolean realBand = spectraUnit != SpectraData.SpectraUnit.IMAGINARY;
        this.spectrum = this.getSpectrum(currentRec, realBand);
        if (this.waveProductType == SpectraData.WaveProductType.WAVE_SPECTRA) {
            this.minValue = Float.MAX_VALUE;
            this.maxValue = Float.MIN_VALUE;
            for (int i = 0; i < this.spectrum.length; ++i) {
                for (int j = 0; j < this.spectrum[0].length; ++j) {
                    float val = this.spectrum[i][j];
                    if (spectraUnit == SpectraData.SpectraUnit.INTENSITY) {
                        val *= val;
                    }
                    this.spectrum[i][j] = val;
                    this.minValue = Math.min(this.minValue, val);
                    this.maxValue = Math.max(this.maxValue, val);
                }
            }
        } else if (this.waveProductType == SpectraData.WaveProductType.CROSS_SPECTRA && (spectraUnit == SpectraData.SpectraUnit.AMPLITUDE || spectraUnit == SpectraData.SpectraUnit.INTENSITY)) {
            float[][] imagSpectrum = this.getSpectrum(currentRec, false);
            this.minValue = Float.MAX_VALUE;
            this.maxValue = Float.MIN_VALUE;
            for (int i = 0; i < this.spectrum.length; ++i) {
                for (int j = 0; j < this.spectrum[0].length; ++j) {
                    float realVal = this.spectrum[i][j];
                    float imagVal = imagSpectrum[i][j];
                    float val = this.sign(realVal) == this.sign(imagVal) ? realVal * realVal + imagVal * imagVal : 0.0f;
                    if (spectraUnit == SpectraData.SpectraUnit.AMPLITUDE) {
                        val = (float)Math.sqrt(val);
                    }
                    this.spectrum[i][j] = val;
                    this.minValue = Math.min(this.minValue, val);
                    this.maxValue = Math.max(this.maxValue, val);
                }
            }
        }
        float rStep = (float)(Math.log(this.lastWLBin) - Math.log(this.firstWLBin)) / (float)(this.numWLBins - 1);
        double logr = Math.log(this.firstWLBin) - (double)rStep / 2.0;
        float thFirst = this.firstDirBins + 5.0f;
        float thStep = -this.dirBinStep;
        float[] radii = new float[this.spectrum[0].length + 1];
        for (int j = 0; j <= this.spectrum[0].length; ++j) {
            radii[j] = (float)(10000.0 / FastMath.exp((double)logr));
            logr += (double)rStep;
        }
        return new PolarData(this.spectrum, 90.0f + thFirst, thStep, radii, this.minValue, this.maxValue);
    }

    private Band getBand(int currentRec, boolean getReal) throws Exception {
        for (Band band : this.product.getBands()) {
            try {
                String bandName = band.getName().toLowerCase();
                String bandRecNumStr = bandName.substring(3, 6);
                Integer bandRecNum = Integer.parseInt(bandRecNumStr);
                if (bandRecNum != currentRec + 1) continue;
                if (this.waveProductType == SpectraData.WaveProductType.WAVE_SPECTRA && bandName.contains("oswpolspec")) {
                    return band;
                }
                if (this.waveProductType != SpectraData.WaveProductType.CROSS_SPECTRA) continue;
                if (getReal && bandName.contains("oswqualitycrossspectrare")) {
                    return band;
                }
                if (getReal || !bandName.contains("oswqualitycrossspectraim")) continue;
                return band;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new Exception("Band not found for record " + currentRec);
    }

    private float[][] getSpectrum(int currentRec, boolean getReal) throws Exception {
        Band rasterNode = this.getBand(currentRec, getReal);
        rasterNode.loadRasterData();
        float[] dataset = new float[rasterNode.getRasterWidth() * rasterNode.getRasterHeight()];
        rasterNode.getPixels(0, 0, rasterNode.getRasterWidth(), rasterNode.getRasterHeight(), dataset);
        this.minValue = (float)rasterNode.getStx().getMinimum();
        this.maxValue = (float)rasterNode.getStx().getMaximum();
        float[][] spectrum = new float[this.numDirBins][this.numWLBins];
        int index = 0;
        for (int i = 0; i < this.numDirBins; ++i) {
            for (int j = 0; j < this.numWLBins; ++j) {
                spectrum[i][j] = dataset[index++];
            }
        }
        return spectrum;
    }

    @Override
    public String[] updateReadouts(double[] rTh, int currentRecord) {
        if (this.spectrum == null) {
            return null;
        }
        float rStep = (float)(Math.log(this.lastWLBin) - Math.log(this.firstWLBin)) / (float)(this.numWLBins - 1);
        int wvBin = (int)(((double)rStep / 2.0 + Math.log(10000.0 / rTh[0]) - Math.log(this.firstWLBin)) / (double)rStep);
        wvBin = Math.min(wvBin, this.spectrum[0].length - 1);
        int wl = (int)Math.round(FastMath.exp((double)((double)wvBin * (double)rStep + Math.log(this.firstWLBin))));
        float thFirst = this.firstDirBins + 5.0f;
        float thStep = -this.dirBinStep;
        int thBin = (int)((360.0 - rTh[1] + (double)thFirst) % 360.0 / (double)(-thStep));
        int element = thBin * this.spectrum[0].length + wvBin;
        int direction = (int)(-((float)thBin * thStep + thStep / 2.0f + thFirst));
        ArrayList<String> readoutList = new ArrayList<String>(5);
        readoutList.add("Wavelength: " + wl + " m");
        readoutList.add("Direction: " + direction + " \u00b0");
        readoutList.add("Bin: " + (thBin + 1) + "," + (wvBin + 1) + " Element: " + element);
        readoutList.add("Value: " + this.spectrum[thBin][wvBin]);
        return readoutList.toArray(new String[readoutList.size()]);
    }
}

