/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.ocean.toolviews.polarview;

import java.util.ArrayList;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.ocean.toolviews.polarview.SpectraData;
import org.esa.s1tbx.ocean.toolviews.polarview.SpectraDataBase;
import org.esa.s1tbx.ocean.toolviews.polarview.polarplot.PolarData;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;

public class SpectraDataAsar
extends SpectraDataBase
implements SpectraData {
    private MetadataElement spectraMetadataRoot = null;
    private ProductData.UTC zeroDopplerTime = null;
    private double minSpectrum = 0.0;
    private double maxSpectrum = 255.0;
    private double minReal = 0.0;
    private double maxReal = 0.0;
    private double minImaginary = 0.0;
    private double maxImaginary = 0.0;

    public SpectraDataAsar(Product product, SpectraData.WaveProductType waveProductType) {
        super(product);
        this.setWaveProductType(waveProductType);
        MetadataElement root = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement sph = root.getElement("SPH");
        this.numDirBins = sph.getAttributeInt("NUM_DIR_BINS", 0);
        this.numWLBins = sph.getAttributeInt("NUM_WL_BINS", 0);
        this.firstDirBins = (float)sph.getAttributeDouble("FIRST_DIR_BIN", 0.0);
        this.dirBinStep = (float)sph.getAttributeDouble("DIR_BIN_STEP", 0.0);
        this.firstWLBin = (float)sph.getAttributeDouble("FIRST_WL_BIN", 0.0);
        this.lastWLBin = (float)sph.getAttributeDouble("LAST_WL_BIN", 0.0);
        Band rasterNode = product.getBandAt(0);
        this.numRecords = rasterNode.getRasterHeight() - 1;
        this.recordLength = rasterNode.getRasterWidth();
        this.spectraMetadataRoot = waveProductType == SpectraData.WaveProductType.WAVE_SPECTRA ? root.getElement("OCEAN_WAVE_SPECTRA_MDS") : root.getElement("CROSS_SPECTRA_MDS");
    }

    public float getMinValue(boolean real) {
        if (this.waveProductType == SpectraData.WaveProductType.WAVE_SPECTRA) {
            return (float)this.minSpectrum;
        }
        return real ? (float)this.minReal : (float)this.minImaginary;
    }

    public float getMaxValue(boolean real) {
        if (this.waveProductType == SpectraData.WaveProductType.WAVE_SPECTRA) {
            return (float)this.maxSpectrum;
        }
        return real ? (float)this.maxReal : (float)this.maxImaginary;
    }

    @Override
    public String[] getSpectraMetadata(int rec) throws Exception {
        if (this.spectraMetadataRoot == null) {
            throw new Exception("OSW Metadata not found in product");
        }
        try {
            String elemName = this.spectraMetadataRoot.getName() + '.' + (rec + 1);
            MetadataElement spectraMetadata = this.spectraMetadataRoot.getElement(elemName);
            this.zeroDopplerTime = spectraMetadata.getAttributeUTC("zero_doppler_time");
            double maxSpecDir = spectraMetadata.getAttributeDouble("spec_max_dir", 0.0);
            double maxSpecWL = spectraMetadata.getAttributeDouble("spec_max_wl", 0.0);
            double sarWaveHeight = 0.0;
            double sarAzShiftVar = 0.0;
            double backscatter = 0.0;
            if (this.waveProductType == SpectraData.WaveProductType.WAVE_SPECTRA) {
                this.minSpectrum = spectraMetadata.getAttributeDouble("min_spectrum", 0.0);
                this.maxSpectrum = spectraMetadata.getAttributeDouble("max_spectrum", 255.0);
                this.windSpeed = spectraMetadata.getAttributeDouble("wind_speed", 0.0);
                this.windDirection = spectraMetadata.getAttributeDouble("wind_direction", 0.0);
                sarWaveHeight = spectraMetadata.getAttributeDouble("SAR_wave_height", 0.0);
                sarAzShiftVar = spectraMetadata.getAttributeDouble("SAR_az_shift_var", 0.0);
                backscatter = spectraMetadata.getAttributeDouble("backscatter", 0.0);
            } else {
                this.minReal = spectraMetadata.getAttributeDouble("min_real", 0.0);
                this.maxReal = spectraMetadata.getAttributeDouble("max_real", 255.0);
                this.minImaginary = spectraMetadata.getAttributeDouble("min_imag", 0.0);
                this.maxImaginary = spectraMetadata.getAttributeDouble("max_imag", 255.0);
            }
            ArrayList<String> metadataList = new ArrayList<String>(10);
            metadataList.add("Time: " + this.zeroDopplerTime.toString());
            metadataList.add("Peak Direction: " + maxSpecDir + " \u00b0");
            metadataList.add("Peak Wavelength: " + this.frmt.format(maxSpecWL) + " m");
            if (this.waveProductType == SpectraData.WaveProductType.WAVE_SPECTRA) {
                metadataList.add("Min Spectrum: " + this.frmt.format(this.minSpectrum));
                metadataList.add("Max Spectrum: " + this.frmt.format(this.maxSpectrum));
                metadataList.add("Wind Speed: " + this.frmt.format(this.windSpeed) + " m/s");
                metadataList.add("Wind Direction: " + this.windDirection + " \u00b0");
                metadataList.add("SAR Swell Wave Height: " + this.frmt.format(sarWaveHeight) + " m");
                metadataList.add("SAR Azimuth Shift Var: " + this.frmt.format(sarAzShiftVar) + " m^2");
                metadataList.add("Backscatter: " + this.frmt.format(backscatter) + " dB");
            }
            return metadataList.toArray(new String[metadataList.size()]);
        }
        catch (Exception e) {
            throw new Exception("Unable to get metadata for " + this.spectraMetadataRoot.getName());
        }
    }

    @Override
    public PolarData getPolarData(int currentRec, SpectraData.SpectraUnit spectraUnit) throws Exception {
        float thStep;
        float thFirst;
        boolean realBand = spectraUnit != SpectraData.SpectraUnit.IMAGINARY;
        this.spectrum = this.getSpectrum(currentRec, realBand);
        float minValue = this.getMinValue(realBand);
        float maxValue = this.getMaxValue(realBand);
        if (this.waveProductType == SpectraData.WaveProductType.WAVE_SPECTRA) {
            if (spectraUnit == SpectraData.SpectraUnit.INTENSITY) {
                minValue = Float.MAX_VALUE;
                maxValue = Float.MIN_VALUE;
                for (int i = 0; i < this.spectrum.length; ++i) {
                    for (int j = 0; j < this.spectrum[0].length; ++j) {
                        float val;
                        float realVal = this.spectrum[i][j];
                        this.spectrum[i][j] = val = realVal * realVal;
                        minValue = Math.min(minValue, val);
                        maxValue = Math.max(maxValue, val);
                    }
                }
            }
        } else if (spectraUnit == SpectraData.SpectraUnit.AMPLITUDE || spectraUnit == SpectraData.SpectraUnit.INTENSITY) {
            float[][] imagSpectrum = this.getSpectrum(currentRec, false);
            minValue = Float.MAX_VALUE;
            maxValue = Float.MIN_VALUE;
            for (int i = 0; i < this.spectrum.length; ++i) {
                for (int j = 0; j < this.spectrum[0].length; ++j) {
                    float realVal = this.spectrum[i][j];
                    float imagVal = imagSpectrum[i][j];
                    float val = this.sign(realVal) == this.sign(imagVal) ? realVal * realVal + imagVal * imagVal : 0.0f;
                    if (spectraUnit == SpectraData.SpectraUnit.AMPLITUDE) {
                        val = (float)Math.sqrt(val);
                    }
                    this.spectrum[i][j] = val;
                    minValue = Math.min(minValue, val);
                    maxValue = Math.max(maxValue, val);
                }
            }
        }
        float rStep = (float)(Math.log(this.lastWLBin) - Math.log(this.firstWLBin)) / (float)(this.numWLBins - 1);
        double logr = Math.log(this.firstWLBin) - (double)rStep / 2.0;
        if (this.waveProductType == SpectraData.WaveProductType.WAVE_SPECTRA) {
            thFirst = this.firstDirBins + 5.0f;
            thStep = -this.dirBinStep;
        } else {
            thFirst = this.firstDirBins - 5.0f;
            thStep = this.dirBinStep;
        }
        float[] radii = new float[this.spectrum[0].length + 1];
        for (int j = 0; j <= this.spectrum[0].length; ++j) {
            radii[j] = (float)(10000.0 / FastMath.exp((double)logr));
            logr += (double)rStep;
        }
        return new PolarData(this.spectrum, 90.0f + thFirst, thStep, radii, minValue, maxValue);
    }

    private float[][] getSpectrum(int currentRec, boolean getReal) throws Exception {
        Band rasterNode = this.product.getBandAt(getReal ? 0 : 1);
        rasterNode.loadRasterData();
        float[] dataset = new float[this.recordLength];
        rasterNode.getPixels(0, currentRec, this.recordLength, 1, dataset);
        float minValue = this.getMinValue(getReal);
        float maxValue = this.getMaxValue(getReal);
        float scale = (maxValue - minValue) / 255.0f;
        float[][] spectrum = new float[this.numDirBins][this.numWLBins];
        int index = 0;
        if (this.waveProductType == SpectraData.WaveProductType.WAVE_SPECTRA) {
            for (int i = 0; i < this.numDirBins; ++i) {
                for (int j = 0; j < this.numWLBins; ++j) {
                    spectrum[i][j] = dataset[index++] * scale + minValue;
                }
            }
        } else {
            int j;
            int i;
            int Nd2 = this.numDirBins / 2;
            for (i = 0; i < Nd2; ++i) {
                for (j = 0; j < this.numWLBins; ++j) {
                    spectrum[i][j] = dataset[index++] * scale + minValue;
                }
            }
            if (getReal) {
                for (i = 0; i < Nd2; ++i) {
                    System.arraycopy(spectrum[i], 0, spectrum[i + Nd2], 0, this.numWLBins);
                }
            } else {
                for (i = 0; i < Nd2; ++i) {
                    for (j = 0; j < this.numWLBins; ++j) {
                        spectrum[i + Nd2][j] = -spectrum[i][j];
                    }
                }
            }
        }
        return spectrum;
    }

    @Override
    public String[] updateReadouts(double[] rTh, int currentRecord) {
        int direction;
        int element;
        int thBin;
        if (this.spectrum == null) {
            return null;
        }
        float rStep = (float)(Math.log(this.lastWLBin) - Math.log(this.firstWLBin)) / (float)(this.numWLBins - 1);
        int wvBin = (int)(((double)rStep / 2.0 + Math.log(10000.0 / rTh[0]) - Math.log(this.firstWLBin)) / (double)rStep);
        wvBin = Math.min(wvBin, this.spectrum[0].length - 1);
        int wl = (int)Math.round(FastMath.exp((double)((double)wvBin * (double)rStep + Math.log(this.firstWLBin))));
        if (this.waveProductType == SpectraData.WaveProductType.CROSS_SPECTRA) {
            float thFirst = this.firstDirBins - 5.0f;
            float thStep = this.dirBinStep;
            thBin = (int)((rTh[1] - (double)thFirst) % 360.0 / (double)thStep);
            element = thBin % (this.spectrum.length / 2) * this.spectrum[0].length + wvBin;
            direction = (int)((float)thBin * thStep + thStep / 2.0f + thFirst);
        } else {
            float thFirst = this.firstDirBins + 5.0f;
            float thStep = -this.dirBinStep;
            thBin = (int)((360.0 - rTh[1] + (double)thFirst) % 360.0 / (double)(-thStep));
            element = thBin * this.spectrum[0].length + wvBin;
            direction = (int)(-((float)thBin * thStep + thStep / 2.0f + thFirst));
        }
        ArrayList<String> readoutList = new ArrayList<String>(5);
        readoutList.add("Wavelength: " + wl + " m");
        readoutList.add("Direction: " + direction + " \u00b0");
        readoutList.add("Bin: " + (thBin + 1) + "," + (wvBin + 1) + " Element: " + element);
        readoutList.add("Value: " + this.spectrum[thBin][wvBin]);
        return readoutList.toArray(new String[readoutList.size()]);
    }
}

