/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.ocean.toolviews.polarview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.esa.s1tbx.ocean.toolviews.polarview.ColourScaleDialog;
import org.esa.s1tbx.ocean.toolviews.polarview.ControlPanel;
import org.esa.s1tbx.ocean.toolviews.polarview.PolarPanel;
import org.esa.s1tbx.ocean.toolviews.polarview.SpectraData;
import org.esa.s1tbx.ocean.toolviews.polarview.SpectraDataAsar;
import org.esa.s1tbx.ocean.toolviews.polarview.SpectraDataSentinel1;
import org.esa.s1tbx.ocean.toolviews.polarview.polarplot.Axis;
import org.esa.s1tbx.ocean.toolviews.polarview.polarplot.ColourScale;
import org.esa.s1tbx.ocean.toolviews.polarview.polarplot.PolarCanvas;
import org.esa.s1tbx.ocean.toolviews.polarview.polarplot.PolarData;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.graphbuilder.rcp.utils.FileFolderUtils;
import org.esa.snap.rcp.SnapApp;

public final class PolarView
extends JPanel
implements ActionListener,
PopupMenuListener,
MouseListener,
MouseMotionListener {
    private Product product;
    private int currentRecord = 0;
    private final String[] unitTypes = new String[]{"Real", "Imaginary", "Amplitude", "Intensity"};
    private ControlPanel controlPanel;
    private PolarPanel polarPanel;
    private Component emptyPanel;
    private SpectraData.SpectraUnit spectraUnit;
    private SpectraData.WaveProductType waveProductType;
    private SpectraData spectraData;
    public static final Color[] colourTable = new Color[]{new Color(255, 255, 255), new Color(0, 0, 255), new Color(0, 255, 255), new Color(0, 255, 0), new Color(255, 255, 0), new Color(255, 0, 0)};
    private static final double[] rings = new double[]{50.0, 100.0, 200.0};
    private static final String[] ringTextStrings = new String[]{"200 m", "100 m", "50 m"};

    public PolarView() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(new BorderLayout());
        this.waveProductType = null;
        this.spectraData = null;
        this.emptyPanel = this.createEmptyPanel();
        this.add(this.emptyPanel, "North");
        this.polarPanel = new PolarPanel();
        this.add((Component)this.polarPanel, "Center");
        this.controlPanel = new ControlPanel(this);
        this.add((Component)this.controlPanel, "South");
        this.enablePlot(false);
    }

    private Component createEmptyPanel() {
        return new JLabel("<html>This tool window is used to analyse<br><b>Level-2 Ocean Swell</b> data in a polar plot.<br>Please open and select a Sentinel-1 L2 OCN WV<br>or an ASAR L2 WV product.", 0);
    }

    private void enablePlot(boolean flag) {
        this.emptyPanel.setVisible(!flag);
        this.polarPanel.setVisible(flag);
        this.controlPanel.setVisible(flag);
    }

    public void setProduct(Product prod) {
        if (this.product == prod) {
            return;
        }
        this.product = prod;
        if (this.product == null) {
            this.enablePlot(false);
            return;
        }
        switch (this.product.getProductType()) {
            case "ASA_WVW_2P": {
                if (this.spectraUnit == null) {
                    this.spectraUnit = SpectraData.SpectraUnit.AMPLITUDE;
                }
                this.spectraData = new SpectraDataAsar(this.product, SpectraData.WaveProductType.WAVE_SPECTRA);
                break;
            }
            case "ASA_WVS_1P": {
                if (this.spectraUnit == null) {
                    this.spectraUnit = SpectraData.SpectraUnit.INTENSITY;
                }
                this.spectraData = new SpectraDataAsar(this.product, SpectraData.WaveProductType.CROSS_SPECTRA);
                break;
            }
            case "OCN": {
                MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.product);
                String mode = absRoot.getAttributeString("ACQUISITION_MODE");
                if (mode.equals("WV")) {
                    if (this.spectraUnit == null) {
                        this.spectraUnit = SpectraData.SpectraUnit.AMPLITUDE;
                    }
                    if (this.waveProductType == null) {
                        this.waveProductType = SpectraData.WaveProductType.WAVE_SPECTRA;
                    }
                    this.spectraData = new SpectraDataSentinel1(this.product);
                    this.spectraData.setWaveProductType(this.waveProductType);
                    break;
                }
                this.enablePlot(false);
                return;
            }
            default: {
                this.enablePlot(false);
                return;
            }
        }
        if (this.waveProductType != null) {
            this.currentRecord = 0;
            this.createPlot(this.currentRecord);
        }
        this.enablePlot(this.waveProductType != null);
    }

    public void removeProduct(Product product) {
        if (this.product == product) {
            this.product = null;
            this.enablePlot(false);
        }
    }

    private void createPlot(int rec) {
        try {
            String[] readouts = this.spectraData.getSpectraMetadata(rec);
            this.polarPanel.setMetadata(readouts);
            PolarCanvas polarCanvas = this.polarPanel.getPolarCanvas();
            polarCanvas.setAxisNames("Azimuth", "Range");
            if (!(this.spectraData instanceof SpectraDataAsar) || this.spectraData.getWaveProductType() != SpectraData.WaveProductType.CROSS_SPECTRA) {
                polarCanvas.setWindDirection(this.spectraData.getWindDirection());
                polarCanvas.showWindDirection(true);
                polarCanvas.setAxisNames("North", "East");
            }
            PolarData data = this.spectraData.getPolarData(this.currentRecord, this.spectraUnit);
            double[] colourRange = new double[]{data.getMinValue(), data.getMaxValue()};
            double[] radialRange = new double[]{this.spectraData.getMinRadius(), this.spectraData.getMaxRadius()};
            Axis colourAxis = polarCanvas.getColourAxis();
            Axis radialAxis = polarCanvas.getRadialAxis();
            colourAxis.setDataRange(colourRange);
            colourAxis.setUnit(this.unitTypes[this.spectraUnit.ordinal()]);
            radialAxis.setAutoRange(false);
            radialAxis.setDataRange(radialRange);
            radialAxis.setRange(radialRange[0], radialRange[1], 4);
            radialAxis.setTitle("Wavelength (m)");
            polarCanvas.setRings(rings, ringTextStrings);
            data.setColorScale(ColourScale.newCustomScale(colourRange));
            polarCanvas.setData(data);
            this.repaint();
            this.controlPanel.updateControls();
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to read OSW data from product ", (Throwable)e);
        }
    }

    public JPopupMenu createPopupMenu(MouseEvent event) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem itemNext = this.createMenuItem("Next");
        popup.add(itemNext);
        itemNext.setEnabled(this.currentRecord < this.spectraData.getNumRecords());
        JMenuItem itemPrev = this.createMenuItem("Previous");
        popup.add(itemPrev);
        itemPrev.setEnabled(this.currentRecord > 0);
        JMenuItem itemColourScale = this.createMenuItem("Colour Scale");
        popup.add(itemColourScale);
        if (this.spectraData instanceof SpectraDataSentinel1) {
            JMenu dataMenu = new JMenu("Data");
            popup.add(dataMenu);
            this.createCheckedMenuItem("Wave Spectra", dataMenu, this.spectraData.getWaveProductType() == SpectraData.WaveProductType.WAVE_SPECTRA);
            this.createCheckedMenuItem("Cross Spectra", dataMenu, this.spectraData.getWaveProductType() == SpectraData.WaveProductType.CROSS_SPECTRA);
        }
        JMenu unitMenu = new JMenu("Unit");
        popup.add(unitMenu);
        if (this.spectraData.getWaveProductType() == SpectraData.WaveProductType.WAVE_SPECTRA) {
            this.createCheckedMenuItem(this.unitTypes[SpectraData.SpectraUnit.AMPLITUDE.ordinal()], unitMenu, this.spectraUnit == SpectraData.SpectraUnit.AMPLITUDE);
            this.createCheckedMenuItem(this.unitTypes[SpectraData.SpectraUnit.INTENSITY.ordinal()], unitMenu, this.spectraUnit == SpectraData.SpectraUnit.INTENSITY);
        } else {
            this.createCheckedMenuItem(this.unitTypes[SpectraData.SpectraUnit.REAL.ordinal()], unitMenu, this.spectraUnit == SpectraData.SpectraUnit.REAL);
            this.createCheckedMenuItem(this.unitTypes[SpectraData.SpectraUnit.IMAGINARY.ordinal()], unitMenu, this.spectraUnit == SpectraData.SpectraUnit.IMAGINARY);
            this.createCheckedMenuItem(this.unitTypes[SpectraData.SpectraUnit.AMPLITUDE.ordinal()], unitMenu, this.spectraUnit == SpectraData.SpectraUnit.AMPLITUDE);
            this.createCheckedMenuItem(this.unitTypes[SpectraData.SpectraUnit.INTENSITY.ordinal()], unitMenu, this.spectraUnit == SpectraData.SpectraUnit.INTENSITY);
        }
        JMenuItem itemExportReadout = this.createMenuItem("Export Readouts");
        popup.add(itemExportReadout);
        popup.setLabel("Justification");
        popup.setBorder(new BevelBorder(0));
        popup.addPopupMenuListener(this);
        popup.show(this, event.getX(), event.getY());
        return popup;
    }

    private JMenuItem createMenuItem(String name) {
        JMenuItem item = new JMenuItem(name);
        item.setHorizontalTextPosition(4);
        item.addActionListener(this);
        return item;
    }

    public JCheckBoxMenuItem createCheckedMenuItem(String name, JMenu parent, boolean state) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(name);
        item.setHorizontalTextPosition(4);
        item.addActionListener(this);
        item.setState(state);
        parent.add(item);
        return item;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("Next")) {
            this.showNextPlot();
        } else if (event.getActionCommand().equals("Previous")) {
            this.showPreviousPlot();
        } else if (event.getActionCommand().equals("Colour Scale")) {
            this.callColourScaleDlg();
        } else if (event.getActionCommand().equals("Export Readouts")) {
            this.exportReadouts();
        } else if (event.getActionCommand().equals("Real")) {
            this.spectraUnit = SpectraData.SpectraUnit.REAL;
            this.createPlot(this.currentRecord);
        } else if (event.getActionCommand().equals("Imaginary")) {
            this.spectraUnit = SpectraData.SpectraUnit.IMAGINARY;
            this.createPlot(this.currentRecord);
        } else if (event.getActionCommand().equals("Amplitude")) {
            this.spectraUnit = SpectraData.SpectraUnit.AMPLITUDE;
            this.createPlot(this.currentRecord);
        } else if (event.getActionCommand().equals("Intensity")) {
            this.spectraUnit = SpectraData.SpectraUnit.INTENSITY;
            this.createPlot(this.currentRecord);
        } else if (event.getActionCommand().equals("Wave Spectra")) {
            this.waveProductType = SpectraData.WaveProductType.WAVE_SPECTRA;
            this.spectraData.setWaveProductType(this.waveProductType);
            if (this.spectraUnit != SpectraData.SpectraUnit.AMPLITUDE && this.spectraUnit != SpectraData.SpectraUnit.INTENSITY) {
                this.spectraUnit = SpectraData.SpectraUnit.AMPLITUDE;
            }
            this.createPlot(this.currentRecord);
        } else if (event.getActionCommand().equals("Cross Spectra")) {
            this.waveProductType = SpectraData.WaveProductType.CROSS_SPECTRA;
            this.spectraData.setWaveProductType(this.waveProductType);
            this.createPlot(this.currentRecord);
        }
    }

    int getCurrentRecord() {
        return this.currentRecord;
    }

    int getNumRecords() {
        return this.spectraData != null ? this.spectraData.getNumRecords() : 0;
    }

    void showNextPlot() {
        this.createPlot(++this.currentRecord);
    }

    void showPreviousPlot() {
        this.createPlot(--this.currentRecord);
    }

    void showPlot(int record) {
        this.currentRecord = record;
        this.createPlot(this.currentRecord);
    }

    void zoomOut() {
        this.createPlot(this.currentRecord);
    }

    void zoomIn() {
        this.createPlot(this.currentRecord);
    }

    private void callColourScaleDlg() {
        PolarCanvas polarCanvas = this.polarPanel.getPolarCanvas();
        ColourScaleDialog dlg = new ColourScaleDialog(polarCanvas.getColourAxis());
        dlg.show();
    }

    private void exportReadouts() {
        File file = FileFolderUtils.GetFilePath((String)"Export Wave Mode Readout", (String)"txt", (String)"txt", (String)(this.product.getName() + "_rec" + this.currentRecord), (String)"Wave mode readout", (boolean)true);
        try {
            if (file != null) {
                this.polarPanel.exportReadout(file);
            }
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to export file " + file.toString() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createPopupMenu(e);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Axis axis;
        this.checkPopup(e);
        Object src = e.getSource();
        PolarCanvas polarCanvas = this.polarPanel.getPolarCanvas();
        if (src == polarCanvas && (axis = polarCanvas.selectAxis(e.getPoint())) != null && axis == polarCanvas.getColourAxis()) {
            this.callColourScaleDlg();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkPopup(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateReadout(e);
    }

    private void updateReadout(MouseEvent evt) {
        double[] rTh = this.polarPanel.getPolarCanvas().getRTheta(evt.getPoint());
        if (rTh != null) {
            String[] readouts = this.spectraData.updateReadouts(rTh, this.currentRecord);
            this.polarPanel.setReadout(readouts);
        } else {
            this.polarPanel.setReadout(null);
        }
        this.repaint();
    }
}

