/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.ocean.toolviews.polarview;

import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.esa.s1tbx.ocean.toolviews.polarview.PolarView;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="OceanSwellTopComponent", iconBase="org/esa/s1tbx/ocean/icons/ocean-swell22.png", persistenceType=2)
public class OceanSwellTopComponent
extends ToolTopComponent {
    private PolarView polarView;

    public OceanSwellTopComponent() {
        this.setDisplayName("Ocean Swell");
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.add(this.createControl(), "Center");
    }

    public JComponent createControl() {
        this.polarView = new PolarView();
        SnapApp snapApp = SnapApp.getDefault();
        snapApp.getProductManager().addListener((ProductManager.Listener)new OSWProductManagerListener(this.polarView));
        snapApp.getSelectionSupport(ProductNode.class).addHandler((SelectionSupport.Handler)new SelectionSupport.Handler<ProductNode>(){

            public void selectionChange(@NullAllowed ProductNode oldValue, @NullAllowed ProductNode newValue) {
                if (newValue != null) {
                    OceanSwellTopComponent.this.polarView.setProduct(newValue.getProduct());
                }
            }
        });
        this.polarView.setProduct(snapApp.getSelectedProduct(SnapApp.SelectionSourceHint.AUTO));
        return this.polarView;
    }

    void setSelectedRecord(Product product, int recNum) {
        this.polarView.setProduct(product);
        this.polarView.showPlot(recNum);
    }

    public static void setOSWRecord(final Product product, final int recNum) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OceanSwellTopComponent window = (OceanSwellTopComponent)WindowManager.getDefault().findTopComponent("OceanSwellTopComponent");
                if (window != null) {
                    window.open();
                    window.requestActive();
                    window.setSelectedRecord(product, recNum);
                }
            }
        });
    }

    public class OSWProductManagerListener
    implements ProductManager.Listener {
        private final PolarView polarView;

        public OSWProductManagerListener(PolarView polarView) {
            this.polarView = polarView;
        }

        public void productAdded(ProductManager.Event event) {
            this.polarView.setProduct(event.getProduct());
        }

        public void productRemoved(ProductManager.Event event) {
            this.polarView.removeProduct(event.getProduct());
        }
    }
}

