/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.ocean.toolviews.polarview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.s1tbx.ocean.toolviews.polarview.PolarView;

class ControlPanel
extends JPanel {
    private final PolarView polarView;
    private final JButton prevBtn = new JButton("Prev");
    private final JButton nextBtn = new JButton("Next");
    private final JLabel recordLabel = new JLabel();
    private final JButton zoomInBtn = new JButton("Zoom In");
    private final JButton zoomOutBtn = new JButton("Zoom Out");
    private boolean animate = false;
    private final JToggleButton animateBtn = new JToggleButton("Animate", this.animate);
    private JSlider recordSlider = null;

    ControlPanel(PolarView theView) {
        this.polarView = theView;
        this.createPanel();
        this.startUpdateTimer();
    }

    private void createPanel() {
        this.add(this.recordLabel);
        this.add(this.prevBtn);
        this.prevBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.polarView.showPreviousPlot();
            }
        });
        this.add(this.nextBtn);
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.polarView.showNextPlot();
            }
        });
        this.recordSlider = new JSlider(0, this.polarView.getNumRecords(), 0);
        this.recordSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ControlPanel.this.polarView.showPlot(ControlPanel.this.recordSlider.getValue());
            }
        });
        this.add(this.recordSlider);
        this.add(this.animateBtn);
        this.animateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.animate = !ControlPanel.this.animate;
                ControlPanel.this.updateControls();
            }
        });
    }

    public void updateControls() {
        int currentRecord = this.polarView.getCurrentRecord();
        int numRecords = this.polarView.getNumRecords();
        this.prevBtn.setEnabled(currentRecord > 0 && !this.animate);
        this.nextBtn.setEnabled(currentRecord < numRecords && !this.animate);
        this.recordSlider.setMinimum(0);
        this.recordSlider.setMaximum(this.polarView.getNumRecords());
        this.recordSlider.setValue(currentRecord);
        this.recordLabel.setText("Record " + (currentRecord + 1) + " of " + (numRecords + 1));
    }

    private void startUpdateTimer() {
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (ControlPanel.this.animate) {
                    if (ControlPanel.this.polarView.getCurrentRecord() >= ControlPanel.this.polarView.getNumRecords()) {
                        ControlPanel.this.polarView.showPlot(0);
                    } else {
                        ControlPanel.this.polarView.showNextPlot();
                    }
                }
            }
        }, 0L, 1000L);
    }
}

