/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.support;

import org.esa.s1tbx.insar.gpf.support.SARGeocoding;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.PosVector;
import org.esa.snap.engine_utilities.util.Maths;

public class SARPosition {
    private final double firstLineTime;
    private final double lastLineTime;
    private final double lineTimeInterval;
    private final double wavelength;
    private final double rangeSpacing;
    private final int sourceImageWidth;
    private final boolean srgrFlag;
    private final double nearEdgeSlantRange;
    private final boolean nearRangeOnLeft;
    private final SARGeocoding.Orbit orbit;
    private final AbstractMetadata.SRGRCoefficientList[] srgrConvParams;
    private int x0;
    private int y0;
    private int w;
    private int h;

    public SARPosition(double firstLineTime, double lastLineTime, double lineTimeInterval, double wavelength, double rangeSpacing, int sourceImageWidth, boolean srgrFlag, double nearEdgeSlantRange, boolean nearRangeOnLeft, SARGeocoding.Orbit orbit, AbstractMetadata.SRGRCoefficientList[] srgrConvParams) {
        this.firstLineTime = firstLineTime;
        this.lastLineTime = lastLineTime;
        this.lineTimeInterval = lineTimeInterval;
        this.wavelength = wavelength;
        this.rangeSpacing = rangeSpacing;
        this.sourceImageWidth = sourceImageWidth;
        this.srgrFlag = srgrFlag;
        this.nearEdgeSlantRange = nearEdgeSlantRange;
        this.nearRangeOnLeft = nearRangeOnLeft;
        this.orbit = orbit;
        this.srgrConvParams = srgrConvParams;
    }

    public void setTileConstraints(int x0, int y0, int w, int h) {
        this.x0 = x0;
        this.y0 = y0;
        this.w = w;
        this.h = h;
    }

    public boolean getPosition(PositionData data) {
        double zeroDopplerTime = SARGeocoding.getEarthPointZeroDopplerTime(this.firstLineTime, this.lineTimeInterval, this.wavelength, data.earthPoint, this.orbit.sensorPosition, this.orbit.sensorVelocity);
        if (zeroDopplerTime == -99999.0) {
            return false;
        }
        data.slantRange = SARGeocoding.computeSlantRange(zeroDopplerTime, this.orbit, data.earthPoint, data.sensorPos);
        data.azimuthIndex = (zeroDopplerTime - this.firstLineTime) / this.lineTimeInterval;
        if (data.azimuthIndex < 0.0 || this.h > 0 && (!(data.azimuthIndex >= (double)(this.y0 - 1)) || !(data.azimuthIndex <= (double)(this.y0 + this.h)))) {
            return false;
        }
        data.rangeIndex = !this.srgrFlag ? (data.slantRange - this.nearEdgeSlantRange) / this.rangeSpacing : this.computeRangeIndex(zeroDopplerTime, data.slantRange);
        if (!this.nearRangeOnLeft) {
            data.rangeIndex = (double)(this.sourceImageWidth - 1) - data.rangeIndex;
        }
        return data.rangeIndex >= 0.0 || this.w > 0 && data.rangeIndex >= (double)(this.x0 - 1) && data.rangeIndex <= (double)(this.x0 + this.w);
    }

    private double computeRangeIndex(double zeroDopplerTime, double slantRange) {
        if (zeroDopplerTime < Math.min(this.firstLineTime, this.lastLineTime) || zeroDopplerTime > Math.max(this.firstLineTime, this.lastLineTime)) {
            return -1.0;
        }
        if (this.srgrFlag) {
            if (this.srgrConvParams.length == 1) {
                double groundRange = SARGeocoding.computeGroundRange(this.sourceImageWidth, this.rangeSpacing, slantRange, this.srgrConvParams[0].coefficients, this.srgrConvParams[0].ground_range_origin);
                if (groundRange < 0.0) {
                    return -1.0;
                }
                return (groundRange - this.srgrConvParams[0].ground_range_origin) / this.rangeSpacing;
            }
            int idx = 0;
            int i = 0;
            while (i < this.srgrConvParams.length && zeroDopplerTime >= this.srgrConvParams[i].timeMJD) {
                idx = i++;
            }
            double[] srgrCoefficients = new double[this.srgrConvParams[idx].coefficients.length];
            if (idx == this.srgrConvParams.length - 1) {
                --idx;
            }
            double mu = (zeroDopplerTime - this.srgrConvParams[idx].timeMJD) / (this.srgrConvParams[idx + 1].timeMJD - this.srgrConvParams[idx].timeMJD);
            for (int i2 = 0; i2 < srgrCoefficients.length; ++i2) {
                srgrCoefficients[i2] = Maths.interpolationLinear((double)this.srgrConvParams[idx].coefficients[i2], (double)this.srgrConvParams[idx + 1].coefficients[i2], (double)mu);
            }
            double groundRange = SARGeocoding.computeGroundRange(this.sourceImageWidth, this.rangeSpacing, slantRange, srgrCoefficients, this.srgrConvParams[idx].ground_range_origin);
            if (groundRange < 0.0) {
                return -1.0;
            }
            return (groundRange - this.srgrConvParams[idx].ground_range_origin) / this.rangeSpacing;
        }
        return (slantRange - this.nearEdgeSlantRange) / this.rangeSpacing;
    }

    public static class PositionData {
        public final PosVector earthPoint = new PosVector();
        public final PosVector sensorPos = new PosVector();
        public double azimuthIndex;
        public double rangeIndex;
        public double slantRange;
    }
}

