/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.support;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationTable;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.WarpPolynomial;
import javax.media.jai.operator.DFTDescriptor;

public class JAIFunctions {
    public static PlanarImage dft(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(DFTDescriptor.SCALING_NONE);
        pb.add(DFTDescriptor.REAL_TO_COMPLEX);
        return JAI.create((String)"dft", (ParameterBlock)pb, null);
    }

    public static PlanarImage idft(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(DFTDescriptor.SCALING_DIMENSIONS);
        pb.add(DFTDescriptor.COMPLEX_TO_COMPLEX);
        return JAI.create((String)"idft", (ParameterBlock)pb, null);
    }

    public static PlanarImage conjugate(PlanarImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        return JAI.create((String)"conjugate", (ParameterBlock)pb, null);
    }

    public static PlanarImage multiplyComplex(PlanarImage image1, PlanarImage image2) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image1);
        pb.addSource(image2);
        return JAI.create((String)"MultiplyComplex", (ParameterBlock)pb, null);
    }

    public static RenderedImage upsampling(PlanarImage image, int rowUpSamplingFactor, int colUpSamplingFactor) {
        int topPad;
        int leftPad;
        int w = image.getWidth();
        int h = image.getHeight();
        int newWidth = rowUpSamplingFactor * w;
        int newHeight = colUpSamplingFactor * h;
        ParameterBlock pb1 = new ParameterBlock();
        pb1.addSource(image);
        pb1.add(w / 2);
        pb1.add(h / 2);
        RenderedOp shiftedImage = JAI.create((String)"PeriodicShift", (ParameterBlock)pb1, null);
        ParameterBlock pb2 = new ParameterBlock();
        int rightPad = leftPad = (newWidth - w) / 2;
        int bottomPad = topPad = (newHeight - h) / 2;
        pb2.addSource(shiftedImage);
        pb2.add(leftPad);
        pb2.add(rightPad);
        pb2.add(topPad);
        pb2.add(bottomPad);
        pb2.add(BorderExtender.createInstance((int)0));
        RenderedOp zeroPaddedImage = JAI.create((String)"border", (ParameterBlock)pb2);
        ParameterBlock pb3 = new ParameterBlock();
        pb3.addSource(zeroPaddedImage);
        pb3.add(1.0f * (float)leftPad);
        pb3.add(1.0f * (float)topPad);
        RenderedOp zeroBorderedImage = JAI.create((String)"translate", (ParameterBlock)pb3, null);
        ParameterBlock pb4 = new ParameterBlock();
        pb4.addSource(zeroBorderedImage);
        pb4.add(newWidth / 2);
        pb4.add(newHeight / 2);
        RenderedOp shiftedZeroPaddedImage = JAI.create((String)"PeriodicShift", (ParameterBlock)pb4, null);
        return shiftedZeroPaddedImage;
    }

    public static PlanarImage magnitude(PlanarImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        return JAI.create((String)"magnitude", (ParameterBlock)pb, null);
    }

    public static double getMean(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(null);
        pb.add(1);
        pb.add(1);
        RenderedOp meanImage = JAI.create((String)"mean", (ParameterBlock)pb, null);
        double[] mean = (double[])meanImage.getProperty("mean");
        return mean[0];
    }

    public static double getMax(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(null);
        pb.add(1);
        pb.add(1);
        RenderedOp op = JAI.create((String)"extrema", (ParameterBlock)pb);
        double[][] extrema = (double[][])op.getProperty("extrema");
        return extrema[1][0];
    }

    public static RenderedOp createWarpImage(WarpPolynomial warp, RenderedImage srcImage, Interpolation interp, InterpolationTable interpTable) {
        ParameterBlock pb1 = new ParameterBlock();
        pb1.addSource(srcImage);
        pb1.add(4);
        RenderedOp srcImageFloat = JAI.create((String)"format", (ParameterBlock)pb1);
        if (warp == null) {
            return srcImageFloat;
        }
        ParameterBlock pb2 = new ParameterBlock();
        pb2.addSource(srcImageFloat);
        pb2.add(warp);
        if (interp != null) {
            pb2.add(interp);
        } else if (interpTable != null) {
            pb2.add(interpTable);
        }
        return JAI.create((String)"warp", (ParameterBlock)pb2);
    }
}

