/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.coregistration;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationTable;
import javax.media.jai.RenderedOp;
import org.esa.s1tbx.insar.gpf.coregistration.WarpData;
import org.esa.s1tbx.insar.gpf.support.JAIFunctions;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GcpDescriptor;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.jlinda.core.Orbit;
import org.jlinda.core.SLCImage;
import org.jlinda.core.Window;
import org.jlinda.core.coregistration.CPM;
import org.jlinda.core.coregistration.PolynomialModel;
import org.jlinda.core.coregistration.SimpleLUT;
import org.jlinda.nest.gpf.coregistration.GCPManager;

@OperatorMetadata(alias="Warp", category="Radar/Coregistration", authors="Jun Lu, Luis Veci, Petar Marinkovic", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Create Warp Function And Get Co-registrated Images")
public class WarpOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="Confidence level for outlier detection procedure, lower value accepts more outliers", valueSet={"0.001", "0.05", "0.1", "0.5", "1.0"}, defaultValue="0.05", label="Significance Level for Outlier Removal")
    private float rmsThreshold = 0.05f;
    private float cpmWtestCriticalValue;
    @Parameter(description="The order of WARP polynomial function", valueSet={"1", "2", "3"}, defaultValue="2", label="Warp Polynomial Order")
    private int warpPolynomialOrder = 2;
    @Parameter(valueSet={"Nearest-neighbor interpolation", "Bilinear interpolation", "Bicubic interpolation", "Bicubic2 interpolation", "Linear interpolation", "Cubic convolution (4 points)", "Cubic convolution (6 points)", "Truncated sinc (6 points)", "Truncated sinc (8 points)", "Truncated sinc (16 points)"}, defaultValue="Cubic convolution (6 points)", label="Interpolation Method")
    private String interpolationMethod = "Cubic convolution (6 points)";
    private boolean inSAROptimized = true;
    @Parameter(description="Refine estimated offsets using a-priori DEM", defaultValue="false", label="Offset Refinement Based on DEM")
    private Boolean demRefinement = false;
    @Parameter(description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(defaultValue="false")
    private boolean excludeMaster = false;
    private Interpolation interp;
    private InterpolationTable interpTable;
    @Parameter(description="Show the Residuals file in a text viewer", defaultValue="false", label="Show Residuals")
    private Boolean openResidualsFile;
    private Band masterBand;
    private boolean complexCoregistration;
    private boolean warpDataAvailable;
    public static final String NEAREST_NEIGHBOR = "Nearest-neighbor interpolation";
    public static final String BILINEAR = "Bilinear interpolation";
    public static final String BICUBIC = "Bicubic interpolation";
    public static final String BICUBIC2 = "Bicubic2 interpolation";
    public static final String TRI = "Linear interpolation";
    public static final String CC4P = "Cubic convolution (4 points)";
    public static final String CC6P = "Cubic convolution (6 points)";
    public static final String TS6P = "Truncated sinc (6 points)";
    public static final String TS8P = "Truncated sinc (8 points)";
    public static final String TS16P = "Truncated sinc (16 points)";
    private final Map<Band, Band> sourceRasterMap = new HashMap<Band, Band>(10);
    private final Map<Band, Band> complexSrcMap = new HashMap<Band, Band>(10);
    private final Map<Band, PolynomialModel> warpDataMap = new HashMap<Band, PolynomialModel>(10);
    private String processedSlaveBand;
    private String[] masterBandNames;
    private static final int ORBIT_INTERP_DEGREE = 3;
    float demNoDataValue = 0.0f;
    private ElevationModel dem;
    private int maxIterations = 20;

    public void initialize() throws OperatorException {
        try {
            File residualsFile = WarpOp.getResidualsFile(this.sourceProduct);
            if (residualsFile.exists()) {
                residualsFile.delete();
            }
            this.getMasterBands();
            if (this.complexCoregistration) {
                if (this.demRefinement == null) {
                    this.demRefinement = false;
                }
                if (this.rmsThreshold == 0.001f) {
                    this.cpmWtestCriticalValue = 3.2905266f;
                    this.inSAROptimized = true;
                } else if (this.rmsThreshold == 0.05f) {
                    this.cpmWtestCriticalValue = 1.959964f;
                    this.inSAROptimized = true;
                } else if (this.rmsThreshold == 0.1f) {
                    this.cpmWtestCriticalValue = 1.6448536f;
                    this.inSAROptimized = true;
                } else {
                    this.cpmWtestCriticalValue = 1.0f;
                }
            } else {
                this.inSAROptimized = false;
                this.demRefinement = false;
            }
            switch (this.interpolationMethod) {
                case "Nearest-neighbor interpolation": {
                    this.interp = Interpolation.getInstance((int)0);
                    break;
                }
                case "Bilinear interpolation": {
                    this.interp = Interpolation.getInstance((int)1);
                    break;
                }
                case "Bicubic interpolation": {
                    this.interp = Interpolation.getInstance((int)2);
                    break;
                }
                case "Bicubic2 interpolation": {
                    this.interp = Interpolation.getInstance((int)3);
                    break;
                }
                case "Cubic convolution (4 points)": {
                    this.constructInterpolationTable(CC4P);
                    break;
                }
                case "Cubic convolution (6 points)": {
                    this.constructInterpolationTable(CC6P);
                    break;
                }
                case "Truncated sinc (6 points)": {
                    this.constructInterpolationTable(TS6P);
                    break;
                }
                case "Truncated sinc (8 points)": {
                    this.constructInterpolationTable(TS8P);
                    break;
                }
                case "Truncated sinc (16 points)": {
                    this.constructInterpolationTable(TS16P);
                    break;
                }
                default: {
                    this.interp = Interpolation.getInstance((int)1);
                }
            }
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            if (absRoot != null) {
                this.processedSlaveBand = absRoot.getAttributeString("processed_slave");
            }
            this.createTargetProduct();
        }
        catch (Throwable e) {
            this.openResidualsFile = true;
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getMasterBands() {
        String[] masterBandNames;
        String mstBandName = this.sourceProduct.getBandAt(0).getName();
        for (String bandName : masterBandNames = StackUtils.getMasterBandNames((Product)this.sourceProduct)) {
            String mstPol = OperatorUtils.getPolarizationFromBandName((String)bandName);
            if (mstPol == null || !mstPol.equals("hh") && !mstPol.equals("vv")) continue;
            mstBandName = bandName;
            break;
        }
        this.masterBand = this.sourceProduct.getBand(mstBandName);
        if (this.masterBand.getUnit() != null && this.masterBand.getUnit().equals("real")) {
            int mstIdx = this.sourceProduct.getBandIndex(mstBandName);
            if (this.sourceProduct.getNumBands() > mstIdx + 1) {
                this.complexCoregistration = true;
            }
        }
    }

    private void addSlaveGCPs(PolynomialModel warpData, String bandName) {
        GeoCoding targetGeoCoding = this.targetProduct.getSceneGeoCoding();
        String newName = this.excludeMaster ? StackUtils.getBandNameWithoutDate((String)bandName) : bandName;
        ProductNodeGroup targetGCPGroup = GCPManager.instance().getGcpGroup(this.targetProduct.getBand(newName));
        targetGCPGroup.removeAll();
        List slaveGCPList = warpData.getSlaveGCPList();
        for (Placemark sPin : slaveGCPList) {
            Placemark tPin = Placemark.createPointPlacemark((PlacemarkDescriptor)GcpDescriptor.getInstance(), (String)sPin.getName(), (String)sPin.getLabel(), (String)sPin.getDescription(), (PixelPos)sPin.getPixelPos(), (GeoPos)sPin.getGeoPos(), (GeoCoding)targetGeoCoding);
            targetGCPGroup.add((ProductNode)tPin);
        }
    }

    private String formatName(Band srcBand) {
        String name = srcBand.getName();
        if (this.excludeMaster) {
            String newName = StackUtils.getBandNameWithoutDate((String)name);
            if (name.equals(this.processedSlaveBand)) {
                this.processedSlaveBand = newName;
            }
            return newName;
        }
        return name;
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.masterBandNames = StackUtils.getMasterBandNames((Product)this.sourceProduct);
        Band[] sourceBands = this.sourceProduct.getBands();
        for (int i = 0; i < sourceBands.length; ++i) {
            Band targetBandQ;
            Band targetBand;
            Band srcBand = sourceBands[i];
            String srcBandName = srcBand.getName();
            if (StringUtils.contains((String[])this.masterBandNames, (String)srcBandName)) {
                if (this.excludeMaster || this.targetProduct.getBand(srcBandName) != null) continue;
                targetBand = ProductUtils.copyBand((String)srcBandName, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
                targetBand.setSourceImage(srcBand.getSourceImage());
            } else {
                String targetBandName = this.formatName(srcBand);
                if (this.targetProduct.getBand(targetBandName) != null) continue;
                targetBand = this.targetProduct.addBand(targetBandName, 30);
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBand, (RasterDataNode)targetBand);
            }
            this.sourceRasterMap.put(targetBand, srcBand);
            if (!this.complexCoregistration) continue;
            Band srcBandQ = this.sourceProduct.getBandAt(i + 1);
            if (StringUtils.contains((String[])this.masterBandNames, (String)srcBandName)) {
                if (this.targetProduct.getBand(srcBandQ.getName()) != null) continue;
                targetBandQ = ProductUtils.copyBand((String)srcBandQ.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
                targetBandQ.setSourceImage(srcBandQ.getSourceImage());
            } else {
                String targetBandName = this.formatName(srcBandQ);
                if (this.targetProduct.getBand(targetBandName) != null) continue;
                targetBandQ = this.targetProduct.addBand(targetBandName, 30);
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBandQ, (RasterDataNode)targetBandQ);
            }
            this.sourceRasterMap.put(targetBandQ, srcBandQ);
            this.complexSrcMap.put(srcBandQ, srcBand);
            String suffix = "";
            if (this.excludeMaster) {
                String pol = OperatorUtils.getPolarizationFromBandName((String)srcBand.getName());
                if (pol != null && !pol.isEmpty()) {
                    suffix = '_' + pol.toUpperCase();
                }
            } else {
                suffix = '_' + OperatorUtils.getSuffixFromBandName((String)srcBand.getName());
            }
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)targetBand, (Band)targetBandQ, (String)suffix);
            ++i;
        }
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.updateTargetProductMetadata();
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (this.excludeMaster) {
            String[] slaveNames = StackUtils.getSlaveProductNames((Product)this.sourceProduct);
            absTgt.setAttributeString("PRODUCT", slaveNames[0]);
            ProductData.UTC[] times = StackUtils.getProductTimes((Product)this.sourceProduct);
            this.targetProduct.setStartTime(times[1]);
            double lineTimeInterval = absTgt.getAttributeDouble("line_time_interval");
            int height = this.sourceProduct.getSceneRasterHeight();
            ProductData.UTC endTime = new ProductData.UTC(times[1].getMJD() + lineTimeInterval * (double)height / 86400.0);
            this.targetProduct.setEndTime(endTime);
        } else {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"coregistered_stack", (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetRectangle = targetTile.getRectangle();
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        try {
            Band srcBand;
            if (!this.warpDataAvailable) {
                if (this.demRefinement.booleanValue()) {
                    this.createDEM();
                }
                this.getWarpData(targetRectangle);
            }
            if ((srcBand = this.sourceRasterMap.get(targetBand)) == null) {
                return;
            }
            Band realSrcBand = this.complexSrcMap.get(srcBand);
            if (realSrcBand == null) {
                realSrcBand = srcBand;
            }
            Tile sourceRaster = this.getSourceTile((RasterDataNode)srcBand, targetRectangle);
            if (pm.isCanceled()) {
                return;
            }
            PolynomialModel warpData = this.warpDataMap.get(realSrcBand);
            if (!warpData.isValid()) {
                return;
            }
            MultiLevelImage srcImage = sourceRaster.getRasterDataNode().getSourceImage();
            RenderedOp warpedImage = JAIFunctions.createWarpImage(warpData.getJAIWarp(), (RenderedImage)srcImage, this.interp, this.interpTable);
            float[] dataArray = warpedImage.getData(targetRectangle).getSamples(x0, y0, w, h, 0, (float[])null);
            targetTile.setRawSamples(ProductData.createInstance((float[])dataArray));
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private synchronized void createDEM() throws IOException {
        Resampling resampling = ResamplingFactory.createResampling((String)"BILINEAR_INTERPOLATION");
        if (this.dem != null) {
            return;
        }
        ElevationModelRegistry elevationModelRegistry = ElevationModelRegistry.getInstance();
        ElevationModelDescriptor demDescriptor = elevationModelRegistry.getDescriptor(this.demName);
        if (demDescriptor == null) {
            throw new OperatorException("The DEM '" + this.demName + "' is not supported.");
        }
        this.dem = demDescriptor.createDem(resampling);
        if (this.dem == null) {
            throw new OperatorException("The DEM '" + this.demName + "' has not been installed.");
        }
        this.demNoDataValue = demDescriptor.getNoDataValue();
    }

    private synchronized void getWarpData(Rectangle targetRectangle) throws Exception {
        if (this.warpDataAvailable) {
            return;
        }
        Band targetBand = this.targetProduct.getBand(this.processedSlaveBand);
        Tile sourceRaster = this.getSourceTile((RasterDataNode)this.sourceRasterMap.get(targetBand), targetRectangle);
        ProductNodeGroup masterGCPGroup = GCPManager.instance().getGcpGroup(this.masterBand);
        Window masterWindow = new Window(0L, (long)this.sourceProduct.getSceneRasterHeight(), 0L, (long)this.sourceProduct.getSceneRasterWidth());
        SLCImage masterMeta = null;
        Orbit masterOrbit = null;
        if (this.demRefinement.booleanValue()) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
            masterMeta = new SLCImage(absRoot, this.targetProduct);
            masterOrbit = new Orbit(absRoot, 3);
        }
        boolean appendFlag = false;
        int slaveMetaCnt = 0;
        Band[] sourceBands = this.sourceProduct.getBands();
        for (int i = 0; i < sourceBands.length; ++i) {
            Band srcBand = this.sourceProduct.getBandAt(i);
            if (StringUtils.contains((String[])this.masterBandNames, (String)srcBand.getName()) || this.complexCoregistration && !srcBand.getUnit().equals("real")) continue;
            ProductNodeGroup slaveGCPGroup = GCPManager.instance().getGcpGroup(srcBand);
            if (slaveGCPGroup.getNodeCount() < 3) {
                String slvProductName = StackUtils.getSlaveProductName((Product)this.sourceProduct, (Band)srcBand, null);
                for (Band band : this.sourceProduct.getBands()) {
                    if (band == srcBand) continue;
                    String productName = StackUtils.getSlaveProductName((Product)this.sourceProduct, (Band)band, null);
                    if (slvProductName != null && slvProductName.equals(productName) && (slaveGCPGroup = GCPManager.instance().getGcpGroup(band)).getNodeCount() >= 3) break;
                }
            }
            if (this.inSAROptimized) {
                CPM cpm = new CPM(this.warpPolynomialOrder, this.maxIterations, this.cpmWtestCriticalValue, masterWindow, masterGCPGroup, slaveGCPGroup);
                this.warpDataMap.put(srcBand, (PolynomialModel)cpm);
                int nodeCount = slaveGCPGroup.getNodeCount();
                if (nodeCount < 3) {
                    cpm.noRedundancy = true;
                    continue;
                }
                if (this.demRefinement.booleanValue() && !cpm.noRedundancy) {
                    double[] heightArray = new double[nodeCount];
                    ArrayList<ProductNode> slaveGCPList = new ArrayList<ProductNode>();
                    for (int j = 0; j < nodeCount; ++j) {
                        slaveGCPList.add(slaveGCPGroup.get(j));
                        Placemark sPin = (Placemark)slaveGCPList.get(j);
                        Placemark mPin = (Placemark)masterGCPGroup.get(sPin.getName());
                        PixelPos mGCPPos = mPin.getPixelPos();
                        double[] phiLamPoint = masterOrbit.lph2ell(mGCPPos.y, mGCPPos.x, 0.0, masterMeta);
                        PixelPos demIndexPoint = this.dem.getIndex(new GeoPos(phiLamPoint[0] * 57.29577951308232, phiLamPoint[1] * 57.29577951308232));
                        double height = this.dem.getSample(demIndexPoint.x, demIndexPoint.y);
                        if (Double.isNaN(height)) {
                            height = this.demNoDataValue;
                        }
                        heightArray[j] = height;
                    }
                    MetadataElement slaveRoot = this.targetProduct.getMetadataRoot().getElement("Slave_Metadata").getElementAt(slaveMetaCnt);
                    SLCImage slaveMeta = new SLCImage(slaveRoot, this.targetProduct);
                    Orbit slaveOrbit = new Orbit(slaveRoot, 3);
                    cpm.setDemNoDataValue(this.demNoDataValue);
                    cpm.setUpDEMRefinement(masterMeta, masterOrbit, slaveMeta, slaveOrbit, heightArray);
                    cpm.setUpDemOffset();
                }
                cpm.computeCPM();
                cpm.computeEstimationStats();
                cpm.wrapJaiWarpPolynomial();
                if (cpm.noRedundancy) continue;
                if (!appendFlag) {
                    appendFlag = true;
                }
                this.addSlaveGCPs((PolynomialModel)cpm, srcBand.getName());
                continue;
            }
            WarpData warpData = new WarpData((ProductNodeGroup<Placemark>)slaveGCPGroup);
            this.warpDataMap.put(srcBand, warpData);
            if (slaveGCPGroup.getNodeCount() < 3) {
                warpData.setInValid();
                continue;
            }
            warpData.computeWARPPolynomialFromGCPs(this.sourceProduct, srcBand, this.warpPolynomialOrder, (ProductNodeGroup<Placemark>)masterGCPGroup, this.maxIterations, this.rmsThreshold, appendFlag);
            if (!warpData.isValid()) continue;
            if (!appendFlag) {
                appendFlag = true;
            }
            this.addSlaveGCPs(warpData, targetBand.getName());
        }
        this.announceGCPWarning();
        GCPManager.instance().removeAllGcpGroups();
        if (this.openResidualsFile.booleanValue()) {
            File residualsFile = WarpOp.getResidualsFile(this.sourceProduct);
            if (Desktop.isDesktopSupported() && residualsFile.exists()) {
                try {
                    Desktop.getDesktop().open(residualsFile);
                }
                catch (Exception e) {
                    SystemUtils.LOG.warning("Error opening residuals file " + e.getMessage());
                }
            }
        }
        this.writeWarpDataToMetadata();
        this.warpDataAvailable = true;
    }

    private void writeWarpDataToMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        Set<Band> bandSet = this.warpDataMap.keySet();
        for (Band band : bandSet) {
            MetadataElement bandElem = AbstractMetadata.getBandAbsMetadata((MetadataElement)absRoot, (String)band.getName(), (boolean)true);
            MetadataElement warpDataElem = bandElem.getElement("WarpData");
            if (warpDataElem == null) {
                warpDataElem = new MetadataElement("WarpData");
                bandElem.addElement(warpDataElem);
            } else {
                MetadataAttribute[] attribList;
                for (MetadataAttribute attrib : attribList = warpDataElem.getAttributes()) {
                    warpDataElem.removeAttribute(attrib);
                }
            }
            PolynomialModel warpData = this.warpDataMap.get(band);
            if (warpData.getNumObservations() > 0) {
                for (int i = 0; i < warpData.getNumObservations(); ++i) {
                    MetadataElement gcpElem = new MetadataElement("GCP" + i);
                    warpDataElem.addElement(gcpElem);
                    gcpElem.setAttributeDouble("mst_x", warpData.getXMasterCoord(i));
                    gcpElem.setAttributeDouble("mst_y", warpData.getYMasterCoord(i));
                    gcpElem.setAttributeDouble("slv_x", warpData.getXSlaveCoord(i));
                    gcpElem.setAttributeDouble("slv_y", warpData.getYSlaveCoord(i));
                    if (!warpData.isValid()) continue;
                    gcpElem.setAttributeDouble("rms", warpData.getRMS(i));
                }
            }
            warpDataElem.setAttributeDouble("rmsStd", warpData.getRMSStd());
            warpDataElem.setAttributeDouble("rmsMean", warpData.getRMSMean());
            warpDataElem.setAttributeDouble("rowResidualStd", warpData.getRowResidualStd());
            warpDataElem.setAttributeDouble("rowResidualMean", warpData.getRowResidualMean());
            warpDataElem.setAttributeDouble("colResidualStd", warpData.getColResidualStd());
            warpDataElem.setAttributeDouble("colResidualMean", warpData.getColResidualMean());
        }
    }

    private void constructInterpolationTable(String interpolationMethod) {
        SimpleLUT lut = new SimpleLUT(interpolationMethod);
        lut.constructLUT();
        int kernelLength = lut.getKernelLength();
        double[] lutArrayDoubles = lut.getKernelAsArray();
        float[] lutArrayFloats = new float[lutArrayDoubles.length];
        int i = 0;
        for (double lutElement : lutArrayDoubles) {
            lutArrayFloats[i++] = (float)lutElement;
        }
        int subsampleBits = 7;
        int precisionBits = 32;
        int padding = kernelLength / 2 - 1;
        this.interpTable = new InterpolationTable(padding, kernelLength, 7, 32, lutArrayFloats);
    }

    private static File getResidualsFile(Product sourceProduct) {
        String fileName = sourceProduct.getName() + "_residual.txt";
        return new File(ResourceUtils.getReportFolder(), fileName);
    }

    private void announceGCPWarning() {
        String msg = "";
        for (Band srcBand : this.sourceProduct.getBands()) {
            PolynomialModel warpData = this.warpDataMap.get(srcBand);
            if (warpData == null || warpData.isValid()) continue;
            msg = msg + srcBand.getName() + " does not have enough valid GCPs for the warp\n";
            this.openResidualsFile = true;
        }
        if (!msg.isEmpty()) {
            SystemUtils.LOG.warning(msg);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(WarpOp.class);
        }
    }
}

