/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.coregistration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.WarpPolynomial;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.jlinda.core.coregistration.PolynomialModel;

public class WarpData
implements PolynomialModel {
    public final List<Placemark> slaveGCPList = new ArrayList<Placemark>();
    private WarpPolynomial jaiWarp = null;
    private double[] xCoef = null;
    private double[] yCoef = null;
    private int numValidGCPs = 0;
    private boolean notEnoughGCPs = false;
    private float[] rms = null;
    private float[] rowResiduals = null;
    private float[] colResiduals = null;
    private float[] masterGCPCoords = null;
    private float[] slaveGCPCoords = null;
    private double rmsStd = 0.0;
    private double rmsMean = 0.0;
    private double rowResidualStd = 0.0;
    private double rowResidualMean = 0.0;
    private double colResidualStd = 0.0;
    private double colResidualMean = 0.0;

    public WarpData(ProductNodeGroup<Placemark> slaveGCPGroup) {
        for (int i = 0; i < slaveGCPGroup.getNodeCount(); ++i) {
            this.slaveGCPList.add((Placemark)slaveGCPGroup.get(i));
        }
    }

    public double getRMSStd() {
        return this.rmsStd;
    }

    public double getRMSMean() {
        return this.rmsMean;
    }

    public double getRowResidualStd() {
        return this.rowResidualStd;
    }

    public double getRowResidualMean() {
        return this.rowResidualMean;
    }

    public double getColResidualStd() {
        return this.colResidualStd;
    }

    public double getColResidualMean() {
        return this.colResidualMean;
    }

    public boolean isValid() {
        return !this.notEnoughGCPs;
    }

    public void setInValid() {
        this.notEnoughGCPs = true;
    }

    public int getNumValidGCPs() {
        return this.numValidGCPs;
    }

    public WarpPolynomial getJAIWarp() {
        return this.jaiWarp;
    }

    public int getNumObservations() {
        return this.numValidGCPs;
    }

    public double getRMS(int index) {
        return this.rms[index];
    }

    public double getXMasterCoord(int index) {
        return this.masterGCPCoords[2 * index];
    }

    public double getYMasterCoord(int index) {
        return this.masterGCPCoords[2 * index + 1];
    }

    public double getXSlaveCoord(int index) {
        return this.slaveGCPCoords[2 * index];
    }

    public double getYSlaveCoord(int index) {
        return this.slaveGCPCoords[2 * index + 1];
    }

    public List<Placemark> getSlaveGCPList() {
        return this.slaveGCPList;
    }

    public void computeWARP(int warpPolynomialOrder) {
        float sum = 0.0f;
        for (int i = 0; i < this.slaveGCPCoords.length; ++i) {
            sum += Math.abs(this.slaveGCPCoords[i] - this.masterGCPCoords[i]);
        }
        if ((double)sum < 0.01) {
            if (warpPolynomialOrder < 1) {
                throw new OperatorException("Incorrect WARP degree");
            }
            int coefLen = (warpPolynomialOrder + 1) * (warpPolynomialOrder + 2) / 2;
            this.xCoef = new double[coefLen];
            this.yCoef = new double[coefLen];
            for (int i = 0; i < coefLen; ++i) {
                this.xCoef[i] = 0.0;
                this.yCoef[i] = 0.0;
            }
            this.xCoef[1] = 1.0;
            this.yCoef[2] = 1.0;
            this.jaiWarp = null;
            return;
        }
        this.jaiWarp = WarpPolynomial.createWarp((float[])this.slaveGCPCoords, (int)0, (float[])this.masterGCPCoords, (int)0, (int)(2 * this.numValidGCPs), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)warpPolynomialOrder);
        float[] jaiXCoefs = this.jaiWarp.getXCoeffs();
        float[] jaiYCoefs = this.jaiWarp.getYCoeffs();
        int size = jaiXCoefs.length;
        this.xCoef = new double[size];
        this.yCoef = new double[size];
        for (int i = 0; i < size; ++i) {
            this.xCoef[i] = jaiXCoefs[i];
            this.yCoef[i] = jaiYCoefs[i];
        }
    }

    public void computeWARPPolynomialFromGCPs(Product sourceProduct, Band srcBand, int warpPolynomialOrder, ProductNodeGroup<Placemark> masterGCPGroup, int maxIterations, float rmsThreshold, boolean appendFlag) {
        float threshold = 0.0f;
        for (int iter = 0; iter < maxIterations; ++iter) {
            boolean append;
            if (iter == 0) {
                append = appendFlag;
            } else {
                append = true;
                threshold = iter < maxIterations - 1 && this.rmsMean > (double)rmsThreshold ? (float)(this.rmsMean + this.rmsStd) : rmsThreshold;
            }
            if (threshold > 0.0f) {
                this.eliminateGCPsBasedOnRMS(threshold);
            }
            this.computeWARPPolynomial(warpPolynomialOrder, masterGCPGroup);
            WarpData.outputCoRegistrationInfo(sourceProduct, warpPolynomialOrder, this, append, threshold, iter, srcBand.getName());
            if (this.notEnoughGCPs || iter > 0 && threshold <= rmsThreshold) break;
        }
    }

    private void computeWARPPolynomial(int warpPolynomialOrder, ProductNodeGroup<Placemark> masterGCPGroup) {
        this.getNumOfValidGCPs(warpPolynomialOrder);
        this.getMasterAndSlaveGCPCoordinates(masterGCPGroup);
        if (this.notEnoughGCPs) {
            return;
        }
        this.computeWARP(warpPolynomialOrder);
        this.computeRMS(warpPolynomialOrder);
    }

    private void getNumOfValidGCPs(int warpPolynomialOrder) throws OperatorException {
        this.numValidGCPs = this.slaveGCPList.size();
        int requiredGCPs = (warpPolynomialOrder + 2) * (warpPolynomialOrder + 1) / 2;
        if (this.numValidGCPs < requiredGCPs) {
            this.notEnoughGCPs = true;
        }
    }

    private void getMasterAndSlaveGCPCoordinates(ProductNodeGroup<Placemark> masterGCPGroup) {
        this.masterGCPCoords = new float[2 * this.numValidGCPs];
        this.slaveGCPCoords = new float[2 * this.numValidGCPs];
        for (int i = 0; i < this.numValidGCPs; ++i) {
            Placemark sPin = this.slaveGCPList.get(i);
            PixelPos sGCPPos = sPin.getPixelPos();
            Placemark mPin = (Placemark)masterGCPGroup.get(sPin.getName());
            PixelPos mGCPPos = mPin.getPixelPos();
            int j = 2 * i;
            this.masterGCPCoords[j] = (float)mGCPPos.x;
            this.masterGCPCoords[j + 1] = (float)mGCPPos.y;
            this.slaveGCPCoords[j] = (float)sGCPPos.x;
            this.slaveGCPCoords[j + 1] = (float)sGCPPos.y;
        }
    }

    private void computeRMS(int warpPolynomialOrder) {
        this.rms = new float[this.numValidGCPs];
        this.colResiduals = new float[this.numValidGCPs];
        this.rowResiduals = new float[this.numValidGCPs];
        PixelPos slavePos = new PixelPos(0.0, 0.0);
        for (int i = 0; i < this.rms.length; ++i) {
            int i2 = 2 * i;
            this.getWarpedCoords(warpPolynomialOrder, this.masterGCPCoords[i2], this.masterGCPCoords[i2 + 1], slavePos);
            double dX = slavePos.x - (double)this.slaveGCPCoords[i2];
            double dY = slavePos.y - (double)this.slaveGCPCoords[i2 + 1];
            this.colResiduals[i] = (float)dX;
            this.rowResiduals[i] = (float)dY;
            this.rms[i] = (float)Math.sqrt(dX * dX + dY * dY);
        }
        this.rmsMean = 0.0;
        this.rowResidualMean = 0.0;
        this.colResidualMean = 0.0;
        double rms2Mean = 0.0;
        double rowResidual2Mean = 0.0;
        double colResidual2Mean = 0.0;
        for (int i = 0; i < this.rms.length; ++i) {
            this.rmsMean += (double)this.rms[i];
            rms2Mean += (double)(this.rms[i] * this.rms[i]);
            this.rowResidualMean += (double)this.rowResiduals[i];
            rowResidual2Mean += (double)(this.rowResiduals[i] * this.rowResiduals[i]);
            this.colResidualMean += (double)this.colResiduals[i];
            colResidual2Mean += (double)(this.colResiduals[i] * this.colResiduals[i]);
        }
        this.rmsMean /= (double)this.rms.length;
        this.rowResidualMean /= (double)this.rms.length;
        this.colResidualMean /= (double)this.rms.length;
        this.rmsStd = Math.sqrt((rms2Mean /= (double)this.rms.length) - this.rmsMean * this.rmsMean);
        this.rowResidualStd = Math.sqrt((rowResidual2Mean /= (double)this.rms.length) - this.rowResidualMean * this.rowResidualMean);
        this.colResidualStd = Math.sqrt((colResidual2Mean /= (double)this.rms.length) - this.colResidualMean * this.colResidualMean);
    }

    private boolean eliminateGCPsBasedOnRMS(float threshold) {
        ArrayList<Placemark> pinList = new ArrayList<Placemark>();
        if (this.slaveGCPList.size() < this.rms.length) {
            this.notEnoughGCPs = true;
            return true;
        }
        for (int i = 0; i < this.rms.length; ++i) {
            if (!(this.rms[i] >= threshold)) continue;
            pinList.add(this.slaveGCPList.get(i));
        }
        for (Placemark aPin : pinList) {
            this.slaveGCPList.remove(aPin);
        }
        return !pinList.isEmpty();
    }

    public void getWarpedCoords(int warpPolynomialOrder, double mX, double mY, PixelPos slavePos) throws OperatorException {
        double[] xCoeffs = this.xCoef;
        double[] yCoeffs = this.yCoef;
        if (xCoeffs.length != yCoeffs.length) {
            throw new OperatorException("WARP has different number of coefficients for X and Y");
        }
        int numOfCoeffs = xCoeffs.length;
        switch (warpPolynomialOrder) {
            case 1: {
                if (numOfCoeffs != 3) {
                    throw new OperatorException("Number of WARP coefficients do not match WARP degree");
                }
                slavePos.x = xCoeffs[0] + xCoeffs[1] * mX + xCoeffs[2] * mY;
                slavePos.y = yCoeffs[0] + yCoeffs[1] * mX + yCoeffs[2] * mY;
                break;
            }
            case 2: {
                if (numOfCoeffs != 6) {
                    throw new OperatorException("Number of WARP coefficients do not match WARP degree");
                }
                double mXmX = mX * mX;
                double mXmY = mX * mY;
                double mYmY = mY * mY;
                slavePos.x = xCoeffs[0] + xCoeffs[1] * mX + xCoeffs[2] * mY + xCoeffs[3] * mXmX + xCoeffs[4] * mXmY + xCoeffs[5] * mYmY;
                slavePos.y = yCoeffs[0] + yCoeffs[1] * mX + yCoeffs[2] * mY + yCoeffs[3] * mXmX + yCoeffs[4] * mXmY + yCoeffs[5] * mYmY;
                break;
            }
            case 3: {
                if (numOfCoeffs != 10) {
                    throw new OperatorException("Number of WARP coefficients do not match WARP degree");
                }
                double mXmX = mX * mX;
                double mXmY = mX * mY;
                double mYmY = mY * mY;
                slavePos.x = xCoeffs[0] + xCoeffs[1] * mX + xCoeffs[2] * mY + xCoeffs[3] * mXmX + xCoeffs[4] * mXmY + xCoeffs[5] * mYmY + xCoeffs[6] * mXmX * mX + xCoeffs[7] * mX * mXmY + xCoeffs[8] * mXmY * mY + xCoeffs[9] * mYmY * mY;
                slavePos.y = yCoeffs[0] + yCoeffs[1] * mX + yCoeffs[2] * mY + yCoeffs[3] * mXmX + yCoeffs[4] * mXmY + yCoeffs[5] * mYmY + yCoeffs[6] * mXmX * mX + yCoeffs[7] * mX * mXmY + yCoeffs[8] * mXmY * mY + yCoeffs[9] * mYmY * mY;
                break;
            }
            default: {
                throw new OperatorException("Incorrect WARP degree");
            }
        }
    }

    private static void outputCoRegistrationInfo(Product sourceProduct, int warpPolynomialOrder, WarpData warpData, boolean appendFlag, float threshold, int parseIndex, String bandName) throws OperatorException {
        File residualFile = WarpData.getResidualsFile(sourceProduct);
        try (PrintStream p = null;){
            FileOutputStream out = new FileOutputStream(residualFile.getAbsolutePath(), appendFlag);
            p = new PrintStream(out);
            p.println();
            if (!appendFlag) {
                p.println();
                p.format("Transformation degree = %d", warpPolynomialOrder);
                p.println();
            }
            p.println();
            p.print("------------------------ Band: " + bandName + " (Parse " + parseIndex + ") ------------------------");
            p.println();
            if (!warpData.notEnoughGCPs) {
                p.println();
                p.println("WARP coefficients:");
                for (double xCoeff : warpData.xCoef) {
                    p.print((float)xCoeff + ", ");
                }
                p.println();
                for (double yCoeff : warpData.yCoef) {
                    p.print((float)yCoeff + ", ");
                }
                p.println();
            }
            if (appendFlag) {
                p.println();
                p.format("RMS Threshold: %5.3f", Float.valueOf(threshold));
                p.println();
            }
            p.println();
            if (appendFlag) {
                p.print("Valid GCPs after parse " + parseIndex + " :");
            } else {
                p.print("Initial Valid GCPs:");
            }
            p.println();
            if (!warpData.notEnoughGCPs) {
                p.println();
                p.println("  No.  | Master GCP x | Master GCP y | Slave GCP x  | Slave GCP y  | Row Residual | Col Residual |        RMS        |");
                p.println("----------------------------------------------------------------------------------------------------------------------");
                for (int i = 0; i < warpData.rms.length; ++i) {
                    p.format("%6d |%13.3f |%13.3f |%13.3f |%13.3f |%13.8f |%13.8f |%18.12f |", i, Float.valueOf(warpData.masterGCPCoords[2 * i]), Float.valueOf(warpData.masterGCPCoords[2 * i + 1]), Float.valueOf(warpData.slaveGCPCoords[2 * i]), Float.valueOf(warpData.slaveGCPCoords[2 * i + 1]), Float.valueOf(warpData.rowResiduals[i]), Float.valueOf(warpData.colResiduals[i]), Float.valueOf(warpData.rms[i]));
                    p.println();
                }
                p.println();
                p.print("Row residual mean = " + warpData.rowResidualMean);
                p.println();
                p.print("Row residual std = " + warpData.rowResidualStd);
                p.println();
                p.println();
                p.print("Col residual mean = " + warpData.colResidualMean);
                p.println();
                p.print("Col residual std = " + warpData.colResidualStd);
                p.println();
                p.println();
                p.print("RMS mean = " + warpData.rmsMean);
                p.println();
                p.print("RMS std = " + warpData.rmsStd);
                p.println();
            } else {
                p.println();
                p.println("No. | Master GCP x | Master GCP y | Slave GCP x | Slave GCP y |");
                p.println("---------------------------------------------------------------");
                for (int i = 0; i < warpData.numValidGCPs; ++i) {
                    p.format("%2d  |%13.3f |%13.3f |%12.3f |%12.3f |", i, Float.valueOf(warpData.masterGCPCoords[2 * i]), Float.valueOf(warpData.masterGCPCoords[2 * i + 1]), Float.valueOf(warpData.slaveGCPCoords[2 * i]), Float.valueOf(warpData.slaveGCPCoords[2 * i + 1]));
                    p.println();
                }
            }
            p.println();
            p.println();
        }
    }

    private static File getResidualsFile(Product sourceProduct) {
        String fileName = sourceProduct.getName() + "_residual.txt";
        return new File(ResourceUtils.getReportFolder(), fileName);
    }
}

