/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.coregistration;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import org.apache.commons.math3.util.FastMath;

public class FineRegistration {
    private static final int ITMAX = 200;
    private static final double TOL = 2.0E-4;
    private static final double GOLD = 1.618034;
    private static final double GLIMIT = 100.0;
    private static final double TINY = 1.0E-20;
    private static final double CGOLD = 0.381966;
    private static final double ZEPS = 1.0E-10;

    public static double powell(ComplexCoregData complexData, double[] p) {
        double[][] directions = new double[][]{{0.0, 1.0}, {1.0, 0.0}};
        double fp = FineRegistration.computeCoherence(complexData, p);
        double[] p0 = new double[]{p[0], p[1]};
        double[] currentDirection = new double[]{0.0, 0.0};
        for (int iter = 0; iter < 200; ++iter) {
            double d2;
            double d1;
            p0[0] = p[0];
            p0[1] = p[1];
            double fp0 = fp;
            int imax = 0;
            double maxDecrement = 0.0;
            for (int i = 0; i < 2; ++i) {
                currentDirection[0] = directions[i][0];
                currentDirection[1] = directions[i][1];
                double fpc = fp;
                double decrement = Math.abs(fpc - (fp = FineRegistration.linmin(complexData, p, currentDirection)));
                if (!(decrement > maxDecrement)) continue;
                maxDecrement = decrement;
                imax = i;
            }
            if (Math.abs(fp0 - fp) < complexData.coherenceFuncToler) {
                return fp;
            }
            if (Math.sqrt((p0[0] - p[0]) * (p0[0] - p[0]) + (p0[1] - p[1]) * (p0[1] - p[1])) < complexData.coherenceValueToler) {
                return fp;
            }
            double[] averageDirection = new double[]{p[0] - p0[0], p[1] - p0[1]};
            double norm = Math.sqrt(averageDirection[0] * averageDirection[0] + averageDirection[1] * averageDirection[1]);
            int j = 0;
            while (j < 2) {
                int n = j++;
                averageDirection[n] = averageDirection[n] / norm;
            }
            double fpe = FineRegistration.linmin(complexData, p, averageDirection);
            if (!(fpe < fp0) || !(2.0 * (fp0 - 2.0 * fp + fpe) * (d1 = (fp0 - fp - maxDecrement) * (fp0 - fp - maxDecrement)) < maxDecrement * (d2 = (fp0 - fpe) * (fp0 - fpe)))) continue;
            for (int j2 = 0; j2 < 2; ++j2) {
                directions[imax][j2] = directions[1][j2];
                directions[1][j2] = averageDirection[j2];
            }
        }
        return fp;
    }

    private static double linmin(ComplexCoregData complexData, double[] p, double[] xi) {
        double[] bracketPoints = new double[]{0.0, 0.02, 0.0};
        FineRegistration.mnbrak(complexData, bracketPoints, p, xi);
        return FineRegistration.brent(complexData, bracketPoints, p, xi);
    }

    private static void mnbrak(ComplexCoregData complexData, double[] bracketPoints, double[] p, double[] xi) {
        double ax = bracketPoints[0];
        double bx = bracketPoints[1];
        double fa = FineRegistration.computeCoherence(complexData, ax, p, xi);
        double fb = FineRegistration.computeCoherence(complexData, bx, p, xi);
        if (fb > fa) {
            double tmp = ax;
            ax = bx;
            bx = tmp;
            tmp = fa;
            fa = fb;
            fb = tmp;
        }
        double cx = bx + 1.618034 * (bx - ax);
        double fc = FineRegistration.computeCoherence(complexData, cx, p, xi);
        while (fb > fc) {
            double fu;
            double r = (bx - ax) * (fb - fc);
            double q = (bx - cx) * (fb - fa);
            double u = bx - ((bx - cx) * q - (bx - ax) * r) / (2.0 * FineRegistration.sign(Math.max(Math.abs(q - r), 1.0E-20), q - r));
            double ulim = bx + 100.0 * (cx - bx);
            if ((bx - u) * (u - cx) > 0.0) {
                fu = FineRegistration.computeCoherence(complexData, u, p, xi);
                if (fu < fc) {
                    ax = bx;
                    bx = u;
                    break;
                }
                if (fu > fb) {
                    cx = u;
                    break;
                }
                u = cx + 1.618034 * (cx - bx);
                fu = FineRegistration.computeCoherence(complexData, u, p, xi);
            } else if ((cx - u) * (u - ulim) > 0.0) {
                fu = FineRegistration.computeCoherence(complexData, u, p, xi);
                if (fu < fc) {
                    bx = cx;
                    cx = u;
                    u = cx + 1.618034 * (cx - bx);
                    fb = fc;
                    fc = fu;
                    fu = FineRegistration.computeCoherence(complexData, u, p, xi);
                }
            } else if ((u - ulim) * (ulim - cx) >= 0.0) {
                u = ulim;
                fu = FineRegistration.computeCoherence(complexData, u, p, xi);
            } else {
                u = cx + 1.618034 * (cx - bx);
                fu = FineRegistration.computeCoherence(complexData, u, p, xi);
            }
            ax = bx;
            bx = cx;
            cx = u;
            fa = fb;
            fb = fc;
            fc = fu;
        }
        bracketPoints[0] = ax;
        bracketPoints[1] = bx;
        bracketPoints[2] = cx;
    }

    private static double brent(ComplexCoregData complexData, double[] bracketPoints, double[] pp, double[] xi) {
        double fw;
        int maxNumIterations = 100;
        double ax = bracketPoints[0];
        double bx = bracketPoints[1];
        double cx = bracketPoints[2];
        double d = 0.0;
        double u = 0.0;
        double e = 0.0;
        double a = ax < cx ? ax : cx;
        double b = ax > cx ? ax : cx;
        double x = bx;
        double w = bx;
        double v = bx;
        double fv = fw = FineRegistration.computeCoherence(complexData, x, pp, xi);
        double fx = fw;
        for (int iter = 0; iter < 100; ++iter) {
            double xm = 0.5 * (a + b);
            double tol1 = 2.0E-4 * Math.abs(x) + 1.0E-10;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                xi[0] = xi[0] * x;
                xi[1] = xi[1] * x;
                pp[0] = pp[0] + xi[0];
                pp[1] = pp[1] + xi[1];
                return fx;
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (a - x) || p >= q * (b - x)) {
                    e = x >= xm ? a - x : b - x;
                    d = 0.381966 * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = FineRegistration.sign(tol1, xm - x);
                    }
                }
            } else {
                e = x >= xm ? a - x : b - x;
                d = 0.381966 * e;
            }
            u = Math.abs(d) >= tol1 ? x + d : x + FineRegistration.sign(tol1, d);
            double fu = FineRegistration.computeCoherence(complexData, u, pp, xi);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                w = x;
                x = u;
                fv = fw;
                fw = fx;
                fx = fu;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                w = u;
                fv = fw;
                fw = fu;
                continue;
            }
            if (!(fu <= fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
        }
        System.out.println("Too many iterations in brent");
        return -1.0;
    }

    private static double computeCoherence(ComplexCoregData complexData, double a, double[] p, double[] d) {
        double[] point = new double[]{p[0] + a * d[0], p[1] + a * d[1]};
        return FineRegistration.computeCoherence(complexData, point);
    }

    private static double computeCoherence(ComplexCoregData complexData, double[] point) {
        double xShift = Math.abs(complexData.point0[0] - point[0]);
        double yShift = Math.abs(complexData.point0[1] - point[1]);
        FineRegistration.getComplexSlaveImagette(complexData, point);
        double coherence = 0.0;
        if (complexData.useSlidingWindow) {
            int maxR = complexData.fWindowHeight - complexData.coherenceWindowSize;
            int maxC = complexData.fWindowWidth - complexData.coherenceWindowSize;
            for (int r = 0; r <= maxR; ++r) {
                for (int c = 0; c <= maxC; ++c) {
                    coherence += FineRegistration.getCoherence(complexData, r, c, complexData.coherenceWindowSize, complexData.coherenceWindowSize);
                }
            }
            coherence /= (double)((maxR + 1) * (maxC + 1));
        } else {
            coherence = FineRegistration.getCoherence(complexData, 0, 0, complexData.fWindowWidth, complexData.fWindowHeight);
        }
        return 1.0 - coherence;
    }

    private static double getCoherence(ComplexCoregData complexData, int row, int col, int coherenceWindowWidth, int coherenceWindowHeight) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        double[][] mIIdata = complexData.mII;
        double[][] mIQdata = complexData.mIQ;
        double[][] sIIdata = complexData.sII;
        double[][] sIQdata = complexData.sIQ;
        for (int r = 0; r < coherenceWindowHeight; ++r) {
            int rIdx = row + r;
            double[] mII = mIIdata[rIdx];
            double[] mIQ = mIQdata[rIdx];
            double[] sII = sIIdata[rIdx];
            double[] sIQ = sIQdata[rIdx];
            for (int c = 0; c < coherenceWindowWidth; ++c) {
                int cIdx = col + c;
                double mr = mII[cIdx];
                double mi = mIQ[cIdx];
                double sr = sII[cIdx];
                double si = sIQ[cIdx];
                sum1 += mr * sr + mi * si;
                sum2 += mi * sr - mr * si;
                sum3 += mr * mr + mi * mi;
                sum4 += sr * sr + si * si;
            }
        }
        return Math.sqrt(sum1 * sum1 + sum2 * sum2) / Math.sqrt(sum3 * sum4);
    }

    private static void getComplexSlaveImagette(ComplexCoregData compleData, double[] point) {
        compleData.sII = new double[compleData.fWindowHeight][compleData.fWindowWidth];
        compleData.sIQ = new double[compleData.fWindowHeight][compleData.fWindowWidth];
        double[][] sII0data = compleData.sII0;
        double[][] sIQ0data = compleData.sIQ0;
        double[][] sIIdata = compleData.sII;
        double[][] sIQdata = compleData.sIQ;
        int x0 = (int)(compleData.point0[0] + 0.5);
        int y0 = (int)(compleData.point0[1] + 0.5);
        double xShift = (double)x0 - point[0];
        double yShift = (double)y0 - point[1];
        double[] rowArray = new double[compleData.fTwoWindowWidth];
        double[] rowPhaseArray = new double[compleData.fTwoWindowWidth];
        DoubleFFT_1D row_fft = new DoubleFFT_1D(compleData.fWindowWidth);
        int signalLength = rowArray.length / 2;
        FineRegistration.computeShiftPhaseArray(xShift, signalLength, rowPhaseArray);
        for (int r = 0; r < compleData.fWindowHeight; ++r) {
            int c;
            int k = 0;
            double[] sII = sII0data[r];
            double[] sIQ = sIQ0data[r];
            for (c = 0; c < compleData.fWindowWidth; ++c) {
                rowArray[k++] = sII[c];
                rowArray[k++] = sIQ[c];
            }
            row_fft.complexForward(rowArray);
            FineRegistration.multiplySpectrumByShiftFactor(rowArray, rowPhaseArray);
            row_fft.complexInverse(rowArray, true);
            for (c = 0; c < compleData.fWindowWidth; ++c) {
                sIIdata[r][c] = rowArray[2 * c];
                sIQdata[r][c] = rowArray[2 * c + 1];
            }
        }
        double[] colArray = new double[compleData.fTwoWindowHeight];
        double[] colPhaseArray = new double[compleData.fTwoWindowHeight];
        DoubleFFT_1D col_fft = new DoubleFFT_1D(compleData.fWindowHeight);
        signalLength = colArray.length / 2;
        FineRegistration.computeShiftPhaseArray(yShift, signalLength, colPhaseArray);
        for (int c = 0; c < compleData.fWindowWidth; ++c) {
            int r;
            int k = 0;
            for (r = 0; r < compleData.fWindowHeight; ++r) {
                colArray[k++] = sIIdata[r][c];
                colArray[k++] = sIQdata[r][c];
            }
            col_fft.complexForward(colArray);
            FineRegistration.multiplySpectrumByShiftFactor(colArray, colPhaseArray);
            col_fft.complexInverse(colArray, true);
            for (r = 0; r < compleData.fWindowHeight; ++r) {
                sIIdata[r][c] = colArray[2 * r];
                sIQdata[r][c] = colArray[2 * r + 1];
            }
        }
    }

    private static void computeShiftPhaseArray(double shift, int signalLength, double[] phaseArray) {
        double phase = Math.PI * -2 * shift / (double)signalLength;
        int halfSignalLength = (int)((double)signalLength * 0.5 + 0.5);
        for (int k = 0; k < signalLength; ++k) {
            double phaseK = k < halfSignalLength ? phase * (double)k : phase * (double)(k - signalLength);
            int k2 = k * 2;
            phaseArray[k2] = FastMath.cos((double)phaseK);
            phaseArray[k2 + 1] = FastMath.sin((double)phaseK);
        }
    }

    private static void multiplySpectrumByShiftFactor(double[] array, double[] phaseArray) {
        int signalLength = array.length / 2;
        for (int k = 0; k < signalLength; ++k) {
            int k2 = k * 2;
            double c = phaseArray[k2];
            double s = phaseArray[k2 + 1];
            double real = array[k2];
            double imag = array[k2 + 1];
            array[k2] = real * c - imag * s;
            array[k2 + 1] = real * s + imag * c;
        }
    }

    public static void getShiftedData(ComplexCoregData complexData, double[][] srcI, double[][] srcQ, double xShift, double yShift, double[][] tgtI, double[][] tgtQ) {
        double[] rowArray = new double[complexData.fTwoWindowWidth];
        double[] rowPhaseArray = new double[complexData.fTwoWindowWidth];
        DoubleFFT_1D row_fft = new DoubleFFT_1D(complexData.fWindowWidth);
        int signalLength = rowArray.length / 2;
        FineRegistration.computeShiftPhaseArray(xShift, signalLength, rowPhaseArray);
        for (int r = 0; r < complexData.fWindowHeight; ++r) {
            int c;
            int k = 0;
            double[] sII = srcI[r];
            double[] sIQ = srcQ[r];
            for (c = 0; c < complexData.fWindowWidth; ++c) {
                rowArray[k++] = sII[c];
                rowArray[k++] = sIQ[c];
            }
            row_fft.complexForward(rowArray);
            FineRegistration.multiplySpectrumByShiftFactor(rowArray, rowPhaseArray);
            row_fft.complexInverse(rowArray, true);
            for (c = 0; c < complexData.fWindowWidth; ++c) {
                tgtI[r][c] = rowArray[2 * c];
                tgtQ[r][c] = rowArray[2 * c + 1];
            }
        }
        double[] colArray = new double[complexData.fTwoWindowHeight];
        double[] colPhaseArray = new double[complexData.fTwoWindowHeight];
        DoubleFFT_1D col_fft = new DoubleFFT_1D(complexData.fWindowHeight);
        signalLength = colArray.length / 2;
        FineRegistration.computeShiftPhaseArray(yShift, signalLength, colPhaseArray);
        for (int c = 0; c < complexData.fWindowWidth; ++c) {
            int r;
            int k = 0;
            for (r = 0; r < complexData.fWindowHeight; ++r) {
                colArray[k++] = tgtI[r][c];
                colArray[k++] = tgtQ[r][c];
            }
            col_fft.complexForward(colArray);
            FineRegistration.multiplySpectrumByShiftFactor(colArray, colPhaseArray);
            col_fft.complexInverse(colArray, true);
            for (r = 0; r < complexData.fWindowHeight; ++r) {
                tgtI[r][c] = colArray[2 * r];
                tgtQ[r][c] = colArray[2 * r + 1];
            }
        }
    }

    private static double sign(double a, double b) {
        if (b >= 0.0) {
            return a;
        }
        return -a;
    }

    private static void outputRealImage(double[][] I) {
        int row = I.length;
        int col = I[0].length;
        for (double[] aI : I) {
            for (int c = 0; c < col; ++c) {
                System.out.print(aI[c] + ",");
            }
        }
        System.out.println();
    }

    public static class ComplexCoregData {
        public double[][] mII = null;
        public double[][] mIQ = null;
        public double[][] sII = null;
        public double[][] sIQ = null;
        public double[][] sII0 = null;
        public double[][] sIQ0 = null;
        public final double[] point0 = new double[2];
        public final int coherenceWindowSize;
        public final double coherenceFuncToler;
        public final double coherenceValueToler;
        public final int fWindowWidth;
        public final int fWindowHeight;
        public final int fHalfWindowWidth;
        public final int fHalfWindowHeight;
        public final int fTwoWindowWidth;
        public final int fTwoWindowHeight;
        public final boolean useSlidingWindow;

        public ComplexCoregData(int coherenceWindowSize, double coherenceFuncToler, double coherenceValueToler, int fWindowWidth, int fWindowHeight, boolean useSlidingWindow) {
            this.coherenceWindowSize = coherenceWindowSize;
            this.coherenceFuncToler = coherenceFuncToler;
            this.coherenceValueToler = coherenceValueToler;
            this.fWindowWidth = fWindowWidth;
            this.fWindowHeight = fWindowHeight;
            this.fHalfWindowWidth = fWindowWidth / 2;
            this.fHalfWindowHeight = fWindowHeight / 2;
            this.fTwoWindowWidth = fWindowWidth * 2;
            this.fTwoWindowHeight = fWindowHeight * 2;
            this.useSlidingWindow = useSlidingWindow;
        }

        public void dispose() {
            this.mII = null;
            this.mIQ = null;
            this.sII = null;
            this.sIQ = null;
            this.sII0 = null;
            this.sIQ0 = null;
        }
    }
}

