/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.coregistration;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.esa.s1tbx.insar.gpf.support.SARGeocoding;
import org.esa.s1tbx.insar.gpf.support.SARPosition;
import org.esa.s1tbx.insar.gpf.support.SARUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.dem.dataio.EarthGravitationalModel96;
import org.esa.snap.dem.dataio.FileElevationModel;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.OrbitStateVector;
import org.esa.snap.engine_utilities.datamodel.PosVector;
import org.esa.snap.engine_utilities.datamodel.ProductInformation;
import org.esa.snap.engine_utilities.eo.GeoUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.jlinda.core.Window;
import org.jlinda.core.delaunay.TriangleInterpolator;

@OperatorMetadata(alias="DEM-Assisted-Coregistration", category="Radar/Coregistration", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Orbit and DEM based co-registration")
public final class DEMAssistedCoregistrationOp
extends Operator {
    @SourceProducts
    private Product[] sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(defaultValue="BICUBIC_INTERPOLATION", label="DEM Resampling Method")
    private String demResamplingMethod = "BICUBIC_INTERPOLATION";
    @Parameter(label="External DEM")
    private File externalDEMFile = null;
    @Parameter(label="DEM No Data Value", defaultValue="0")
    private double externalDEMNoDataValue = 0.0;
    @Parameter(defaultValue="BISINC_5_POINT_INTERPOLATION", description="The method to be used when resampling the slave grid onto the master grid.", label="Resampling Type")
    private String resamplingType = "BISINC_5_POINT_INTERPOLATION";
    @Parameter(label="Tile Extension [%]", description="Define tile extension percentage.", interval="[0, *)", defaultValue="50")
    private int tileExtensionPercent = 50;
    @Parameter(defaultValue="true", label="Mask out areas with no elevation")
    private boolean maskOutAreaWithoutElevation = true;
    @Parameter(defaultValue="false", label="Output Range and Azimuth Offset")
    private boolean outputRangeAzimuthOffset = false;
    private Resampling selectedResampling;
    private Product masterProduct;
    private Product[] slaveProducts;
    private Metadata mstMetadata = new Metadata();
    private Metadata[] slvMetadatas;
    private ElevationModel dem = null;
    private boolean isElevationModelAvailable = false;
    private double demNoDataValue = 0.0;
    private double noDataValue = 0.0;
    private GeoCoding targetGeoCoding = null;
    private final HashMap<Band, Band> targetBandToSlaveBandMap = new HashMap(2);
    private static final double invalidIndex = -9999.0;
    private static final String PRODUCT_SUFFIX = "_Stack";

    public void initialize() throws OperatorException {
        try {
            if (this.sourceProduct == null) {
                return;
            }
            if (this.sourceProduct.length < 2) {
                throw new OperatorException("Please select two or more source products");
            }
            this.masterProduct = this.sourceProduct[0];
            this.slaveProducts = new Product[this.sourceProduct.length - 1];
            System.arraycopy(this.sourceProduct, 1, this.slaveProducts, 0, this.slaveProducts.length);
            DEMAssistedCoregistrationOp.getProductMetadata(this.masterProduct, this.mstMetadata);
            this.slvMetadatas = new Metadata[this.slaveProducts.length];
            int i = 0;
            for (Product slaveProduct : this.slaveProducts) {
                this.slvMetadatas[i] = new Metadata();
                DEMAssistedCoregistrationOp.getProductMetadata(slaveProduct, this.slvMetadatas[i]);
                ++i;
            }
            if (this.externalDEMFile == null) {
                DEMFactory.checkIfDEMInstalled((String)this.demName);
            }
            DEMFactory.validateDEM((String)this.demName, (Product)this.masterProduct);
            this.selectedResampling = ResamplingFactory.createResampling((String)this.resamplingType);
            if (this.selectedResampling == null) {
                throw new OperatorException("Resampling method " + this.resamplingType + " is invalid");
            }
            this.createTargetProduct();
            StackUtils.saveSlaveProductNames((Product[])this.sourceProduct, (Product)this.targetProduct, (Product)this.masterProduct, this.targetBandToSlaveBandMap);
            this.updateTargetProductMetadata();
            this.noDataValue = this.masterProduct.getBandAt(0).getNoDataValue();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private static void getProductMetadata(Product sourceProduct, Metadata metadata) throws Exception {
        metadata.sourceImageWidth = sourceProduct.getSceneRasterWidth();
        metadata.sourceImageHeight = sourceProduct.getSceneRasterHeight();
        metadata.absRoot = AbstractMetadata.getAbstractedMetadata((Product)sourceProduct);
        metadata.srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)metadata.absRoot, (String)"srgr_flag");
        metadata.wavelength = SARUtils.getRadarFrequency(metadata.absRoot);
        metadata.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)metadata.absRoot, (String)"range_spacing");
        metadata.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)metadata.absRoot, (String)"azimuth_spacing");
        metadata.firstLineTime = AbstractMetadata.parseUTC((String)metadata.absRoot.getAttributeString("first_line_time")).getMJD();
        metadata.lastLineTime = AbstractMetadata.parseUTC((String)metadata.absRoot.getAttributeString("last_line_time")).getMJD();
        metadata.lineTimeInterval = metadata.absRoot.getAttributeDouble("line_time_interval") / 86400.0;
        OrbitStateVector[] orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)metadata.absRoot);
        metadata.orbit = new SARGeocoding.Orbit(orbitStateVectors, metadata.firstLineTime, metadata.lineTimeInterval, metadata.sourceImageHeight);
        if (metadata.srgrFlag) {
            metadata.srgrConvParams = AbstractMetadata.getSRGRCoefficients((MetadataElement)metadata.absRoot);
        } else {
            metadata.nearEdgeSlantRange = AbstractMetadata.getAttributeDouble((MetadataElement)metadata.absRoot, (String)"slant_range_to_first_pixel");
        }
        TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)sourceProduct);
        metadata.nearRangeOnLeft = SARGeocoding.isNearRangeOnLeft(incidenceAngle, metadata.sourceImageWidth);
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.masterProduct.getName() + PRODUCT_SUFFIX, this.masterProduct.getProductType(), this.masterProduct.getSceneRasterWidth(), this.masterProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.masterProduct, (Product)this.targetProduct);
        String[] masterBandNames = this.masterProduct.getBandNames();
        String mstSuffix = "_mst" + StackUtils.createBandTimeStamp((Product)this.masterProduct);
        for (String string : masterBandNames) {
            Band targetBand;
            if (this.masterProduct.getBand(string) instanceof VirtualBand || this.targetProduct.getBand(string + mstSuffix) != null || (targetBand = ProductUtils.copyBand((String)string, (Product)this.masterProduct, (String)(string + mstSuffix), (Product)this.targetProduct, (boolean)true)) == null || !"imaginary".equals(targetBand.getUnit())) continue;
            int idx = this.targetProduct.getBandIndex(targetBand.getName());
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)this.targetProduct.getBandAt(idx - 1), (Band)targetBand, (String)mstSuffix);
        }
        Band masterBand = this.masterProduct.getBand(masterBandNames[0]);
        int masterBandWidth = masterBand.getRasterWidth();
        int masterBandHeight = masterBand.getRasterHeight();
        for (Product slaveProduct : this.slaveProducts) {
            String[] slaveBandNames = slaveProduct.getBandNames();
            String slvSuffix = "_slv1" + StackUtils.createBandTimeStamp((Product)slaveProduct);
            for (String bandName : slaveBandNames) {
                Band srcBand = slaveProduct.getBand(bandName);
                if (srcBand instanceof VirtualBand || this.targetProduct.getBand(bandName + slvSuffix) != null) continue;
                Band targetBand = new Band(bandName + slvSuffix, 30, masterBandWidth, masterBandHeight);
                targetBand.setUnit(srcBand.getUnit());
                targetBand.setDescription(srcBand.getDescription());
                this.targetProduct.addBand(targetBand);
                this.targetBandToSlaveBandMap.put(targetBand, srcBand);
                if (!targetBand.getUnit().equals("imaginary")) continue;
                int idx = this.targetProduct.getBandIndex(targetBand.getName());
                ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)this.targetProduct.getBandAt(idx - 1), (Band)targetBand, (String)slvSuffix);
            }
            this.copySlaveMetadata(slaveProduct);
        }
        DEMAssistedCoregistrationOp.setMasterValidPixelExpression(this.targetProduct, this.maskOutAreaWithoutElevation);
        if (this.outputRangeAzimuthOffset) {
            Band band = new Band("azOffset", 30, masterBandWidth, masterBandHeight);
            band.setUnit("Index");
            this.targetProduct.addBand(band);
            Band rgOffsetBand = new Band("rgOffset", 30, masterBandWidth, masterBandHeight);
            rgOffsetBand.setUnit("Index");
            this.targetProduct.addBand(rgOffsetBand);
        }
        this.targetGeoCoding = this.targetProduct.getSceneGeoCoding();
    }

    public static void setMasterValidPixelExpression(Product targetProduct, boolean maskOutAreaWithoutElevation) {
        if (maskOutAreaWithoutElevation) {
            Band slvBand = null;
            for (Band tgtBand : targetProduct.getBands()) {
                if (!tgtBand.getName().contains("_slv")) continue;
                slvBand = tgtBand;
                break;
            }
            if (slvBand != null) {
                for (Band tgtBand : targetProduct.getBands()) {
                    if (!tgtBand.getName().contains("_mst")) continue;
                    tgtBand.setValidPixelExpression(slvBand.getName());
                }
            }
        }
    }

    private void copySlaveMetadata(Product slaveProduct) {
        MetadataElement targetSlaveMetadataRoot = AbstractMetadata.getSlaveMetadata((MetadataElement)this.targetProduct.getMetadataRoot());
        MetadataElement slvAbsMetadata = AbstractMetadata.getAbstractedMetadata((Product)slaveProduct);
        if (slvAbsMetadata != null) {
            String timeStamp = StackUtils.createBandTimeStamp((Product)slaveProduct);
            MetadataElement targetSlaveMetadata = new MetadataElement(slaveProduct.getName() + timeStamp);
            targetSlaveMetadataRoot.addElement(targetSlaveMetadata);
            ProductUtils.copyMetadata((MetadataElement)slvAbsMetadata, (MetadataElement)targetSlaveMetadata);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement abstractedMetadata = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (abstractedMetadata != null) {
            abstractedMetadata.setAttributeInt("collocated_stack", 1);
        }
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"coregistered_stack", (int)1);
        MetadataElement inputElem = ProductInformation.getInputProducts((Product)this.targetProduct);
        for (Product slaveProduct : this.slaveProducts) {
            MetadataAttribute[] slvInputProductAttrbList;
            MetadataElement slvInputElem = ProductInformation.getInputProducts((Product)slaveProduct);
            for (MetadataAttribute attrib : slvInputProductAttrbList = slvInputElem.getAttributes()) {
                MetadataAttribute inputAttrb = AbstractMetadata.addAbstractedAttribute((MetadataElement)inputElem, (String)"InputProduct", (int)41, (String)"", (String)"");
                inputAttrb.getData().setElems((Object)attrib.getData().getElemString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            if (!this.isElevationModelAvailable) {
                this.getElevationModel();
            }
            for (Metadata slaveMetadata : this.slvMetadatas) {
                int margin;
                Rectangle sourceRectangle;
                PixelPos[][] slavePixPos = this.computeSlavePixPos(tx0, ty0, tw, th, slaveMetadata);
                if (slavePixPos == null) {
                    return;
                }
                if (this.outputRangeAzimuthOffset) {
                    this.outputRangeAzimuthOffsets(tx0, ty0, tw, th, targetTileMap, slavePixPos);
                }
                if ((sourceRectangle = this.getBoundingBox(slaveMetadata, slavePixPos, margin = this.selectedResampling.getKernelSize())) == null) {
                    return;
                }
                this.performInterpolation(tx0, ty0, tw, th, sourceRectangle, targetTileMap, slavePixPos, slaveMetadata);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private synchronized void getElevationModel() throws Exception {
        if (this.isElevationModelAvailable) {
            return;
        }
        try {
            if (this.externalDEMFile != null) {
                this.dem = new FileElevationModel(this.externalDEMFile, this.demResamplingMethod, Double.valueOf(this.externalDEMNoDataValue));
                this.demNoDataValue = this.externalDEMNoDataValue;
                this.demName = this.externalDEMFile.getPath();
            } else {
                this.dem = DEMFactory.createElevationModel((String)this.demName, (String)this.demResamplingMethod);
                this.demNoDataValue = this.dem.getDescriptor().getNoDataValue();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.isElevationModelAvailable = true;
    }

    private PixelPos[][] computeSlavePixPos(int x0, int y0, int w, int h, Metadata slvMetadata) throws Exception {
        try {
            double[] latLonMinMax = new double[4];
            this.computeImageGeoBoundary(x0, x0 + w, y0, y0 + h, latLonMinMax);
            double extralat = (latLonMinMax[1] - latLonMinMax[0]) * (double)this.tileExtensionPercent / 100.0;
            double extralon = (latLonMinMax[3] - latLonMinMax[2]) * (double)this.tileExtensionPercent / 100.0;
            double latMin = latLonMinMax[0] - extralat;
            double latMax = latLonMinMax[1] + extralat;
            double lonMin = latLonMinMax[2] - extralon;
            double lonMax = latLonMinMax[3] + extralon;
            PixelPos upperLeft = this.dem.getIndex(new GeoPos(latMax, lonMin));
            PixelPos lowerRight = this.dem.getIndex(new GeoPos(latMin, lonMax));
            int latMaxIdx = (int)Math.floor(upperLeft.getY());
            int latMinIdx = (int)Math.ceil(lowerRight.getY());
            int lonMinIdx = (int)Math.floor(upperLeft.getX());
            int lonMaxIdx = (int)Math.ceil(lowerRight.getX());
            EarthGravitationalModel96 egm = EarthGravitationalModel96.instance();
            int numLines = latMinIdx - latMaxIdx;
            int numPixels = lonMaxIdx - lonMinIdx;
            double[][] masterAz = new double[numLines][numPixels];
            double[][] masterRg = new double[numLines][numPixels];
            double[][] slaveAz = new double[numLines][numPixels];
            double[][] slaveRg = new double[numLines][numPixels];
            double[][] lat = new double[numLines][numPixels];
            double[][] lon = new double[numLines][numPixels];
            SARPosition mstSARPosition = new SARPosition(this.mstMetadata.firstLineTime, this.mstMetadata.lastLineTime, this.mstMetadata.lineTimeInterval, this.mstMetadata.wavelength, this.mstMetadata.rangeSpacing, this.mstMetadata.sourceImageWidth, this.mstMetadata.srgrFlag, this.mstMetadata.nearEdgeSlantRange, this.mstMetadata.nearRangeOnLeft, this.mstMetadata.orbit, this.mstMetadata.srgrConvParams);
            SARPosition slvSARPosition = new SARPosition(slvMetadata.firstLineTime, slvMetadata.lastLineTime, slvMetadata.lineTimeInterval, slvMetadata.wavelength, slvMetadata.rangeSpacing, slvMetadata.sourceImageWidth, slvMetadata.srgrFlag, slvMetadata.nearEdgeSlantRange, slvMetadata.nearRangeOnLeft, slvMetadata.orbit, slvMetadata.srgrConvParams);
            SARPosition.PositionData posData = new SARPosition.PositionData();
            PixelPos pix = new PixelPos();
            boolean noValidSlavePixPos = true;
            for (int l = 0; l < numLines; ++l) {
                for (int p = 0; p < numPixels; ++p) {
                    pix.setLocation((double)(lonMinIdx + p), (double)(latMaxIdx + l));
                    GeoPos gp = this.dem.getGeoPos(pix);
                    lat[l][p] = gp.lat;
                    lon[l][p] = gp.lon;
                    Double alt = this.dem.getElevation(gp);
                    if (alt.equals(this.demNoDataValue)) {
                        alt = egm.getEGM(gp.lat, gp.lon);
                    }
                    GeoUtils.geo2xyzWGS84((double)gp.lat, (double)gp.lon, (double)alt, (PosVector)posData.earthPoint);
                    if (mstSARPosition.getPosition(posData)) {
                        masterAz[l][p] = posData.azimuthIndex;
                        masterRg[l][p] = posData.rangeIndex;
                        if (slvSARPosition.getPosition(posData)) {
                            slaveAz[l][p] = posData.azimuthIndex;
                            slaveRg[l][p] = posData.rangeIndex;
                            noValidSlavePixPos = false;
                            continue;
                        }
                    }
                    masterAz[l][p] = -9999.0;
                    masterRg[l][p] = -9999.0;
                }
            }
            if (noValidSlavePixPos) {
                return null;
            }
            Window tileWindow = new Window((long)y0, (long)(y0 + h - 1), (long)x0, (long)(x0 + w - 1));
            double rgAzRatio = this.mstMetadata.rangeSpacing / this.mstMetadata.azimuthSpacing;
            double[][] latArray = new double[(int)tileWindow.lines()][(int)tileWindow.pixels()];
            double[][] lonArray = new double[(int)tileWindow.lines()][(int)tileWindow.pixels()];
            double[][] azArray = new double[(int)tileWindow.lines()][(int)tileWindow.pixels()];
            double[][] rgArray = new double[(int)tileWindow.lines()][(int)tileWindow.pixels()];
            for (double[] data : azArray) {
                Arrays.fill(data, -9999.0);
            }
            for (double[] data : rgArray) {
                Arrays.fill(data, -9999.0);
            }
            TriangleInterpolator.ZData[] dataList = new TriangleInterpolator.ZData[]{new TriangleInterpolator.ZData(slaveAz, azArray), new TriangleInterpolator.ZData(slaveRg, rgArray), new TriangleInterpolator.ZData(lat, latArray), new TriangleInterpolator.ZData(lon, lonArray)};
            TriangleInterpolator.gridDataLinear((double[][])masterAz, (double[][])masterRg, (TriangleInterpolator.ZData[])dataList, (Window)tileWindow, (double)rgAzRatio, (int)1, (int)1, (double)-9999.0, (int)0);
            boolean allElementsAreNull = true;
            PixelPos[][] slavePixelPos = new PixelPos[h][w];
            for (int yy = 0; yy < h; ++yy) {
                for (int xx = 0; xx < w; ++xx) {
                    if (rgArray[yy][xx] == -9999.0 || azArray[yy][xx] == -9999.0 || rgArray[yy][xx] < 0.0 || rgArray[yy][xx] >= (double)slvMetadata.sourceImageWidth || azArray[yy][xx] < 0.0 || azArray[yy][xx] >= (double)slvMetadata.sourceImageHeight) {
                        slavePixelPos[yy][xx] = null;
                        continue;
                    }
                    if (this.maskOutAreaWithoutElevation) {
                        Double alt = this.dem.getElevation(new GeoPos(latArray[yy][xx], lonArray[yy][xx]));
                        if (!alt.equals(this.demNoDataValue)) {
                            slavePixelPos[yy][xx] = new PixelPos(rgArray[yy][xx], azArray[yy][xx]);
                            allElementsAreNull = false;
                            continue;
                        }
                        slavePixelPos[yy][xx] = null;
                        continue;
                    }
                    slavePixelPos[yy][xx] = new PixelPos(rgArray[yy][xx], azArray[yy][xx]);
                    allElementsAreNull = false;
                }
            }
            if (allElementsAreNull) {
                return null;
            }
            return slavePixelPos;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeSlavePixPos", (Throwable)e);
            return null;
        }
    }

    private void computeImageGeoBoundary(int xMin, int xMax, int yMin, int yMax, double[] latLonMinMax) throws Exception {
        GeoPos geoPosFirstNear = this.targetGeoCoding.getGeoPos(new PixelPos((double)xMin, (double)yMin), null);
        GeoPos geoPosFirstFar = this.targetGeoCoding.getGeoPos(new PixelPos((double)xMax, (double)yMin), null);
        GeoPos geoPosLastNear = this.targetGeoCoding.getGeoPos(new PixelPos((double)xMin, (double)yMax), null);
        GeoPos geoPosLastFar = this.targetGeoCoding.getGeoPos(new PixelPos((double)xMax, (double)yMax), null);
        double[] lats = new double[]{geoPosFirstNear.getLat(), geoPosFirstFar.getLat(), geoPosLastNear.getLat(), geoPosLastFar.getLat()};
        double[] lons = new double[]{geoPosFirstNear.getLon(), geoPosFirstFar.getLon(), geoPosLastNear.getLon(), geoPosLastFar.getLon()};
        double latMin = 90.0;
        double latMax = -90.0;
        for (double lat : lats) {
            if (lat < latMin) {
                latMin = lat;
            }
            if (!(lat > latMax)) continue;
            latMax = lat;
        }
        double lonMin = 180.0;
        double lonMax = -180.0;
        for (double lon : lons) {
            if (lon < lonMin) {
                lonMin = lon;
            }
            if (!(lon > lonMax)) continue;
            lonMax = lon;
        }
        latLonMinMax[0] = latMin;
        latLonMinMax[1] = latMax;
        latLonMinMax[2] = lonMin;
        latLonMinMax[3] = lonMax;
    }

    private Rectangle getBoundingBox(Metadata slvMetadata, PixelPos[][] slavePixPos, int margin) {
        int minX = Integer.MAX_VALUE;
        int maxX = -2147483647;
        int minY = Integer.MAX_VALUE;
        int maxY = -2147483647;
        for (PixelPos[] slavePixPo : slavePixPos) {
            for (int j = 0; j < slavePixPos[0].length; ++j) {
                if (slavePixPo[j] == null) continue;
                int x = (int)Math.floor(slavePixPo[j].getX());
                int y = (int)Math.floor(slavePixPo[j].getY());
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        minX = Math.max(minX - margin, 0);
        maxX = Math.min(maxX + margin, slvMetadata.sourceImageWidth - 1);
        minY = Math.max(minY - margin, 0);
        maxY = Math.min(maxY + margin, slvMetadata.sourceImageHeight - 1);
        if (minX > maxX || minY > maxY) {
            return null;
        }
        return new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    private void performInterpolation(int x0, int y0, int w, int h, Rectangle sourceRectangle, Map<Band, Tile> targetTileMap, PixelPos[][] slavePixPos, Metadata slvMetadata) {
        try {
            Set<Band> keySet = this.targetBandToSlaveBandMap.keySet();
            int numSlvBands = this.targetBandToSlaveBandMap.size();
            Tile targetTile = null;
            ProductData[] targetBuffers = new ProductData[numSlvBands];
            ResamplingRaster[] slvResamplingRasters = new ResamplingRaster[numSlvBands];
            int k = 0;
            for (Band band : keySet) {
                targetTile = targetTileMap.get(band);
                targetBuffers[k] = targetTile.getDataBuffer();
                Band slvBand = this.targetBandToSlaveBandMap.get(band);
                Tile slvTile = this.getSourceTile((RasterDataNode)slvBand, sourceRectangle);
                ProductData slvBuffer = slvTile.getDataBuffer();
                slvResamplingRasters[k] = new ResamplingRaster(slvTile, slvBuffer);
                ++k;
            }
            TileIndex tgtIndex = new TileIndex(targetTile);
            Resampling.Index resamplingIndex = this.selectedResampling.createIndex();
            for (int y = y0; y < y0 + h; ++y) {
                tgtIndex.calculateStride(y);
                int yy = y - y0;
                for (int x = x0; x < x0 + w; ++x) {
                    int tgtIdx = tgtIndex.getIndex(x);
                    PixelPos slavePixelPos = slavePixPos[yy][x - x0];
                    if (slavePixelPos == null) continue;
                    this.selectedResampling.computeCornerBasedIndex(slavePixelPos.x, slavePixelPos.y, slvMetadata.sourceImageWidth, slvMetadata.sourceImageHeight, resamplingIndex);
                    this.saveToTargetBand(resamplingIndex, slvResamplingRasters, targetBuffers, tgtIdx);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"performInterpolation", (Throwable)e);
        }
    }

    private void saveToTargetBand(Resampling.Index resamplingIndex, ResamplingRaster[] slvResamplingRasters, ProductData[] targetBuffers, int tgtIdx) throws Exception {
        int i = 0;
        for (ProductData targetBuffer : targetBuffers) {
            targetBuffer.setElemDoubleAt(tgtIdx, this.selectedResampling.resample((Resampling.Raster)slvResamplingRasters[i], resamplingIndex));
            ++i;
        }
    }

    private void outputRangeAzimuthOffsets(int x0, int y0, int w, int h, Map<Band, Tile> targetTileMap, PixelPos[][] slavePixPos) {
        try {
            Band azOffsetBand = this.targetProduct.getBand("azOffset");
            Band rgOffsetBand = this.targetProduct.getBand("rgOffset");
            if (azOffsetBand == null || rgOffsetBand == null) {
                return;
            }
            Tile tgtTileAzOffset = targetTileMap.get(azOffsetBand);
            Tile tgtTileRgOffset = targetTileMap.get(rgOffsetBand);
            ProductData tgtBufferAzOffset = tgtTileAzOffset.getDataBuffer();
            ProductData tgtBufferRgOffset = tgtTileRgOffset.getDataBuffer();
            TileIndex tgtIndex = new TileIndex(tgtTileAzOffset);
            for (int y = y0; y < y0 + h; ++y) {
                tgtIndex.calculateStride(y);
                int yy = y - y0;
                for (int x = x0; x < x0 + w; ++x) {
                    int tgtIdx = tgtIndex.getIndex(x);
                    int xx = x - x0;
                    if (slavePixPos[yy][xx] == null) {
                        tgtBufferAzOffset.setElemFloatAt(tgtIdx, (float)this.noDataValue);
                        tgtBufferRgOffset.setElemFloatAt(tgtIdx, (float)this.noDataValue);
                        continue;
                    }
                    tgtBufferAzOffset.setElemFloatAt(tgtIdx, (float)slavePixPos[yy][xx].y);
                    tgtBufferRgOffset.setElemFloatAt(tgtIdx, (float)slavePixPos[yy][xx].x);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"outputRangeAzimuthOffsets", (Throwable)e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(DEMAssistedCoregistrationOp.class);
        }
    }

    private static class Metadata {
        public MetadataElement absRoot = null;
        public SARGeocoding.Orbit orbit = null;
        public double firstLineTime = 0.0;
        public double lastLineTime = 0.0;
        public double lineTimeInterval = 0.0;
        public double wavelength = 0.0;
        public double rangeSpacing = 0.0;
        public double azimuthSpacing = 0.0;
        public double nearEdgeSlantRange = 0.0;
        public boolean srgrFlag = false;
        public boolean nearRangeOnLeft = false;
        public int sourceImageWidth = 0;
        public int sourceImageHeight = 0;
        public AbstractMetadata.SRGRCoefficientList[] srgrConvParams = null;

        private Metadata() {
        }
    }

    private static class ResamplingRaster
    implements Resampling.Raster {
        private final Tile tile;
        private final ProductData dataBuffer;

        private ResamplingRaster(Tile tile, ProductData dataBuffer) {
            this.tile = tile;
            this.dataBuffer = dataBuffer;
        }

        public final int getWidth() {
            return this.tile.getWidth();
        }

        public final int getHeight() {
            return this.tile.getHeight();
        }

        public boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
            boolean allValid = true;
            try {
                TileIndex index = new TileIndex(this.tile);
                int maxX = x.length;
                for (int i = 0; i < y.length; ++i) {
                    index.calculateStride(y[i]);
                    for (int j = 0; j < maxX; ++j) {
                        double v;
                        samples[i][j] = v = this.dataBuffer.getElemDoubleAt(index.getIndex(x[j]));
                    }
                }
            }
            catch (Exception e) {
                SystemUtils.LOG.severe(e.getMessage());
                allValid = false;
            }
            return allValid;
        }
    }
}

