/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.coregistration;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.insar.gpf.coregistration.FineRegistration;
import org.esa.s1tbx.insar.gpf.support.JAIFunctions;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GcpDescriptor;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkNameFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.MemUtils;
import org.jblas.ComplexDoubleMatrix;
import org.jlinda.core.Window;
import org.jlinda.core.coregistration.utils.CoregistrationUtils;
import org.jlinda.nest.gpf.coregistration.GCPManager;
import org.jlinda.nest.utils.TileUtilsDoris;

@OperatorMetadata(alias="Cross-Correlation", category="Radar/Coregistration", authors="Jun Lu, Luis Veci, Petar Marinkovic", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Automatic Selection of Ground Control Points")
public class CrossCorrelationOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The number of GCPs to use in a grid", interval="(10, *)", defaultValue="200", label="Number of GCPs")
    private int numGCPtoGenerate = 200;
    @Parameter(valueSet={"32", "64", "128", "256", "512", "1024", "2048"}, defaultValue="128", label="Coarse Registration Window Width")
    private String coarseRegistrationWindowWidth = "128";
    @Parameter(valueSet={"32", "64", "128", "256", "512", "1024", "2048"}, defaultValue="128", label="Coarse Registration Window Height")
    private String coarseRegistrationWindowHeight = "128";
    @Parameter(valueSet={"2", "4", "8", "16"}, defaultValue="2", label="Row Interpolation Factor")
    private String rowInterpFactor = "2";
    @Parameter(valueSet={"2", "4", "8", "16"}, defaultValue="2", label="Column Interpolation Factor")
    private String columnInterpFactor = "2";
    @Parameter(description="The maximum number of iterations", interval="(1, 10]", defaultValue="10", label="Max Iterations")
    private int maxIteration = 10;
    @Parameter(description="Tolerance in slave GCP validation check", interval="(0, *)", defaultValue="0.5", label="GCP Tolerance")
    private double gcpTolerance = 0.5;
    @Parameter(defaultValue="true", label="Apply Fine Registration")
    private boolean applyFineRegistration = true;
    @Parameter(defaultValue="true", label="Optimize for InSAR")
    private boolean inSAROptimized = true;
    @Parameter(valueSet={"8", "16", "32", "64", "128", "256", "512"}, defaultValue="32", label="Fine Registration Window Width")
    private String fineRegistrationWindowWidth = "32";
    @Parameter(valueSet={"8", "16", "32", "64", "128", "256", "512"}, defaultValue="32", label="Fine Registration Window Height")
    private String fineRegistrationWindowHeight = "32";
    @Parameter(valueSet={"2", "4", "8", "16", "32", "64"}, defaultValue="16", label="Search Window Accuracy in Azimuth Direction")
    private String fineRegistrationWindowAccAzimuth = "16";
    @Parameter(valueSet={"2", "4", "8", "16", "32", "64"}, defaultValue="16", label="Search Window Accuracy in Range Direction")
    private String fineRegistrationWindowAccRange = "16";
    @Parameter(valueSet={"2", "4", "8", "16", "32", "64"}, defaultValue="16", label="Window oversampling factor")
    private String fineRegistrationOversampling = "16";
    @Parameter(description="The coherence window size", interval="(1, 16]", defaultValue="3", label="Coherence Window Size")
    private int coherenceWindowSize = 3;
    @Parameter(description="The coherence threshold", interval="(0, *)", defaultValue="0.6", label="Coherence Threshold")
    private double coherenceThreshold = 0.6;
    @Parameter(description="Use sliding window for coherence calculation", defaultValue="false", label="Use coherence sliding window")
    private Boolean useSlidingWindow = false;
    private boolean useAllPolarimetricBands = false;
    private static final double coherenceFuncToler = 1.0E-5;
    private static final double coherenceValueToler = 0.01;
    @Parameter(defaultValue="false", label="Estimate Coarse Offset")
    private boolean computeOffset = false;
    @Parameter(defaultValue="false", label="Test GCPs are on land")
    private boolean onlyGCPsOnLand = false;
    private Band masterBand1;
    private Band masterBand2;
    private boolean complexCoregistration;
    private ProductNodeGroup<Placemark> masterGcpGroup;
    private String[] masterBandNames = null;
    private int sourceImageWidth;
    private int sourceImageHeight;
    private int cWindowWidth = 0;
    private int cWindowHeight = 0;
    private int rowUpSamplingFactor = 0;
    private int colUpSamplingFactor = 0;
    private int cHalfWindowWidth;
    private int cHalfWindowHeight;
    private int fWindowWidth = 0;
    private int fWindowHeight = 0;
    private static final double MaxInvalidPixelPercentage = 0.66;
    private final Map<Band, Band> sourceRasterMap = new HashMap<Band, Band>(10);
    private final Map<Band, Band> complexSrcMap = new HashMap<Band, Band>(10);
    private final Map<Band, Boolean> gcpsComputedMap = new HashMap<Band, Boolean>(10);
    private Band primarySlaveBand = null;
    private boolean collocatedStack = false;
    private ElevationModel dem = null;
    private CorrelationWindow fineWin;

    public void initialize() throws OperatorException {
        try {
            double achievableAccuracy;
            this.getCollocatedStackFlag();
            this.cWindowWidth = Integer.parseInt(this.coarseRegistrationWindowWidth);
            this.cWindowHeight = Integer.parseInt(this.coarseRegistrationWindowHeight);
            this.cHalfWindowWidth = this.cWindowWidth / 2;
            this.cHalfWindowHeight = this.cWindowHeight / 2;
            this.rowUpSamplingFactor = Integer.parseInt(this.rowInterpFactor);
            this.colUpSamplingFactor = Integer.parseInt(this.columnInterpFactor);
            this.getMasterBands();
            if (this.applyFineRegistration) {
                if (this.complexCoregistration) {
                    this.fWindowWidth = Integer.parseInt(this.fineRegistrationWindowWidth);
                    this.fWindowHeight = Integer.parseInt(this.fineRegistrationWindowHeight);
                }
                if (this.inSAROptimized) {
                    if (this.fineRegistrationOversampling == null) {
                        this.fineRegistrationOversampling = "2";
                    }
                    this.fineWin = new CorrelationWindow(Integer.parseInt(this.fineRegistrationWindowWidth), Integer.parseInt(this.fineRegistrationWindowHeight), Integer.parseInt(this.fineRegistrationWindowAccRange), Integer.parseInt(this.fineRegistrationWindowAccAzimuth), Integer.parseInt(this.fineRegistrationOversampling));
                }
            }
            if (this.gcpTolerance < (achievableAccuracy = 1.0 / (double)Math.max(this.rowUpSamplingFactor, this.colUpSamplingFactor))) {
                throw new OperatorException("GCP Tolerance is below the achievable accuracy with current interpolation factors of " + achievableAccuracy + '.');
            }
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.createTargetProduct();
            GCPManager.instance().removeAllGcpGroups();
            this.masterGcpGroup = GCPManager.instance().getGcpGroup(this.masterBand1);
            if (this.masterGcpGroup.getNodeCount() <= 0) {
                CrossCorrelationOp.addGCPGrid(this.sourceImageWidth, this.sourceImageHeight, this.numGCPtoGenerate, this.masterGcpGroup, this.targetProduct.getSceneGeoCoding());
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getMasterBands() {
        String mstBandName = this.sourceProduct.getBandAt(0).getName();
        for (String bandName : this.masterBandNames = CrossCorrelationOp.getMasterBandNames(this.sourceProduct)) {
            String mstPol = OperatorUtils.getPolarizationFromBandName((String)bandName);
            if (mstPol == null || !mstPol.equals("hh") && !mstPol.equals("vv")) continue;
            mstBandName = bandName;
            break;
        }
        this.masterBand1 = this.sourceProduct.getBand(mstBandName);
        if (this.masterBand1 == null) {
            mstBandName = this.sourceProduct.getBandAt(0).getName();
            this.masterBand1 = this.sourceProduct.getBand(mstBandName);
        }
        if (this.masterBand1.getUnit() != null && this.masterBand1.getUnit().equals("real")) {
            int mstIdx = this.sourceProduct.getBandIndex(mstBandName);
            if (this.sourceProduct.getNumBands() > mstIdx + 1) {
                this.masterBand2 = this.sourceProduct.getBandAt(mstIdx + 1);
                this.complexCoregistration = true;
            }
        }
    }

    private static String[] getMasterBandNames(Product sourceProduct) {
        ArrayList<String> bandNames = new ArrayList<String>();
        for (String bandName : sourceProduct.getBandNames()) {
            if (!bandName.toLowerCase().contains("_mst")) continue;
            bandNames.add(bandName);
        }
        return bandNames.toArray(new String[bandNames.size()]);
    }

    private static void addGCPGrid(int width, int height, int numPins, ProductNodeGroup<Placemark> group, GeoCoding targetGeoCoding) {
        double ratio = (double)width / (double)height;
        double n = Math.sqrt((double)numPins / ratio);
        double m = ratio * n;
        double spacingX = (double)width / m;
        double spacingY = (double)height / n;
        GcpDescriptor gcpDescriptor = GcpDescriptor.getInstance();
        group.removeAll();
        int pinNumber = group.getNodeCount() + 1;
        for (double y = spacingY / 2.0; y < (double)height; y += spacingY) {
            for (double x = spacingX / 2.0; x < (double)width; x += spacingX) {
                String name = PlacemarkNameFactory.createName((PlacemarkDescriptor)gcpDescriptor, (int)pinNumber);
                String label = PlacemarkNameFactory.createLabel((PlacemarkDescriptor)gcpDescriptor, (int)pinNumber, (boolean)true);
                Placemark newPin = Placemark.createPointPlacemark((PlacemarkDescriptor)gcpDescriptor, (String)name, (String)label, (String)"", (PixelPos)new PixelPos((double)((int)x), (double)((int)y)), null, (GeoCoding)targetGeoCoding);
                group.add((ProductNode)newPin);
                ++pinNumber;
            }
        }
    }

    private void getCollocatedStackFlag() {
        MetadataAttribute attr;
        this.collocatedStack = false;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        if (absRoot != null && (attr = absRoot.getAttribute("collocated_stack")) != null) {
            this.collocatedStack = true;
            absRoot.removeAttribute(attr);
        }
    }

    private void createTargetProduct() {
        String unit;
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        int numSrcBands = this.sourceProduct.getNumBands();
        Band slvBand1 = null;
        Object slvBand2 = null;
        String mstPol = OperatorUtils.getPolarizationFromBandName((String)this.masterBand1.getName());
        for (Band slvBand : this.sourceProduct.getBands()) {
            if (StringUtils.contains((String[])this.masterBandNames, (String)slvBand.getName()) || slvBand == this.masterBand1) continue;
            String slvPol = OperatorUtils.getPolarizationFromBandName((String)slvBand.getName());
            if (mstPol != null && slvPol != null && !mstPol.equals(slvPol)) continue;
            String unit2 = slvBand.getUnit();
            if (unit2 != null && !unit2.contains("imaginary")) {
                slvBand1 = slvBand;
                break;
            }
            if (unit2 != null) continue;
            slvBand1 = slvBand;
        }
        if (slvBand1 == null) {
            for (Band slvBand : this.sourceProduct.getBands()) {
                if (StringUtils.contains((String[])this.masterBandNames, (String)slvBand.getName()) || slvBand == this.masterBand1) continue;
                unit = slvBand.getUnit();
                if (unit != null && !unit.contains("imaginary")) {
                    slvBand1 = slvBand;
                    break;
                }
                if (unit != null) continue;
                slvBand1 = slvBand;
            }
        }
        boolean oneSlaveProcessed = false;
        for (int i = 0; i < numSrcBands; ++i) {
            Band srcBand = this.sourceProduct.getBandAt(i);
            Band targetBand = this.targetProduct.addBand(srcBand.getName(), srcBand.getDataType());
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBand, (RasterDataNode)targetBand);
            this.sourceRasterMap.put(targetBand, srcBand);
            this.gcpsComputedMap.put(srcBand, false);
            if (srcBand == this.masterBand1 || srcBand == this.masterBand2 || oneSlaveProcessed || srcBand != slvBand1 && slvBand1 != null || StringUtils.contains((String[])this.masterBandNames, (String)srcBand.getName())) {
                targetBand.setSourceImage(srcBand.getSourceImage());
            } else {
                unit = srcBand.getUnit();
                if (!(oneSlaveProcessed || unit != null && unit.contains("imaginary"))) {
                    oneSlaveProcessed = true;
                    this.primarySlaveBand = srcBand;
                    MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
                    AbstractMetadata.addAbstractedAttribute((MetadataElement)absRoot, (String)"processed_slave", (int)41, (String)"", (String)"");
                    absRoot.setAttributeString("processed_slave", this.primarySlaveBand.getName());
                }
            }
            if (!this.complexCoregistration || srcBand.getUnit() == null || !srcBand.getUnit().equals("real") || i + 1 >= numSrcBands) continue;
            this.complexSrcMap.put(srcBand, this.sourceProduct.getBandAt(i + 1));
        }
    }

    private synchronized void createDEM() {
        if (this.dem != null) {
            return;
        }
        ElevationModelRegistry elevationModelRegistry = ElevationModelRegistry.getInstance();
        ElevationModelDescriptor demDescriptor = elevationModelRegistry.getDescriptor("SRTM 3Sec");
        this.dem = demDescriptor.createDem(ResamplingFactory.createResampling((String)"NEAREST_NEIGHBOUR"));
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            Band slaveBand;
            if (this.onlyGCPsOnLand && this.dem == null) {
                this.createDEM();
            }
            String[] masterBandNames = StackUtils.getMasterBandNames((Product)this.sourceProduct);
            HashMap<String, Band> singleSlvBandMap = new HashMap<String, Band>();
            HashMap<Band, Band> bandList = new HashMap<Band, Band>();
            for (Band targetBand : this.targetProduct.getBands()) {
                String unit;
                slaveBand = this.sourceRasterMap.get(targetBand);
                if (this.gcpsComputedMap.get(slaveBand).booleanValue()) {
                    bandList.put(targetBand, this.primarySlaveBand);
                    break;
                }
                if (slaveBand == this.masterBand1 || slaveBand == this.masterBand2 || StringUtils.contains((String[])masterBandNames, (String)slaveBand.getName())) continue;
                if (this.collocatedStack && !this.useAllPolarimetricBands) {
                    String mstPol = OperatorUtils.getPolarizationFromBandName((String)this.masterBand1.getName());
                    String slvProductName = StackUtils.getSlaveProductName((Product)this.targetProduct, (Band)targetBand, (String)mstPol);
                    if (slvProductName == null || singleSlvBandMap.get(slvProductName) != null) continue;
                    singleSlvBandMap.put(slvProductName, targetBand);
                }
                if ((unit = slaveBand.getUnit()) != null && (unit.contains("imaginary") || unit.contains("bit") || this.complexCoregistration && unit.contains("intensity"))) continue;
                bandList.put(targetBand, slaveBand);
            }
            int bandCnt = 0;
            Band firstTargetBand = null;
            for (Band targetBand : bandList.keySet()) {
                Tile targetTile;
                slaveBand = (Band)bandList.get(targetBand);
                if (this.collocatedStack || !this.collocatedStack && ++bandCnt == 1) {
                    String bandCountStr = bandCnt + " of " + bandList.size();
                    if (this.complexCoregistration) {
                        this.computeSlaveGCPs(slaveBand, this.complexSrcMap.get(slaveBand), targetBand, bandCountStr);
                    } else {
                        this.computeSlaveGCPs(slaveBand, null, targetBand, bandCountStr);
                    }
                    if (bandCnt == 1) {
                        firstTargetBand = targetBand;
                    }
                } else {
                    CrossCorrelationOp.copyFirstTargetBandGCPs(firstTargetBand, targetBand);
                }
                if (slaveBand != this.primarySlaveBand || (targetTile = targetTileMap.get(targetBand)) == null) continue;
                targetTile.setRawSamples(this.getSourceTile((RasterDataNode)slaveBand, targetRectangle).getRawSamples());
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private synchronized void computeSlaveGCPs(final Band slaveBand1, final Band slaveBand2, Band targetBand, String bandCountStr) throws OperatorException {
        if (this.gcpsComputedMap.get(slaveBand1).booleanValue()) {
            return;
        }
        try {
            final ProductNodeGroup targetGCPGroup = GCPManager.instance().getGcpGroup(targetBand);
            final GeoCoding tgtGeoCoding = this.targetProduct.getSceneGeoCoding();
            int[] offset = new int[2];
            if (this.computeOffset) {
                this.determiningImageOffset(slaveBand1, slaveBand2, offset);
            }
            ThreadManager threadManager = new ThreadManager();
            int numberOfMasterGCPs = this.masterGcpGroup.getNodeCount();
            StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
            status.beginTask("Cross Correlating " + bandCountStr + ' ' + slaveBand1.getName() + "... ", numberOfMasterGCPs);
            for (int i = 0; i < numberOfMasterGCPs; ++i) {
                this.checkForCancellation();
                final Placemark mPin = (Placemark)this.masterGcpGroup.get(i);
                if (this.checkMasterGCPValidity(mPin)) {
                    final GeoPos mGCPGeoPos = mPin.getGeoPos();
                    final PixelPos mGCPPixelPos = mPin.getPixelPos();
                    final PixelPos sGCPPixelPos = new PixelPos(mPin.getPixelPos().x + (double)offset[0], mPin.getPixelPos().y + (double)offset[1]);
                    if (!this.checkSlaveGCPValidity(sGCPPixelPos)) continue;
                    Thread worker = new Thread(){

                        @Override
                        public void run() {
                            boolean getSlaveGCP = CrossCorrelationOp.this.getCoarseSlaveGCPPosition(slaveBand1, slaveBand2, mGCPPixelPos, sGCPPixelPos);
                            if (getSlaveGCP && CrossCorrelationOp.this.complexCoregistration && CrossCorrelationOp.this.applyFineRegistration) {
                                getSlaveGCP = CrossCorrelationOp.this.inSAROptimized ? CrossCorrelationOp.this.getFineOffsets(slaveBand1, slaveBand2, mGCPPixelPos, sGCPPixelPos) : CrossCorrelationOp.this.getFineSlaveGCPPosition(slaveBand1, slaveBand2, mGCPPixelPos, sGCPPixelPos);
                            }
                            if (getSlaveGCP) {
                                Placemark sPin = Placemark.createPointPlacemark((PlacemarkDescriptor)GcpDescriptor.getInstance(), (String)mPin.getName(), (String)mPin.getLabel(), (String)mPin.getDescription(), (PixelPos)sGCPPixelPos, (GeoPos)mGCPGeoPos, (GeoCoding)tgtGeoCoding);
                                this.addPlacemark(sPin);
                            }
                        }

                        private synchronized void addPlacemark(Placemark pin) {
                            targetGCPGroup.add((ProductNode)pin);
                        }
                    };
                    threadManager.add(worker);
                }
                status.worked(1);
            }
            threadManager.finish();
            MemUtils.tileCacheFreeOldTiles();
            status.done();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " computeSlaveGCPs "), (Throwable)e);
        }
        this.gcpsComputedMap.put(slaveBand1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determiningImageOffset(final Band slaveBand1, final Band slaveBand2, int[] offset) {
        try {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            double groundRangeSpacing = absRoot.getAttributeDouble("range_spacing", 1.0);
            double azimuthSpacing = absRoot.getAttributeDouble("azimuth_spacing", 1.0);
            boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)absRoot, (String)"srgr_flag");
            if (!srgrFlag) {
                TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
                double incidenceAngleAtCentreRangePixel = incidenceAngle.getPixelDouble((double)((float)this.sourceImageWidth / 2.0f), (double)((float)this.sourceImageHeight / 2.0f));
                groundRangeSpacing /= FastMath.sin((double)(incidenceAngleAtCentreRangePixel * (Math.PI / 180)));
            }
            final int nRgLooks = Math.max(1, this.sourceImageWidth / 2048);
            final int nAzLooks = Math.max(1, (int)((double)nRgLooks * groundRangeSpacing / azimuthSpacing + 0.5));
            int targetImageWidth = this.sourceImageWidth / nRgLooks;
            int targetImageHeight = this.sourceImageHeight / nAzLooks;
            final int windowWidth = (int)FastMath.pow((double)2.0, (int)((int)(Math.log10(targetImageWidth) / Math.log10(2.0))));
            int windowHeight = (int)FastMath.pow((double)2.0, (int)((int)(Math.log10(targetImageHeight) / Math.log10(2.0))));
            final double[] mI = new double[windowWidth * windowHeight];
            final double[] sI = new double[windowWidth * windowHeight];
            int tileCountX = 4;
            int tileCountY = 4;
            int tileWidth = windowWidth / 4;
            int tileHeight = windowHeight / 4;
            Rectangle[] tileRectangles = new Rectangle[16];
            int index = 0;
            for (int tileY = 0; tileY < 4; ++tileY) {
                int ypos = tileY * tileHeight;
                for (int tileX = 0; tileX < 4; ++tileX) {
                    Rectangle tileRectangle = new Rectangle(tileX * tileWidth, ypos, tileWidth, tileHeight);
                    tileRectangles[index++] = tileRectangle;
                }
            }
            final StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
            status.beginTask("Computing offset... ", tileRectangles.length);
            ThreadManager threadManager = new ThreadManager();
            try {
                for (final Rectangle rectangle : tileRectangles) {
                    this.checkForCancellation();
                    Thread worker = new Thread(){

                        @Override
                        public void run() {
                            int x0 = rectangle.x;
                            int y0 = rectangle.y;
                            int w = rectangle.width;
                            int h = rectangle.height;
                            int xMax = x0 + w;
                            int yMax = y0 + h;
                            int xStart = x0 * nRgLooks;
                            int yStart = y0 * nAzLooks;
                            int xEnd = xMax * nRgLooks;
                            int yEnd = yMax * nAzLooks;
                            Rectangle srcRect = new Rectangle(xStart, yStart, xEnd - xStart, yEnd - yStart);
                            Tile mstTile1 = CrossCorrelationOp.this.getSourceTile((RasterDataNode)CrossCorrelationOp.this.masterBand1, srcRect);
                            ProductData mstData1 = mstTile1.getDataBuffer();
                            TileIndex mstIndex = new TileIndex(mstTile1);
                            Tile slvTile1 = CrossCorrelationOp.this.getSourceTile((RasterDataNode)slaveBand1, srcRect);
                            ProductData slvData1 = slvTile1.getDataBuffer();
                            TileIndex slvIndex = new TileIndex(slvTile1);
                            ProductData mstData2 = null;
                            ProductData slvData2 = null;
                            if (CrossCorrelationOp.this.complexCoregistration) {
                                mstData2 = CrossCorrelationOp.this.getSourceTile((RasterDataNode)CrossCorrelationOp.this.masterBand2, srcRect).getDataBuffer();
                                slvData2 = CrossCorrelationOp.this.getSourceTile((RasterDataNode)slaveBand2, srcRect).getDataBuffer();
                            }
                            double rgAzLooks = nRgLooks * nAzLooks;
                            for (int y = y0; y < yMax; ++y) {
                                int yByWidth = y * windowWidth;
                                int y1 = y * nAzLooks;
                                int y2 = y1 + nAzLooks;
                                for (int x = x0; x < xMax; ++x) {
                                    int x1 = x * nRgLooks;
                                    int x2 = x1 + nRgLooks;
                                    mI[yByWidth + x] = CrossCorrelationOp.this.getMeanValue(x1, x2, y1, y2, mstData1, mstData2, mstIndex, rgAzLooks);
                                    sI[yByWidth + x] = CrossCorrelationOp.this.getMeanValue(x1, x2, y1, y2, slvData1, slvData2, slvIndex, rgAzLooks);
                                }
                            }
                            status.worked(1);
                        }
                    };
                    threadManager.add(worker);
                }
                threadManager.finish();
            }
            catch (Throwable e) {
                OperatorUtils.catchOperatorException((String)"GCPSelectionOp", (Throwable)e);
            }
            finally {
                status.done();
            }
            RenderedImage masterImage = CrossCorrelationOp.createRenderedImage(mI, windowWidth, windowHeight);
            PlanarImage masterSpectrum = JAIFunctions.dft(masterImage);
            RenderedImage slaveImage = CrossCorrelationOp.createRenderedImage(sI, windowWidth, windowHeight);
            PlanarImage slaveSpectrum = JAIFunctions.dft(slaveImage);
            PlanarImage conjugateSlaveSpectrum = JAIFunctions.conjugate(slaveSpectrum);
            PlanarImage crossSpectrum = JAIFunctions.multiplyComplex(masterSpectrum, conjugateSlaveSpectrum);
            PlanarImage correlatedImage = JAIFunctions.idft((RenderedImage)crossSpectrum);
            PlanarImage crossCorrelatedImage = JAIFunctions.magnitude(correlatedImage);
            int w = crossCorrelatedImage.getWidth();
            int h = crossCorrelatedImage.getHeight();
            Raster idftData = crossCorrelatedImage.getData();
            double[] real = idftData.getSamples(0, 0, w, h, 0, (double[])null);
            int peakRow = 0;
            int peakCol = 0;
            double peak = 0.0;
            for (int r = 0; r < h; ++r) {
                for (int c = 0; c < w; ++c) {
                    int s;
                    if (r >= h / 4 && r <= h * 3 / 4 || c >= w / 4 && c <= w * 3 / 4 || !(peak < real[s = r * w + c])) continue;
                    peak = real[s];
                    peakRow = r;
                    peakCol = c;
                }
            }
            offset[1] = peakRow <= h / 2 ? -peakRow * nAzLooks : (h - peakRow) * nAzLooks;
            offset[0] = peakCol <= w / 2 ? -peakCol * nRgLooks : (w - peakCol) * nRgLooks;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " determiningImageOffset "), (Throwable)e);
        }
    }

    private double getMeanValue(int xStart, int xEnd, int yStart, int yEnd, ProductData srcData1, ProductData srcData2, TileIndex srcIndex, double rgAzLooks) {
        double meanValue = 0.0;
        if (this.complexCoregistration) {
            for (int y = yStart; y < yEnd; ++y) {
                srcIndex.calculateStride(y);
                for (int x = xStart; x < xEnd; ++x) {
                    int idx = srcIndex.getIndex(x);
                    double v1 = srcData1.getElemDoubleAt(idx);
                    double v2 = srcData2.getElemDoubleAt(idx);
                    meanValue += v1 * v1 + v2 * v2;
                }
            }
        } else {
            for (int y = yStart; y < yEnd; ++y) {
                srcIndex.calculateStride(y);
                for (int x = xStart; x < xEnd; ++x) {
                    meanValue += srcData1.getElemDoubleAt(srcIndex.getIndex(x));
                }
            }
        }
        return meanValue / rgAzLooks;
    }

    private static void copyFirstTargetBandGCPs(Band firstTargetBand, Band targetBand) {
        ProductNodeGroup firstTargetBandGcpGroup = GCPManager.instance().getGcpGroup(firstTargetBand);
        ProductNodeGroup currentTargetBandGCPGroup = GCPManager.instance().getGcpGroup(targetBand);
        int numberOfGCPs = firstTargetBandGcpGroup.getNodeCount();
        for (int i = 0; i < numberOfGCPs; ++i) {
            currentTargetBandGCPGroup.add(firstTargetBandGcpGroup.get(i));
        }
    }

    private boolean checkMasterGCPValidity(Placemark mPin) throws Exception {
        double alt;
        PixelPos pixelPos = mPin.getPixelPos();
        if (this.onlyGCPsOnLand && (alt = this.dem.getElevation(mPin.getGeoPos())) == (double)this.dem.getDescriptor().getNoDataValue()) {
            return false;
        }
        return pixelPos.x - (double)this.cHalfWindowWidth + 1.0 >= 0.0 && pixelPos.x + (double)this.cHalfWindowWidth <= (double)(this.sourceImageWidth - 1) && pixelPos.y - (double)this.cHalfWindowHeight + 1.0 >= 0.0 && pixelPos.y + (double)this.cHalfWindowHeight <= (double)(this.sourceImageHeight - 1);
    }

    private boolean checkSlaveGCPValidity(PixelPos pixelPos) {
        return pixelPos.x - (double)this.cHalfWindowWidth + 1.0 >= 0.0 && pixelPos.x + (double)this.cHalfWindowWidth <= (double)(this.sourceImageWidth - 1) && pixelPos.y - (double)this.cHalfWindowHeight + 1.0 >= 0.0 && pixelPos.y + (double)this.cHalfWindowHeight <= (double)(this.sourceImageHeight - 1);
    }

    private boolean getFineOffsets(Band slaveBand1, Band slaveBand2, PixelPos mGCPPixelPos, PixelPos sGCPPixelPos) {
        try {
            ComplexDoubleMatrix mI = this.getComplexDoubleMatrix(this.masterBand1, this.masterBand2, mGCPPixelPos, this.fineWin);
            ComplexDoubleMatrix sI = this.getComplexDoubleMatrix(slaveBand1, slaveBand2, sGCPPixelPos, this.fineWin);
            double[] fineOffset = new double[]{sGCPPixelPos.x, sGCPPixelPos.y};
            double coherence = CoregistrationUtils.crossCorrelateFFT((double[])fineOffset, (ComplexDoubleMatrix)mI, (ComplexDoubleMatrix)sI, (int)this.fineWin.ovsFactor, (int)this.fineWin.accY, (int)this.fineWin.accX);
            if (coherence < this.coherenceThreshold) {
                return false;
            }
            sGCPPixelPos.x += (double)((float)fineOffset[1]);
            sGCPPixelPos.y += (double)((float)fineOffset[0]);
            return true;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " getFineSlaveGCPPosition "), (Throwable)e);
            return false;
        }
    }

    private ComplexDoubleMatrix getComplexDoubleMatrix(Band band1, Band band2, PixelPos pixelPos, CorrelationWindow corrWindow) {
        Rectangle rectangle = corrWindow.defineRectangleMask(pixelPos);
        Tile tileReal = this.getSourceTile((RasterDataNode)band1, rectangle);
        Tile tileImag = null;
        if (band2 != null) {
            tileImag = this.getSourceTile((RasterDataNode)band2, rectangle);
        }
        return TileUtilsDoris.pullComplexDoubleMatrix((Tile)tileReal, tileImag);
    }

    private boolean getCoarseSlaveGCPPosition(Band slaveBand, Band slaveBand2, PixelPos mGCPPixelPos, PixelPos sGCPPixelPos) {
        try {
            double[] mI = new double[this.cWindowWidth * this.cWindowHeight];
            double[] sI = new double[this.cWindowWidth * this.cWindowHeight];
            boolean getMISuccess = this.getMasterImagette(mGCPPixelPos, mI);
            if (!getMISuccess) {
                return false;
            }
            double rowShift = this.gcpTolerance + 1.0;
            double colShift = this.gcpTolerance + 1.0;
            int numIter = 0;
            while (Math.abs(rowShift) >= this.gcpTolerance || Math.abs(colShift) >= this.gcpTolerance) {
                if (numIter >= this.maxIteration) {
                    return false;
                }
                if (!this.checkSlaveGCPValidity(sGCPPixelPos)) {
                    return false;
                }
                boolean getSISuccess = this.getSlaveImagette(slaveBand, slaveBand2, sGCPPixelPos, sI);
                if (!getSISuccess) {
                    return false;
                }
                double[] shift = new double[]{0.0, 0.0};
                if (!this.getSlaveGCPShift(shift, mI, sI)) {
                    return false;
                }
                rowShift = shift[0];
                colShift = shift[1];
                sGCPPixelPos.x += colShift;
                sGCPPixelPos.y += rowShift;
                ++numIter;
            }
            return true;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " getCoarseSlaveGCPPosition "), (Throwable)e);
            return false;
        }
    }

    private boolean getMasterImagette(PixelPos gcpPixelPos, double[] mI) throws OperatorException {
        int x0 = (int)gcpPixelPos.x;
        int y0 = (int)gcpPixelPos.y;
        int xul = x0 - this.cHalfWindowWidth + 1;
        int yul = y0 - this.cHalfWindowHeight + 1;
        Rectangle masterImagetteRectangle = new Rectangle(xul, yul, this.cWindowWidth, this.cWindowHeight);
        try {
            Tile masterImagetteRaster1 = this.getSourceTile((RasterDataNode)this.masterBand1, masterImagetteRectangle);
            ProductData masterData1 = masterImagetteRaster1.getDataBuffer();
            Double noDataValue1 = this.masterBand1.getNoDataValue();
            ProductData masterData2 = null;
            Double noDataValue2 = 0.0;
            if (this.complexCoregistration) {
                Tile masterImagetteRaster2 = this.getSourceTile((RasterDataNode)this.masterBand2, masterImagetteRectangle);
                masterData2 = masterImagetteRaster2.getDataBuffer();
                noDataValue2 = this.masterBand2.getNoDataValue();
            }
            TileIndex mstIndex = new TileIndex(masterImagetteRaster1);
            int k = 0;
            int numInvalidPixels = 0;
            for (int j = 0; j < this.cWindowHeight; ++j) {
                int offset = mstIndex.calculateStride(yul + j);
                for (int i = 0; i < this.cWindowWidth; ++i) {
                    int index = xul + i - offset;
                    if (this.complexCoregistration) {
                        double v1 = masterData1.getElemDoubleAt(index);
                        double v2 = masterData2.getElemDoubleAt(index);
                        if (noDataValue1.equals(v1) && noDataValue2.equals(v2)) {
                            ++numInvalidPixels;
                        }
                        mI[k++] = v1 * v1 + v2 * v2;
                        continue;
                    }
                    double v = masterData1.getElemDoubleAt(index);
                    if (noDataValue1.equals(v)) {
                        ++numInvalidPixels;
                    }
                    mI[k++] = v;
                }
            }
            masterData1.dispose();
            if (masterData2 != null) {
                masterData2.dispose();
            }
            return (double)numInvalidPixels <= 0.66 * (double)this.cWindowHeight * (double)this.cWindowWidth;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"getMasterImagette", (Throwable)e);
            return false;
        }
    }

    private boolean getSlaveImagette(Band slaveBand1, Band slaveBand2, PixelPos gcpPixelPos, double[] sI) throws OperatorException {
        double xx = gcpPixelPos.x;
        double yy = gcpPixelPos.y;
        int xul = (int)xx - this.cHalfWindowWidth;
        int yul = (int)yy - this.cHalfWindowHeight;
        Rectangle slaveImagetteRectangle = new Rectangle(xul, yul, this.cWindowWidth + 3, this.cWindowHeight + 3);
        int k = 0;
        try {
            Tile slaveImagetteRaster1 = this.getSourceTile((RasterDataNode)slaveBand1, slaveImagetteRectangle);
            ProductData slaveData1 = slaveImagetteRaster1.getDataBuffer();
            Double noDataValue1 = slaveBand1.getNoDataValue();
            Tile slaveImagetteRaster2 = null;
            ProductData slaveData2 = null;
            Double noDataValue2 = 0.0;
            if (this.complexCoregistration) {
                slaveImagetteRaster2 = this.getSourceTile((RasterDataNode)slaveBand2, slaveImagetteRectangle);
                slaveData2 = slaveImagetteRaster2.getDataBuffer();
                noDataValue2 = slaveBand2.getNoDataValue();
            }
            TileIndex index0 = new TileIndex(slaveImagetteRaster1);
            TileIndex index1 = new TileIndex(slaveImagetteRaster1);
            int numInvalidPixels = 0;
            for (int j = 0; j < this.cWindowHeight; ++j) {
                double y = yy - (double)this.cHalfWindowHeight + (double)j + 1.0;
                int y0 = (int)y;
                int y1 = y0 + 1;
                int offset0 = index0.calculateStride(y0);
                int offset1 = index1.calculateStride(y1);
                double wy = y - (double)y0;
                for (int i = 0; i < this.cWindowWidth; ++i) {
                    double x = xx - (double)this.cHalfWindowWidth + (double)i + 1.0;
                    int x0 = (int)x;
                    int x1 = x0 + 1;
                    double wx = x - (double)x0;
                    int x00 = x0 - offset0;
                    int x01 = x0 - offset1;
                    int x10 = x1 - offset0;
                    int x11 = x1 - offset1;
                    if (this.complexCoregistration) {
                        double v1 = MathUtils.interpolate2D((double)wy, (double)wx, (double)slaveData1.getElemDoubleAt(x00), (double)slaveData1.getElemDoubleAt(x01), (double)slaveData1.getElemDoubleAt(x10), (double)slaveData1.getElemDoubleAt(x11));
                        double v2 = MathUtils.interpolate2D((double)wy, (double)wx, (double)slaveData2.getElemDoubleAt(x00), (double)slaveData2.getElemDoubleAt(x01), (double)slaveData2.getElemDoubleAt(x10), (double)slaveData2.getElemDoubleAt(x11));
                        if (noDataValue1.equals(v1) && noDataValue2.equals(v2)) {
                            ++numInvalidPixels;
                        }
                        sI[k] = v1 * v1 + v2 * v2;
                    } else {
                        double v = MathUtils.interpolate2D((double)wy, (double)wx, (double)slaveData1.getElemDoubleAt(x00), (double)slaveData1.getElemDoubleAt(x01), (double)slaveData1.getElemDoubleAt(x10), (double)slaveData1.getElemDoubleAt(x11));
                        if (noDataValue1.equals(v)) {
                            ++numInvalidPixels;
                        }
                        sI[k] = v;
                    }
                    ++k;
                }
            }
            slaveData1.dispose();
            if (slaveData2 != null) {
                slaveData2.dispose();
            }
            return (double)numInvalidPixels <= 0.66 * (double)this.cWindowHeight * (double)this.cWindowWidth;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"getSlaveImagette", (Throwable)e);
            return false;
        }
    }

    private boolean getSlaveGCPShift(double[] shift, double[] mI, double[] sI) {
        try {
            PlanarImage crossCorrelatedImage = this.computeCrossCorrelatedImage(mI, sI);
            int w = crossCorrelatedImage.getWidth();
            int h = crossCorrelatedImage.getHeight();
            Raster idftData = crossCorrelatedImage.getData();
            double[] real = idftData.getSamples(0, 0, w, h, 0, (double[])null);
            int peakRow = 0;
            int peakCol = 0;
            double peak = real[0];
            for (int r = 0; r < h; ++r) {
                for (int c = 0; c < w; ++c) {
                    int k = r * w + c;
                    if (!(real[k] > peak)) continue;
                    peak = real[k];
                    peakRow = r;
                    peakCol = c;
                }
            }
            shift[0] = peakRow <= h / 2 ? (double)(-peakRow) / (double)this.rowUpSamplingFactor : (double)(h - peakRow) / (double)this.rowUpSamplingFactor;
            shift[1] = peakCol <= w / 2 ? (double)(-peakCol) / (double)this.colUpSamplingFactor : (double)(w - peakCol) / (double)this.colUpSamplingFactor;
            return true;
        }
        catch (Throwable t) {
            SystemUtils.LOG.warning("getSlaveGCPShift failed " + t.getMessage());
            return false;
        }
    }

    private PlanarImage computeCrossCorrelatedImage(double[] mI, double[] sI) {
        RenderedImage masterImage = CrossCorrelationOp.createRenderedImage(mI, this.cWindowWidth, this.cWindowHeight);
        PlanarImage masterSpectrum = JAIFunctions.dft(masterImage);
        RenderedImage slaveImage = CrossCorrelationOp.createRenderedImage(sI, this.cWindowWidth, this.cWindowHeight);
        PlanarImage slaveSpectrum = JAIFunctions.dft(slaveImage);
        PlanarImage conjugateSlaveSpectrum = JAIFunctions.conjugate(slaveSpectrum);
        PlanarImage crossSpectrum = JAIFunctions.multiplyComplex(masterSpectrum, conjugateSlaveSpectrum);
        RenderedImage upsampledCrossSpectrum = JAIFunctions.upsampling(crossSpectrum, this.rowUpSamplingFactor, this.colUpSamplingFactor);
        PlanarImage correlatedImage = JAIFunctions.idft(upsampledCrossSpectrum);
        return JAIFunctions.magnitude(correlatedImage);
    }

    private static RenderedImage createRenderedImage(double[] array, int w, int h) {
        SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)5, (int)w, (int)h, (int)1);
        ColorModel colourModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        DataBufferDouble dataBuffer = new DataBufferDouble(array, array.length);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (DataBuffer)dataBuffer, (Point)new Point(0, 0));
        return new BufferedImage(colourModel, raster, false, null);
    }

    private static void outputRealImage(double[] I) {
        for (double v : I) {
            System.out.print(v + ",");
        }
        System.out.println();
    }

    private static void outputComplexImage(PlanarImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        Raster dftData = image.getData();
        double[] real = dftData.getSamples(0, 0, w, h, 0, (double[])null);
        double[] imag = dftData.getSamples(0, 0, w, h, 1, (double[])null);
        System.out.println("Real part:");
        for (double v : real) {
            System.out.print(v + ", ");
        }
        System.out.println();
        System.out.println("Imaginary part:");
        for (double v : imag) {
            System.out.print(v + ", ");
        }
        System.out.println();
    }

    public void setTestParameters(String windowWidth, String windowHeight, String rowUpSamplingFactor, String colUpSamplingFactor, int maxIter, double tolerance) {
        this.coarseRegistrationWindowWidth = windowWidth;
        this.coarseRegistrationWindowHeight = windowHeight;
        this.rowInterpFactor = rowUpSamplingFactor;
        this.columnInterpFactor = colUpSamplingFactor;
        this.maxIteration = maxIter;
        this.gcpTolerance = tolerance;
    }

    private boolean getFineSlaveGCPPosition(Band slaveBand1, Band slaveBand2, PixelPos mGCPPixelPos, PixelPos sGCPPixelPos) {
        try {
            FineRegistration fineRegistration = new FineRegistration();
            FineRegistration.ComplexCoregData complexData = new FineRegistration.ComplexCoregData(this.coherenceWindowSize, 1.0E-5, 0.01, this.fWindowWidth, this.fWindowHeight, this.useSlidingWindow);
            this.getComplexMasterImagette(complexData, mGCPPixelPos);
            this.getInitialComplexSlaveImagette(fineRegistration, complexData, slaveBand1, slaveBand2, sGCPPixelPos);
            double[] p = new double[]{sGCPPixelPos.x, sGCPPixelPos.y};
            double coherence = FineRegistration.powell(complexData, p);
            complexData.dispose();
            if (1.0 - coherence < this.coherenceThreshold) {
                return false;
            }
            sGCPPixelPos.x = p[0];
            sGCPPixelPos.y = p[1];
            return true;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " getFineSlaveGCPPosition "), (Throwable)e);
            return false;
        }
    }

    private void getComplexMasterImagette(FineRegistration.ComplexCoregData complexData, PixelPos gcpPixelPos) {
        complexData.mII = new double[complexData.fWindowHeight][complexData.fWindowWidth];
        complexData.mIQ = new double[complexData.fWindowHeight][complexData.fWindowWidth];
        int x0 = (int)gcpPixelPos.x;
        int y0 = (int)gcpPixelPos.y;
        int xul = x0 - complexData.fHalfWindowWidth + 1;
        int yul = y0 - complexData.fHalfWindowHeight + 1;
        Rectangle masterImagetteRectangle = new Rectangle(xul, yul, complexData.fWindowWidth, complexData.fWindowHeight);
        Tile masterImagetteRaster1 = this.getSourceTile((RasterDataNode)this.masterBand1, masterImagetteRectangle);
        Tile masterImagetteRaster2 = this.getSourceTile((RasterDataNode)this.masterBand2, masterImagetteRectangle);
        ProductData masterData1 = masterImagetteRaster1.getDataBuffer();
        ProductData masterData2 = masterImagetteRaster2.getDataBuffer();
        TileIndex index = new TileIndex(masterImagetteRaster1);
        double[][] mIIdata = complexData.mII;
        double[][] mIQdata = complexData.mIQ;
        for (int j = 0; j < complexData.fWindowHeight; ++j) {
            index.calculateStride(yul + j);
            for (int i = 0; i < complexData.fWindowWidth; ++i) {
                int idx = index.getIndex(xul + i);
                mIIdata[j][i] = masterData1.getElemDoubleAt(idx);
                mIQdata[j][i] = masterData2.getElemDoubleAt(idx);
            }
        }
        masterData1.dispose();
        masterData2.dispose();
    }

    private static void getInitialComplexSlaveImagette(FineRegistration fineRegistration, FineRegistration.ComplexCoregData complexData, PixelPos mGCPPixelPos) {
        complexData.sII0 = new double[complexData.fWindowHeight][complexData.fWindowWidth];
        complexData.sIQ0 = new double[complexData.fWindowHeight][complexData.fWindowWidth];
        complexData.point0[0] = mGCPPixelPos.x;
        complexData.point0[1] = mGCPPixelPos.y;
        double[][] mIIdata = complexData.mII;
        double[][] mIQdata = complexData.mIQ;
        double[][] sII0data = complexData.sII0;
        double[][] sIQ0data = complexData.sIQ0;
        double xShift = 0.3;
        double yShift = -0.2;
        FineRegistration.getShiftedData(complexData, mIIdata, mIQdata, 0.3, -0.2, sII0data, sIQ0data);
    }

    private void getInitialComplexSlaveImagette(FineRegistration fineRegistration, FineRegistration.ComplexCoregData complexData, Band slaveBand1, Band slaveBand2, PixelPos sGCPPixelPos) {
        complexData.sII0 = new double[complexData.fWindowHeight][complexData.fWindowWidth];
        complexData.sIQ0 = new double[complexData.fWindowHeight][complexData.fWindowWidth];
        complexData.point0[0] = sGCPPixelPos.x;
        complexData.point0[1] = sGCPPixelPos.y;
        double[][] sII0data = complexData.sII0;
        double[][] sIQ0data = complexData.sIQ0;
        double[][] tmpI = new double[complexData.fWindowHeight][complexData.fWindowWidth];
        double[][] tmpQ = new double[complexData.fWindowHeight][complexData.fWindowWidth];
        int x0 = (int)(sGCPPixelPos.x + 0.5);
        int y0 = (int)(sGCPPixelPos.y + 0.5);
        int xul = x0 - complexData.fHalfWindowWidth + 1;
        int yul = y0 - complexData.fHalfWindowHeight + 1;
        Rectangle slaveImagetteRectangle = new Rectangle(xul, yul, complexData.fWindowWidth, complexData.fWindowHeight);
        Tile slaveImagetteRaster1 = this.getSourceTile((RasterDataNode)slaveBand1, slaveImagetteRectangle);
        Tile slaveImagetteRaster2 = this.getSourceTile((RasterDataNode)slaveBand2, slaveImagetteRectangle);
        ProductData slaveData1 = slaveImagetteRaster1.getDataBuffer();
        ProductData slaveData2 = slaveImagetteRaster2.getDataBuffer();
        TileIndex index = new TileIndex(slaveImagetteRaster1);
        for (int j = 0; j < complexData.fWindowHeight; ++j) {
            index.calculateStride(yul + j);
            for (int i = 0; i < complexData.fWindowWidth; ++i) {
                int idx = index.getIndex(xul + i);
                tmpI[j][i] = slaveData1.getElemDoubleAt(idx);
                tmpQ[j][i] = slaveData2.getElemDoubleAt(idx);
            }
        }
        slaveData1.dispose();
        slaveData2.dispose();
        double xShift = sGCPPixelPos.x - (double)x0;
        double yShift = sGCPPixelPos.y - (double)y0;
        FineRegistration.getShiftedData(complexData, tmpI, tmpQ, xShift, yShift, sII0data, sIQ0data);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CrossCorrelationOp.class);
        }
    }

    public static class CorrelationWindow {
        public final int height;
        public final int width;
        public final int halfWidth;
        public final int halfHeight;
        public final int accY;
        public final int accX;
        public final int ovsFactor;

        public CorrelationWindow(int winWidth, int winHeight, int accX, int accY, int ovsFactor) {
            this.accX = accX;
            this.accY = accY;
            this.width = winWidth;
            this.height = winHeight;
            this.halfWidth = winWidth / 2;
            this.halfHeight = winHeight / 2;
            this.ovsFactor = ovsFactor;
        }

        public Window defineWindowMask(int x, int y) {
            int l0 = y - this.halfHeight;
            int lN = y + this.halfHeight - 1;
            int p0 = x - this.halfWidth;
            int pN = x + this.halfWidth - 1;
            return new Window((long)l0, (long)lN, (long)p0, (long)pN);
        }

        public Window defineWindowMask(PixelPos pos) {
            int l0 = (int)(pos.y - (double)this.halfHeight);
            int lN = (int)(pos.y + (double)this.halfHeight - 1.0);
            int p0 = (int)(pos.x - (double)this.halfWidth);
            int pN = (int)(pos.x + (double)this.halfWidth - 1.0);
            return new Window((long)l0, (long)lN, (long)p0, (long)pN);
        }

        public Rectangle defineRectangleMask(int x, int y) {
            Window temp = this.defineWindowMask(x, y);
            return new Rectangle((int)temp.pixlo, (int)temp.linelo, (int)temp.pixels(), (int)temp.lines());
        }

        public Rectangle defineRectangleMask(PixelPos pos) {
            Window temp = this.defineWindowMask(pos);
            return new Rectangle((int)temp.pixlo, (int)temp.linelo, (int)temp.pixels(), (int)temp.lines());
        }
    }
}

