/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.coregistration;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Rectangle;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.s1tbx.insar.gpf.coregistration.Collocator;
import org.esa.snap.core.dataio.ProductSubsetBuilder;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.ProductInformation;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.jlinda.core.Orbit;
import org.jlinda.core.Point;
import org.jlinda.core.SLCImage;
import org.jlinda.nest.gpf.coregistration.GCPManager;

@OperatorMetadata(alias="CreateStack", category="Radar/Coregistration/Stack Tools", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Collocates two or more products based on their geo-codings.")
public class CreateStackOp
extends Operator {
    @SourceProducts
    private Product[] sourceProduct;
    @Parameter(description="The list of source bands.", alias="masterBands", rasterDataNodeType=Band.class, label="Master Band")
    private String[] masterBandNames = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Slave Bands")
    private String[] slaveBandNames = null;
    private Product masterProduct = null;
    private final Band[] masterBands = new Band[2];
    @TargetProduct(description="The target product which will use the master's grid.")
    private Product targetProduct = null;
    @Parameter(defaultValue="NONE", description="The method to be used when resampling the slave grid onto the master grid.", label="Resampling Type")
    private String resamplingType = "NONE";
    private Resampling selectedResampling = null;
    @Parameter(valueSet={"Master", "Minimum", "Maximum"}, defaultValue="Master", description="The output image extents.", label="Output Extents")
    private String extent = "Master";
    public static final String MASTER_EXTENT = "Master";
    public static final String MIN_EXTENT = "Minimum";
    public static final String MAX_EXTENT = "Maximum";
    public static final String INITIAL_OFFSET_GEOLOCATION = "Product Geolocation";
    public static final String INITIAL_OFFSET_ORBIT = "Orbit";
    @Parameter(valueSet={"Orbit", "Product Geolocation"}, defaultValue="Orbit", description="Method to be used in computation of initial offset between master and slave", label="Initial Offset Method")
    private String initialOffsetMethod = "Orbit";
    private final Map<Band, Band> sourceRasterMap = new HashMap<Band, Band>(10);
    private final Map<Product, int[]> slaveOffsettMap = new HashMap<Product, int[]>(10);
    private boolean appendToMaster = false;
    private boolean productPixelSpacingChecked = false;
    private static final String PRODUCT_SUFFIX = "_Stack";

    public void initialize() throws OperatorException {
        try {
            if (this.sourceProduct == null) {
                return;
            }
            if (this.sourceProduct.length < 2) {
                throw new OperatorException("Please select at least two source products");
            }
            for (Product prod : this.sourceProduct) {
                InputProductValidator validator = new InputProductValidator(prod);
                if (validator.isTOPSARProduct() && !validator.isDebursted()) {
                    throw new OperatorException("S1 TOPS SLC products should use TOPS Coregistration.");
                }
                if (prod.getSceneGeoCoding() != null) continue;
                throw new OperatorException(MessageFormat.format("Product ''{0}'' has no geo-coding.", prod.getName()));
            }
            if (this.masterBandNames == null || this.masterBandNames.length == 0 || this.getMasterProduct(this.masterBandNames[0]) == null) {
                Band defaultBand;
                Product defaultProd = this.sourceProduct[0];
                if (defaultProd != null && (defaultBand = defaultProd.getBandAt(0)) != null) {
                    this.masterBandNames = defaultBand.getUnit() != null && defaultBand.getUnit().equals("real") ? new String[]{defaultProd.getBandAt(0).getName(), defaultProd.getBandAt(1).getName()} : new String[]{defaultBand.getName()};
                }
                if (this.masterBandNames.length == 0) {
                    this.targetProduct = OperatorUtils.createDummyTargetProduct((Product[])this.sourceProduct);
                    return;
                }
            }
            this.masterProduct = this.getMasterProduct(this.masterBandNames[0]);
            if (this.masterProduct == null) {
                this.targetProduct = OperatorUtils.createDummyTargetProduct((Product[])this.sourceProduct);
                return;
            }
            this.appendToMaster = AbstractMetadata.getAbstractedMetadata((Product)this.masterProduct).getAttributeInt("coregistered_stack", 0) == 1;
            ArrayList<String> masterProductBands = new ArrayList<String>(this.masterProduct.getNumBands());
            Band[] slaveBandList = this.getSlaveBands();
            if (this.masterProduct == null || slaveBandList.length == 0 || slaveBandList[0] == null) {
                this.targetProduct = OperatorUtils.createDummyTargetProduct((Product[])this.sourceProduct);
                return;
            }
            if (this.resamplingType.contains("NONE") && !this.extent.equals(MASTER_EXTENT)) {
                throw new OperatorException("Please select only Master extents when resampling type is None");
            }
            if (this.appendToMaster) {
                this.extent = MASTER_EXTENT;
            }
            switch (this.extent) {
                case "Master": {
                    this.targetProduct = new Product(this.masterProduct.getName() + PRODUCT_SUFFIX, this.masterProduct.getProductType(), this.masterProduct.getSceneRasterWidth(), this.masterProduct.getSceneRasterHeight());
                    ProductUtils.copyProductNodes((Product)this.masterProduct, (Product)this.targetProduct);
                    break;
                }
                case "Minimum": {
                    this.determinMinExtents();
                    break;
                }
                default: {
                    this.determinMaxExtents();
                }
            }
            if (this.appendToMaster) {
                for (Band b : this.masterProduct.getBands()) {
                    if (b instanceof VirtualBand) continue;
                    Band targetBand = new Band(b.getName(), b.getDataType(), this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
                    masterProductBands.add(b.getName());
                    this.sourceRasterMap.put(targetBand, b);
                    this.targetProduct.addBand(targetBand);
                    ProductUtils.copyRasterDataNodeProperties((RasterDataNode)b, (RasterDataNode)targetBand);
                    targetBand.setSourceImage(b.getSourceImage());
                }
            }
            String suffix = "_mst";
            if (!this.appendToMaster) {
                for (Band srcBand : slaveBandList) {
                    if (srcBand.getProduct() != this.masterProduct) continue;
                    suffix = "_mst" + StackUtils.createBandTimeStamp((Product)srcBand.getProduct());
                    Band targetBand = new Band(srcBand.getName() + suffix, srcBand.getDataType(), this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
                    masterProductBands.add(targetBand.getName());
                    this.sourceRasterMap.put(targetBand, srcBand);
                    this.targetProduct.addBand(targetBand);
                    ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBand, (RasterDataNode)targetBand);
                    if (this.extent.equals(MASTER_EXTENT)) {
                        targetBand.setSourceImage(srcBand.getSourceImage());
                    }
                    CreateStackOp.fixDependencies(targetBand, slaveBandList, suffix);
                }
            }
            int cnt = 1;
            if (this.appendToMaster) {
                for (Band trgBand : this.targetProduct.getBands()) {
                    String name = trgBand.getName();
                    if (!name.contains("_slv" + cnt)) continue;
                    ++cnt;
                }
            }
            for (Band srcBand : slaveBandList) {
                if (srcBand.getProduct() == this.masterProduct) continue;
                if (srcBand.getUnit() == null || !srcBand.getUnit().equals("imaginary")) {
                    suffix = "_slv" + cnt++ + StackUtils.createBandTimeStamp((Product)srcBand.getProduct());
                }
                String tgtBandName = srcBand.getName() + suffix;
                if (this.targetProduct.getBand(tgtBandName) != null) continue;
                Product srcProduct = srcBand.getProduct();
                Band targetBand = new Band(tgtBandName, srcBand.getDataType(), this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
                this.sourceRasterMap.put(targetBand, srcBand);
                this.targetProduct.addBand(targetBand);
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBand, (RasterDataNode)targetBand);
                if (this.extent.equals(MASTER_EXTENT) && srcProduct.isCompatibleProduct(this.targetProduct, 0.001f)) {
                    targetBand.setSourceImage(srcBand.getSourceImage());
                }
                CreateStackOp.fixDependencies(targetBand, slaveBandList, suffix);
            }
            this.copySlaveMetadata();
            StackUtils.saveMasterProductBandNames((Product)this.targetProduct, (String[])masterProductBands.toArray(new String[masterProductBands.size()]));
            StackUtils.saveSlaveProductNames((Product[])this.sourceProduct, (Product)this.targetProduct, (Product)this.masterProduct, this.sourceRasterMap);
            this.updateMetadata();
            PlacemarkGroup masterGCPgroup = this.masterProduct.getGcpGroup();
            if (masterGCPgroup.getNodeCount() > 0) {
                OperatorUtils.copyGCPsToTarget((ProductNodeGroup)masterGCPgroup, (ProductNodeGroup)GCPManager.instance().getGcpGroup(this.targetProduct.getBandAt(0)), (GeoCoding)this.targetProduct.getSceneGeoCoding());
            }
            if (!this.resamplingType.contains("NONE")) {
                this.selectedResampling = ResamplingFactory.createResampling((String)this.resamplingType);
                if (this.selectedResampling == null) {
                    throw new OperatorException("Resampling method " + this.selectedResampling + " is invalid");
                }
            } else {
                if (this.initialOffsetMethod == null) {
                    this.initialOffsetMethod = INITIAL_OFFSET_ORBIT;
                }
                if (this.initialOffsetMethod.equals(INITIAL_OFFSET_GEOLOCATION)) {
                    this.computeTargetSlaveCoordinateOffsets_GCP();
                }
                if (this.initialOffsetMethod.equals(INITIAL_OFFSET_ORBIT)) {
                    this.computeTargetSlaveCoordinateOffsets_Orbits();
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private static void fixDependencies(Band targetBand, Band[] srcBandList, String suffix) {
    }

    private void updateMetadata() {
        MetadataElement abstractedMetadata = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (abstractedMetadata != null) {
            abstractedMetadata.setAttributeInt("collocated_stack", 1);
        }
        MetadataElement inputElem = ProductInformation.getInputProducts((Product)this.targetProduct);
        for (Product srcProduct : this.sourceProduct) {
            MetadataAttribute[] slvInputProductAttrbList;
            if (srcProduct == this.masterProduct) continue;
            MetadataElement slvInputElem = ProductInformation.getInputProducts((Product)srcProduct);
            for (MetadataAttribute attrib : slvInputProductAttrbList = slvInputElem.getAttributes()) {
                MetadataAttribute inputAttrb = AbstractMetadata.addAbstractedAttribute((MetadataElement)inputElem, (String)"InputProduct", (int)41, (String)"", (String)"");
                inputAttrb.getData().setElems((Object)attrib.getData().getElemString());
            }
        }
    }

    private void copySlaveMetadata() {
        MetadataElement targetSlaveMetadataRoot = AbstractMetadata.getSlaveMetadata((MetadataElement)this.targetProduct.getMetadataRoot());
        for (Product prod : this.sourceProduct) {
            MetadataElement slvAbsMetadata;
            if (prod == this.masterProduct || (slvAbsMetadata = AbstractMetadata.getAbstractedMetadata((Product)prod)) == null) continue;
            String timeStamp = StackUtils.createBandTimeStamp((Product)prod);
            MetadataElement targetSlaveMetadata = new MetadataElement(prod.getName() + timeStamp);
            targetSlaveMetadataRoot.addElement(targetSlaveMetadata);
            ProductUtils.copyMetadata((MetadataElement)slvAbsMetadata, (MetadataElement)targetSlaveMetadata);
        }
    }

    private Product getMasterProduct(String name) {
        String masterName = this.getProductName(name);
        for (Product prod : this.sourceProduct) {
            if (!prod.getName().equals(masterName)) continue;
            return prod;
        }
        return null;
    }

    private Band[] getSlaveBands() throws OperatorException {
        String unit;
        ArrayList<Band> bandList = new ArrayList<Band>(5);
        if (this.masterProduct == null) {
            throw new OperatorException("masterProduct is null");
        }
        if (this.masterBandNames.length > 2) {
            throw new OperatorException("Master band should be one real band or a real and imaginary band");
        }
        this.masterBands[0] = this.masterProduct.getBand(CreateStackOp.getBandName(this.masterBandNames[0]));
        if (!this.appendToMaster) {
            bandList.add(this.masterBands[0]);
        }
        if ((unit = this.masterBands[0].getUnit()) != null) {
            if (unit.contains("phase")) {
                throw new OperatorException("Phase band should not be selected for co-registration");
            }
            if (unit.contains("imaginary")) {
                throw new OperatorException("Real and imaginary master bands should be selected in pairs");
            }
            if (unit.contains("real")) {
                if (this.masterBandNames.length < 2) {
                    if (!CreateStackOp.contains(this.masterBandNames, this.slaveBandNames[0])) {
                        throw new OperatorException("Real and imaginary master bands should be selected in pairs");
                    }
                    int iBandIdx = this.masterProduct.getBandIndex(CreateStackOp.getBandName(this.masterBandNames[0]));
                    this.masterBands[1] = this.masterProduct.getBandAt(iBandIdx + 1);
                    if (!this.masterBands[1].getUnit().equals("imaginary")) {
                        throw new OperatorException("For complex products select a real and an imaginary band");
                    }
                    if (!this.appendToMaster) {
                        bandList.add(this.masterBands[1]);
                    }
                } else {
                    Product prod = this.getMasterProduct(this.masterBandNames[1]);
                    if (prod != this.masterProduct) {
                        // empty if block
                    }
                    this.masterBands[1] = this.masterProduct.getBand(CreateStackOp.getBandName(this.masterBandNames[1]));
                    if (!this.masterBands[1].getUnit().equals("imaginary")) {
                        throw new OperatorException("For complex products select a real and an imaginary band");
                    }
                    if (!this.appendToMaster) {
                        bandList.add(this.masterBands[1]);
                    }
                }
            }
        }
        if (this.slaveBandNames == null || this.slaveBandNames.length == 0 || CreateStackOp.contains(this.masterBandNames, this.slaveBandNames[0])) {
            for (Product slvProduct : this.sourceProduct) {
                for (Band band : slvProduct.getBands()) {
                    if (band.getUnit() != null && band.getUnit().equals("phase") || band instanceof VirtualBand || slvProduct == this.masterProduct && (band == this.masterBands[0] || band == this.masterBands[1] || this.appendToMaster)) continue;
                    bandList.add(band);
                }
            }
        } else {
            for (int i = 0; i < this.slaveBandNames.length; ++i) {
                String name = this.slaveBandNames[i];
                if (CreateStackOp.contains(this.masterBandNames, name)) {
                    throw new OperatorException("Please do not select the same band as master and slave");
                }
                String bandName = CreateStackOp.getBandName(name);
                String productName = this.getProductName(name);
                Product prod = this.getProduct(productName, bandName);
                if (prod == null) continue;
                Band band = prod.getBand(bandName);
                String bandUnit = band.getUnit();
                if (bandUnit != null) {
                    if (bandUnit.contains("phase")) {
                        throw new OperatorException("Phase band should not be selected for co-registration");
                    }
                    if (bandUnit.contains("real") || bandUnit.contains("imaginary")) {
                        if (this.slaveBandNames.length < 2) {
                            throw new OperatorException("Real and imaginary slave bands should be selected in pairs");
                        }
                        String nextBandName = CreateStackOp.getBandName(this.slaveBandNames[i + 1]);
                        String nextBandProdName = this.getProductName(this.slaveBandNames[i + 1]);
                        if (!nextBandProdName.contains(productName)) {
                            throw new OperatorException("Real and imaginary slave bands should be selected from the same product in pairs");
                        }
                        Band nextBand = prod.getBand(nextBandName);
                        if (bandUnit.contains("real") && !nextBand.getUnit().contains("imaginary") || bandUnit.contains("imaginary") && !nextBand.getUnit().contains("real")) {
                            throw new OperatorException("Real and imaginary slave bands should be selected in pairs");
                        }
                        bandList.add(band);
                        bandList.add(nextBand);
                        ++i;
                        continue;
                    }
                    bandList.add(band);
                    continue;
                }
                bandList.add(band);
            }
        }
        return bandList.toArray(new Band[bandList.size()]);
    }

    private Product getProduct(String productName, String bandName) {
        for (Product prod : this.sourceProduct) {
            if (!prod.getName().equals(productName) || prod.getBand(bandName) == null) continue;
            return prod;
        }
        return null;
    }

    private static boolean contains(String[] nameList, String name) {
        for (String nameInList : nameList) {
            if (!name.equals(nameInList)) continue;
            return true;
        }
        return false;
    }

    private static String getBandName(String name) {
        if (name.contains("::")) {
            return name.substring(0, name.indexOf("::"));
        }
        return name;
    }

    private String getProductName(String name) {
        if (name.contains("::")) {
            return name.substring(name.indexOf("::") + 2, name.length());
        }
        return this.sourceProduct[0].getName();
    }

    private void determinMinExtents() {
        Geometry tgtGeometry = FeatureUtils.createGeoBoundaryPolygon((Product)this.masterProduct);
        for (Product slvProd : this.sourceProduct) {
            if (slvProd == this.masterProduct) continue;
            Geometry slvGeometry = FeatureUtils.createGeoBoundaryPolygon((Product)slvProd);
            tgtGeometry = tgtGeometry.intersection(slvGeometry);
        }
        GeoCoding mstGeoCoding = this.masterProduct.getSceneGeoCoding();
        PixelPos pixPos = new PixelPos();
        GeoPos geoPos = new GeoPos();
        double mstWidth = this.masterProduct.getSceneRasterWidth();
        double mstHeight = this.masterProduct.getSceneRasterHeight();
        double maxX = 0.0;
        double maxY = 0.0;
        double minX = mstWidth;
        double minY = mstHeight;
        for (Coordinate c : tgtGeometry.getCoordinates()) {
            geoPos.setLocation(c.y, c.x);
            mstGeoCoding.getPixelPos(geoPos, pixPos);
            if (!pixPos.isValid() || pixPos.x == -1.0 || pixPos.y == -1.0) continue;
            if (pixPos.x < minX) {
                minX = Math.max(0.0, pixPos.x);
            }
            if (pixPos.y < minY) {
                minY = Math.max(0.0, pixPos.y);
            }
            if (pixPos.x > maxX) {
                maxX = Math.min(mstWidth, pixPos.x);
            }
            if (!(pixPos.y > maxY)) continue;
            maxY = Math.min(mstHeight, pixPos.y);
        }
        ProductSubsetBuilder subsetReader = new ProductSubsetBuilder();
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        subsetDef.addNodeNames(this.masterProduct.getTiePointGridNames());
        subsetDef.setRegion((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
        subsetDef.setSubSampling(1, 1);
        subsetDef.setIgnoreMetadata(false);
        try {
            Band[] bands;
            this.targetProduct = subsetReader.readProductNodes((Object)this.masterProduct, subsetDef);
            for (Band b : bands = this.targetProduct.getBands()) {
                this.targetProduct.removeBand(b);
            }
        }
        catch (Throwable t) {
            throw new OperatorException(t);
        }
    }

    private void determinMaxExtents() throws Exception {
        try {
            GeoCoding masterGeoCoding = this.masterProduct.getSceneGeoCoding();
            double xMin = 0.0;
            double xMax = this.masterProduct.getSceneRasterWidth();
            double yMin = 0.0;
            double yMax = this.masterProduct.getSceneRasterHeight();
            PixelPos pixelPosUL = new PixelPos();
            PixelPos pixelPosUR = new PixelPos();
            PixelPos pixelPosLL = new PixelPos();
            PixelPos pixelPosLR = new PixelPos();
            GeoPos geoPosUL = new GeoPos();
            GeoPos geoPosUR = new GeoPos();
            GeoPos geoPosLL = new GeoPos();
            GeoPos geoPosLR = new GeoPos();
            for (Product slvProd : this.sourceProduct) {
                if (slvProd == this.masterProduct) continue;
                GeoCoding slaveGeoCoding = slvProd.getSceneGeoCoding();
                GeoPos geoPosFirstNear = slaveGeoCoding.getGeoPos(new PixelPos(0.0, 0.0), null);
                GeoPos geoPosFirstFar = slaveGeoCoding.getGeoPos(new PixelPos((double)(slvProd.getSceneRasterWidth() - 1), 0.0), null);
                GeoPos geoPosLastNear = slaveGeoCoding.getGeoPos(new PixelPos(0.0, (double)(slvProd.getSceneRasterHeight() - 1)), null);
                GeoPos geoPosLastFar = slaveGeoCoding.getGeoPos(new PixelPos((double)(slvProd.getSceneRasterWidth() - 1), (double)(slvProd.getSceneRasterHeight() - 1)), null);
                masterGeoCoding.getPixelPos(geoPosFirstNear, pixelPosUL);
                masterGeoCoding.getPixelPos(geoPosFirstFar, pixelPosUR);
                masterGeoCoding.getPixelPos(geoPosLastNear, pixelPosLL);
                masterGeoCoding.getPixelPos(geoPosLastFar, pixelPosLR);
                double[] xArray = new double[]{pixelPosUL.x, pixelPosUR.x, pixelPosLL.x, pixelPosLR.x};
                double[] yArray = new double[]{pixelPosUL.y, pixelPosUR.y, pixelPosLL.y, pixelPosLR.y};
                for (int i = 0; i < 4; ++i) {
                    xMin = Math.min(xMin, xArray[i]);
                    xMax = Math.max(xMax, xArray[i]);
                    yMin = Math.min(yMin, yArray[i]);
                    yMax = Math.max(yMax, yArray[i]);
                }
            }
            int sceneWidth = (int)(xMax - xMin) + 1;
            int sceneHeight = (int)(yMax - yMin) + 1;
            this.targetProduct = new Product(this.masterProduct.getName(), this.masterProduct.getProductType(), sceneWidth, sceneHeight);
            masterGeoCoding.getGeoPos(new PixelPos(xMin, yMin), geoPosUL);
            masterGeoCoding.getGeoPos(new PixelPos(xMax, yMin), geoPosUR);
            masterGeoCoding.getGeoPos(new PixelPos(xMin, yMax), geoPosLL);
            masterGeoCoding.getGeoPos(new PixelPos(xMax, yMax), geoPosLR);
            float[] latTiePoints = new float[]{(float)geoPosUL.lat, (float)geoPosUR.lat, (float)geoPosLL.lat, (float)geoPosLR.lat};
            float[] lonTiePoints = new float[]{(float)geoPosUL.lon, (float)geoPosUR.lon, (float)geoPosLL.lon, (float)geoPosLR.lon};
            TiePointGrid latGrid = new TiePointGrid("latitude", 2, 2, 0.5, 0.5, (double)(sceneWidth - 1), (double)(sceneHeight - 1), latTiePoints);
            latGrid.setUnit("deg");
            TiePointGrid lonGrid = new TiePointGrid("longitude", 2, 2, 0.5, 0.5, (double)(sceneWidth - 1), (double)(sceneHeight - 1), lonTiePoints, 180);
            lonGrid.setUnit("deg");
            this.targetProduct.addTiePointGrid(latGrid);
            this.targetProduct.addTiePointGrid(lonGrid);
            this.targetProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid));
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void computeTargetSlaveCoordinateOffsets_GCP() {
        GeoCoding targGeoCoding = this.targetProduct.getSceneGeoCoding();
        int targImageWidth = this.targetProduct.getSceneRasterWidth();
        int targImageHeight = this.targetProduct.getSceneRasterHeight();
        Geometry tgtGeometry = FeatureUtils.createGeoBoundaryPolygon((Product)this.targetProduct);
        PixelPos slvPixelPos = new PixelPos();
        PixelPos tgtPixelPos = new PixelPos();
        GeoPos slvGeoPos = new GeoPos();
        for (Product slvProd : this.sourceProduct) {
            if (slvProd == this.masterProduct && this.extent.equals(MASTER_EXTENT)) {
                this.slaveOffsettMap.put(slvProd, new int[]{0, 0});
                continue;
            }
            GeoCoding slvGeoCoding = slvProd.getSceneGeoCoding();
            int slvImageWidth = slvProd.getSceneRasterWidth();
            int slvImageHeight = slvProd.getSceneRasterHeight();
            boolean foundOverlapPoint = false;
            slvGeoCoding.getGeoPos(new PixelPos(10.0, 10.0), slvGeoPos);
            if (!foundOverlapPoint) {
                Geometry slvGeometry = FeatureUtils.createGeoBoundaryPolygon((Product)slvProd);
                Geometry intersect = tgtGeometry.intersection(slvGeometry);
                for (Coordinate c : intersect.getCoordinates()) {
                    CreateStackOp.getPixelPos(c.y, c.x, slvGeoCoding, slvPixelPos);
                    if (!slvPixelPos.isValid() || !(slvPixelPos.x >= 0.0) || !(slvPixelPos.x < (double)slvImageWidth) || !(slvPixelPos.y >= 0.0) || !(slvPixelPos.y < (double)slvImageHeight)) continue;
                    CreateStackOp.getPixelPos(c.y, c.x, targGeoCoding, tgtPixelPos);
                    if (!tgtPixelPos.isValid() || !(tgtPixelPos.x >= 0.0) || !(tgtPixelPos.x < (double)targImageWidth) || !(tgtPixelPos.y >= 0.0) || !(tgtPixelPos.y < (double)targImageHeight)) continue;
                    this.addOffset(slvProd, (int)slvPixelPos.x - (int)tgtPixelPos.x, (int)slvPixelPos.y - (int)tgtPixelPos.y);
                    foundOverlapPoint = true;
                    break;
                }
            }
            if (foundOverlapPoint) continue;
            throw new OperatorException("Product " + slvProd.getName() + " has no overlap with master product.");
        }
    }

    private void computeTargetSlaveCoordinateOffsets_Orbits() throws Exception {
        try {
            if (!AbstractMetadata.hasAbstractedMetadata((Product)this.targetProduct)) {
                throw new Exception("Orbit offset method is not support for product " + this.targetProduct.getName());
            }
            MetadataElement root = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
            int orbitDegree = 3;
            SLCImage metaMaster = new SLCImage(root, this.targetProduct);
            Orbit orbitMaster = new Orbit(root, 3);
            Point tgtLP = metaMaster.getApproxRadarCentreOriginal();
            for (Product slvProd : this.sourceProduct) {
                if (slvProd == this.masterProduct) {
                    this.slaveOffsettMap.put(slvProd, new int[]{0, 0});
                    continue;
                }
                if (!AbstractMetadata.hasAbstractedMetadata((Product)slvProd)) {
                    throw new Exception("Orbit offset method is not support for product " + slvProd.getName());
                }
                root = AbstractMetadata.getAbstractedMetadata((Product)slvProd);
                SLCImage metaSlave = new SLCImage(root, slvProd);
                Orbit orbitSlave = new Orbit(root, 3);
                Point tgtXYZ = orbitMaster.lp2xyz(tgtLP, metaMaster);
                Point slvLP = orbitSlave.xyz2lp(tgtXYZ, metaSlave);
                Point offsetLP = slvLP.min(tgtLP);
                int offsetX = (int)Math.floor(offsetLP.x + 0.5);
                int offsetY = (int)Math.floor(offsetLP.y + 0.5);
                this.addOffset(slvProd, offsetX, offsetY);
            }
        }
        catch (Exception e) {
            throw new IOException("Orbit offset method is not support for this product: " + e.getMessage());
        }
    }

    private static boolean pixelPosValid(GeoCoding geoCoding, GeoPos geoPos, PixelPos pixelPos, int width, int height) {
        geoCoding.getPixelPos(geoPos, pixelPos);
        return pixelPos.isValid() && pixelPos.x >= 0.0 && pixelPos.x < (double)width && pixelPos.y >= 0.0 && pixelPos.y < (double)height;
    }

    private static void getPixelPos(double lat, double lon, GeoCoding srcGeoCoding, PixelPos pixelPos) {
        srcGeoCoding.getPixelPos(new GeoPos(lat, lon), pixelPos);
    }

    private void addOffset(Product slvProd, int offsetX, int offsetY) {
        this.slaveOffsettMap.put(slvProd, new int[]{offsetX, offsetY});
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        block11: {
            try {
                Band sourceRaster = this.sourceRasterMap.get(targetBand);
                Product srcProduct = sourceRaster.getProduct();
                int srcImageWidth = srcProduct.getSceneRasterWidth();
                int srcImageHeight = srcProduct.getSceneRasterHeight();
                if (this.resamplingType.contains("NONE")) {
                    if (!this.productPixelSpacingChecked) {
                        this.checkProductPixelSpacings();
                    }
                    float noDataValue = (float)targetBand.getGeophysicalNoDataValue();
                    Rectangle targetRectangle = targetTile.getRectangle();
                    ProductData trgData = targetTile.getDataBuffer();
                    int tx0 = targetRectangle.x;
                    int ty0 = targetRectangle.y;
                    int tw = targetRectangle.width;
                    int th = targetRectangle.height;
                    int maxX = tx0 + tw;
                    int maxY = ty0 + th;
                    int[] offset = this.slaveOffsettMap.get(srcProduct);
                    int sx0 = Math.min(Math.max(0, tx0 + offset[0]), srcImageWidth - 1);
                    int sy0 = Math.min(Math.max(0, ty0 + offset[1]), srcImageHeight - 1);
                    int sw = Math.min(sx0 + tw - 1, srcImageWidth - 1) - sx0 + 1;
                    int sh = Math.min(sy0 + th - 1, srcImageHeight - 1) - sy0 + 1;
                    Rectangle srcRectangle = new Rectangle(sx0, sy0, sw, sh);
                    Tile srcTile = this.getSourceTile((RasterDataNode)sourceRaster, srcRectangle);
                    ProductData srcData = srcTile.getDataBuffer();
                    TileIndex trgIndex = new TileIndex(targetTile);
                    TileIndex srcIndex = new TileIndex(srcTile);
                    boolean isInt = false;
                    int trgDataType = trgData.getType();
                    if (trgDataType == srcData.getType() && (trgDataType == 11 || trgDataType == 12)) {
                        isInt = true;
                    }
                    for (int ty = ty0; ty < maxY; ++ty) {
                        int sy = ty + offset[1];
                        int trgOffset = trgIndex.calculateStride(ty);
                        if (sy < 0 || sy >= srcImageHeight) {
                            for (int tx = tx0; tx < maxX; ++tx) {
                                trgData.setElemDoubleAt(tx - trgOffset, (double)noDataValue);
                            }
                            continue;
                        }
                        int srcOffset = srcIndex.calculateStride(sy);
                        for (int tx = tx0; tx < maxX; ++tx) {
                            int sx = tx + offset[0];
                            if (sx < 0 || sx >= srcImageWidth) {
                                trgData.setElemDoubleAt(tx - trgOffset, (double)noDataValue);
                                continue;
                            }
                            if (isInt) {
                                trgData.setElemIntAt(tx - trgOffset, srcData.getElemIntAt(sx - srcOffset));
                                continue;
                            }
                            trgData.setElemDoubleAt(tx - trgOffset, srcData.getElemDoubleAt(sx - srcOffset));
                        }
                    }
                    break block11;
                }
                Collocator col = new Collocator(this, srcProduct, this.targetProduct, targetTile.getRectangle());
                col.collocateSourceBand((RasterDataNode)sourceRaster, targetTile, this.selectedResampling);
            }
            catch (Throwable e) {
                OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            }
        }
    }

    private synchronized void checkProductPixelSpacings() throws OperatorException {
        if (this.productPixelSpacingChecked) {
            return;
        }
        this.productPixelSpacingChecked = true;
    }

    public static void checkPixelSpacing(Product[] sourceProducts) throws Exception {
        double savedRangeSpacing = 0.0;
        double savedAzimuthSpacing = 0.0;
        for (Product prod : sourceProducts) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)prod);
            if (absRoot == null) {
                throw new OperatorException(MessageFormat.format("Product ''{0}'' has no abstract metadata.", prod.getName()));
            }
            double rangeSpacing = absRoot.getAttributeDouble("range_spacing", 0.0);
            double azimuthSpacing = absRoot.getAttributeDouble("azimuth_spacing", 0.0);
            if (rangeSpacing == 0.0 || azimuthSpacing == 0.0) {
                return;
            }
            if (savedRangeSpacing > 0.0 && savedAzimuthSpacing > 0.0 && (Math.abs(rangeSpacing - savedRangeSpacing) > 0.05 || Math.abs(azimuthSpacing - savedAzimuthSpacing) > 0.05)) {
                throw new OperatorException("Resampling type cannot be NONE because pixel spacings are different for master and slave products");
            }
            savedRangeSpacing = rangeSpacing;
            savedAzimuthSpacing = azimuthSpacing;
        }
    }

    protected void setTestParameters(String ext, String offsetMethod) {
        this.extent = ext;
        this.initialOffsetMethod = offsetMethod;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CreateStackOp.class);
        }
    }
}

