/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.coregistration;

import java.awt.Rectangle;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class Collocator {
    private final PixelPos[] sourcePixelPositions;
    private final Rectangle sourceRectangle;
    private final Operator operator;

    public Collocator(Operator op, Product srcProduct, Product trgProduct, Rectangle trgRectangle) {
        this.operator = op;
        this.sourcePixelPositions = ProductUtils.computeSourcePixelCoordinates((GeoCoding)srcProduct.getSceneGeoCoding(), (int)srcProduct.getSceneRasterWidth(), (int)srcProduct.getSceneRasterHeight(), (GeoCoding)trgProduct.getSceneGeoCoding(), (Rectangle)trgRectangle);
        this.sourceRectangle = Collocator.getBoundingBox(this.sourcePixelPositions, srcProduct.getSceneRasterWidth(), srcProduct.getSceneRasterHeight());
    }

    public void collocateSourceBand(RasterDataNode sourceBand, Tile targetTile, Resampling selectedResampling) throws OperatorException {
        RasterDataNode targetBand = targetTile.getRasterDataNode();
        Rectangle targetRectangle = targetTile.getRectangle();
        ProductData trgBuffer = targetTile.getDataBuffer();
        float noDataValue = (float)targetBand.getGeophysicalNoDataValue();
        int maxX = targetRectangle.x + targetRectangle.width;
        int maxY = targetRectangle.y + targetRectangle.height;
        Tile sourceTile = null;
        if (this.sourceRectangle != null) {
            sourceTile = this.operator.getSourceTile(sourceBand, this.sourceRectangle);
        }
        if (sourceTile != null) {
            Product srcProduct = sourceBand.getProduct();
            int sourceRasterHeight = srcProduct.getSceneRasterHeight();
            int sourceRasterWidth = srcProduct.getSceneRasterWidth();
            Resampling resampling = Collocator.isFlagBand(sourceBand) || Collocator.isValidPixelExpressionUsed(sourceBand) ? Resampling.NEAREST_NEIGHBOUR : selectedResampling;
            Resampling.Index resamplingIndex = resampling.createIndex();
            ResamplingRaster resamplingRaster = new ResamplingRaster(sourceTile);
            int index = 0;
            for (int y = targetRectangle.y; y < maxY; ++y) {
                int x = targetRectangle.x;
                while (x < maxX) {
                    PixelPos sourcePixelPos = this.sourcePixelPositions[index];
                    int trgIndex = targetTile.getDataBufferIndex(x, y);
                    if (sourcePixelPos != null) {
                        resampling.computeIndex(sourcePixelPos.x, sourcePixelPos.y, sourceRasterWidth, sourceRasterHeight, resamplingIndex);
                        try {
                            double sample = resampling.resample((Resampling.Raster)resamplingRaster, resamplingIndex);
                            if (Double.isNaN(sample)) {
                                sample = noDataValue;
                            }
                            trgBuffer.setElemDoubleAt(trgIndex, sample);
                        }
                        catch (Exception e) {
                            throw new OperatorException(e.getMessage());
                        }
                    } else {
                        trgBuffer.setElemDoubleAt(trgIndex, (double)noDataValue);
                    }
                    ++x;
                    ++index;
                }
            }
            sourceTile.getDataBuffer().dispose();
        } else {
            TileIndex trgIndex = new TileIndex(targetTile);
            int index = 0;
            for (int y = targetRectangle.y; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                int x = targetRectangle.x;
                while (x < maxX) {
                    trgBuffer.setElemDoubleAt(trgIndex.getIndex(x), (double)noDataValue);
                    ++x;
                    ++index;
                }
            }
        }
    }

    private static boolean isFlagBand(RasterDataNode sourceRaster) {
        return sourceRaster instanceof Band && ((Band)sourceRaster).isFlagBand();
    }

    private static boolean isValidPixelExpressionUsed(RasterDataNode sourceRaster) {
        String validPixelExpression = sourceRaster.getValidPixelExpression();
        return validPixelExpression != null && !validPixelExpression.trim().isEmpty();
    }

    private static Rectangle getBoundingBox(PixelPos[] pixelPositions, int maxWidth, int maxHeight) {
        int minX = Integer.MAX_VALUE;
        int maxX = -2147483647;
        int minY = Integer.MAX_VALUE;
        int maxY = -2147483647;
        for (PixelPos pixelsPos : pixelPositions) {
            if (pixelsPos == null) continue;
            int x = (int)Math.floor(pixelsPos.getX());
            int y = (int)Math.floor(pixelsPos.getY());
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        if (minX > maxX || minY > maxY) {
            return null;
        }
        minX = Math.max(minX - 4, 0);
        maxX = Math.min(maxX + 4, maxWidth - 1);
        minY = Math.max(minY - 4, 0);
        maxY = Math.min(maxY + 4, maxHeight - 1);
        return new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    private static class ResamplingRaster
    implements Resampling.Raster {
        private final Tile tile;
        private final boolean usesNoData;
        private final boolean scalingApplied;
        private final double noDataValue;
        private final double geophysicalNoDataValue;
        private final ProductData dataBuffer;

        public ResamplingRaster(Tile tile) {
            this.tile = tile;
            this.dataBuffer = tile.getDataBuffer();
            RasterDataNode rasterDataNode = tile.getRasterDataNode();
            this.usesNoData = rasterDataNode.isNoDataValueUsed();
            this.noDataValue = rasterDataNode.getNoDataValue();
            this.geophysicalNoDataValue = rasterDataNode.getGeophysicalNoDataValue();
            this.scalingApplied = rasterDataNode.isScalingApplied();
        }

        public final int getWidth() {
            return this.tile.getWidth();
        }

        public final int getHeight() {
            return this.tile.getHeight();
        }

        public boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
            boolean allValid = true;
            for (int i = 0; i < y.length; ++i) {
                for (int j = 0; j < x.length; ++j) {
                    samples[i][j] = this.dataBuffer.getElemDoubleAt(this.tile.getDataBufferIndex(x[j], y[i]));
                    if (!this.usesNoData || (!this.scalingApplied || this.geophysicalNoDataValue != samples[i][j]) && this.noDataValue != samples[i][j]) continue;
                    samples[i][j] = Double.NaN;
                    allValid = false;
                }
            }
            return allValid;
        }
    }
}

