/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import org.esa.s1tbx.insar.gpf.InSARStackOverview;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;

@OperatorMetadata(alias="StampsExport", category="Radar/Interferometric/PSI \\ SBAS", authors="Cecilia Wong, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", autoWriteDisabled=true, description="Export data for StaMPS processing")
public class StampsExportOp
extends Operator {
    @SourceProducts
    private Product[] sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The output folder to which the data product is written.")
    private File targetFolder;
    @Parameter(description="Format for PSI or SBAS", defaultValue="true")
    private Boolean psiFormat = true;
    private static final String formatName = "Gamma";
    private static final String[] folder = new String[]{"rslc", "diff0", "geo"};
    private static final String[] ext = new String[]{".rslc", ".diff", "_dem.rdc"};
    private static final DateFormat rawDateFormat = ProductData.UTC.createDateFormat((String)"ddMMMyyyy");
    private static final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyyMMdd");
    private final HashMap<Band, WriterInfo> tgtBandToInfoMap = new HashMap();

    public StampsExportOp() {
        this.setRequiresAllBands(true);
    }

    public void initialize() throws OperatorException {
        try {
            if (this.sourceProduct.length != 2) {
                throw new OperatorException("Input requires coregistered stack and interferogram");
            }
            if (!this.psiFormat.booleanValue()) {
                throw new OperatorException("SBAS format is not yet supported.");
            }
            InputProductValidator validator = new InputProductValidator(this.sourceProduct[0]);
            validator.checkIfCoregisteredStack();
            validator.checkIfSLC();
            validator.checkIfTOPSARBurstProduct(false);
            validator.checkIfCompatibleProducts(this.sourceProduct);
            InputProductValidator validator2 = new InputProductValidator(this.sourceProduct[1]);
            validator2.checkIfCoregisteredStack();
            validator2.checkIfSLC();
            validator2.checkIfTOPSARBurstProduct(false);
            if (this.targetFolder == null) {
                throw new OperatorException("Please add a target folder");
            }
            if (!this.targetFolder.exists() && !this.targetFolder.mkdirs()) {
                SystemUtils.LOG.severe("Unable to create folders in " + this.targetFolder);
            }
            this.targetProduct = new Product(this.sourceProduct[1].getName(), this.sourceProduct[1].getProductType(), this.sourceProduct[1].getSceneRasterWidth(), this.sourceProduct[1].getSceneRasterHeight());
            ProductUtils.copyProductNodes((Product)this.sourceProduct[1], (Product)this.targetProduct);
            boolean includesElevation = false;
            for (Product aSourceProduct : this.sourceProduct) {
                for (Band srcBand : aSourceProduct.getBands()) {
                    String targetBandName;
                    FOLDERS folderType;
                    String srcBandName = srcBand.getName();
                    if (srcBandName.startsWith("i_")) {
                        folderType = srcBandName.startsWith("i_ifg") ? FOLDERS.DIFF : FOLDERS.RSLC;
                        targetBandName = "i_" + StampsExportOp.extractDate(srcBandName, folderType) + ext[folderType.ordinal()];
                        Band targetBand = ProductUtils.copyBand((String)srcBandName, (Product)aSourceProduct, (String)targetBandName, (Product)this.targetProduct, (boolean)true);
                        this.tgtBandToInfoMap.put(targetBand, new WriterInfo(folder[folderType.ordinal()], targetBandName));
                        continue;
                    }
                    if (srcBandName.startsWith("q_")) {
                        folderType = srcBandName.startsWith("q_ifg") ? FOLDERS.DIFF : FOLDERS.RSLC;
                        targetBandName = "q_" + StampsExportOp.extractDate(srcBandName, folderType) + ext[folderType.ordinal()];
                        ProductUtils.copyBand((String)srcBandName, (Product)aSourceProduct, (String)targetBandName, (Product)this.targetProduct, (boolean)true);
                        continue;
                    }
                    if (!srcBandName.startsWith("elevation")) continue;
                    String targetBandName2 = srcBandName + ext[FOLDERS.GEO.ordinal()];
                    Band targetBand = ProductUtils.copyBand((String)srcBandName, (Product)aSourceProduct, (String)targetBandName2, (Product)this.targetProduct, (boolean)true);
                    this.tgtBandToInfoMap.put(targetBand, new WriterInfo(folder[FOLDERS.GEO.ordinal()], targetBandName2));
                    includesElevation = true;
                }
            }
            if (!includesElevation) {
                throw new OperatorException("Elevation band required. Please add an elevation band to the interferogram product.");
            }
        }
        catch (Throwable t) {
            throw new OperatorException(t);
        }
    }

    private static String convertFormat(String rawDate) {
        try {
            ProductData.UTC utc = ProductData.UTC.parse((String)rawDate, (DateFormat)rawDateFormat);
            String date = dateFormat.format(utc.getAsDate());
            return date;
        }
        catch (Exception e) {
            SystemUtils.LOG.severe("failed to convert date" + e.getMessage());
            return rawDate;
        }
    }

    private static String extractDate(String bandName, FOLDERS folderType) {
        String dateStr = bandName.substring(bandName.lastIndexOf(95) + 1, bandName.length());
        if (folderType.equals((Object)FOLDERS.DIFF)) {
            String mstStr = bandName.substring(0, bandName.lastIndexOf(95));
            String mstDate = mstStr.substring(mstStr.lastIndexOf(95) + 1, mstStr.length());
            return StampsExportOp.convertFormat(mstDate) + '_' + StampsExportOp.convertFormat(dateStr);
        }
        return StampsExportOp.convertFormat(dateStr);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        for (Band targetBand : this.tgtBandToInfoMap.keySet()) {
            try {
                WriterInfo info = this.tgtBandToInfoMap.get(targetBand);
                Tile targetTile = targetTiles.get(targetBand);
                this.writeHeader(info);
                Rectangle trgRect = targetTile.getRectangle();
                Tile sourceTile = this.getSourceTile((RasterDataNode)targetBand, trgRect);
                ProductData rawSamples = sourceTile.getRawSamples();
                info.productWriter.writeBandRasterData(targetBand, trgRect.x, trgRect.y, trgRect.width, trgRect.height, rawSamples, ProgressMonitor.NULL);
            }
            catch (Exception e) {
                if (e instanceof OperatorException) {
                    throw (OperatorException)e;
                }
                throw new OperatorException((Throwable)e);
            }
        }
    }

    private synchronized void writeHeader(WriterInfo info) throws Exception {
        if (info.written) {
            return;
        }
        File outputFile = this.targetFolder.toPath().resolve(info.folderName).resolve(info.targetBandName + ".par").toFile();
        info.productWriter.writeProductNodes(this.targetProduct, (Object)outputFile);
        if (info.folderName.equals("diff0")) {
            this.writeBaselineFile(info);
        }
        info.written = true;
    }

    private void writeBaselineFile(WriterInfo info) throws Exception {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct[0]);
        double prf = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"pulse_repetition_frequency");
        double height = 0.0;
        double firstLine = 0.0;
        double lastLine = this.sourceProduct[0].getSceneRasterHeight() - 1;
        double refPixel = (double)(this.sourceProduct[0].getSceneRasterWidth() - 1) / 2.0;
        double t0 = 0.0 / prf;
        double tN = lastLine / prf;
        InSARStackOverview.IfgStack[] stackOverview = InSARStackOverview.calculateInSAROverview(this.sourceProduct[0]);
        String masterDate = info.targetBandName.substring(0, info.targetBandName.indexOf("_"));
        String slaveDate = info.targetBandName.substring(info.targetBandName.indexOf("_") + 1, info.targetBandName.indexOf("."));
        int mstIndex = 0;
        int slvIndex = 0;
        block14: for (int i = 0; i < stackOverview.length; ++i) {
            double mstMJD = stackOverview[i].getMasterSlave()[0].getMasterMetadata().getMjd();
            String mstDate = dateFormat.format(new ProductData.UTC(mstMJD).getAsDate());
            if (!masterDate.equals(mstDate)) continue;
            mstIndex = i;
            for (int j = 0; j < stackOverview[i].getMasterSlave().length; ++j) {
                double slvMJD = stackOverview[i].getMasterSlave()[j].getSlaveMetadata().getMjd();
                String slvDate = dateFormat.format(new ProductData.UTC(slvMJD).getAsDate());
                if (!slaveDate.equals(slvDate)) continue;
                slvIndex = j;
                break block14;
            }
            break;
        }
        double bh0 = stackOverview[mstIndex].getMasterSlave()[slvIndex].getHorizontalBaseline(0.0, refPixel, 0.0);
        double bhN = stackOverview[mstIndex].getMasterSlave()[slvIndex].getHorizontalBaseline(lastLine, refPixel, 0.0);
        double bhm = (bh0 + bhN) * 0.5;
        double bhr = (bhN - bh0) / (tN - t0);
        double bv0 = stackOverview[mstIndex].getMasterSlave()[slvIndex].getVerticalBaseline(0.0, refPixel, 0.0);
        double bvN = stackOverview[mstIndex].getMasterSlave()[slvIndex].getVerticalBaseline(lastLine, refPixel, 0.0);
        double bvm = (bv0 + bvN) * 0.5;
        double bvr = (bvN - bv0) / (tN - t0);
        String baselineFilename = info.targetBandName + ".base";
        baselineFilename = baselineFilename.replace(".diff", "");
        File outputBaselineFile = this.targetFolder.toPath().resolve(info.folderName).resolve(baselineFilename).toFile();
        String oldEOL = System.getProperty("line.separator");
        System.setProperty("line.separator", "\n");
        FileOutputStream out = new FileOutputStream(outputBaselineFile);
        try (PrintStream p = new PrintStream(out);){
            p.println("initial_baseline(TCN):\t0.0000000\t" + bhm + "\t" + bvm + "\t" + "m   m   m");
            p.println("initial_baseline_rate:\t0.0000000\t" + bhr + "\t" + bvr + "\t" + "m/s   m/s   m/s");
            p.println("precision_baseline(TCN):\t0.0000000        0.0000000        0.0000000   m   m   m");
            p.println("precision_baseline_rate:\t0.0000000        0.0000000        0.0000000   m/s m/s m/s");
            p.println("unwrap_phase_constant:\t0.00000     radians");
            p.flush();
        }
        catch (Exception e) {
            throw new IOException("StampsExportOp unable to write baseline file " + e.getMessage());
        }
        finally {
            System.setProperty("line.separator", oldEOL);
        }
    }

    public void dispose() {
        try {
            for (WriterInfo info : this.tgtBandToInfoMap.values()) {
                if (info == null || info.productWriter == null) continue;
                info.productWriter.close();
                info.productWriter = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.dispose();
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(StampsExportOp.class);
        }
    }

    private static class WriterInfo {
        ProductWriter productWriter;
        boolean written = false;
        final String folderName;
        final String targetBandName;

        WriterInfo(String folderName, String targetBandName) {
            this.folderName = folderName;
            this.targetBandName = targetBandName.startsWith("i_") ? targetBandName.substring(2, targetBandName.length()) : targetBandName;
            this.productWriter = ProductIO.getProductWriter((String)StampsExportOp.formatName);
            if (this.productWriter == null) {
                throw new OperatorException("No data product writer for the 'Gamma' format available");
            }
            this.productWriter.setIncrementalMode(false);
        }
    }

    private static enum FOLDERS {
        RSLC,
        DIFF,
        GEO;

    }
}

