/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;

@OperatorMetadata(alias="Stack-Averaging", category="Radar/Coregistration/Stack Tools", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Averaging multi-temporal images")
public class StackAveragingOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"Mean Average", "Minimum", "Maximum", "Standard Deviation", "Coefficient of Variation"}, defaultValue="Mean Average", label="Statistic")
    private String statistic = "Mean Average";
    private BandInfo[] nameGroups;

    public void initialize() throws OperatorException {
        try {
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            block16: for (BandInfo bandInfo : this.nameGroups = this.getBandGroupNames()) {
                if (bandInfo.isVirtual) {
                    this.addOriginalVirtualBands(bandInfo.name);
                    continue;
                }
                String name_prefix = bandInfo.name;
                Band[] sourceBands = this.getSourceBands(name_prefix);
                String unit = sourceBands[0].getUnit();
                double nodatavalue = sourceBands[0].getNoDataValue();
                switch (this.statistic) {
                    case "Mean Average": {
                        this.addVirtualBand("average", name_prefix, StackAveragingOp.mean(sourceBands), unit, nodatavalue);
                        continue block16;
                    }
                    case "Minimum": {
                        this.addVirtualBand("min", name_prefix, StackAveragingOp.min(sourceBands), unit, nodatavalue);
                        continue block16;
                    }
                    case "Maximum": {
                        this.addVirtualBand("max", name_prefix, StackAveragingOp.max(sourceBands), unit, nodatavalue);
                        continue block16;
                    }
                    case "Standard Deviation": {
                        this.addVirtualBand("stddev", name_prefix, StackAveragingOp.stddev(sourceBands), unit, nodatavalue);
                        continue block16;
                    }
                    case "Coefficient of Variation": {
                        this.addVirtualBand("coefVar", name_prefix, StackAveragingOp.coefVar(sourceBands), unit, nodatavalue);
                    }
                }
            }
            StackAveragingOp.updateMetadata(this.targetProduct);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public void dispose() {
        for (BandInfo bandInfo : this.nameGroups) {
            Band srcBand = this.sourceProduct.getBand(bandInfo.name);
            if (srcBand == null) continue;
            this.sourceProduct.removeBand(srcBand);
        }
        this.sourceProduct.setModified(false);
    }

    private static void updateMetadata(Product targetProduct) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"coregistered_stack", (int)0);
    }

    private BandInfo[] getBandGroupNames() {
        Band[] bands = this.sourceProduct.getBands();
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
        ArrayList<BandInfo> bandGroup = new ArrayList<BandInfo>();
        for (Band band : bands) {
            String name = StackUtils.getBandNameWithoutDate((String)band.getName());
            if (nameSet.contains(name)) continue;
            nameSet.add(name);
            bandGroup.add(new BandInfo(band, name));
        }
        return bandGroup.toArray(new BandInfo[bandGroup.size()]);
    }

    private Band[] getSourceBands(String name_prefix) {
        Band[] bands = this.sourceProduct.getBands();
        ArrayList<Band> bandList = new ArrayList<Band>();
        for (Band band : bands) {
            if (band instanceof VirtualBand || !band.getName().startsWith(name_prefix)) continue;
            bandList.add(band);
        }
        return bandList.toArray(new Band[bandList.size()]);
    }

    private void addVirtualBand(String operation, String name_prefix, String expression, String unit, double nodatavalue) {
        VirtualBand virtBand = new VirtualBand(name_prefix, 30, this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight(), expression);
        virtBand.setUnit(unit);
        virtBand.setDescription(name_prefix + ' ' + operation + ' ' + unit);
        virtBand.setNoDataValueUsed(true);
        virtBand.setNoDataValue(nodatavalue);
        Band srcBand = this.sourceProduct.getBand(virtBand.getName());
        if (srcBand != null) {
            this.sourceProduct.removeBand(srcBand);
        }
        this.sourceProduct.addBand((Band)virtBand);
        ProductUtils.copyBand((String)name_prefix, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
    }

    private void addOriginalVirtualBands(String trgBandName) {
        Band[] srcBands = this.sourceProduct.getBands();
        Band virtSrcBand = null;
        for (Band band : srcBands) {
            if (!band.getName().startsWith(trgBandName) || !(band instanceof VirtualBand)) continue;
            virtSrcBand = band;
            break;
        }
        if (virtSrcBand == null) {
            return;
        }
        VirtualBand srcBand = (VirtualBand)virtSrcBand;
        String expression = srcBand.getExpression();
        for (Band b : srcBands) {
            String bName = b.getName();
            if (!expression.contains(bName) || this.nameGroupContains(bName)) continue;
            String newName = StackUtils.getBandNameWithoutDate((String)bName);
            expression = expression.replaceAll(bName, newName);
        }
        VirtualBand virtBand = new VirtualBand(trgBandName, srcBand.getDataType(), srcBand.getRasterWidth(), srcBand.getRasterHeight(), expression);
        virtBand.setUnit(srcBand.getUnit());
        virtBand.setDescription(srcBand.getDescription());
        virtBand.setNoDataValue(srcBand.getNoDataValue());
        virtBand.setNoDataValueUsed(srcBand.isNoDataValueUsed());
        this.targetProduct.addBand((Band)virtBand);
    }

    private boolean nameGroupContains(String name) {
        for (BandInfo b : this.nameGroups) {
            if (!name.equals(b.name)) continue;
            return true;
        }
        return false;
    }

    private static String mean(Band[] sourceBands) {
        StringBuilder expression = new StringBuilder("( ");
        int cnt = 0;
        for (Band band : sourceBands) {
            if (cnt > 0) {
                expression.append(" + ");
            }
            expression.append(band.getName());
            ++cnt;
        }
        expression.append(") / ");
        expression.append(sourceBands.length);
        return expression.toString();
    }

    private static String min(Band[] sourceBands) {
        StringBuilder expression = new StringBuilder("min( ");
        int cnt = 0;
        for (Band band : sourceBands) {
            if (cnt > 0) {
                expression.append(", ");
                if (cnt < sourceBands.length - 1) {
                    expression.append("min( ");
                }
            }
            expression.append(band.getName());
            ++cnt;
        }
        for (int i = 0; i < sourceBands.length - 1; ++i) {
            expression.append(')');
        }
        return expression.toString();
    }

    private static String max(Band[] sourceBands) {
        StringBuilder expression = new StringBuilder("max( ");
        int cnt = 0;
        for (Band band : sourceBands) {
            if (cnt > 0) {
                expression.append(", ");
                if (cnt < sourceBands.length - 1) {
                    expression.append("max( ");
                }
            }
            expression.append(band.getName());
            ++cnt;
        }
        for (int i = 0; i < sourceBands.length - 1; ++i) {
            expression.append(')');
        }
        return expression.toString();
    }

    private static String mean2(Band[] sourceBands) {
        StringBuilder expression = new StringBuilder("( ");
        int cnt = 0;
        for (Band band : sourceBands) {
            if (cnt > 0) {
                expression.append(" + ");
            }
            expression.append("sq(");
            expression.append(band.getName());
            expression.append(')');
            ++cnt;
        }
        expression.append(") / ");
        expression.append(sourceBands.length);
        return expression.toString();
    }

    private static String mean4(Band[] sourceBands) {
        StringBuilder expression = new StringBuilder("( ");
        int cnt = 0;
        for (Band band : sourceBands) {
            if (cnt > 0) {
                expression.append(" + ");
            }
            expression.append("pow(");
            expression.append(band.getName());
            expression.append(", 4)");
            ++cnt;
        }
        expression.append(") / ");
        expression.append(sourceBands.length);
        return expression.toString();
    }

    private static String stddev(Band[] sourceBands) {
        return "sqrt( " + StackAveragingOp.mean2(sourceBands) + " - " + "sq(" + StackAveragingOp.mean(sourceBands) + "))";
    }

    private static String coefVar(Band[] sourceBands) {
        String m2 = StackAveragingOp.mean2(sourceBands);
        return "sqrt( " + StackAveragingOp.mean4(sourceBands) + " - " + "sq(" + m2 + ")) / " + m2;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(StackAveragingOp.class);
        }
    }

    private static class BandInfo {
        final String name;
        final boolean isVirtual;

        public BandInfo(Band band, String name) {
            this.name = name;
            this.isVirtual = band instanceof VirtualBand;
        }
    }
}

